/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.regnosys.rosetta.common.transform.FunctionNameHelper;
import com.regnosys.rosetta.common.transform.TransformType;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PipelineNode {
    private final String modelId;
    private final FunctionNameHelper functionNameHelper;
    private final TransformType transformType;
    private Class<? extends RosettaFunction> function;
    private PipelineNode upstream;

    public PipelineNode(String modelId, FunctionNameHelper functionNameHelper, TransformType transformType) {
        this.modelId = modelId;
        this.functionNameHelper = functionNameHelper;
        this.transformType = transformType;
    }

    PipelineNode(String modelId, FunctionNameHelper functionNameHelper, TransformType transformType, Class<? extends RosettaFunction> function, PipelineNode upstream) {
        this.modelId = modelId;
        this.functionNameHelper = functionNameHelper;
        this.transformType = transformType;
        this.function = function;
        this.upstream = upstream;
    }

    private static String createPipelineId(TransformType transformType, String modelId, String idSuffix) {
        String prefixedIdSuffix = StringUtils.isEmpty((CharSequence)modelId) ? idSuffix : String.format("%s-%s", modelId, idSuffix);
        return String.format("pipeline-%s-%s", transformType.name().toLowerCase(), prefixedIdSuffix);
    }

    public String getInputPath(boolean strictUniqueIds) {
        if (this.upstream != null) {
            return String.format("%s/output/%s", this.upstream.getTransformType().getResourcePath(), this.upstream.idSuffix(strictUniqueIds, "/"));
        }
        return String.format("%s/input", this.transformType.getResourcePath());
    }

    public String getOutputPath(boolean strictUniqueIds) {
        return String.format("%s/output/%s", this.transformType.getResourcePath(), this.idSuffix(strictUniqueIds, "/"));
    }

    public List<PipelineNode> withFunctions(List<Class<? extends RosettaFunction>> function) {
        return function.stream().map(f -> new PipelineNode(this.modelId, this.functionNameHelper, this.transformType, (Class<? extends RosettaFunction>)f, this.upstream)).collect(Collectors.toList());
    }

    public PipelineNode withFunction(Class<? extends RosettaFunction> function) {
        this.function = function;
        return this;
    }

    public PipelineNode linkWithUpstream(PipelineNode upstreamPipelineNode) {
        this.upstream = upstreamPipelineNode;
        return this;
    }

    public Class<? extends RosettaFunction> getFunction() {
        return this.function;
    }

    public TransformType getTransformType() {
        return this.transformType;
    }

    public String id(boolean strictUniqueIds) {
        return PipelineNode.createPipelineId(this.getTransformType(), this.modelId, this.idSuffix(strictUniqueIds, "-"));
    }

    public String upstreamId(boolean strictUniqueIds) {
        if (strictUniqueIds) {
            return this.upstream == null ? null : PipelineNode.createPipelineId(this.upstream.getTransformType(), this.modelId, this.upstream.upstreamIdSuffix(strictUniqueIds, "-"));
        }
        return this.upstream == null ? null : PipelineNode.createPipelineId(this.upstream.getTransformType(), this.modelId, this.upstream.idSuffix(strictUniqueIds, "-"));
    }

    private String upstreamIdSuffix(boolean strictUniqueIds, String separator) {
        return this.upstream == null ? this.idSuffix(strictUniqueIds, separator) : String.format("%s%s%s", this.upstream.upstreamIdSuffix(strictUniqueIds, separator), separator, this.functionNameHelper.readableId(this.getFunction()));
    }

    public String idSuffix(boolean strictUniqueIds, String separator) {
        if (strictUniqueIds) {
            return this.upstream == null ? this.functionNameHelper.readableId(this.getFunction()) : String.format("%s%s%s", this.upstream.idSuffix(true, separator), separator, this.functionNameHelper.readableId(this.getFunction()));
        }
        return this.functionNameHelper.readableId(this.getFunction());
    }

    public String toString() {
        return this.id(true);
    }

    public PipelineNode getUpstream() {
        return this.upstream;
    }
}

