/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.transform;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ReferenceResolverProcessStep;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.regnosys.testing.TestingExpectationUtil;
import com.regnosys.testing.transform.TransformExpectationUtil;
import com.regnosys.testing.transform.TransformTestResult;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TransformTestExtension<T>
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransformTestExtension.class);
    private static final ObjectMapper JSON_OBJECT_MAPPER = RosettaObjectMapper.getNewRosettaObjectMapper();
    private static final ObjectWriter JSON_OBJECT_WRITER = JSON_OBJECT_MAPPER.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true).writerWithDefaultPrettyPrinter();
    public static final String ERROR_OUTPUT = "";
    private final Module runtimeModule;
    private final Path configPath;
    private final Class<T> funcType;
    private Validator xsdValidator;
    @Inject
    RosettaTypeValidator typeValidator;
    @Inject
    ReferenceConfig referenceConfig;
    private Multimap<String, TransformTestResult> actualExpectation;
    private PipelineModel pipelineModel;
    private Injector injector;
    private ObjectMapper inputObjectMapper;
    private ObjectWriter outputObjectWriter;

    public TransformTestExtension(Module runtimeModule, Path configPath, Class<T> funcType) {
        this.runtimeModule = runtimeModule;
        this.configPath = configPath;
        this.funcType = funcType;
    }

    public TransformTestExtension<T> withSchemaValidation(URL xsdSchema) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            Schema schema = schemaFactory.newSchema(xsdSchema);
            this.xsdValidator = schema.newValidator();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @BeforeAll
    public void beforeAll(ExtensionContext context) {
        this.injector = Guice.createInjector((Module[])new Module[]{this.runtimeModule});
        this.injector.injectMembers((Object)this);
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.pipelineModel = TestPackUtils.getPipelineModel((List)TestPackUtils.getPipelineModels((Path)this.configPath, (ClassLoader)classLoader, (ObjectMapper)JSON_OBJECT_MAPPER), (String)this.funcType.getName());
        this.inputObjectMapper = TestPackUtils.getObjectMapper((PipelineModel.Serialisation)this.pipelineModel.getInputSerialisation()).orElse(JSON_OBJECT_MAPPER);
        this.outputObjectWriter = TestPackUtils.getObjectWriter((PipelineModel.Serialisation)this.pipelineModel.getOutputSerialisation()).orElse(JSON_OBJECT_WRITER);
        this.actualExpectation = ArrayListMultimap.create();
    }

    @AfterAll
    public void afterAll(ExtensionContext context) throws Exception {
        this.writeExpectations(this.actualExpectation);
    }

    public <IN extends RosettaModelObject, OUT extends RosettaModelObject> void runTransformAndAssert(String testPackId, TestPackModel.SampleModel sampleModel, Function<IN, OUT> transformFunc) {
        TransformTestResult result = this.getResult(sampleModel, transformFunc);
        this.actualExpectation.put((Object)testPackId, (Object)result);
        String actualOutput = result.getOutput();
        Path outputPath = Path.of(sampleModel.getOutputPath(), new String[0]);
        String expectedOutput = TestingExpectationUtil.readStringFromResources(outputPath);
        Assertions.assertEquals((Object)expectedOutput, (Object)actualOutput);
        TestPackModel.SampleModel.Assertions actualAssertions = result.getSampleModel().getAssertions();
        TestPackModel.SampleModel.Assertions expectedAssertions = sampleModel.getAssertions();
        Assertions.assertEquals((Object)expectedAssertions, (Object)actualAssertions);
    }

    protected <IN extends RosettaModelObject, OUT extends RosettaModelObject> TransformTestResult getResult(TestPackModel.SampleModel sampleModel, Function<IN, OUT> function) {
        String inputFile = sampleModel.getInputPath();
        URL inputFileUrl = TransformTestExtension.getInputFileUrl(inputFile);
        Assertions.assertNotNull((Object)inputFileUrl);
        Class<IN> inputType = this.getInputType();
        try {
            RosettaModelObject input = (RosettaModelObject)TestPackUtils.readFile((URL)inputFileUrl, (ObjectMapper)this.inputObjectMapper, inputType);
            RosettaModelObject resolvedInput = this.resolveReferences(input);
            RosettaModelObject output = (RosettaModelObject)function.apply(resolvedInput);
            Assertions.assertNotNull((Object)output);
            String serialisedOutput = this.outputObjectWriter.writeValueAsString((Object)output);
            ValidationReport validationReport = this.typeValidator.runProcessStep(output.getType(), output);
            validationReport.logReport();
            int actualValidationFailures = validationReport.validationFailures().size();
            Boolean schemaValidationFailure = this.isSchemaValidationFailure(serialisedOutput);
            TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(Integer.valueOf(actualValidationFailures), schemaValidationFailure, Boolean.valueOf(false));
            return new TransformTestResult(serialisedOutput, this.updateSampleModel(sampleModel, assertions));
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred running transform", (Throwable)e);
            TestPackModel.SampleModel.Assertions assertions = new TestPackModel.SampleModel.Assertions(null, null, Boolean.valueOf(true));
            return new TransformTestResult(ERROR_OUTPUT, this.updateSampleModel(sampleModel, assertions));
        }
    }

    public Stream<Arguments> getArguments() {
        Object func = this.injector.getInstance(this.funcType);
        ClassLoader classLoader = this.getClass().getClassLoader();
        List testPackModels = TestPackUtils.getTestPackModels((List)TestPackUtils.getTestPackModels((Path)this.configPath, (ClassLoader)classLoader, (ObjectMapper)JSON_OBJECT_MAPPER), (String)this.pipelineModel.getId());
        return testPackModels.stream().flatMap(testPackModel -> testPackModel.getSamples().stream().map(sampleModel -> Arguments.of((Object[])new Object[]{String.format("%s | %s", testPackModel.getName(), sampleModel.getId()), testPackModel.getId(), sampleModel, func}))).filter(Objects::nonNull);
    }

    private static URL getInputFileUrl(String inputFile) {
        try {
            return Resources.getResource((String)inputFile);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Failed to load input file " + inputFile);
            return null;
        }
    }

    protected <IN extends RosettaModelObject> Class<IN> getInputType() {
        try {
            return Class.forName(this.pipelineModel.getTransform().getInputType());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T extends RosettaModelObject> T resolveReferences(T modelObject) {
        RosettaModelObjectBuilder builder = modelObject.toBuilder();
        new ReferenceResolverProcessStep(this.referenceConfig).runProcessStep(modelObject.getType(), (RosettaModelObject)builder);
        return (T)builder.build();
    }

    protected void writeExpectations(Multimap<String, TransformTestResult> actualExpectation) throws Exception {
        TransformExpectationUtil.writeExpectations(actualExpectation, this.configPath);
    }

    protected Boolean isSchemaValidationFailure(String actualXml) {
        Boolean bl;
        if (this.xsdValidator == null) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(actualXml.getBytes(StandardCharsets.UTF_8));
        try {
            this.xsdValidator.validate(new StreamSource(inputStream));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException e) {
                LOGGER.error("Schema validation failed: {}", (Object)e.getMessage());
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return bl;
    }

    protected TestPackModel.SampleModel updateSampleModel(TestPackModel.SampleModel sampleModel, TestPackModel.SampleModel.Assertions assertions) {
        return new TestPackModel.SampleModel(sampleModel.getId(), sampleModel.getName(), sampleModel.getInputPath(), sampleModel.getOutputPath(), assertions);
    }
}

