/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.testpack;

import com.google.common.collect.ImmutableList;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.Function;
import com.regnosys.rosetta.transgest.ModelLoader;
import com.regnosys.testing.testpack.TestPackModelHelper;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.CollectionUtils;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.generated.GeneratedJavaClassService;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class TestPackModelHelperImpl
implements TestPackModelHelper {
    @Inject
    private ModelLoader modelLoader;
    @Inject
    private JavaTypeTranslator javaTypeTranslator;
    private final GeneratedJavaClassService generatedJavaClassService = new GeneratedJavaClassService();

    @Override
    public List<RosettaModel> loadRosettaModels(ImmutableList<String> rosettaPaths, ClassLoader classLoader) {
        return this.modelLoader.loadRosettaModels(ClassPathUtils.findPathsFromClassPath(rosettaPaths, (String)".*\\.rosetta", Optional.empty(), (ClassLoader)classLoader).stream().map(UrlUtils::toUrl));
    }

    @Override
    public List<RosettaReport> getReports(List<RosettaModel> models, String namespaceRegex, Collection<Class<?>> excluded) {
        Set excludedClassNames = excluded.stream().map(Class::getName).collect(Collectors.toSet());
        return this.modelLoader.rosettaElements(models, RosettaReport.class).stream().filter(r -> this.filterNamespace(r.getModel(), namespaceRegex)).filter(r -> !excludedClassNames.contains(this.toJavaClass((RosettaReport)r))).collect(Collectors.toList());
    }

    @Override
    public List<Function> getFunctionsWithAnnotation(List<RosettaModel> models, String namespaceRegex, String annotation, Collection<Class<?>> excluded) {
        Set excludedClassNames = excluded.stream().map(Class::getName).collect(Collectors.toSet());
        return this.modelLoader.rosettaElements(models, Function.class).stream().filter(r -> this.filterNamespace(r.getModel(), namespaceRegex)).filter(f -> f.getAnnotations().stream().map(AnnotationRef::getAnnotation).anyMatch(a -> annotation.equals(a.getName()))).filter(r -> !excludedClassNames.contains(this.toJavaClass((Function)r))).collect(Collectors.toList());
    }

    @Override
    public RosettaType getInputType(Function func) {
        return CollectionUtils.emptyIfNull((List)func.getInputs()).stream().map(inputAttr -> inputAttr.getTypeCall().getType()).findFirst().orElseThrow();
    }

    @Override
    public RosettaReport getUpstreamReport(List<RosettaModel> models, Function func, Collection<Class<?>> excluded) {
        Data inputType = (Data)this.getInputType(func);
        return this.getReports(models, null, excluded).stream().filter(r -> r.getReportType().equals(inputType)).findFirst().orElseThrow();
    }

    @Override
    public String toJavaClass(Function function) {
        return this.javaTypeTranslator.toFunctionJavaClass(function).getCanonicalName().withDots();
    }

    @Override
    public String toJavaClass(RosettaReport report) {
        return this.javaTypeTranslator.toReportFunctionJavaClass(report).getCanonicalName().withDots();
    }

    @Override
    public String toJavaClass(RosettaType rosettaType) {
        return this.generatedJavaClassService.toJavaType(this.toModelSymbolId(rosettaType)).getCanonicalName().withDots();
    }

    private boolean filterNamespace(RosettaModel rosettaModel, String namespaceIncludeRegex) {
        return Optional.ofNullable(namespaceIncludeRegex).map(regex -> rosettaModel.getName().matches((String)regex)).orElse(true);
    }

    private ModelSymbolId toModelSymbolId(RosettaType type) {
        DottedPath namespace = DottedPath.splitOnDots((String)type.getModel().getName());
        return new ModelSymbolId(namespace, type.getName());
    }
}

