/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.testpack;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.testing.reports.FileNameProcessor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPackConfigWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestPackConfigWriter.class);
    private final ObjectMapper writeMapper;
    private final SimpleFilterProvider filterProvider;

    public TestPackConfigWriter(ObjectMapper writeMapper) {
        this.writeMapper = writeMapper;
        this.filterProvider = com.regnosys.testing.reports.FilterProvider.getExpectedTypeFilter();
    }

    public void sortAndWriteConfigFile(Path resourcesPath, Path configPath, TestPackModel testPackModel) {
        TestPackModel sortedTestPackModel = this.sortSamples(testPackModel);
        this.writeConfigFile(resourcesPath, configPath, testPackModel.getId(), sortedTestPackModel);
    }

    public void writeConfigFile(Path resourcesPath, Path configPath, String id, Object object) {
        Path path = this.generateTestPackModelFilePath(configPath, id);
        try {
            Path fullPath = resourcesPath.resolve(path);
            Files.createDirectories(fullPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(fullPath, new OpenOption[0]);){
                writer.write(this.writeMapper.writer((FilterProvider)this.filterProvider).withDefaultPrettyPrinter().writeValueAsString(object));
                LOGGER.info("Writing config file: {}", (Object)path);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TestPackModel sortSamples(TestPackModel testPackModel) {
        List sampleModels = testPackModel.getSamples().stream().sorted(Comparator.comparing(TestPackModel.SampleModel::getId)).collect(Collectors.toList());
        return new TestPackModel(testPackModel.getId(), testPackModel.getPipelineId(), testPackModel.getName(), sampleModels);
    }

    private List<TestPackModel> readTestPackModelFile(Path file) {
        try {
            return (List)this.writeMapper.readValue(file.toFile(), (TypeReference)new TypeReference<List<TestPackModel>>(){});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path generateTestPackModelFilePath(Path outFolder, String Filename) {
        return outFolder.resolve(FileNameProcessor.sanitizeFileName(Filename + ".json"));
    }
}

