/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.testing.pipeline.FunctionNameHelper;
import com.regnosys.testing.pipeline.PipelineFunctionRunner;
import com.regnosys.testing.pipeline.PipelineModelBuilder;
import com.regnosys.testing.pipeline.PipelineNode;
import com.regnosys.testing.pipeline.PipelineTestPackFilter;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeBuilder;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import com.regnosys.testing.reports.ObjectMapperGenerator;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineTestPackWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineTestPackWriter.class);
    private final PipelineTreeBuilder pipelineTreeBuilder;
    private final PipelineModelBuilder pipelineModelBuilder;
    private final PipelineFunctionRunner pipelineFunctionRunner;
    private final FunctionNameHelper helper;

    @Inject
    public PipelineTestPackWriter(PipelineTreeBuilder pipelineTreeBuilder, PipelineFunctionRunner pipelineFunctionRunner, PipelineModelBuilder pipelineModelBuilder, FunctionNameHelper helper) {
        this.pipelineTreeBuilder = pipelineTreeBuilder;
        this.pipelineFunctionRunner = pipelineFunctionRunner;
        this.pipelineModelBuilder = pipelineModelBuilder;
        this.helper = helper;
    }

    public void writeTestPacks(PipelineTreeConfig config) throws IOException {
        if (config.getWritePath() == null) {
            LOGGER.error("Write path not configured. Aborting.");
            return;
        }
        LOGGER.info("Starting Test Pack Generation");
        ObjectWriter objectWriter = ObjectMapperGenerator.createWriterMapper().writerWithDefaultPrettyPrinter();
        Path resourcesPath = config.getWritePath();
        PipelineTree pipelineTree = this.pipelineTreeBuilder.createPipelineTree(config);
        for (PipelineNode pipelineNode : pipelineTree.getNodeList()) {
            LOGGER.info("Generating {} Test Packs for {} ", (Object)pipelineNode.getTransformType(), (Object)pipelineNode.getFunction().getName());
            PipelineTestPackFilter pipelineTestPackFilter = config.getTestPackFilter();
            if (pipelineTestPackFilter != null && pipelineTestPackFilter.getExcludedFunctionsFromTestPackGeneration().contains(pipelineNode.getFunction())) {
                LOGGER.info("Aborting {} Test Pack Generation for {} as this has been excluded from Test Pack generation", (Object)pipelineNode.getTransformType(), (Object)pipelineNode.getFunction().getName());
                continue;
            }
            Path inputPath = resourcesPath.resolve(pipelineNode.getInputPath(config.isStrictUniqueIds()));
            LOGGER.info("Input path {} ", (Object)inputPath);
            Path outputPath = resourcesPath.resolve(pipelineNode.getOutputPath(config.isStrictUniqueIds()));
            LOGGER.info("Output path {} ", (Object)outputPath);
            List<Path> inputSamples = this.findAllSamples(inputPath);
            Map<String, List<Path>> testPackToSamples = this.filterAndGroupingByTestPackId(resourcesPath, inputPath, inputSamples, config.getTestPackIdFilter());
            Map<String, List<Path>> filteredTestPackToSamples = Optional.ofNullable(pipelineTestPackFilter).map(t -> this.filterTestPacks(pipelineNode, pipelineTestPackFilter, testPackToSamples)).orElse(testPackToSamples);
            LOGGER.info("{} Test Packs will be generated", (Object)filteredTestPackToSamples.keySet().size());
            for (String testPackId : filteredTestPackToSamples.keySet()) {
                List<Path> inputSamplesForTestPack = filteredTestPackToSamples.get(testPackId);
                TestPackModel testPackModel = this.writeTestPackSamples(resourcesPath, inputPath, outputPath, testPackId, inputSamplesForTestPack, pipelineNode, config);
                Path writePath = Files.createDirectories(resourcesPath.resolve(pipelineNode.getTransformType().getResourcePath()).resolve("config"), new FileAttribute[0]);
                Path writeFile = writePath.resolve(testPackModel.getId() + ".json");
                objectWriter.writeValue(writeFile.toFile(), (Object)testPackModel);
            }
        }
    }

    private List<Path> findAllSamples(Path inputDir) throws IOException {
        if (!Files.exists(inputDir, new LinkOption[0])) {
            return List.of();
        }
        try (Stream<Path> paths = Files.walk(inputDir, new FileVisitOption[0]);){
            List<Path> list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).collect(Collectors.toList());
            return list;
        }
    }

    private TestPackModel writeTestPackSamples(Path resourcesPath, Path inputPath, Path outputDir, String testPackId, List<Path> inputSamplesForTestPack, PipelineNode pipelineNode, PipelineTreeConfig config) throws IOException {
        LOGGER.info("Test pack sample generation started for {}", (Object)testPackId);
        TransformType transformType = pipelineNode.getTransformType();
        LOGGER.info("{} {} samples to be generated", (Object)inputSamplesForTestPack.size(), (Object)transformType);
        ArrayList<TestPackModel.SampleModel> sampleModels = new ArrayList<TestPackModel.SampleModel>();
        String pipelineId = pipelineNode.id(config.isStrictUniqueIds());
        String pipelineIdSuffix = pipelineNode.idSuffix(config.isStrictUniqueIds(), "-");
        for (Path inputSample : inputSamplesForTestPack) {
            LOGGER.info("Generating {} sample {}", (Object)transformType, (Object)inputSample.getFileName());
            PipelineModel pipeline = this.pipelineModelBuilder.build(pipelineNode, config);
            Path outputSample = resourcesPath.relativize(outputDir.resolve(resourcesPath.relativize(inputPath).relativize(inputSample)));
            outputSample = outputSample.getParent().resolve(Path.of(this.updateFileExtensionBasedOnOutputFormat(pipeline, outputSample.toFile().getName()), new String[0]));
            PipelineFunctionRunner.Result result = this.pipelineFunctionRunner.run(pipeline, config.getXmlSchemaMap(), resourcesPath.resolve(inputSample));
            TestPackModel.SampleModel.Assertions assertions = result.getAssertions();
            String baseFileName = UrlUtils.getBaseFileName((URL)inputSample.toUri().toURL());
            String displayName = baseFileName.replace("-", " ");
            TestPackModel.SampleModel sampleModel = new TestPackModel.SampleModel(baseFileName.toLowerCase(), displayName, inputSample.toString(), outputSample.toString(), assertions);
            sampleModels.add(sampleModel);
            Files.createDirectories(resourcesPath.resolve(outputSample).getParent(), new FileAttribute[0]);
            Files.write(resourcesPath.resolve(outputSample), result.getSerialisedOutput().getBytes(), new OpenOption[0]);
        }
        List sortedSamples = sampleModels.stream().sorted(Comparator.comparing(TestPackModel.SampleModel::getId)).collect(Collectors.toList());
        LOGGER.info("Test Pack sample generation complete for {} ", (Object)testPackId);
        String testPackName = this.helper.capitalizeFirstLetter(testPackId.replace("-", " "));
        return new TestPackModel(String.format("test-pack-%s-%s-%s", transformType.name().toLowerCase(), pipelineIdSuffix, testPackId), pipelineId, testPackName, sortedSamples);
    }

    private String updateFileExtensionBasedOnOutputFormat(PipelineModel pipelineModel, String fileName) {
        String outputFormat = Optional.ofNullable(pipelineModel.getOutputSerialisation()).map(PipelineModel.Serialisation::getFormat).map(Enum::toString).orElse("json").toLowerCase();
        return fileName.substring(0, fileName.lastIndexOf(".")) + "." + outputFormat;
    }

    private Map<String, List<Path>> filterAndGroupingByTestPackId(Path resourcesPath, Path inputPath, List<Path> inputSamples, Predicate<String> testPackIdFilter) {
        return inputSamples.stream().map(resourcesPath::relativize).filter(path -> testPackIdFilter.test(this.testPackId(resourcesPath, inputPath, (Path)path))).collect(Collectors.groupingBy(p -> this.testPackId(resourcesPath, inputPath, (Path)p)));
    }

    private String testPackId(Path resourcesPath, Path inputPath, Path samplePath) {
        Path parent = samplePath.getParent();
        Path relativePath = resourcesPath.relativize(inputPath).relativize(parent);
        return relativePath.toString().replace(File.separatorChar, '-');
    }

    @NotNull
    private Map<String, List<Path>> filterTestPacks(PipelineNode pipelineNode, PipelineTestPackFilter pipelineTestPackFilter, Map<String, List<Path>> testPackToSamples) {
        Map<String, List<Path>> filteredTestPackToSamples = testPackToSamples;
        Set testPackSpecificFunctions = pipelineTestPackFilter.getTestPacksSpecificToFunctions().entries().stream().filter(entry -> entry.getValue() == pipelineNode.getFunction()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (pipelineTestPackFilter.getTestPacksSpecificToFunctions().containsValue(pipelineNode.getFunction())) {
            filteredTestPackToSamples = testPackToSamples.entrySet().stream().filter(entry -> testPackSpecificFunctions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        } else {
            ImmutableMultiset testPacksToRemove = pipelineTestPackFilter.getTestPacksSpecificToFunctions().keys();
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(arg_0 -> PipelineTestPackWriter.lambda$filterTestPacks$7((ImmutableCollection)testPacksToRemove, arg_0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (pipelineTestPackFilter.getFunctionsSpecificToTestPacks().containsKey(pipelineNode.getFunction())) {
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> pipelineTestPackFilter.getFunctionsSpecificToTestPacks().get(pipelineNode.getFunction()).contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (pipelineTestPackFilter.getTestPacksRestrictedForFunctions().values().contains(pipelineNode.getFunction())) {
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> this.filterApplicableFunctionsForTestPack((String)entry.getKey(), pipelineNode, pipelineTestPackFilter.getTestPacksRestrictedForFunctions())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        } else {
            ImmutableSet testPacksRestrictedForFunctions = pipelineTestPackFilter.getTestPacksRestrictedForFunctions().keySet();
            filteredTestPackToSamples = filteredTestPackToSamples.entrySet().stream().filter(entry -> !testPacksRestrictedForFunctions.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return filteredTestPackToSamples;
    }

    protected boolean filterApplicableFunctionsForTestPack(String testPackName, PipelineNode pipelineNode, ImmutableMultimap<String, Class<?>> testPackIncludedReportIds) {
        ImmutableCollection applicableReportsForTestPack = testPackIncludedReportIds.get((Object)testPackName);
        return applicableReportsForTestPack.isEmpty() || applicableReportsForTestPack.contains(pipelineNode.getFunction());
    }

    private static /* synthetic */ boolean lambda$filterTestPacks$7(ImmutableCollection testPacksToRemove, Map.Entry entry) {
        return !testPacksToRemove.contains(entry.getKey());
    }
}

