/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.testing.pipeline.FunctionNameHelper;
import com.regnosys.testing.pipeline.PipelineNode;
import com.regnosys.testing.pipeline.PipelineTree;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class PipelineModelBuilder {
    private final FunctionNameHelper helper;

    @Inject
    public PipelineModelBuilder(FunctionNameHelper helper) {
        this.helper = helper;
    }

    public List<PipelineModel> createPipelineModels(PipelineTree pipelineTree) {
        return pipelineTree.getNodeList().stream().map(modelBuilder -> this.build((PipelineNode)modelBuilder, pipelineTree.getPipelineTreeConfig())).collect(Collectors.toList());
    }

    protected PipelineModel build(PipelineNode modelBuilder, PipelineTreeConfig config) {
        String inputType = this.helper.getInputType(modelBuilder.getFunction());
        String outputType = this.helper.getOutputType(modelBuilder.getFunction());
        String inputSerialisationConfigPath = (String)config.getXmlConfigMap().get(this.helper.getInputClass(modelBuilder.getFunction()));
        String outputSerialisationConfigPath = (String)config.getXmlConfigMap().get(this.helper.getFuncMethod(modelBuilder.getFunction()).getReturnType());
        String name = this.helper.getName(modelBuilder.getFunction());
        PipelineModel.Serialisation inputSerialisation = this.getSerialisation(inputSerialisationConfigPath);
        PipelineModel.Serialisation outputSerialisation = this.getSerialisation(outputSerialisationConfigPath);
        String pipelineId = modelBuilder.id(config.isStrictUniqueIds());
        String upstreamPipelineId = modelBuilder.upstreamId(config.isStrictUniqueIds());
        return new PipelineModel(pipelineId, name, new PipelineModel.Transform(modelBuilder.getTransformType(), modelBuilder.getFunction().getName(), inputType, outputType), upstreamPipelineId, inputSerialisation, outputSerialisation);
    }

    private PipelineModel.Serialisation getSerialisation(String xmlConfigPath) {
        return xmlConfigPath == null ? null : new PipelineModel.Serialisation(PipelineModel.Serialisation.Format.XML, xmlConfigPath);
    }
}

