/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackModel;
import com.regnosys.rosetta.common.util.Pair;
import com.regnosys.testing.testpack.TestPackFunctionRunner;
import com.regnosys.testing.testpack.TestPackFunctionRunnerProvider;
import java.nio.file.Path;
import javax.inject.Inject;

public class PipelineFunctionRunner {
    @Inject
    Injector injector;
    @Inject
    TestPackFunctionRunnerProvider provider;

    public Result run(PipelineModel pipelineModel, ImmutableMap<Class<?>, String> outputSchemaMap, Path inputPath) {
        TestPackFunctionRunner functionRunner = this.getFunctionRunner(pipelineModel, outputSchemaMap);
        Pair<String, TestPackModel.SampleModel.Assertions> result = functionRunner.run(inputPath);
        return new Result((String)result.left(), (TestPackModel.SampleModel.Assertions)result.right());
    }

    private TestPackFunctionRunner getFunctionRunner(PipelineModel pipelineModel, ImmutableMap<Class<?>, String> schemaMap) {
        return this.provider.create(pipelineModel.getTransform(), pipelineModel.getInputSerialisation(), pipelineModel.getOutputSerialisation(), schemaMap, this.injector);
    }

    public static class Result {
        String serialisedOutput;
        TestPackModel.SampleModel.Assertions assertions;

        public Result(String serialisedOutput, TestPackModel.SampleModel.Assertions assertions) {
            this.serialisedOutput = serialisedOutput;
            this.assertions = assertions;
        }

        public TestPackModel.SampleModel.Assertions getAssertions() {
            return this.assertions;
        }

        public String getSerialisedOutput() {
            return this.serialisedOutput;
        }
    }
}

