/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.regnosys.testing.TestingExpectationUtil;
import com.regnosys.testing.pipeline.PipelineModelWriter;
import com.regnosys.testing.pipeline.PipelineTestPackWriter;
import com.regnosys.testing.pipeline.PipelineTreeConfig;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineConfigWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineConfigWriter.class);
    @Inject
    private PipelineModelWriter pipelineModelWriter;
    @Inject
    private PipelineTestPackWriter pipelineTestPackWriter;

    @Inject
    public PipelineConfigWriter(PipelineModelWriter pipelineModelWriter, PipelineTestPackWriter pipelineTestPackWriter) {
        this.pipelineModelWriter = pipelineModelWriter;
        this.pipelineTestPackWriter = pipelineTestPackWriter;
    }

    public void writePipelinesAndTestPacks(PipelineTreeConfig config) throws IOException {
        if (config.getWritePath() == null) {
            if (TestingExpectationUtil.TEST_WRITE_BASE_PATH.isEmpty()) {
                LOGGER.error("TEST_WRITE_BASE_PATH not set");
                return;
            }
            Path writePath = TestingExpectationUtil.TEST_WRITE_BASE_PATH.get();
            config.withWritePath(writePath);
        }
        LOGGER.info("Generating Pipeline and Test Pack Generation");
        this.pipelineModelWriter.writePipelines(config);
        this.pipelineTestPackWriter.writeTestPacks(config);
    }
}

