/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing;

import com.regnosys.rosetta.common.reports.ReportField;
import com.regnosys.rosetta.common.serialisation.RosettaDataValueObjectToString;
import com.rosetta.model.lib.reports.Tabulator;
import java.util.ArrayList;
import java.util.List;

public class FieldValueFlattener
implements Tabulator.FieldValueVisitor<List<ParentAndIndex>> {
    public List<ReportField> accumulator = new ArrayList<ReportField>();

    public void visitSingle(Tabulator.FieldValue fieldValue, List<ParentAndIndex> parentsAndIndices) {
        if (fieldValue.getValue().isPresent()) {
            String value = RosettaDataValueObjectToString.toValueString(fieldValue.getValue().get());
            this.accumulator.add(new ReportField(FieldValueFlattener.computeFieldName(fieldValue, parentsAndIndices), (String)((Tabulator.FieldImpl)fieldValue.getField()).getRuleId().map(Object::toString).orElse(null), parentsAndIndices.isEmpty() ? null : parentsAndIndices.get((int)(parentsAndIndices.size() - 1)).index, value, ""));
        }
    }

    private static String computeFieldName(Tabulator.FieldValue fieldValue, List<ParentAndIndex> parentsAndIndices) {
        if (parentsAndIndices.isEmpty()) {
            return fieldValue.getField().getName();
        }
        StringBuilder result = new StringBuilder();
        result.append(parentsAndIndices.get((int)0).parent).append(" -> ");
        for (int i = 1; i < parentsAndIndices.size(); ++i) {
            result.append(FieldValueFlattener.insertIndex(parentsAndIndices.get((int)i).parent, parentsAndIndices.get((int)(i - 1)).index)).append(" -> ");
        }
        result.append(FieldValueFlattener.insertIndex(fieldValue.getField().getName(), parentsAndIndices.get((int)(parentsAndIndices.size() - 1)).index));
        return result.toString();
    }

    private static String insertIndex(String fieldName, Integer index) {
        if (index == null) {
            return fieldName;
        }
        if (fieldName.contains("$")) {
            return fieldName.replace("$", index.toString());
        }
        return fieldName + " (" + index + ")";
    }

    public void visitNested(Tabulator.NestedFieldValue nestedFieldValue, List<ParentAndIndex> parentsAndIndices) {
        ArrayList<ParentAndIndex> newParentsAndIndices = new ArrayList<ParentAndIndex>(parentsAndIndices);
        newParentsAndIndices.add(new ParentAndIndex(nestedFieldValue.getField().getName(), null));
        nestedFieldValue.getValue().ifPresent(v -> v.forEach(sub -> sub.accept((Tabulator.FieldValueVisitor)this, (Object)newParentsAndIndices)));
    }

    public void visitMultiNested(Tabulator.MultiNestedFieldValue multiNestedFieldValue, List<ParentAndIndex> parentsAndIndices) {
        multiNestedFieldValue.getValue().ifPresent(vs -> {
            for (int i = 0; i < vs.size(); ++i) {
                int repeatableIndex = i + 1;
                ArrayList<ParentAndIndex> newParentsAndIndices = new ArrayList<ParentAndIndex>(parentsAndIndices);
                newParentsAndIndices.add(new ParentAndIndex(multiNestedFieldValue.getField().getName(), repeatableIndex));
                ((List)vs.get(i)).forEach(sub -> sub.accept((Tabulator.FieldValueVisitor)this, (Object)newParentsAndIndices));
            }
        });
    }

    public static class ParentAndIndex {
        public final String parent;
        public final Integer index;

        public ParentAndIndex(String parent, Integer index) {
            this.parent = parent;
            this.index = index;
        }
    }
}

