/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.regnosys.rosetta.common.serialisation.DataLoader;
import com.regnosys.rosetta.common.serialisation.DataSet;
import com.regnosys.rosetta.common.serialisation.InputDataLoader;
import com.regnosys.rosetta.common.serialisation.JsonDataLoaderUtil;
import com.regnosys.rosetta.common.serialisation.reportdata.ReportDataItem;
import com.regnosys.rosetta.common.util.UrlUtils;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class AbstractJsonDataLoader<T>
implements DataLoader<T>,
InputDataLoader<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJsonDataLoader.class);
    protected final ClassLoader classLoader;
    protected final ObjectMapper rosettaObjectMapper;
    protected final URL descriptorPath;
    protected final Class<T> loadType;
    private final boolean loadInputFromFile;
    private final List<String> descriptorFileNames;

    protected AbstractJsonDataLoader(ClassLoader classLoader, ObjectMapper rosettaObjectMapper, URL descriptorPath, List<String> descriptorFileNames, Class<T> loadType, boolean loadInputFromFile) {
        this.classLoader = classLoader;
        this.rosettaObjectMapper = rosettaObjectMapper;
        this.descriptorPath = descriptorPath;
        this.descriptorFileNames = descriptorFileNames;
        this.loadType = loadType;
        this.loadInputFromFile = loadInputFromFile;
    }

    @Override
    public List<T> load() {
        return this.descriptorFileNames.stream().map(fileName -> this.resolve(this.descriptorPath, (String)fileName)).map(JsonDataLoaderUtil::openURL).filter(Optional::isPresent).map(descriptorStream -> JsonDataLoaderUtil.readTypeList(this.loadType, this.rosettaObjectMapper, (Reader)descriptorStream.get())).flatMap(Collection::stream).map(i -> this.loadInputFromFile ? this.loadInputFiles(i) : i).collect(Collectors.toList());
    }

    public URL resolve(URL url, String child) {
        URL resolvedUrl = UrlUtils.resolve(url, child);
        LOGGER.debug("Resolved URL {}", (Object)resolvedUrl);
        return resolvedUrl;
    }

    public Object getInput(String inputType, ReportDataItem data, URL inputPath) {
        Class<?> inputTypeClass = JsonDataLoaderUtil.loadClass(inputType, this.classLoader);
        if (data.getInput() instanceof String) {
            String inputFileName = (String)data.getInput();
            return JsonDataLoaderUtil.readType(inputTypeClass, this.rosettaObjectMapper, this.resolve(inputPath, inputFileName));
        }
        return JsonDataLoaderUtil.fromObject(data.getInput(), inputTypeClass, this.rosettaObjectMapper);
    }

    public List<ReportDataItem> getDataItem(DataSet descriptor, URL inputPath) {
        ArrayList<ReportDataItem> loadedData = new ArrayList<ReportDataItem>();
        for (ReportDataItem data : descriptor.getData()) {
            ReportDataItem reportDataItem;
            try {
                reportDataItem = new ReportDataItem(data.getName(), this.getInput(descriptor.getInputType(), data, inputPath), data.getExpected());
            }
            catch (RuntimeException e) {
                reportDataItem = new ReportDataItem(data.getName(), data.getInput(), data.getExpected(), e);
            }
            loadedData.add(reportDataItem);
        }
        return loadedData;
    }
}

