/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ScopeReferenceHelper;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolverProcessStep
implements PostProcessStep {
    private final ReferenceConfig referenceConfig;

    public ReferenceResolverProcessStep(ReferenceConfig referenceConfig) {
        this.referenceConfig = referenceConfig;
    }

    public Integer getPriority() {
        return 2;
    }

    public String getName() {
        return "Reference Resolver";
    }

    public <T extends RosettaModelObject> ReferenceResolverPostProcessorReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
        ReferenceCollector collector = new ReferenceCollector(this.referenceConfig);
        instance.process(path, (Processor)collector);
        ReferenceResolver resolver = new ReferenceResolver(this.referenceConfig, collector.globalReferences, collector.helper);
        RosettaModelObjectBuilder builder = instance.toBuilder();
        builder.process(path, (BuilderProcessor)resolver);
        return new ReferenceResolverPostProcessorReport(builder.build(), null);
    }

    private static class ReferenceCollector
    extends SimpleProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceCollector.class);
        private final Table<Class<?>, String, Object> globalReferences = HashBasedTable.create();
        private final ScopeReferenceHelper<Table<Class<?>, String, Object>> helper;

        public ReferenceCollector(ReferenceConfig referenceConfig) {
            this.helper = new ScopeReferenceHelper<Table>(referenceConfig, () -> HashBasedTable.create());
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<? extends R> rosettaType, R instance, RosettaModelObject parent, AttributeMeta ... metas) {
            this.helper.collectScopePath(path, rosettaType);
            if (instance instanceof GlobalKey && instance != null) {
                GlobalKey globalKey = (GlobalKey)instance;
                Object value = this.getValue(instance);
                Class<?> valueClass = this.getValueType(instance);
                if (value != null && valueClass != null) {
                    Optional.ofNullable(globalKey.getMeta()).map(GlobalKeyFields::getGlobalKey).ifPresent(gk -> this.globalReferences.put((Object)valueClass, gk, value));
                    Optional.of(globalKey).map(GlobalKey::getMeta).map(GlobalKeyFields::getKey).ifPresent(keys -> keys.stream().filter(k -> k.getKeyValue() != null).forEach(k -> {
                        String keyValue = k.getKeyValue();
                        Path keyPath = PathUtils.toPath(path);
                        LOGGER.debug("Collecting object [key={}, type={}, path={}]", new Object[]{keyValue, valueClass.getName(), path});
                        this.helper.getDataForModelPath(keyPath).put((Object)valueClass, (Object)keyValue, value);
                    }));
                }
            }
            return true;
        }

        private Object getValue(RosettaModelObject instance) {
            if (instance instanceof FieldWithMeta) {
                return ((FieldWithMeta)instance).getValue();
            }
            return instance;
        }

        private Class<?> getValueType(RosettaModelObject builder) {
            if (builder instanceof FieldWithMeta) {
                return ((FieldWithMeta)builder).getValueType();
            }
            return builder.getType();
        }

        public Processor.Report report() {
            return null;
        }
    }

    private static class ReferenceResolver
    extends SimpleBuilderProcessor {
        private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceResolver.class);
        private final Table<Class<?>, String, Object> globalReferences;
        private final ScopeReferenceHelper<Table<Class<?>, String, Object>> helper;
        private final ReferenceConfig config;

        private ReferenceResolver(ReferenceConfig config, Table<Class<?>, String, Object> globalReferences, ScopeReferenceHelper<Table<Class<?>, String, Object>> helper) {
            this.config = config;
            this.globalReferences = globalReferences;
            this.helper = helper;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (this.config.getExcludedPaths().stream().anyMatch(endsWithPathElement -> path.endsWith(endsWithPathElement))) {
                return false;
            }
            if (builder instanceof ReferenceWithMeta.ReferenceWithMetaBuilder) {
                Path currentModelPath;
                Table<Class<?>, String, Object> currentScopeReferences;
                ReferenceWithMeta.ReferenceWithMetaBuilder referenceWithMetaBuilder = (ReferenceWithMeta.ReferenceWithMetaBuilder)builder;
                if (referenceWithMetaBuilder.getGlobalReference() != null) {
                    this.setReferenceValue(referenceWithMetaBuilder.getGlobalReference(), this.globalReferences, referenceWithMetaBuilder, path);
                } else if (referenceWithMetaBuilder.getReference() != null && (currentScopeReferences = this.helper.getDataForModelPath(currentModelPath = PathUtils.toPath(path))) != null) {
                    this.setReferenceValue(referenceWithMetaBuilder.getReference().getReference(), currentScopeReferences, referenceWithMetaBuilder, path);
                }
            }
            return true;
        }

        private void setReferenceValue(String keyValue, Table<Class<?>, String, Object> references, ReferenceWithMeta.ReferenceWithMetaBuilder referenceWithMeta, RosettaPath path) {
            Map clazzToReferencedObjectMap;
            if (keyValue != null && (clazzToReferencedObjectMap = references.column((Object)keyValue)) != null) {
                List clazzToReferencedObjectEntries = clazzToReferencedObjectMap.entrySet().stream().filter(e -> this.doTest(referenceWithMeta.getValueType(), (Class)e.getKey())).collect(Collectors.toList());
                clazzToReferencedObjectEntries.stream().map(Map.Entry::getValue).forEach(referencedObject -> {
                    LOGGER.debug("Setting resolved object [key={}, type={}, path={}, scope={}]", new Object[]{keyValue, referenceWithMeta.getValueType().getName(), path, Optional.ofNullable(this.config).map(ReferenceConfig::getScopeType).orElse(null)});
                    referenceWithMeta.setValue(referencedObject);
                });
            }
        }

        private boolean doTest(Class<?> valueType, Class<?> clazz) {
            return valueType.isAssignableFrom(clazz);
        }

        public BuilderProcessor.Report report() {
            return null;
        }
    }

    public static class ReferenceResolverPostProcessorReport<T extends RosettaModelObject>
    implements PostProcessorReport {
        private final T instance;

        private ReferenceResolverPostProcessorReport(T instance) {
            this.instance = instance;
        }

        public T getResultObject() {
            return this.instance;
        }

        /* synthetic */ ReferenceResolverPostProcessorReport(RosettaModelObject x0, 1 x1) {
            this(x0);
        }
    }
}

