/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.testing;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.hashing.ReferenceResolverProcessStep;
import com.regnosys.rosetta.common.testing.ExecutableFunction;
import com.regnosys.rosetta.common.testing.ExecutionDescriptor;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.process.PostProcessor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(FunctionRunner.class);
    private static final String ROSETTA_FUNC_EVAL_METHOD_NAME = "evaluate";
    private final ExecutionDescriptor executionDescriptor;
    private final InstanceLoader instanceLoader;
    private final ClassLoader classLoader;
    private final ObjectMapper objectMapper;

    public FunctionRunner(ExecutionDescriptor executionDescriptor, InstanceLoader instanceLoader, ClassLoader classLoader, ObjectMapper objectMapper) {
        this.executionDescriptor = executionDescriptor;
        this.instanceLoader = instanceLoader;
        this.classLoader = classLoader;
        this.objectMapper = objectMapper;
    }

    public <INPUT, OUTPUT> FunctionRunnerResult<INPUT, OUTPUT> run() throws ClassNotFoundException, IOException, InvocationTargetException, IllegalAccessException {
        LOGGER.info("Executing " + this.executionDescriptor.getGroup() + ":" + this.executionDescriptor.getName());
        String inputFile = this.executionDescriptor.getInputFile();
        String expectedOutputFile = this.executionDescriptor.getExpectedOutputFile();
        LOGGER.info("Output File:  " + expectedOutputFile);
        if (this.executionDescriptor.isNativeFunction()) {
            String jsonExpected;
            Object expectedOutput;
            JsonNode jsonNode = this.objectMapper.readTree(this.loadURL(inputFile));
            Object actualOutput = this.postProcess(this.runNativeFunction(jsonNode, this.executionDescriptor.getExecutableFunctionClass()));
            String jsonActual = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(actualOutput);
            if (expectedOutputFile == null) {
                return new FunctionRunnerResult<JsonNode, Object>(jsonNode, null, actualOutput, jsonActual, null);
            }
            try {
                expectedOutput = this.objectMapper.readValue(this.loadURL(expectedOutputFile), this.getType(actualOutput));
                jsonExpected = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectedOutput);
            }
            catch (Exception e) {
                LOGGER.error("Error getting expected output " + this.executionDescriptor.getGroup() + ":" + this.executionDescriptor.getName(), (Throwable)e);
                expectedOutput = null;
                jsonExpected = "";
            }
            return new FunctionRunnerResult<JsonNode, Object>(jsonNode, expectedOutput, actualOutput, jsonActual, jsonExpected);
        }
        Class<ExecutableFunction<INPUT, OUTPUT>> functionClass = this.loadExecutableFunctionClass(this.executionDescriptor.getExecutableFunctionClass());
        ExecutableFunction<Object, OUTPUT> instance = this.instanceLoader.createInstance(functionClass);
        Object input = this.objectMapper.readValue(this.loadURL(inputFile), instance.getInputType());
        OUTPUT actualOutput = this.postProcess(instance.execute(input));
        String jsonActual = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(actualOutput);
        if (expectedOutputFile == null) {
            return new FunctionRunnerResult<Object, Object>(input, null, actualOutput, jsonActual, null);
        }
        try {
            Object expectedOutput = this.objectMapper.readValue(this.loadURL(expectedOutputFile), instance.getOutputType());
            String jsonExpected = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(expectedOutput);
            return new FunctionRunnerResult<Object, Object>(input, expectedOutput, actualOutput, jsonActual, jsonExpected);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to deserialise expected json file, proceeding without it.");
            return new FunctionRunnerResult<Object, Object>(input, null, actualOutput, jsonActual, "");
        }
    }

    private Class<?> getType(Object actualOutput) {
        return RosettaModelObject.class.isInstance(actualOutput) ? ((RosettaModelObject)actualOutput).getType() : actualOutput.getClass();
    }

    private <OUTPUT> OUTPUT postProcess(OUTPUT actualOutput) {
        if (actualOutput instanceof RosettaModelObject) {
            PostProcessor postProcessor = this.instanceLoader.createInstance(PostProcessor.class);
            RosettaModelObject funcModelOutput = (RosettaModelObject)actualOutput;
            RosettaModelObjectBuilder instance = funcModelOutput.toBuilder();
            instance.prune();
            RosettaModelObjectBuilder postProcessedBuilder = postProcessor.postProcess(funcModelOutput.getType(), instance);
            RosettaModelObject postProcessed = postProcessedBuilder.build();
            return (OUTPUT)postProcessed;
        }
        return actualOutput;
    }

    private <INPUT> INPUT resolveReferences(INPUT input) {
        if (input instanceof List) {
            List builderList = ((List)input).stream().map(this::resolveReferences).collect(Collectors.toList());
            return (INPUT)builderList;
        }
        if (input instanceof RosettaModelObject) {
            RosettaModelObjectBuilder builder = ((RosettaModelObject)input).toBuilder();
            ReferenceConfig resolverConfig = this.instanceLoader.createInstance(ReferenceConfig.class);
            new ReferenceResolverProcessStep(resolverConfig).runProcessStep(builder.getType(), (RosettaModelObject)builder);
            return (INPUT)builder.build();
        }
        return input;
    }

    private Object runNativeFunction(JsonNode jsonNode, String functionClassName) throws ClassNotFoundException, IOException, InvocationTargetException, IllegalAccessException {
        Class<?> functionClass = this.classLoader.loadClass(functionClassName);
        if (!this.checkFunctionIsRosettaFunction(functionClass)) {
            throw new IllegalArgumentException(String.format("Function %s is not defined in Rosetta.", functionClassName));
        }
        Object rosettaFunction = this.instanceLoader.createInstance(functionClass);
        if (null == rosettaFunction) {
            throw new IllegalArgumentException(String.format("Function %s cannot be created.", functionClassName));
        }
        Optional<Method> executeMethod = this.getEvaluateMethod(functionClass);
        if (!executeMethod.isPresent()) {
            throw new IllegalArgumentException(String.format("Function %s is not executable.", functionClassName));
        }
        Method method = executeMethod.get();
        Object[] argsList = this.getMethodArguments(method, jsonNode);
        return method.invoke(rosettaFunction, argsList);
    }

    private Optional<Method> getEvaluateMethod(Class<?> rosettaClass) {
        List methods = Arrays.stream(rosettaClass.getMethods()).filter(x -> Modifier.isPublic(x.getModifiers())).filter(x -> x.getName().equals(ROSETTA_FUNC_EVAL_METHOD_NAME)).collect(Collectors.toList());
        if (methods.size() == 1) {
            return Optional.of((Method)methods.get(0));
        }
        if (methods.isEmpty()) {
            return Optional.empty();
        }
        if (methods.stream().allMatch(x -> x.getParameterCount() == 1)) {
            return methods.stream().filter(x -> !x.getParameterTypes()[0].isAssignableFrom(Object.class)).findFirst();
        }
        throw new RuntimeException("Unable to find the evaluate function as multiple implementations found. " + methods.stream().map(Method::toString).collect(Collectors.joining(", ")));
    }

    private boolean checkFunctionIsRosettaFunction(Class<?> functionClass) {
        return RosettaFunction.class.isAssignableFrom(functionClass);
    }

    private Object[] getMethodArguments(Method method, JsonNode jsonNode) throws IOException, ClassNotFoundException {
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (!jsonNode.isArray() && parameterTypes.length == 1 && !this.isList(parameterTypes[0])) {
            Class<?> parameterType = this.classLoader.loadClass(parameterTypes[0].getTypeName());
            return new Object[]{this.resolveReferences(this.objectMapper.treeToValue((TreeNode)jsonNode, parameterType))};
        }
        JsonNode[] jsonArrayNodes = (JsonNode[])Iterables.toArray((Iterable)jsonNode, JsonNode.class);
        Object[] argsList = new Object[parameterTypes.length];
        if (parameterTypes.length == jsonArrayNodes.length) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameterTypes[i]);
                JsonParser jsonParser = this.objectMapper.treeAsTokens((TreeNode)jsonArrayNodes[i]);
                argsList[i] = this.resolveReferences(this.objectMapper.readValue(jsonParser, javaType));
            }
        } else {
            throw new IllegalArgumentException(String.format("The function %s requires %s arguments, but %s was supplied in the json array.", method.getName(), parameterTypes.length, jsonArrayNodes.length));
        }
        return argsList;
    }

    private boolean isList(Type parameterType) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(parameterType);
        return javaType.getRawClass().isAssignableFrom(List.class);
    }

    private <INPUT, OUTPUT> Class<ExecutableFunction<INPUT, OUTPUT>> loadExecutableFunctionClass(String testClass) throws ClassNotFoundException {
        return this.classLoader.loadClass(testClass);
    }

    protected URL loadURL(String inputFile) throws MalformedURLException {
        Optional<Path> inputPath = ClassPathUtils.loadFromClasspath(inputFile, this.classLoader).findFirst();
        if (!inputPath.isPresent()) {
            throw new IllegalArgumentException("Could not load " + inputFile);
        }
        return inputPath.get().toUri().toURL();
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static interface InstanceLoader {
        public <T> T createInstance(Class<T> var1) throws RuntimeException;
    }

    public class FunctionRunnerResult<INPUT, OUTPUT> {
        private final INPUT input;
        private final OUTPUT expectedOutput;
        private final OUTPUT actualOutput;
        private final String jsonActual;
        private final String jsonExpected;
        private final boolean success;

        public FunctionRunnerResult(INPUT input, OUTPUT expectedOutput, OUTPUT actualOutput, String jsonActual, String jsonExpected) {
            this.input = input;
            this.expectedOutput = expectedOutput;
            this.actualOutput = actualOutput;
            this.jsonActual = jsonActual;
            this.jsonExpected = jsonExpected;
            this.success = jsonActual.equals(jsonExpected);
        }

        public boolean isSuccess() {
            return this.success;
        }

        public INPUT getInput() {
            return this.input;
        }

        public OUTPUT getExpectedOutput() {
            return this.expectedOutput;
        }

        public OUTPUT getActualOutput() {
            return this.actualOutput;
        }

        public String getJsonActual() {
            return this.jsonActual;
        }

        public String getJsonExpected() {
            return this.jsonExpected;
        }
    }
}

