/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.transform;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

public class TestPackModel {
    private final String id;
    private final String pipelineId;
    private final String name;
    private final List<SampleModel> samples;

    @JsonCreator
    public TestPackModel(@JsonProperty(value="id") String id, @JsonProperty(value="pipelineId") String pipelineId, @JsonProperty(value="name") String name, @JsonProperty(value="samples") List<SampleModel> samples) {
        this.id = id;
        this.pipelineId = pipelineId;
        this.name = name;
        this.samples = samples;
    }

    public String getId() {
        return this.id;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getName() {
        return this.name;
    }

    public List<SampleModel> getSamples() {
        return this.samples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TestPackModel)) {
            return false;
        }
        TestPackModel that = (TestPackModel)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getPipelineId(), that.getPipelineId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getSamples(), that.getSamples());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getPipelineId(), this.getName(), this.getSamples());
    }

    public String toString() {
        return "TestPackModel{id='" + this.id + '\'' + ", pipelineId='" + this.pipelineId + '\'' + ", name='" + this.name + '\'' + ", samples=" + this.samples + '}';
    }

    public static class SampleModel {
        private final String id;
        private final String name;
        private final String inputPath;
        private final String outputPath;
        private final Assertions assertions;

        @JsonCreator
        public SampleModel(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="inputPath") String inputPath, @JsonProperty(value="outputPath") String outputPath, @JsonProperty(value="assertions") Assertions assertions) {
            this.id = id;
            this.name = name;
            this.inputPath = inputPath;
            this.outputPath = outputPath;
            this.assertions = assertions;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public Assertions getAssertions() {
            return this.assertions;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof SampleModel)) {
                return false;
            }
            SampleModel that = (SampleModel)object;
            return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getInputPath(), that.getInputPath()) && Objects.equals(this.getOutputPath(), that.getOutputPath()) && Objects.equals(this.getAssertions(), that.getAssertions());
        }

        public int hashCode() {
            return Objects.hash(this.getId(), this.getName(), this.getInputPath(), this.getOutputPath(), this.getAssertions());
        }

        public String toString() {
            return "SampleModel{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", inputPath='" + this.inputPath + '\'' + ", outputPath='" + this.outputPath + '\'' + ", assertions=" + this.assertions + '}';
        }

        public static class Assertions {
            private final Integer modelValidationFailures;
            private final Boolean schemaValidationFailure;
            private final Boolean runtimeError;

            @JsonCreator
            public Assertions(@JsonProperty(value="modelValidationFailures") Integer modelValidationFailures, @JsonProperty(value="schemaValidationFailure") Boolean schemaValidationFailure, @JsonProperty(value="runtimeError") Boolean runtimeError) {
                this.modelValidationFailures = modelValidationFailures;
                this.schemaValidationFailure = schemaValidationFailure;
                this.runtimeError = runtimeError;
            }

            public Integer getModelValidationFailures() {
                return this.modelValidationFailures;
            }

            public Boolean isSchemaValidationFailure() {
                return this.schemaValidationFailure;
            }

            public Boolean isRuntimeError() {
                return this.runtimeError;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Assertions)) {
                    return false;
                }
                Assertions that = (Assertions)o;
                return Objects.equals(this.getModelValidationFailures(), that.getModelValidationFailures()) && Objects.equals(this.schemaValidationFailure, that.schemaValidationFailure) && Objects.equals(this.runtimeError, that.runtimeError);
            }

            public int hashCode() {
                return Objects.hash(this.getModelValidationFailures(), this.schemaValidationFailure, this.runtimeError);
            }

            public String toString() {
                return "Assertions{modelValidationFailures=" + this.modelValidationFailures + ", schemaValidationFailure=" + this.schemaValidationFailure + ", runtimeError=" + this.runtimeError + '}';
            }
        }
    }
}

