/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.testing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public class ExecutionDescriptor {
    private String group;
    private String name;
    private String description;
    private String markDownFile;
    private String inputFile;
    private String expectedOutputFile;
    private String executableFunctionClass;
    private boolean nativeFunction;

    public static List<ExecutionDescriptor> loadExecutionDescriptor(ObjectMapper objectMapper, URL url) {
        try {
            return (List)objectMapper.readValue(url, (TypeReference)new TypeReference<List<ExecutionDescriptor>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load expectations from " + url.toString(), e);
        }
    }

    public static List<ExecutionDescriptor> loadExecutionDescriptor(ObjectMapper objectMapper, String resourceName, InputStream inputStream) {
        try {
            return (List)objectMapper.readValue(inputStream, (TypeReference)new TypeReference<List<ExecutionDescriptor>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load expectations " + resourceName, e);
        }
    }

    public boolean isNativeFunction() {
        return this.nativeFunction;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public String getExpectedOutputFile() {
        return this.expectedOutputFile;
    }

    public String getExecutableFunctionClass() {
        return this.executableFunctionClass;
    }

    public String getMarkDownFile() {
        return this.markDownFile;
    }
}

