/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.UnwrappableIndexedListSerializer;

public class SubstitutingBeanPropertyWriter
extends BeanPropertyWriter {
    private final SubstitutionMap substitutionNameMap;

    public SubstitutingBeanPropertyWriter(BeanPropertyWriter base, SubstitutionMap substitutionNameMap) {
        super(base);
        this.substitutionNameMap = substitutionNameMap;
    }

    protected SubstitutingBeanPropertyWriter(SubstitutingBeanPropertyWriter base, PropertyName name) {
        super((BeanPropertyWriter)base, name);
        this.substitutionNameMap = base.substitutionNameMap;
    }

    protected SubstitutingBeanPropertyWriter _new(PropertyName newName) {
        return new SubstitutingBeanPropertyWriter(this, newName);
    }

    public void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap m;
        SerializedString substitutedName;
        Object value = this._accessorMethod == null ? this._field.get(bean) : this._accessorMethod.invoke(bean, (Object[])null);
        String rawSubstitutedName = this.substitutionNameMap.getSubstitutedName(value);
        SerializedString serializedString = substitutedName = rawSubstitutedName == null ? this._name : new SerializedString(rawSubstitutedName);
        if (value == null) {
            if (this._suppressableValue != null && prov.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                gen.writeFieldName((SerializableString)substitutedName);
                this._nullSerializer.serialize(null, gen, prov);
            }
            return;
        }
        JsonSerializer ser = this._serializer;
        if (ser == null && (ser = (m = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(m, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
            return;
        }
        gen.writeFieldName((SerializableString)substitutedName);
        if (ser instanceof UnwrappableIndexedListSerializer) {
            ((UnwrappableIndexedListSerializer)ser).setNextElementSubstitutionMap(this.substitutionNameMap);
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, gen, prov);
        } else {
            ser.serializeWithType(value, gen, prov, this._typeSerializer);
        }
    }
}

