/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.deser.XmlBeanDeserializerModifier;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializerModifier;
import com.regnosys.rosetta.common.serialisation.xml.RosettaBeanDeserializerModifier;
import com.regnosys.rosetta.common.serialisation.xml.RosettaBeanSerializerModifier;
import com.regnosys.rosetta.common.serialisation.xml.RosettaXMLAnnotationIntrospector;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMapLoader;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import java.io.IOException;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class RosettaXMLModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private final RosettaXMLConfiguration rosettaXMLConfiguration;
    private final boolean supportNativeEnumValue;
    private final ObjectMapper mapper;
    private final ClassLoader classLoader;

    public RosettaXMLModule(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, boolean supportNativeEnumValue, ClassLoader classLoader) {
        super(RosettaXMLModule.class.getSimpleName());
        this.mapper = mapper;
        this.rosettaXMLConfiguration = rosettaXMLConfiguration;
        this.supportNativeEnumValue = supportNativeEnumValue;
        this.classLoader = classLoader;
    }

    public void setupModule(Module.SetupContext context) {
        SubstitutionMapLoader substitutionMapLoader = new SubstitutionMapLoader(this.classLoader);
        context.addBeanSerializerModifier((BeanSerializerModifier)new RosettaBeanSerializerModifier(substitutionMapLoader));
        context.addBeanSerializerModifier((BeanSerializerModifier)new XmlBeanSerializerModifier());
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new RosettaBeanDeserializerModifier(substitutionMapLoader));
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new XmlBeanDeserializerModifier(""));
        context.insertAnnotationIntrospector((AnnotationIntrospector)new RosettaXMLAnnotationIntrospector(this.mapper, this.rosettaXMLConfiguration, this.supportNativeEnumValue));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new StdDeserializer<LocalTime>(LocalTime.class){

            public LocalTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
                String next = (String)p.readValueAs(String.class);
                try {
                    OffsetTime time = OffsetTime.parse(next, DateTimeFormatter.ISO_TIME);
                    return time.toLocalTime().minusSeconds(time.getOffset().getTotalSeconds());
                }
                catch (DateTimeParseException e) {
                    return LocalTime.parse(next, DateTimeFormatter.ISO_TIME);
                }
            }
        });
        this.addSerializer(LocalTime.class, (JsonSerializer)new StdSerializer<LocalTime>(LocalTime.class){

            public void serialize(LocalTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
                gen.writeString(DateTimeFormatter.ISO_TIME.format(OffsetTime.of(value, ZoneOffset.UTC)));
            }
        });
        super.setupModule(context);
    }
}

