/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import com.fasterxml.jackson.dataformat.xml.util.TypeUtil;
import com.google.common.collect.Streams;
import com.regnosys.rosetta.common.serialisation.ConstantAttributePropertyWriter;
import com.regnosys.rosetta.common.serialisation.mixin.EnumAsStringBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.mixin.RosettaEnumBuilderIntrospector;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.VirtualXMLAttribute;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import com.rosetta.util.DottedPath;
import com.rosetta.util.serialisation.AttributeXMLConfiguration;
import com.rosetta.util.serialisation.AttributeXMLRepresentation;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RosettaXMLAnnotationIntrospector
extends JacksonXmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final JsonPOJOBuilder.Value ROSETTA_BUILDER_CONFIG = new JsonPOJOBuilder.Value("build", "set");
    private final RosettaXMLConfiguration rosettaXMLConfiguration;
    private final RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector;
    private final EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector;
    private final ObjectMapper mapper;

    public RosettaXMLAnnotationIntrospector(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, boolean supportNativeEnumValue) {
        this(mapper, rosettaXMLConfiguration, new RosettaEnumBuilderIntrospector(supportNativeEnumValue), new EnumAsStringBuilderIntrospector());
    }

    public RosettaXMLAnnotationIntrospector(ObjectMapper mapper, RosettaXMLConfiguration rosettaXMLConfiguration, RosettaEnumBuilderIntrospector rosettaEnumBuilderIntrospector, EnumAsStringBuilderIntrospector enumAsStringBuilderIntrospector) {
        this.mapper = mapper;
        this.rosettaXMLConfiguration = rosettaXMLConfiguration;
        this.rosettaEnumBuilderIntrospector = rosettaEnumBuilderIntrospector;
        this.enumAsStringBuilderIntrospector = enumAsStringBuilderIntrospector;
    }

    public SubstitutionMap findSubstitutionMap(MapperConfig<?> config, AnnotatedMember member, ClassLoader classLoader) {
        AnnotatedClass ac = this.getAnnotatedClassOrContent(config, member);
        RosettaDataType ann = (RosettaDataType)ac.getAnnotation(RosettaDataType.class);
        if (ann != null) {
            ModelSymbolId id = this.createModelSymbolId(ac, ann.value());
            List substitutions = this.rosettaXMLConfiguration.getSubstitutionsForType(id);
            if (substitutions.isEmpty()) {
                return null;
            }
            return new SubstitutionMap(Streams.concat((Stream[])new Stream[]{substitutions.stream(), Stream.of(id)}).collect(Collectors.toMap(s -> {
                try {
                    return config.constructType(classLoader.loadClass(s.toString()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }, this::getElementName)));
        }
        return null;
    }

    private String getElementName(ModelSymbolId type) {
        return this.rosettaXMLConfiguration.getConfigurationForType(type).flatMap(TypeXMLConfiguration::getXmlElementName).orElse(type.getName());
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        return this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getDeserializationConfig(), (Annotated)member).flatMap(AttributeXMLConfiguration::getXmlRepresentation).filter(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VIRTUAL).map(repr -> NameTransformer.NOP).orElseGet(() -> super.findUnwrappingNameTransformer(member));
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).builder();
        }
        return super.findPOJOBuilder(ac);
    }

    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        if (ac.hasAnnotation(RosettaDataType.class)) {
            return ROSETTA_BUILDER_CONFIG;
        }
        return super.findPOJOBuilderConfig(ac);
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        return this.getTypeXMLConfigurations((MapperConfig<?>)this.mapper.getSerializationConfig(), ac).stream().filter(t -> t.getXmlElementName().isPresent()).map(t -> (String)t.getXmlElementName().get()).findFirst().map(PropertyName::construct).orElseGet(() -> Optional.ofNullable(super.findRootName(ac)).orElseGet(() -> Optional.ofNullable((RosettaDataType)ac.getAnnotation(RosettaDataType.class)).map(rosettaDataTypeAnn -> PropertyName.construct((String)rosettaDataTypeAnn.value())).orElse(null)));
    }

    protected PropertyName _findXmlName(Annotated a) {
        if (a.getRawType().equals(List.class) && this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getSerializationConfig(), a).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(repr -> repr == AttributeXMLRepresentation.VIRTUAL).orElse(false).booleanValue()) {
            return PropertyName.NO_NAME;
        }
        if (this.shouldUseDefaultPropertyName((MapperConfig<?>)this.mapper.getSerializationConfig(), a)) {
            return PropertyName.USE_DEFAULT;
        }
        return this.getAttributeXMLConfiguration((MapperConfig<?>)this.mapper.getSerializationConfig(), a).flatMap(AttributeXMLConfiguration::getXmlName).map(PropertyName::construct).orElseGet(() -> Optional.ofNullable((RosettaAttribute)a.getAnnotation(RosettaAttribute.class)).map(rosettaAttrAnn -> PropertyName.construct((String)rosettaAttrAnn.value())).orElseGet(() -> super._findXmlName(a)));
    }

    private boolean shouldUseDefaultPropertyName(MapperConfig<?> config, Annotated a) {
        return this.getAttributeXMLConfiguration(config, a).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElse(false);
    }

    public void findAndAddVirtualProperties(MapperConfig<?> config, AnnotatedClass ac, List<BeanPropertyWriter> properties) {
        this.getTypeXMLConfigurations(config, ac).forEach(typeXMLConfiguration -> typeXMLConfiguration.getXmlAttributes().ifPresent(xmlAttributes -> {
            for (String xmlAttributeName : xmlAttributes.keySet()) {
                String xmlAttributeValue = (String)xmlAttributes.get(xmlAttributeName);
                JavaType propType = config.constructType(String.class);
                BeanPropertyWriter bpw = this.constructVirtualXMLAttribute(xmlAttributeName, xmlAttributeValue, config, ac, propType);
                properties.add(bpw);
            }
        }));
        super.findAndAddVirtualProperties(config, ac, properties);
    }

    private BeanPropertyWriter constructVirtualXMLAttribute(String xmlAttributeName, String xmlAttributeValue, MapperConfig<?> config, AnnotatedClass ac, JavaType type) {
        PropertyName propertyName = PropertyName.construct((String)xmlAttributeName);
        VirtualXMLAttribute member = new VirtualXMLAttribute(ac.getRawType(), xmlAttributeName, type);
        SimpleBeanPropertyDefinition xmlPropertyDefinition = SimpleBeanPropertyDefinition.construct(config, (AnnotatedMember)member, (PropertyName)propertyName, (PropertyMetadata)PropertyMetadata.STD_REQUIRED, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
        return new ConstantAttributePropertyWriter(xmlAttributeName, (BeanPropertyDefinition)xmlPropertyDefinition, ac.getAnnotations(), type, xmlAttributeValue);
    }

    public Boolean isOutputAsAttribute(MapperConfig<?> config, Annotated ann) {
        if (ann instanceof VirtualXMLAttribute) {
            return true;
        }
        return this.getAttributeXMLConfiguration(config, ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.ATTRIBUTE).orElseGet(() -> super.isOutputAsAttribute(config, ann));
    }

    public Boolean isOutputAsText(MapperConfig<?> config, Annotated ann) {
        return this.getAttributeXMLConfiguration(config, ann).flatMap(AttributeXMLConfiguration::getXmlRepresentation).map(attributeXMLRepresentation -> attributeXMLRepresentation == AttributeXMLRepresentation.VALUE).orElseGet(() -> super.isOutputAsText(config, ann));
    }

    protected boolean _isIgnorable(Annotated a) {
        boolean isIgnorable = super._isIgnorable(a);
        if (isIgnorable) {
            return true;
        }
        return !a.hasAnnotation(RosettaAttribute.class) && !(a instanceof AnnotatedConstructor);
    }

    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated a) {
        JsonIgnoreProperties.Value ignoreProps = super.findPropertyIgnoralByName(config, a);
        return Optional.of(a).filter(ann -> ann instanceof AnnotatedClass).map(ann -> (AnnotatedClass)ann).flatMap(ac -> this.getTypeXMLConfigurations(config, (AnnotatedClass)ac).stream().filter(t -> t.getXmlElementName().isPresent()).map(t -> (String)t.getXmlElementName().get()).findFirst()).map(rootElementName -> {
            HashSet ignoredNames = new HashSet(ignoreProps.getIgnored());
            return JsonIgnoreProperties.Value.construct(ignoredNames, (boolean)ignoreProps.getIgnoreUnknown(), (boolean)ignoreProps.getAllowGetters(), (boolean)ignoreProps.getAllowSetters(), (boolean)ignoreProps.getMerge());
        }).orElse(ignoreProps);
    }

    public PropertyName findWrapperName(Annotated ann) {
        if (ann.hasAnnotation(RosettaAttribute.class) && this.hasCollectionType(ann)) {
            return PropertyName.NO_NAME;
        }
        return super.findWrapperName(ann);
    }

    private boolean hasCollectionType(Annotated ann) {
        if (ann instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)ann;
            JavaType attributeType = method.getParameterCount() == 1 ? method.getParameterType(0) : method.getType();
            return TypeUtil.isIndexedType((JavaType)attributeType);
        }
        return false;
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        } else {
            this.enumAsStringBuilderIntrospector.findEnumValues(enumType, enumValues, names);
        }
        this.getEnumXMLConfigurations(config, enumType).flatMap(TypeXMLConfiguration::getEnumValues).ifPresent(enumMap -> {
            for (int i = 0; i < enumValues.length; ++i) {
                String nameOverride;
                Field f;
                Enum value = enumValues[i];
                try {
                    f = value.getDeclaringClass().getField(value.name());
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException(e);
                }
                RosettaEnumValue ann = f.getAnnotation(RosettaEnumValue.class);
                if (ann == null || (nameOverride = (String)enumMap.get(ann.value())) == null) continue;
                names[i] = nameOverride;
            }
        });
        return names;
    }

    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        if (this.rosettaEnumBuilderIntrospector.isApplicable(enumType)) {
            this.rosettaEnumBuilderIntrospector.findEnumAliases(enumType, enumValues, aliasList);
        } else {
            super.findEnumAliases(config, enumType, (Enum[])enumValues, aliasList);
        }
    }

    private AnnotatedClass getEnclosingAnnotatedClass(MapperConfig<?> config, AnnotatedMember member) {
        return AnnotatedClassResolver.resolve(config, (JavaType)config.constructType(member.getDeclaringClass()), config);
    }

    private AnnotatedClass getAnnotatedClassOrContent(MapperConfig<?> config, AnnotatedMember m) {
        AnnotatedMethod method;
        JavaType t = m instanceof AnnotatedMethod ? ((method = (AnnotatedMethod)m).getParameterCount() == 1 ? method.getParameterType(0) : method.getType()) : m.getType();
        if (t.getContentType() != null) {
            t = t.getContentType();
        }
        return AnnotatedClassResolver.resolve(config, (JavaType)t, config);
    }

    private Optional<AttributeXMLConfiguration> getAttributeXMLConfiguration(MapperConfig<?> config, Annotated a) {
        return Optional.of(a).filter(annotated -> annotated instanceof AnnotatedMember).map(annotated -> (AnnotatedMember)annotated).flatMap(annotatedMember -> Optional.ofNullable((RosettaAttribute)annotatedMember.getAnnotation(RosettaAttribute.class)).flatMap(rosettaAttributeAnnotation -> this.getTypeXMLConfigurations(config, this.getEnclosingAnnotatedClass(config, (AnnotatedMember)annotatedMember)).stream().filter(t -> t.getAttributes().isPresent()).map(t -> (Map)t.getAttributes().get()).filter(attrMap -> attrMap.containsKey(rosettaAttributeAnnotation.value())).map(attributeMap -> (AttributeXMLConfiguration)attributeMap.get(rosettaAttributeAnnotation.value())).findFirst()));
    }

    private List<TypeXMLConfiguration> getTypeXMLConfigurations(MapperConfig<?> config, AnnotatedClass ac) {
        RosettaDataType ann;
        ArrayList<TypeXMLConfiguration> result = new ArrayList<TypeXMLConfiguration>();
        HashSet<ModelSymbolId> visited = new HashSet<ModelSymbolId>();
        while ((ann = (RosettaDataType)ac.getAnnotation(RosettaDataType.class)) != null) {
            ModelSymbolId modelSymbolId = this.createModelSymbolId(ac, ann.value());
            if (visited.add(modelSymbolId)) {
                this.rosettaXMLConfiguration.getConfigurationForType(modelSymbolId).ifPresent(result::add);
            }
            if (ac.getType().getSuperClass() == null) break;
            ac = AnnotatedClassResolver.resolve(config, (JavaType)ac.getType().getSuperClass(), config);
        }
        return result;
    }

    private Optional<TypeXMLConfiguration> getEnumXMLConfigurations(MapperConfig<?> config, AnnotatedClass ac) {
        RosettaEnum ann = (RosettaEnum)ac.getAnnotation(RosettaEnum.class);
        if (ann != null) {
            ModelSymbolId modelSymbolId = this.createModelSymbolId(ac, ann.value());
            return this.rosettaXMLConfiguration.getConfigurationForType(modelSymbolId);
        }
        return Optional.empty();
    }

    private ModelSymbolId createModelSymbolId(AnnotatedClass ac, String name) {
        String namespace = ac.getType().getRawClass().getPackage().getName();
        return new ModelSymbolId(DottedPath.splitOnDots((String)namespace), name);
    }
}

