/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.AttributePropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.XmlBeanSerializerBase;
import com.regnosys.rosetta.common.serialisation.xml.SubstitutionMap;
import com.regnosys.rosetta.common.serialisation.xml.VirtualXMLAttribute;
import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class RosettaBeanSerializer
extends XmlBeanSerializer {
    public static final String SCHEMA_LOCATION_ATTRIBUTE_NAME = "schemaLocation";
    private static final String SCHEMA_LOCATION_ATTRIBUTE_PREFIXED_NAME = "xsi:schemaLocation";
    private final SubstitutionMap _substitutionMap;

    public RosettaBeanSerializer(XmlBeanSerializer src, SubstitutionMap substitutionMap) {
        super((BeanSerializerBase)src);
        this._substitutionMap = substitutionMap;
    }

    public RosettaBeanSerializer(RosettaBeanSerializer src, ObjectIdWriter objectIdWriter, Object filterId) {
        super((XmlBeanSerializerBase)src, objectIdWriter, filterId);
        this._substitutionMap = src._substitutionMap;
    }

    public RosettaBeanSerializer(RosettaBeanSerializer src, Set<String> toIgnore, Set<String> toInclude) {
        super((XmlBeanSerializerBase)src, toIgnore, toInclude);
        this._substitutionMap = src._substitutionMap;
    }

    protected RosettaBeanSerializer(RosettaBeanSerializer src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super((XmlBeanSerializerBase)src, properties, filteredProperties);
        this._substitutionMap = src._substitutionMap;
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new RosettaBeanSerializer(this, objectIdWriter, this._propertyFilterId);
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        return new RosettaBeanSerializer(this, this._objectIdWriter, filterId);
    }

    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new RosettaBeanSerializer(this, toIgnore, toInclude);
    }

    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return new RosettaBeanSerializer(this, properties, filteredProperties);
    }

    public void serialize(Object bean, JsonGenerator g, SerializerProvider provider) throws IOException {
        String substitutedName;
        if (this._substitutionMap != null && g instanceof ToXmlGenerator && (substitutedName = this._substitutionMap.getSubstitutedName(bean)) != null) {
            ((ToXmlGenerator)g).setNextName(new QName(substitutedName));
        }
        if (g instanceof ToXmlGenerator && ((ToXmlGenerator)g).inRoot()) {
            this.serializeRootElement(bean, (ToXmlGenerator)g, provider);
        } else {
            super.serialize(bean, g, provider);
        }
    }

    public void serializeRootElement(Object bean, ToXmlGenerator g, SerializerProvider provider) throws IOException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, (JsonGenerator)g, provider, true);
            return;
        }
        g.writeStartObject();
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(bean, (JsonGenerator)g, provider);
        } else {
            this.serializeFieldsAndAddSchemaLocation(bean, g, provider);
        }
        g.writeEndObject();
    }

    protected void serializeFieldsAndAddSchemaLocation(Object bean, ToXmlGenerator xgen, SerializerProvider provider) throws IOException {
        BeanPropertyWriter[] props = this._filteredProps != null && provider.getActiveView() != null ? this._filteredProps : this._props;
        int attrCount = this._attributeCount;
        xgen.setNextIsAttribute(true);
        int textIndex = this._textPropertyIndex;
        QName[] xmlNames = this._xmlNames;
        int i = 0;
        BitSet cdata = this._cdata;
        try {
            if (props.length == 0) {
                this.writeSchemaLocation(xgen, provider);
            }
            int len = props.length;
            while (i < len) {
                if (i == attrCount && !this.isUnwrappingSerializer()) {
                    this.writeSchemaLocation(xgen, provider);
                    xgen.setNextIsAttribute(false);
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(true);
                }
                xgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop != null) {
                    if (cdata != null && cdata.get(i)) {
                        xgen.setNextIsCData(true);
                        prop.serializeAsField(bean, (JsonGenerator)xgen, provider);
                        xgen.setNextIsCData(false);
                    } else {
                        prop.serializeAsField(bean, (JsonGenerator)xgen, provider);
                    }
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(false);
                }
                ++i;
            }
            if (this._anyGetterWriter != null) {
                xgen.setNextIsAttribute(false);
                this._anyGetterWriter.getAndSerialize(bean, (JsonGenerator)xgen, provider);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, e, bean, name);
        }
        catch (StackOverflowError e) {
            JsonMappingException mapE = JsonMappingException.from((JsonGenerator)xgen, (String)"Infinite recursion (StackOverflowError)");
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            mapE.prependPath(new JsonMappingException.Reference(bean, name));
            throw mapE;
        }
    }

    private void writeSchemaLocation(ToXmlGenerator xgen, SerializerProvider provider) throws IOException {
        JavaType propType = provider.constructType(String.class);
        PropertyName propertyName = PropertyName.construct((String)SCHEMA_LOCATION_ATTRIBUTE_PREFIXED_NAME);
        VirtualXMLAttribute member = new VirtualXMLAttribute(this._beanType.getRawClass(), SCHEMA_LOCATION_ATTRIBUTE_NAME, propType);
        SimpleBeanPropertyDefinition xmlPropertyDefinition = SimpleBeanPropertyDefinition.construct((MapperConfig)provider.getConfig(), (AnnotatedMember)member, (PropertyName)propertyName, (PropertyMetadata)PropertyMetadata.STD_OPTIONAL, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
        AttributePropertyWriter attrWriter = AttributePropertyWriter.construct((String)SCHEMA_LOCATION_ATTRIBUTE_NAME, (BeanPropertyDefinition)xmlPropertyDefinition, null, (JavaType)this._beanType);
        xgen.setNextName(new QName("", attrWriter.getName()));
        try {
            attrWriter.serializeAsField(null, (JsonGenerator)xgen, provider);
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, e, null, SCHEMA_LOCATION_ATTRIBUTE_PREFIXED_NAME);
        }
    }

    public String toString() {
        return "RosettaBeanSerializer for " + this.handledType().getName();
    }
}

