/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.mixin;

import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.rosetta.model.lib.annotations.RosettaEnum;
import com.rosetta.model.lib.annotations.RosettaEnumValue;
import java.util.function.BiFunction;

public class RosettaEnumBuilderIntrospector {
    private final EnumNameFunc enumNameFunc;
    private final EnumAliasFunc enumAliasFunc;

    public RosettaEnumBuilderIntrospector(boolean supportRosettaEnumValue) {
        this.enumNameFunc = supportRosettaEnumValue ? (annotation, javaEnumName) -> !annotation.displayName().isEmpty() ? annotation.displayName() : annotation.value() : (annotation, javaEnumName) -> !annotation.displayName().isEmpty() ? annotation.displayName() : javaEnumName;
        this.enumAliasFunc = (annotation, javaEnumName) -> {
            String[] stringArray;
            if (!annotation.displayName().isEmpty()) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = javaEnumName;
                stringArray2[1] = annotation.displayName();
                stringArray = stringArray2;
                stringArray2[2] = annotation.value();
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = javaEnumName;
                stringArray = stringArray3;
                stringArray3[1] = annotation.value();
            }
            return stringArray;
        };
    }

    public boolean isApplicable(AnnotatedClass enumType) {
        return enumType.getAnnotation(RosettaEnum.class) != null;
    }

    public void findEnumValues(AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        block0: for (AnnotatedField f : enumType.fields()) {
            if (!f.hasAnnotation(RosettaEnumValue.class)) continue;
            RosettaEnumValue annotation = (RosettaEnumValue)f.getAnnotation(RosettaEnumValue.class);
            String name = f.getName();
            int end = enumValues.length;
            for (int i = 0; i < end; ++i) {
                if (!name.equals(enumValues[i].name())) continue;
                names[i] = (String)this.enumNameFunc.apply(annotation, name);
                continue block0;
            }
        }
    }

    public void findEnumAliases(AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        block0: for (AnnotatedField f : enumType.fields()) {
            if (!f.hasAnnotation(RosettaEnumValue.class)) continue;
            RosettaEnumValue annotation = (RosettaEnumValue)f.getAnnotation(RosettaEnumValue.class);
            String name = f.getName();
            int end = enumValues.length;
            for (int i = 0; i < end; ++i) {
                if (!name.equals(enumValues[i].name())) continue;
                aliasList[i] = (String[])this.enumAliasFunc.apply(annotation, name);
                continue block0;
            }
        }
    }

    static interface EnumNameFunc
    extends BiFunction<RosettaEnumValue, String, String> {
    }

    static interface EnumAliasFunc
    extends BiFunction<RosettaEnumValue, String, String[]> {
    }
}

