/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.postprocess.qualify;

import com.google.inject.Inject;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandlerProvider;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationReport;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationResult;
import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class QualifyProcessorStep
implements PostProcessStep {
    @Inject
    QualifyFunctionFactory qualifyFunctionFactory;
    @Inject
    QualificationHandlerProvider qualificationHandlerProvider;

    public Integer getPriority() {
        return 2;
    }

    public String getName() {
        return "Qualification PostProcessor";
    }

    public <T extends RosettaModelObject> QualificationReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
        RosettaModelObjectBuilder builder = (RosettaModelObjectBuilder)instance;
        ArrayList<QualificationResult> collectedResults = new ArrayList<QualificationResult>();
        QualifyThenUpdateResultProcessor processor = new QualifyThenUpdateResultProcessor(this.qualificationHandlerProvider.getQualificationHandlerMap(), collectedResults);
        processor.processRosetta(path, topClass, builder, null, new AttributeMeta[0]);
        builder.process(path, (BuilderProcessor)processor);
        return new QualificationReport(builder.build(), collectedResults);
    }

    private class QualifyThenUpdateResultProcessor
    extends SimpleBuilderProcessor {
        private final Map<Class<?>, QualificationHandler<?, ?, ?>> handlerMap;
        private final Set<Class<?>> rootTypes;
        private final List<QualificationResult> collectedResults;

        QualifyThenUpdateResultProcessor(Map<Class<?>, QualificationHandler<?, ?, ?>> handlerMap, List<QualificationResult> collectedResults) {
            this.handlerMap = handlerMap;
            this.rootTypes = handlerMap.keySet();
            this.collectedResults = collectedResults;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            QualificationHandler<?, ?, ?> handler;
            Object qualifiableObject;
            if (builder == null) {
                return false;
            }
            if (this.rootTypes.contains(builder.getType()) && null != (qualifiableObject = (handler = this.handlerMap.get(builder.getType())).getQualifiableObject(builder.build()))) {
                QualificationResult result = this.qualify((Class<R>)handler.getQualifiableClass(), (R)qualifiableObject);
                this.collectedResults.add(result);
                result.getUniqueSuccessQualifyResult().ifPresent(r -> handler.setQualifier(builder, r.getName()));
            }
            return true;
        }

        public BuilderProcessor.Report report() {
            return null;
        }

        private <R extends RosettaModelObject> QualificationResult qualify(Class<R> type, R instance) {
            RosettaMetaData metaData = instance.metaData();
            List qualifyFunctions = metaData.getQualifyFunctions(QualifyProcessorStep.this.qualifyFunctionFactory);
            if (qualifyFunctions.isEmpty()) {
                return null;
            }
            ArrayList<QualifyResult> allQualifyResults = new ArrayList<QualifyResult>();
            for (Function func : qualifyFunctions) {
                QualifyResult qualificationResult = (QualifyResult)func.apply(instance);
                allQualifyResults.add(qualificationResult);
            }
            return new QualificationResult(type, allQualifyResults);
        }
    }
}

