/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.hashing;

import com.regnosys.rosetta.common.util.SimpleBuilderProcessor;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class GlobalKeyProcessStep
implements PostProcessStep {
    private final Supplier<? extends Processor> hashCalculator;

    public GlobalKeyProcessStep(Supplier<? extends Processor> s) {
        this.hashCalculator = s;
    }

    public Integer getPriority() {
        return 1;
    }

    public String getName() {
        return "GlobalKey postProcessor";
    }

    public <T extends RosettaModelObject> KeyPostProcessReport runProcessStep(Class<? extends T> topClass, T instance) {
        RosettaModelObjectBuilder builder = instance.toBuilder();
        KeyPostProcessReport thisReport = new KeyPostProcessReport(builder, new HashMap<RosettaPath, GlobalKey>());
        ReKeyProcessor reKeyProcessor = new ReKeyProcessor(thisReport);
        RosettaPath path = RosettaPath.valueOf((String)instance.getType().getSimpleName());
        reKeyProcessor.processRosetta(path, topClass, builder, null, new AttributeMeta[0]);
        builder.process(path, (BuilderProcessor)reKeyProcessor);
        return thisReport;
    }

    public class KeyPostProcessReport
    implements PostProcessorReport,
    BuilderProcessor.Report {
        private final RosettaModelObjectBuilder result;
        private final Map<RosettaPath, GlobalKey> keyMap;

        public KeyPostProcessReport(RosettaModelObjectBuilder result, Map<RosettaPath, GlobalKey> keyMap) {
            this.result = result;
            this.keyMap = keyMap;
        }

        public RosettaModelObjectBuilder getResultObject() {
            return this.result;
        }

        public Map<RosettaPath, GlobalKey> getKeyMap() {
            return this.keyMap;
        }
    }

    class ReKeyProcessor
    extends SimpleBuilderProcessor {
        KeyPostProcessReport report;

        ReKeyProcessor(KeyPostProcessReport report) {
            this.report = report;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath path, Class<R> rosettaType, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent, AttributeMeta ... metas) {
            if (builder == null || !builder.hasData()) {
                return false;
            }
            if (this.isGlobalKey(builder, metas)) {
                GlobalKey.GlobalKeyBuilder keyBuilder = (GlobalKey.GlobalKeyBuilder)builder;
                Processor hasher = (Processor)GlobalKeyProcessStep.this.hashCalculator.get();
                builder.process(path, hasher);
                Processor.Report rep = hasher.report();
                keyBuilder.getOrCreateMeta().setGlobalKey(rep.toString());
                this.report.keyMap.put(path, keyBuilder);
            }
            return true;
        }

        public BuilderProcessor.Report report() {
            return this.report;
        }

        private boolean isGlobalKey(RosettaModelObjectBuilder builder, AttributeMeta ... metas) {
            return builder instanceof GlobalKey && (!(builder instanceof FieldWithMeta) || Arrays.asList(metas).contains(AttributeMeta.GLOBAL_KEY_FIELD));
        }
    }
}

