/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json;

import com.google.common.collect.Sets;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JsonEntity
implements Entity {
    private static final String HASH = "#";
    private static final Set<String> DATA_TYPES = Sets.newHashSet((Object[])new String[]{"editor", "datePicker", "radio", "text", "selectGroup", "time", "string", "integer", "boolean"});
    private final NamespaceName name;
    private final List<Attribute> attributes;
    private final String type;

    public JsonEntity(String name, String type, List<Attribute> attributes) {
        this.name = new NamespaceName("", name);
        this.type = type;
        this.attributes = attributes;
    }

    public JsonEntity(String name, String type) {
        this(name, type, new ArrayList<Attribute>());
    }

    public JsonEntity(JsonEntity otherEntity) {
        this(otherEntity.name.getName(), otherEntity.type, otherEntity.getAttributes());
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getType() {
        return this.type;
    }

    public boolean containsReferences() {
        return this.type.startsWith(HASH);
    }

    @Override
    public void addAttribute(Attribute att) {
        this.attributes.add(att);
    }

    @Override
    public Entity getExtendedEntity() {
        return null;
    }

    @Override
    public List<Entity> getKnownExtendingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasChild() {
        return this.attributes.size() > 0;
    }

    @Override
    public boolean hasData() {
        return DATA_TYPES.contains(this.type);
    }

    @Override
    public String toString(Set<String> alreadyWritten) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("\t").append("[" + this.type + "]");
        builder.append("\n");
        for (Attribute attr : this.attributes) {
            builder.append("  ");
            builder.append(attr.toString(alreadyWritten).replace("\n", "\n  "));
            builder.append("\n");
        }
        return builder.toString();
    }

    public String toString() {
        return this.toString(new HashSet<String>());
    }
}

