/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel;

import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.BasicType;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleType
implements Entity {
    private final NamespaceName name;
    private final BasicType type;
    private final List<Entity> extendingEntities;
    private static final Map<NamespaceName, SimpleType> simpleTypes = new HashMap<NamespaceName, SimpleType>();

    public SimpleType(NamespaceName name, BasicType type) {
        this.name = name;
        this.type = type;
        simpleTypes.put(name, this);
        this.extendingEntities = new ArrayList<Entity>();
    }

    private SimpleType(String name, BasicType type) {
        this(new NamespaceName("http://www.w3.org/2001/XMLSchema", name), type);
    }

    public static SimpleType stringType(String name) {
        return new SimpleType(name, BasicType.STRING);
    }

    public static Entity dateType(String name) {
        return new SimpleType(name, BasicType.DATE);
    }

    public static Entity timeType(String name) {
        return new SimpleType(name, BasicType.TIME);
    }

    public static Entity dateTimeType(String name) {
        return new SimpleType(name, BasicType.DATETIME);
    }

    public static Entity intType(String name) {
        return new SimpleType(name, BasicType.INTEGER);
    }

    public static Entity booleanType(String name) {
        return new SimpleType(name, BasicType.BOOLEAN);
    }

    public static Entity decimalType(String name) {
        return new SimpleType(name, BasicType.REAL);
    }

    @Override
    public NamespaceName getName() {
        return this.name;
    }

    @Override
    public List<Attribute> getAttributes() {
        return Collections.emptyList();
    }

    @Override
    public void addAttribute(Attribute att) {
        throw new UnsupportedOperationException("N/A");
    }

    @Override
    public Entity getExtendedEntity() {
        return null;
    }

    @Override
    public List<Entity> getKnownExtendingEntities() {
        return this.extendingEntities;
    }

    @Override
    public boolean hasChild() {
        return false;
    }

    @Override
    public boolean hasData() {
        return true;
    }

    public BasicType getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.name) + "(" + String.valueOf((Object)this.type) + ")";
    }

    public static Map<NamespaceName, SimpleType> getSimpletypes() {
        return simpleTypes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleType other = (SimpleType)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public String toString(Set<String> alreadyWritten) {
        return this.toString();
    }
}

