/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class GeneratorUtil {
    public static List<String> synonymSourceNames(Collection<RosettaSynonymSource> sources) {
        Functions.Function1 _function = it -> it.getName();
        return ListExtensions.map(GeneratorUtil.synonymSources(sources), (Functions.Function1)_function);
    }

    public static List<RosettaExternalSynonymSource> externalSynonymSources(Collection<RosettaSynonymSource> sources) {
        return IterableExtensions.toList((Iterable)Iterables.filter(GeneratorUtil.synonymSources(sources), RosettaExternalSynonymSource.class));
    }

    private static List<RosettaSynonymSource> synonymSources(Collection<RosettaSynonymSource> sources) {
        ArrayList collected = CollectionLiterals.newArrayList();
        Consumer<RosettaSynonymSource> _function = it -> GeneratorUtil.traverse(it, collected);
        sources.forEach(_function);
        return IterableExtensions.toList((Iterable)collected);
    }

    private static <T> void traverse(RosettaSynonymSource source, List<RosettaSynonymSource> collected) {
        if (source != null) {
            GeneratorUtil.addLast(collected, source);
            Consumer<RosettaSynonymSource> _function = it -> GeneratorUtil.traverse(it, collected);
            GeneratorUtil.getSuperSources(source).forEach(_function);
        }
    }

    private static void addLast(List<RosettaSynonymSource> list, RosettaSynonymSource source) {
        boolean _contains = list.contains(source);
        if (_contains) {
            list.remove(source);
        }
        list.add(source);
    }

    private static List<RosettaSynonymSource> getSuperSources(RosettaSynonymSource source) {
        if (source instanceof RosettaExternalSynonymSource) {
            return ((RosettaExternalSynonymSource)source).getSuperSources();
        }
        return CollectionLiterals.emptyList();
    }
}

