/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import com.rosetta.model.lib.path.RosettaPath;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingReportsSummaryWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingReportsSummaryWriter.class);
    private static final String FILE_NAME = "File Name";
    private static final String RESULT = "Result";
    private static final String EXTERNAL_PATH = "Input Path";
    private static final String EXTERNAL_PATH_INDEXLESS = "Indexless Input Path";
    private static final String INTERNAL_PATH_COUNT = "Unmappable CDM Path Count";
    private static final String INTERNAL_PATH_FAILURES = "Unmappable CDM Paths";
    private static final String FAILURE_REASONS = "Reason For Failure";
    private static final String FAILED_MAPPING_COUNT = "Failed Mapping Count";
    private static final String MAPPING_COVERAGE = "Mapping Coverage";
    public static final String FAILED_MAPPINGS_REPORT_CSV = "failed-mappings-report.csv";
    public static final String AGGREGATED_MAPPING_FAILURE_REPORT_CSV = "aggregated-mapping-failure-report.csv";
    private final Table<String, String, MappingReport> mappingReports = HashBasedTable.create();

    public void capture(String testName, String testFileName, MappingReport mappingReport) {
        if (this.mappingReports.put((Object)testName, (Object)testFileName, (Object)mappingReport) != null) {
            throw new IllegalArgumentException(String.format("Mapping report overwritten testName=%s, testFileName=%s", testName, testFileName));
        }
    }

    public void writeSummaryCsvs(Path outputPath) throws IOException {
        for (String testName : this.mappingReports.rowKeySet()) {
            Map reportMap = this.mappingReports.row((Object)testName);
            this.writeFailedMappingResults(outputPath, reportMap, testName + "-failed-mappings-report.csv");
            this.writeAggregatedMappingResults(outputPath, reportMap, testName + "-aggregated-mapping-failure-report.csv");
        }
    }

    private void writeFailedMappingResults(Path outputPath, Map<String, MappingReport> mappingReports, String failedMappingsFileName) throws IOException {
        ArrayList<Map<String, String>> csvDataRecords = new ArrayList<Map<String, String>>();
        mappingReports.forEach((fileName, mappingReport) -> {
            List<MappingResult> failedMappingResults = this.getFailedMappingResults((MappingReport)mappingReport);
            failedMappingResults.forEach(mappingResult -> {
                HashMap<String, String> record = new HashMap<String, String>();
                record.put(FILE_NAME, (String)fileName);
                record.put(RESULT, mappingResult.getResult().toString());
                record.put(EXTERNAL_PATH, mappingResult.getExternalPathString());
                record.put(EXTERNAL_PATH_INDEXLESS, mappingResult.getExternalPath().toIndexless().buildPath());
                record.put(INTERNAL_PATH_COUNT, String.valueOf(mappingResult.getInternalPaths().size()));
                record.put(INTERNAL_PATH_FAILURES, this.generateInternalPathData(mappingResult.getInternalPaths()));
                record.put(FAILURE_REASONS, String.join((CharSequence)" : ", mappingResult.getIssues()));
                csvDataRecords.add(record);
            });
        });
        List<String> orderedColumns = List.of(FILE_NAME, RESULT, EXTERNAL_PATH, EXTERNAL_PATH_INDEXLESS, INTERNAL_PATH_COUNT, INTERNAL_PATH_FAILURES, FAILURE_REASONS);
        this.writeCsv(null, csvDataRecords, orderedColumns, outputPath.resolve(failedMappingsFileName));
    }

    private void writeAggregatedMappingResults(Path outputPath, Map<String, MappingReport> mappingReports, String fileName) throws IOException {
        List<MappingResult> failedMappingResults = this.getFailedMappingResults(mappingReports);
        BigDecimal percentageMapped = this.calculateCoveragePercentage(mappingReports);
        List failedFimlPaths = failedMappingResults.stream().map(mappingResult -> mappingResult.getExternalPath().toIndexless().buildPath()).map(this::stripAttributesFromExternalPath).collect(Collectors.toList());
        Map<String, Long> aggregatedFailedPaths = failedFimlPaths.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        List<Map<String, String>> csvDataRecords = this.convertAggregateMapToDataRecords(aggregatedFailedPaths);
        String header = "Mapping Coverage," + String.valueOf(percentageMapped);
        List<String> orderedColumns = List.of(EXTERNAL_PATH, FAILED_MAPPING_COUNT);
        this.writeCsv(header, csvDataRecords, orderedColumns, outputPath.resolve(fileName));
    }

    private List<Map<String, String>> convertAggregateMapToDataRecords(Map<String, Long> aggregatedFailedPaths) {
        ArrayList<Map<String, String>> csvDataRecords = new ArrayList<Map<String, String>>();
        aggregatedFailedPaths.forEach((path, count) -> {
            HashMap<String, String> record = new HashMap<String, String>();
            record.put(EXTERNAL_PATH, (String)path);
            record.put(FAILED_MAPPING_COUNT, String.valueOf(count));
            csvDataRecords.add(record);
        });
        return csvDataRecords;
    }

    private BigDecimal calculateCoveragePercentage(Map<String, MappingReport> mappingReports) {
        HashMap perFileCoverage = new HashMap();
        mappingReports.forEach((fileName, mappingReport) -> {
            BigDecimal failedMappingCount = BigDecimal.valueOf(this.getFailedMappingResults((MappingReport)mappingReport).size());
            BigDecimal totalMappingCount = BigDecimal.valueOf(mappingReport.getMappingResults().stream().filter(x -> !x.isExcludedExternalPath()).count());
            perFileCoverage.put(fileName, this.getPerFileCoverage(totalMappingCount, failedMappingCount));
        });
        BigDecimal numerator = perFileCoverage.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal denominator = BigDecimal.valueOf(perFileCoverage.size());
        return numerator.divide(denominator, 2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getPerFileCoverage(BigDecimal totalMappingCount, BigDecimal failedMappingCount) {
        BigDecimal successCount = totalMappingCount.subtract(failedMappingCount);
        BigDecimal mappedFraction = successCount.divide(totalMappingCount, 10, RoundingMode.HALF_EVEN);
        return mappedFraction.multiply(BigDecimal.valueOf(100L));
    }

    private String stripAttributesFromExternalPath(String path) {
        return path.replaceAll("\\[.*?\\]", "");
    }

    private void writeCsv(String header, List<Map<String, String>> csvDataRecords, List<String> orderedColumns, Path csvPath) throws IOException {
        ArrayList<List<String>> csv = new ArrayList<List<String>>();
        csv.add(orderedColumns);
        csvDataRecords.forEach(record -> csv.add(orderedColumns.stream().map(record::get).collect(Collectors.toList())));
        String csvContent = csv.stream().map(MappingReportsSummaryWriter::convertToCSV).collect(Collectors.joining("\n"));
        String fileContent = header == null ? csvContent : header + System.lineSeparator() + System.lineSeparator() + csvContent;
        Files.createDirectories(csvPath.getParent(), new FileAttribute[0]);
        Files.write(csvPath, fileContent.getBytes(), new OpenOption[0]);
        LOGGER.info("Wrote output to {}", (Object)csvPath);
    }

    public static String convertToCSV(List<String> row) {
        return row.stream().map(data -> {
            if (data == null) {
                return "";
            }
            Object escapedData = data.replaceAll("\\R", " ");
            if (data.contains(",") || data.contains("\"") || data.contains("'")) {
                data = data.replace("\"", "\"\"");
                escapedData = "\"" + data + "\"";
            }
            return escapedData;
        }).collect(Collectors.joining(","));
    }

    private String generateInternalPathData(Map<RosettaPath, ?> internalPaths) {
        if (internalPaths.isEmpty()) {
            return "";
        }
        return internalPaths.entrySet().stream().map(e -> ((RosettaPath)e.getKey()).buildPath() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining("\n"));
    }

    private List<MappingResult> getFailedMappingResults(Map<String, MappingReport> allMappingReports) {
        return allMappingReports.values().stream().flatMap(mappingReport -> this.getFailedMappingResults((MappingReport)mappingReport).stream()).collect(Collectors.toList());
    }

    private List<MappingResult> getFailedMappingResults(MappingReport mappingReport) {
        return mappingReport.getMappingResults().stream().filter(mappingResult -> !mappingResult.isSuccess() && !mappingResult.isExcludedExternalPath()).collect(Collectors.toList());
    }
}

