/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel.json;

import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.json.JsonEntity;
import java.util.HashSet;
import java.util.Set;

public class JsonAttribute
implements Attribute {
    private final String name;
    private Entity type;

    public JsonAttribute(String name, Entity type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public Cardinality getCardinality() {
        if (((JsonEntity)this.type).getType().equals("multi")) {
            return Cardinality.MULTIPLE;
        }
        return Cardinality.SINGLE;
    }

    @Override
    public Entity getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.toString(new HashSet<String>());
    }

    @Override
    public String toString(Set<String> alreadyWritten) {
        return this.name + this.getCardinality().toShortString() + "=" + this.type.toString(alreadyWritten);
    }
}

