/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.basic;

import com.regnosys.rosetta.translate.basic.BasicParseHandler;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class ZonedDateTimeParseHandler
extends BasicParseHandler<ZonedDateTime> {
    private DateTimeFormatter pattern;
    private static final ZoneId UTC = ZoneId.of("UTC");

    public ZonedDateTimeParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ISO_ZONED_DATE_TIME;
    }

    public ZonedDateTimeParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml, String pattern) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ofPattern(pattern);
    }

    public String toString() {
        return "ZonedDateTime";
    }

    @Override
    protected ZonedDateTime convert(String value) {
        try {
            return ZonedDateTime.parse(value, this.pattern);
        }
        catch (DateTimeParseException e) {
            return ZonedDateTime.of(LocalDateTime.parse(value), UTC);
        }
    }
}

