/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.basic;

import com.regnosys.rosetta.translate.basic.BasicParseHandler;
import com.rosetta.model.lib.records.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class DateParseHandler
extends BasicParseHandler<Date> {
    private DateTimeFormatter pattern;

    public DateParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ISO_LOCAL_DATE;
    }

    public DateParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml, String pattern) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ofPattern(pattern);
    }

    public String toString() {
        return "Date";
    }

    @Override
    protected Date convert(String value) {
        return Date.of((LocalDate)LocalDate.parse(value, this.pattern));
    }
}

