/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Multimap;
import com.regnosys.rosetta.translate.TranslatorOptions;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;

public class TranslatorOptionsImpl
implements TranslatorOptions {
    private final String name;
    private final Optional<String> modelId;
    private final Collection<String> modelClasspath;
    private final String modelFileDirIncludeRegex;
    private final Optional<String> modelFileDirExcludeRegex;
    private final Collection<String> rosettaClasses;
    private final String generatedPackage;
    private final String generatedFactoryName;
    private final Map<String, String> xsdFilePaths;
    private final Multimap<String, String> synonymSources;
    private final Multimap<String, String> topLevelTags;
    private final Map<String, String> childPackageName;
    private final Map<String, String> fullClassnames;
    private final boolean verbose;
    private final boolean clean;
    private final boolean json;
    private final String xmlExclusionsFilePath;
    private final String cdmClassesDir;
    private final Multimap<String, String> integrationTestRoots;
    private final boolean isDefault;
    private final boolean isCoreIgnored;
    private final boolean preProcessJson;

    @JsonCreator
    public TranslatorOptionsImpl(@JsonProperty(value="name") String name, @JsonProperty(value="modelId") Optional<String> modelId, @JsonProperty(value="modelClasspath") Collection<String> modelClasspath, @JsonProperty(value="modelFileDirIncludeRegex") String modelFileDirIncludeRegex, @JsonProperty(value="modelFileDirExcludeRegex") Optional<String> modelFileDirExcludeRegex, @JsonProperty(value="rosettaClasses") Collection<String> rosettaClasses, @JsonProperty(value="generatedPackage") String generatedPackage, @JsonProperty(value="generatedFactoryName") String generatedFactoryName, @JsonProperty(value="xsdFilePaths") Map<String, String> xsdFilePaths, @JsonProperty(value="synonymSources") Multimap<String, String> synonymSources, @JsonProperty(value="topLevelTags") Multimap<String, String> topLevelTags, @JsonProperty(value="childPackageNames") Map<String, String> childPackageNames, @JsonProperty(value="verbose") boolean verbose, @JsonProperty(value="clean") boolean clean, @JsonProperty(value="json") boolean json, @JsonProperty(value="preProcessJson", defaultValue="false") boolean preProcessJson, @JsonProperty(value="xmlExclusionsFilePath") String xmlExclusionsFilePath, @JsonProperty(value="cdmClassesDir") String cdmClassesDir, @JsonProperty(value="integrationTestRoots") Multimap<String, String> integrationTestRoots, @JsonProperty(value="default") boolean isDefault, @JsonProperty(value="fullClassNames") Map<String, String> fullClassNames, @JsonProperty(value="coreIgnored") boolean coreIgnored) {
        this.name = name;
        this.modelId = modelId;
        this.modelClasspath = modelClasspath;
        this.modelFileDirIncludeRegex = modelFileDirIncludeRegex;
        this.modelFileDirExcludeRegex = modelFileDirExcludeRegex;
        this.rosettaClasses = rosettaClasses;
        this.generatedPackage = generatedPackage;
        this.generatedFactoryName = generatedFactoryName;
        this.xsdFilePaths = xsdFilePaths;
        this.synonymSources = synonymSources;
        this.topLevelTags = topLevelTags;
        this.childPackageName = childPackageNames;
        this.verbose = verbose;
        this.clean = clean;
        this.json = json;
        this.preProcessJson = preProcessJson;
        this.xmlExclusionsFilePath = xmlExclusionsFilePath;
        this.cdmClassesDir = cdmClassesDir;
        this.integrationTestRoots = integrationTestRoots;
        this.isDefault = isDefault;
        this.fullClassnames = fullClassNames;
        this.isCoreIgnored = coreIgnored;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<String> getModelId() {
        return this.modelId;
    }

    @Override
    public Collection<String> getModelClasspath() {
        return this.modelClasspath;
    }

    @Override
    public String getModelFileDirIncludeRegex() {
        return this.modelFileDirIncludeRegex;
    }

    @Override
    public Optional<String> getModelFileDirExcludeRegex() {
        return this.modelFileDirExcludeRegex;
    }

    @Override
    public Collection<String> getRosettaClasses() {
        return this.rosettaClasses;
    }

    @Override
    public String getGeneratedPackage() {
        return this.generatedPackage;
    }

    @Override
    public String getXsdFilePath(String rosettaClassName) {
        return this.xsdFilePaths.get(rosettaClassName);
    }

    @Override
    public String getXmlExclusionsFilePath() {
        return this.xmlExclusionsFilePath;
    }

    @Override
    public Collection<String> getSynonymSources(String rosettaClassName) {
        return this.synonymSources.get((Object)rosettaClassName);
    }

    @Override
    public Collection<String> getTopLevelTags(String rosettaClassName) {
        return this.topLevelTags.get((Object)rosettaClassName);
    }

    @Override
    public String getGeneratedFactoryName() {
        return this.generatedFactoryName;
    }

    @Override
    public String getChildPackageName(String rosettaClassName) {
        return this.childPackageName.get(rosettaClassName);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public boolean clean() {
        return this.clean;
    }

    @Override
    public boolean isJson() {
        return this.json;
    }

    @Override
    public boolean isCoreIgnored() {
        return this.isCoreIgnored;
    }

    @Override
    public String getCdmClassesDir() {
        return this.cdmClassesDir;
    }

    @Override
    public Collection<String> getIntegrationTestRoots(String rosettaClassName) {
        return this.integrationTestRoots.get((Object)rosettaClassName);
    }

    @Override
    public String getFullClassname(String rosettaClassName) {
        return this.fullClassnames.get(rosettaClassName);
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public Map<String, String> getXsdFilePaths() {
        return this.xsdFilePaths;
    }

    public Multimap<String, String> getSynonymSources() {
        return this.synonymSources;
    }

    public Multimap<String, String> getTopLevelTags() {
        return this.topLevelTags;
    }

    public Map<String, String> getChildPackageName() {
        return this.childPackageName;
    }

    public boolean isClean() {
        return this.clean;
    }

    public Multimap<String, String> getIntegrationTestRoots() {
        return this.integrationTestRoots;
    }

    public Map<String, String> getFullClassnames() {
        return this.fullClassnames;
    }

    @Override
    public boolean preProcessJson() {
        return this.preProcessJson;
    }

    public String toString() {
        return new StringJoiner(", ", TranslatorOptionsImpl.class.getSimpleName() + "[", "]").add("name='" + this.name + "'").add("modelId='" + String.valueOf(this.modelId) + "'").add("modelClasspath=" + String.valueOf(this.modelClasspath)).add("modelFileDirIncludeRegex='" + this.modelFileDirIncludeRegex + "'").add("modelFileDirExcludeRegex=" + String.valueOf(this.modelFileDirExcludeRegex)).add("rosettaClasses=" + String.valueOf(this.rosettaClasses)).add("generatedPackage='" + this.generatedPackage + "'").add("generatedFactoryName='" + this.generatedFactoryName + "'").add("xsdFilePaths=" + String.valueOf(this.xsdFilePaths)).add("synonymSources=" + String.valueOf(this.synonymSources)).add("topLevelTags=" + String.valueOf(this.topLevelTags)).add("childPackageName=" + String.valueOf(this.childPackageName)).add("verbose=" + this.verbose).add("clean=" + this.clean).add("json=" + this.json).add("xmlExclusionsFilePath='" + this.xmlExclusionsFilePath + "'").add("cdmClassesDir='" + this.cdmClassesDir + "'").add("integrationTestRoots=" + String.valueOf(this.integrationTestRoots) + " ").add("isDefault=" + this.isDefault).toString();
    }
}

