/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.base.Stopwatch;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.common.compile.JavaCSourceCancellableCompiler;
import com.regnosys.rosetta.common.compile.JavaCompilationResult;
import com.regnosys.rosetta.common.compile.JavaCompileReleaseFlag;
import com.regnosys.rosetta.common.util.ClassPathUtils;
import com.regnosys.rosetta.common.util.StreamUtils;
import com.regnosys.rosetta.common.util.UrlUtils;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.rosetta.RosettaRootElement;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaType;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.translate.GeneratedNameAndSource;
import com.regnosys.rosetta.translate.GenerationResult;
import com.regnosys.rosetta.translate.GeneratorParams;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.IngestException;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.JsonHandlerFactory;
import com.regnosys.rosetta.translate.MappingError;
import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import com.regnosys.rosetta.translate.XmlHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class Translator {
    private static final Logger LOGGER = Logger.getLogger(Translator.class);
    private final TranslatorOptions options;
    private final ClassLoader classLoader;
    private final IngesterGenerator generator;
    private final SynonymToEnumMapGenerator synonymToEnumMapGenerator;

    public Translator(TranslatorOptions options, ClassLoader classLoader, IngesterGenerator generator, SynonymToEnumMapGenerator synonymToEnumMapGenerator) {
        this.options = options;
        this.classLoader = classLoader;
        this.generator = generator;
        this.synonymToEnumMapGenerator = synonymToEnumMapGenerator;
    }

    public GeneratedClasses<XmlHandlerFactory> generateClassesFromXmlSchema(Path baseDir) throws IOException, ClassNotFoundException {
        return this.generateClassesFromXmlSchema(baseDir, true);
    }

    public GeneratedClasses<JsonHandlerFactory> generateClassesFromJsonSchema(Path baseDir) throws IOException, ClassNotFoundException {
        return this.generateClassesFromJsonSchema(baseDir, true);
    }

    public GeneratedClasses<XmlHandlerFactory> generateClassesFromXmlSchema(Path baseDir, boolean generate) throws IOException, ClassNotFoundException {
        Path classesPath = this.generateAndCompile(baseDir, generate);
        URLClassLoader mappingsClassLoader = URLClassLoader.newInstance(new URL[]{classesPath.toUri().toURL()}, this.classLoader);
        String factoryName = String.format("%s.%s", this.options.getGeneratedPackage(), this.options.getGeneratedFactoryName());
        Class<?> factory = mappingsClassLoader.loadClass(factoryName);
        if (!XmlHandlerFactory.class.isAssignableFrom(factory)) {
            throw new IllegalStateException(String.valueOf(factory) + " is not assignable from " + String.valueOf(XmlHandlerFactory.class));
        }
        Class<?> xmlFactory = factory;
        Class<SynonymToEnumMapBuilder> synonymToEnumMap = this.createSynonymToEnumMap(mappingsClassLoader);
        return new GeneratedClasses<XmlHandlerFactory>(xmlFactory, synonymToEnumMap);
    }

    public GeneratedClasses<JsonHandlerFactory> generateClassesFromJsonSchema(Path baseDir, boolean generate) throws IOException, ClassNotFoundException {
        Path classesPath = this.generateAndCompile(baseDir, generate);
        URLClassLoader mappingsClassLoader = URLClassLoader.newInstance(new URL[]{classesPath.toUri().toURL()}, this.classLoader);
        String factoryName = String.format("%s.%s", this.options.getGeneratedPackage(), this.options.getGeneratedFactoryName());
        Class<?> factory = mappingsClassLoader.loadClass(factoryName);
        if (!JsonHandlerFactory.class.isAssignableFrom(factory)) {
            throw new IllegalStateException(String.valueOf(factory) + " is not assignable from " + String.valueOf(JsonHandlerFactory.class));
        }
        Class<?> jsonFactory = factory;
        Class<SynonymToEnumMapBuilder> synonymToEnumMap = this.createSynonymToEnumMap(mappingsClassLoader);
        return new GeneratedClasses<JsonHandlerFactory>(jsonFactory, synonymToEnumMap);
    }

    private Class<SynonymToEnumMapBuilder> createSynonymToEnumMap(URLClassLoader mappingsClassLoader) throws IOException, ClassNotFoundException {
        String className = String.format("%s.%s", this.options.getGeneratedPackage(), "SynonymToEnumMapBuilderImpl");
        Class<SynonymToEnumMapBuilder> mapBuilder = mappingsClassLoader.loadClass(className);
        if (!SynonymToEnumMapBuilder.class.isAssignableFrom(mapBuilder)) {
            throw new IllegalStateException(String.valueOf(mapBuilder) + " is not assignable from " + String.valueOf(SynonymToEnumMapBuilder.class));
        }
        return mapBuilder;
    }

    public Path generateAndCompile(Path baseDir, boolean generate) throws IOException {
        Path srcPath = Files.createDirectories(baseDir.resolve("translate-src"), new FileAttribute[0]);
        Path classesDir = baseDir.resolve("translate-classes");
        boolean hasClasses = Files.exists(classesDir, new LinkOption[0]) && Files.walk(classesDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findAny().isPresent();
        Path classesPath = Files.createDirectories(classesDir, new FileAttribute[0]);
        if (generate) {
            List<Path> generateJavaPaths;
            if (this.options.clean() && Files.exists(baseDir, new LinkOption[0])) {
                Files.walk(baseDir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            if (!(generateJavaPaths = this.generateJava(srcPath, hasClasses)).isEmpty()) {
                this.compileToClasses(srcPath, generateJavaPaths, classesPath, true, new Path[0]);
            }
        }
        if (!Files.exists(classesPath, new LinkOption[0])) {
            throw new IllegalStateException("Output classes path does not exist [" + String.valueOf(classesPath) + "]");
        }
        return classesPath;
    }

    public List<Path> generateJava(Path outputPath, boolean hasClasses) throws IOException {
        LOGGER.trace((Object)("Starting Java Code Generation to " + String.valueOf(outputPath)));
        Stopwatch stopwatch = Stopwatch.createStarted();
        List expandedModelPaths = ClassPathUtils.findPathsFromClassPath(this.options.getModelClasspath(), (String)this.options.getModelFileDirIncludeRegex(), this.options.getModelFileDirExcludeRegex(), (ClassLoader)this.classLoader);
        List<RosettaRootElement> rosettaRootElements = this.loadRosettaRootElements(expandedModelPaths);
        List<Data> rosettaClasses = this.loadRosettaClasses(this.options, rosettaRootElements);
        ArrayList<GeneratorParams> generatorParams = new ArrayList<GeneratorParams>();
        for (RosettaType rosettaType : rosettaClasses) {
            URL expandedXsdURL = this.getXsdURL(this.options, rosettaType.getName());
            LOGGER.debug((Object)("Using xsd path: " + String.valueOf(expandedXsdURL)));
            Collection<String> synonymSourcesAsString = this.options.getSynonymSources(rosettaType.getName());
            List<RosettaSynonymSource> synonymSources = synonymSourcesAsString.stream().map(s -> this.loadRosettaSource(rosettaRootElements, (String)s)).collect(Collectors.toList());
            Collection<String> topLevelTags = this.options.getTopLevelTags(rosettaType.getName());
            GeneratorParams params = new GeneratorParams(expandedXsdURL, Collections.singleton(rosettaType), synonymSources, topLevelTags, this.options.getChildPackageName(rosettaType.getName()));
            generatorParams.add(params);
        }
        String generatedFactoryName = this.options.getGeneratedFactoryName();
        LOGGER.debug((Object)("Generating handlers in " + this.options.getGeneratedPackage() + " with factory class " + generatedFactoryName));
        IngesterGenerator.GeneratedIngesters generatedIngesters = this.options.isJson() ? this.generator.generateJson(this.options.getGeneratedPackage(), generatedFactoryName, generatorParams) : this.generator.generateXml(this.options.getGeneratedPackage(), generatedFactoryName, generatorParams);
        LOGGER.info((Object)("Generated " + generatedIngesters.getGeneratedHandlers().size() + " Xml Handlers"));
        HashSet<MappingError> errors = new HashSet<MappingError>(generatedIngesters.getErrors());
        for (MappingError error : errors) {
            if (error.getLevel() == MappingError.MappingErrorLevel.ERROR) {
                LOGGER.trace((Object)error.getMessage());
            }
            if (error.getLevel() != MappingError.MappingErrorLevel.WARNING) continue;
        }
        long warnCount = generatedIngesters.getErrors().stream().filter(e -> e.getLevel() == MappingError.MappingErrorLevel.WARNING).count();
        LOGGER.debug((Object)("Model comparison generated " + warnCount + " warnings"));
        List<Path> generatedJavaPaths = Translator.writeOutJava(generatedIngesters, outputPath, hasClasses);
        LOGGER.debug((Object)("Generating SynonymToEnumMap in " + this.options.getGeneratedPackage()));
        List<RosettaEnumeration> rosettaEnumerations = this.loadRosettaEnumerations(rosettaRootElements);
        GeneratedNameAndSource generatedSynonymToEnumMap = this.synonymToEnumMapGenerator.generate(this.options.getGeneratedPackage(), generatorParams, rosettaEnumerations);
        Translator.writeClass(outputPath, generatedSynonymToEnumMap.getClassName(), generatedSynonymToEnumMap.getSource(), hasClasses).ifPresent(generatedJavaPaths::add);
        LOGGER.info((Object)("Finished Java Code Generation. Took " + stopwatch.toString()));
        return generatedJavaPaths;
    }

    private Path compileToJar(Path javaSourcePath, Path outputJarPath, boolean useSystemClassPath, Path ... additionalClassPaths) throws IOException {
        List javaPaths = ClassPathUtils.expandPaths(Collections.singletonList(javaSourcePath), (String)".*\\.java", Optional.empty());
        Path classesDir = this.compileToClasses(javaSourcePath, javaPaths, Files.createTempDirectory("translate-classes", new FileAttribute[0]), useSystemClassPath, additionalClassPaths);
        Files.createDirectories(outputJarPath.getParent(), new FileAttribute[0]);
        this.cleanupOldJars(outputJarPath);
        return this.jar(outputJarPath, classesDir);
    }

    private Path jar(Path outputJarPath, Path outputClassesDir) throws IOException {
        LOGGER.trace((Object)("Creating JAR file " + String.valueOf(outputJarPath.toAbsolutePath()) + " from " + String.valueOf(outputClassesDir.toAbsolutePath())));
        Path zipFilePath = Files.createFile(outputJarPath, new FileAttribute[0]);
        try (JarOutputStream zipOutputStream = new JarOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            zipOutputStream.setLevel(9);
            List paths = Files.walk(outputClassesDir, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList());
            for (Path path2 : paths) {
                ZipEntry zipEntry = new ZipEntry(outputClassesDir.relativize(path2).toString());
                LOGGER.trace((Object)("Writing JAR file entry " + String.valueOf(zipEntry)));
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(Files.readAllBytes(path2));
                zipOutputStream.closeEntry();
                zipOutputStream.flush();
            }
            zipOutputStream.flush();
        }
        LOGGER.trace((Object)("Finished Creating JAR file " + String.valueOf(outputJarPath.toAbsolutePath()) + " from " + String.valueOf(outputClassesDir.toAbsolutePath())));
        return zipFilePath;
    }

    private void cleanupOldJars(Path outputJarPath) throws IOException {
        if (Files.exists(outputJarPath, new LinkOption[0])) {
            String date = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
            Files.move(outputJarPath, outputJarPath.resolveSibling(date + "-" + outputJarPath.getFileName().toString()), new CopyOption[0]);
        }
        List sortedJarFiles = Files.list(outputJarPath.getParent()).filter(p -> p.getFileName().toString().endsWith(outputJarPath.getFileName().toString())).sorted().collect(Collectors.toList());
        for (int i = 0; i < sortedJarFiles.size() - 5; ++i) {
            LOGGER.trace((Object)("Deleting old jar file " + String.valueOf(sortedJarFiles.get(i)) + "."));
            Files.delete((Path)sortedJarFiles.get(i));
        }
    }

    public Path compileToClasses(Path javaSourcePath, List<Path> generateJavaPaths, Path outputClassesDir, boolean useSystemClassPath, Path ... additionalClassPaths) throws IOException {
        Files.createDirectories(outputClassesDir, new FileAttribute[0]);
        LOGGER.info((Object)("Starting Compiling " + javaSourcePath.toString() + " to " + outputClassesDir.toString()));
        LOGGER.debug((Object)String.format("useSystemClassPath %s - %s", useSystemClassPath, Arrays.toString(additionalClassPaths)));
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        JavaCSourceCancellableCompiler javaCompiler = new JavaCSourceCancellableCompiler(executorService, useSystemClassPath, true, this.options.isVerbose(), JavaCompileReleaseFlag.JAVA_11, additionalClassPaths);
        try {
            JavaCompilationResult compile = javaCompiler.compile(generateJavaPaths, outputClassesDir, () -> false);
            if (!compile.isCompilationSuccessful()) {
                LOGGER.error((Object)("Compilation Failed: " + String.valueOf(compile.getDiagnostics())));
            }
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Error thrown during compilation", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Unexpected interrupt during compilation in Translator", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Timed out during compilation", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            executorService.shutdown();
        }
        LOGGER.info((Object)("Finished Compiling. Took " + stopwatch.toString()));
        return outputClassesDir;
    }

    private List<RosettaRootElement> loadRosettaRootElements(List<Path> expandedModelPaths) {
        LOGGER.trace((Object)"Loading rosetta root elements");
        RosettaStandaloneSetup.doSetup();
        XtextResourceSet resourceSet = this.createResourceSet(expandedModelPaths);
        List<RosettaRootElement> rootElements = resourceSet.getResources().stream().map(Resource::getContents).flatMap(Collection::stream).map(r -> (RosettaModel)r).filter(Objects::nonNull).map(RosettaModel::getElements).flatMap(Collection::stream).collect(Collectors.toList());
        LOGGER.debug((Object)("Found " + rootElements.size() + " root elements"));
        return rootElements;
    }

    private List<Data> loadRosettaClasses(TranslatorOptions options, List<RosettaRootElement> rosettaRootElements) {
        LOGGER.debug((Object)("Trying to load model classes : " + String.valueOf(this.getFullClassName(options))));
        List<Data> rosettaClasses = rosettaRootElements.stream().filter(c -> c instanceof Data).map(c -> (Data)c).filter(c -> this.getFullClassName(options).contains(this.getFullClassName((Data)c))).filter(StreamUtils.distinctByKey(c -> c.getName())).collect(Collectors.toList());
        LOGGER.debug((Object)("Found model classes  : " + String.valueOf(rosettaClasses.stream().map(this::getFullClassName).collect(Collectors.toList()))));
        return rosettaClasses;
    }

    private List<RosettaEnumeration> loadRosettaEnumerations(List<RosettaRootElement> rosettaRootElements) {
        LOGGER.trace((Object)"Load model enumerations");
        List<RosettaEnumeration> rosettaEnums = rosettaRootElements.stream().filter(e -> e instanceof RosettaEnumeration).map(e -> (RosettaEnumeration)e).filter(StreamUtils.distinctByKey(c -> this.getFullClassName((RosettaEnumeration)c))).collect(Collectors.toList());
        LOGGER.debug((Object)("Found " + rosettaEnums.size() + " model enumerations"));
        return rosettaEnums;
    }

    private RosettaSynonymSource loadRosettaSource(List<RosettaRootElement> rosettaRootElements, String sourceName) {
        return rosettaRootElements.stream().filter(c -> c instanceof RosettaSynonymSource).map(c -> (RosettaSynonymSource)c).filter(c -> c.getName().equals(sourceName)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find source with name " + sourceName));
    }

    private List<String> getFullClassName(TranslatorOptions options) {
        return options.getRosettaClasses().stream().map(x -> options.getFullClassname((String)x)).collect(Collectors.toList());
    }

    private String getFullClassName(Data data) {
        String namespace = Optional.ofNullable(data.getModel()).map(RosettaModel::getName).map(ns -> ns + ".").orElse("");
        return namespace + data.getName();
    }

    private String getFullClassName(RosettaEnumeration e) {
        String namespace = Optional.ofNullable(e.getModel()).map(RosettaModel::getName).map(ns -> ns + ".").orElse("");
        return namespace + e.getName();
    }

    private URL getXsdURL(TranslatorOptions options, String rosettaClassName) {
        String xsdFilePath = options.getXsdFilePath(rosettaClassName);
        Path path = Paths.get(xsdFilePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            return UrlUtils.toUrl((Path)path);
        }
        URL resource = this.classLoader.getResource(xsdFilePath);
        if (resource == null) {
            throw new IngestException("Error reading xsd file - " + xsdFilePath + " could not be found");
        }
        return resource;
    }

    private static List<Path> writeOutJava(IngesterGenerator.GeneratedIngesters ingesters, Path outputPath, boolean hasClasses) throws IOException {
        LOGGER.trace((Object)("Writing Java mapping handlers to " + String.valueOf(outputPath)));
        ArrayList<Path> javaPaths = new ArrayList<Path>();
        GeneratedNameAndSource generatedFactory = ingesters.getGeneratedFactory();
        Translator.writeClass(outputPath, generatedFactory.getClassName(), generatedFactory.getSource(), hasClasses).ifPresent(javaPaths::add);
        List<GeneratedNameAndSource> generatedXmlHandlers = ingesters.getGeneratedHandlers();
        for (GeneratedNameAndSource gen : generatedXmlHandlers) {
            Translator.writeClass(outputPath, gen.getClassName(), gen.getSource(), hasClasses).ifPresent(javaPaths::add);
        }
        LOGGER.debug((Object)("Wrote " + javaPaths.size() + " java classes"));
        return javaPaths;
    }

    private static Optional<Path> writeClass(Path outputPath, String qualifiedClassName, GenerationResult classContents, boolean hasClasses) throws IOException {
        String pathName = qualifiedClassName.replace('.', File.separatorChar);
        Path path = outputPath.resolve(pathName + ".java");
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        LOGGER.trace((Object)("Writing Java mapping file " + path.toAbsolutePath().toString()));
        if (classContents.isUnchanged()) {
            return Optional.empty();
        }
        if (!Files.exists(path, new LinkOption[0]) || !hasClasses) {
            Files.writeString(path, classContents.getChangedValue(), StandardCharsets.UTF_8, new OpenOption[0]);
            return Optional.of(path);
        }
        if (!Files.readString(path, StandardCharsets.UTF_8).equals(classContents.getChangedValue())) {
            Files.write(outputPath.resolve(pathName + ".old"), Files.readAllBytes(path), new OpenOption[0]);
            Files.writeString(outputPath.resolve(pathName + ".new"), classContents.getChangedValue(), StandardCharsets.UTF_8, new OpenOption[0]);
            Files.writeString(path, classContents.getChangedValue(), StandardCharsets.UTF_8, new OpenOption[0]);
            return Optional.of(path);
        }
        return Optional.empty();
    }

    private XtextResourceSet createResourceSet(List<Path> expandedModelPaths) {
        XtextResourceSet resourceSet = new XtextResourceSet();
        expandedModelPaths.forEach(f -> resourceSet.getResource(URI.createURI((String)f.toUri().toString(), (boolean)true), true));
        return resourceSet;
    }

    public static class GeneratedClasses<T extends HandlerFactory> {
        private final Class<T> handlerFactory;
        private final Class<SynonymToEnumMapBuilder> synonymToEnumMap;

        public GeneratedClasses(Class<T> handlerFactory, Class<SynonymToEnumMapBuilder> synonymToEnumMap) {
            this.handlerFactory = handlerFactory;
            this.synonymToEnumMap = synonymToEnumMap;
        }

        public Class<T> getHandlerFactory() {
            return this.handlerFactory;
        }

        public Class<SynonymToEnumMapBuilder> getSynonymToEnumMap() {
            return this.synonymToEnumMap;
        }
    }
}

