/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public class CustomDeserialise {
    protected Map<String, BiFunction<Long, DeserialiseContext, ? extends Object>> parseMethods = new HashMap<String, BiFunction<Long, DeserialiseContext, ? extends Object>>();

    public Object deserialise(InputStream in) throws ParseException {
        DeserialiseContext context = new DeserialiseContext(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
        return this.readOne(context);
    }

    protected <T> T readOne(DeserialiseContext context) {
        String line = context.read();
        if (line.startsWith("null")) {
            return null;
        }
        return this.readOne(line, context);
    }

    private <T> T readOne(String firstLine, DeserialiseContext context) {
        Object o = null;
        if (firstLine.startsWith("=")) {
            Long objectId = Long.parseLong(firstLine.substring(1));
            o = context.objectIds.get(objectId);
            if (o == null) {
                throw new ParseException("Object with id " + objectId + " not found at line " + context.lineNum);
            }
        } else if (firstLine.startsWith("#")) {
            Long objectId = Long.parseLong(firstLine.substring(1));
            String className = context.read("class:");
            o = this.readObject(className, objectId, context);
        } else {
            throw new ParseException("Expecting Array end ']' object start '#num' or reference '=num' but found " + firstLine + " at line " + context.lineNum);
        }
        return (T)o;
    }

    protected <T> List<T> readList(DeserialiseContext context) {
        ArrayList<T> result = new ArrayList<T>();
        boolean arrayEnd = false;
        while (!arrayEnd) {
            String line = context.read();
            if (line.startsWith("null")) continue;
            if (line.startsWith("]")) {
                arrayEnd = true;
                continue;
            }
            T o = this.readOne(line, context);
            result.add(o);
        }
        return result;
    }

    private <T> T readObject(String className, long objectId, DeserialiseContext context) {
        BiFunction<Long, DeserialiseContext, ? extends Object> parseMethod = this.parseMethods.get(className);
        if (parseMethod == null) {
            throw new ParseException("Dont know how to read object of type " + className + " at line " + context.lineNum);
        }
        return (T)parseMethod.apply(objectId, context);
    }

    protected class DeserialiseContext {
        private final BufferedReader reader;
        private final Map<Long, Object> objectIds = new HashMap<Long, Object>();
        private int lineNum = 0;

        public DeserialiseContext(BufferedReader reader) {
            this.reader = reader;
        }

        public String read(String expected) {
            String read = this.read();
            if (!read.startsWith(expected)) {
                throw new ParseException("Error reading schema at line " + this.lineNum + " expected " + expected + " but read " + read);
            }
            return read.substring(expected.length());
        }

        public void addObjectId(Long objectId, Object object) {
            this.objectIds.put(objectId, object);
        }

        protected String read() {
            try {
                String read = this.reader.readLine().trim();
                ++this.lineNum;
                return read;
            }
            catch (IOException e) {
                throw new ParseException("error reading from source", e);
            }
        }
    }

    public class ParseException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ParseException(String message, Exception cause) {
            super(message, cause);
        }

        public ParseException(String message) {
            super(message);
        }
    }
}

