/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.rosetta.RosettaMapPathValue;
import com.regnosys.rosetta.rosetta.RosettaMapTestEqualityOperation;
import com.regnosys.rosetta.rosetta.RosettaMapTestExpression;
import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SynonymBinaryTest
implements SynonymTest {
    private final SynonymValue leftPath;
    private final SynonymValue rightPath;
    private final RosettaMapTestExpression leftLiteral;
    private final RosettaMapTestExpression rightLiteral;
    private final String operator;

    public SynonymBinaryTest(RosettaMapTestEqualityOperation op) {
        if (op.getLeft() instanceof RosettaMapPathValue) {
            this.leftPath = new SynonymValue(Element.toElementList(((RosettaMapPathValue)op.getLeft()).getPath()), 1, false);
            this.leftLiteral = null;
        } else {
            this.leftLiteral = op.getLeft();
            this.leftPath = null;
        }
        if (op.getRight() instanceof RosettaMapPathValue) {
            this.rightPath = new SynonymValue(Element.toElementList(((RosettaMapPathValue)op.getRight()).getPath()), 1, false);
            this.rightLiteral = null;
        } else {
            this.rightLiteral = op.getRight();
            this.rightPath = null;
        }
        this.operator = op.getOperator();
    }

    @Override
    public SynonymTest.TestPriority priority() {
        return SynonymTest.TestPriority.Middle;
    }

    @Override
    public List<SynonymValue> getPaths() {
        return Stream.of(this.leftPath, this.rightPath).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public SynonymValue getLeftPath() {
        return this.leftPath;
    }

    public SynonymValue getRightPath() {
        return this.rightPath;
    }

    public RosettaMapTestExpression getLeftLiteral() {
        return this.leftLiteral;
    }

    public RosettaMapTestExpression getRightLiteral() {
        return this.rightLiteral;
    }

    public String getOperator() {
        return this.operator;
    }

    public String toString() {
        return (this.leftPath == null ? SynonymTest.toString(this.leftLiteral) : this.leftPath.toPathString()) + this.operator + (this.rightPath == null ? SynonymTest.toString(this.rightLiteral) : this.rightPath.toPathString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftLiteral == null ? 0 : this.leftLiteral.hashCode());
        result = 31 * result + (this.leftPath == null ? 0 : this.leftPath.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.rightLiteral == null ? 0 : this.rightLiteral.hashCode());
        result = 31 * result + (this.rightPath == null ? 0 : this.rightPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymBinaryTest other = (SynonymBinaryTest)obj;
        if (this.leftLiteral == null ? other.leftLiteral != null : !this.leftLiteral.equals(other.leftLiteral)) {
            return false;
        }
        if (this.leftPath == null ? other.leftPath != null : !this.leftPath.equals(other.leftPath)) {
            return false;
        }
        if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
            return false;
        }
        if (this.rightLiteral == null ? other.rightLiteral != null : !this.rightLiteral.equals(other.rightLiteral)) {
            return false;
        }
        return !(this.rightPath == null ? other.rightPath != null : !this.rightPath.equals(other.rightPath));
    }
}

