/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel;

import com.regnosys.rosetta.translate.CustomSerialise;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.AttributeImpl;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.EntityImpl;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.SimpleType;
import com.regnosys.rosetta.translate.datamodel.json.JsonAttribute;
import com.regnosys.rosetta.translate.datamodel.json.JsonEntity;

public class SchemaSerialise
extends CustomSerialise {
    public SchemaSerialise() {
        this.serialiseMethods.put(AttributeImpl.class, this::serialiseAtt);
        this.serialiseMethods.put(JsonAttribute.class, this::serialiseAtt);
        this.serialiseMethods.put(Schema.class, this::serialiseSchema);
        this.serialiseMethods.put(EntityImpl.class, this::serialiseEntity);
        this.serialiseMethods.put(JsonEntity.class, this::serialiseEntity);
        this.serialiseMethods.put(SimpleType.class, this::serialiseSimpleType);
    }

    private void serialiseSchema(Schema schema, CustomSerialise.SerialiseContext context) {
        this.writeCollection("attributes:", schema.getAttributes(), context);
        this.writeCollection("entities:", schema.getGlobalTypes(), context);
    }

    private void serialiseAtt(Attribute att, CustomSerialise.SerialiseContext context) {
        this.print("name:", att.getName(), context);
        this.print("cardinality:", att.getCardinality().toString(), context);
        this.print("type:", "", context);
        this.writeObjOrRef(att.getType(), context);
    }

    private void serialiseEntity(Entity ent, CustomSerialise.SerialiseContext context) {
        this.print("namespace:", ent.getName().getNamespace(), context);
        this.print("name:", ent.getName().getName(), context);
        this.print("hasData:", ent.hasData(), context);
        this.print("extends:", "", context);
        this.writeObjOrRef(ent.getExtendedEntity(), context);
        this.writeCollection("attributes:", ent.getAttributes(), context);
        this.print("extending:", "[", context);
        for (Entity ext : ent.getKnownExtendingEntities()) {
            this.writeObjOrRef(ext, context);
        }
        this.print("]", context);
        this.print("child:", ent.hasChild(), context);
    }

    private void serialiseSimpleType(SimpleType type, CustomSerialise.SerialiseContext context) {
        this.print("namespace:", type.getName().getNamespace(), context);
        this.print("name:", type.getName().getName(), context);
        this.print("type:", type.getType().toString(), context);
        this.print("extending:", "[", context);
        for (Entity ext : type.getKnownExtendingEntities()) {
            this.writeObjOrRef(ext, context);
        }
        this.print("]", context);
    }
}

