/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.common.translation.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class SynonymValueGroup {
    private final List<Path> paths;

    public SynonymValueGroup(List<Path> paths) {
        this.paths = paths;
    }

    public SynonymValueGroup(String ... pathStrings) {
        this.paths = Arrays.stream(pathStrings).map(s -> Path.parse((String)s)).collect(Collectors.toList());
    }

    public List<Path> getPaths() {
        return this.paths;
    }

    public boolean startMatches(Path path) {
        return this.getPaths().stream().anyMatch(p -> p.nameStartMatches(path));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymValueGroup other = (SynonymValueGroup)obj;
        return !(this.paths == null ? other.paths != null : !this.paths.equals(other.paths));
    }

    public String toString() {
        return "SynonymGroup [paths=" + this.paths + "]";
    }
}

