/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.util.CollectionUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestMerger
implements BuilderMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestMerger.class);

    public <T extends RosettaModelObjectBuilder> void run(T o1, T o2) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Merging [o1={},o2={}]", o1, o2);
        }
        Objects.requireNonNull(o1).merge(Objects.requireNonNull(o2), (BuilderMerger)this);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Merged [o1={}]", o1);
        }
    }

    public <T extends RosettaModelObjectBuilder> void mergeRosetta(T o1, T o2, Consumer<T> o1Setter) {
        if (o1 != null && o2 != null) {
            o1.merge(o2, (BuilderMerger)this);
        } else {
            Optional.ofNullable(o2).ifPresent(o1Setter);
        }
    }

    public <T extends RosettaModelObjectBuilder> void mergeRosetta(List<? extends T> o1, List<? extends T> o2, Function<Integer, T> o1GetOrCreateByIndex) {
        int i = 0;
        Iterator i2 = CollectionUtils.emptyIfNull(o2).iterator();
        while (i2.hasNext()) {
            if (i2.hasNext()) {
                ((RosettaModelObjectBuilder)o1GetOrCreateByIndex.apply(i)).merge((RosettaModelObjectBuilder)i2.next(), (BuilderMerger)this);
            }
            ++i;
        }
    }

    public <T> void mergeBasic(T o1, T o2, Consumer<T> o1Setter, AttributeMeta ... metas) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            if (!this.metaContains(metas, AttributeMeta.GLOBAL_KEY)) {
                LOGGER.info("Merge clash [o1={},o2={}]", o1, o2);
            }
        } else {
            Optional.ofNullable(o2).ifPresent(o1Setter);
        }
    }

    public <T> void mergeBasic(List<? extends T> o1, List<? extends T> o2, Consumer<T> o1Add) {
        CollectionUtils.emptyIfNull(o2).forEach(o1Add);
    }

    private boolean metaContains(AttributeMeta[] metas, AttributeMeta attributeMeta) {
        return Arrays.stream(metas).anyMatch(m -> m == attributeMeta);
    }
}

