/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.collect.Multimap;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public class CustomSerialise {
    protected Map<Class<?>, BiConsumer<? extends Object, SerialiseContext>> serialiseMethods = new HashMap();

    public void serialiseObject(Object o, OutputStream out) {
        SerialiseContext context = new SerialiseContext(new PrintStream(out, false, StandardCharsets.UTF_8));
        this.writeObjOrRef(o, context);
    }

    public <T> void serialiseList(List<T> col, OutputStream out) {
        SerialiseContext context = new SerialiseContext(new PrintStream(out, false, StandardCharsets.UTF_8));
        context.incrementIndent();
        this.writeCollection("", col, context);
        context.decrementIndent();
    }

    protected <T> void serialiseObject(T o, SerialiseContext context) {
        BiConsumer<? extends Object, SerialiseContext> serialiseMethod = this.serialiseMethods.get(o.getClass());
        if (serialiseMethod == null) {
            throw new UnsupportedOperationException("Don't know how to serialise " + o.getClass().getName());
        }
        serialiseMethod.accept(o, context);
    }

    protected void write(String label, Object o, SerialiseContext context) {
        this.print(label, context);
        this.writeObjOrRef(o, context);
    }

    protected void writeObjOrRef(Object o, SerialiseContext context) {
        context.incrementIndent();
        if (o == null) {
            this.print("null", context);
        } else {
            Long existingId = context.objectIds.get(o);
            if (existingId != null) {
                this.print("=", existingId, context);
            } else {
                long newId = context.currentId++;
                context.objectIds.put(o, newId);
                this.print("#", newId, context);
                String className = o.getClass().getName();
                this.print("class:", className, context);
                this.serialiseObject(o, context);
            }
        }
        context.decrementIndent();
    }

    protected <T> void writeCollection(String label, Collection<T> col, SerialiseContext context) {
        this.print(label, "[", context);
        for (T t : col) {
            this.writeObjOrRef(t, context);
        }
        this.print("]", context);
    }

    protected <K, V> void writeMap(String label, Map<K, V> map, SerialiseContext context) {
        this.print(label, "[", context);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeObjOrRef(entry.getKey(), context);
            this.print("->", context);
            this.writeObjOrRef(entry.getValue(), context);
        }
        this.print("]", context);
    }

    protected <K, V> void writeMultimap(String label, Multimap<K, V> map, SerialiseContext context) {
        this.print(label, "[", context);
        for (Map.Entry entry : map.entries()) {
            this.writeObjOrRef(entry.getKey(), context);
            this.print("->", context);
            this.writeObjOrRef(entry.getValue(), context);
        }
        this.print("]", context);
    }

    protected void print(String label, SerialiseContext context) {
        this.indent(context);
        context.pout.println(label);
    }

    protected void print(String label, String value, SerialiseContext context) {
        this.indent(context);
        context.pout.print(label);
        context.pout.println(value);
    }

    protected void print(String label, Long value, SerialiseContext context) {
        this.indent(context);
        context.pout.print(label);
        context.pout.println(value);
    }

    protected void print(String label, int value, SerialiseContext context) {
        this.indent(context);
        context.pout.print(label);
        context.pout.println(value);
    }

    protected void print(String label, boolean value, SerialiseContext context) {
        this.indent(context);
        context.pout.print(label);
        context.pout.println(value);
    }

    private void indent(SerialiseContext context) {
        if (context.indent < 0) {
            throw new RuntimeException("Error serializing objects indent became negative");
        }
        context.pout.write(context.tabs, 0, context.indent);
    }

    protected class SerialiseContext {
        private int indent = -1;
        byte[] tabs = new byte[100];
        private PrintStream pout;
        private final IdentityHashMap<Object, Long> objectIds = new IdentityHashMap();
        private long currentId = 0L;

        public SerialiseContext(PrintStream pout) {
            this.pout = pout;
            Arrays.fill(this.tabs, (byte)9);
        }

        public void incrementIndent() {
            ++this.indent;
            if (this.indent > this.tabs.length - 1) {
                this.tabs = new byte[this.indent * 2];
                Arrays.fill(this.tabs, (byte)9);
            }
        }

        public void decrementIndent() {
            --this.indent;
        }
    }
}

