/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;

public class ExpectationDefaults {
    public static final String WRITE_EXPECTATIONS_ENV = "WRITE_EXPECTATIONS";
    public static final String CREATE_EXPECTATION_FILES_ENV = "CREATE_EXPECTATION_FILES";
    public static final String TEST_WRITE_BASE_PATH_ENV = "TEST_WRITE_BASE_PATH";
    private final FileSystem fileSystem;
    private final Map<String, String> environment;

    public ExpectationDefaults() {
        this.fileSystem = FileSystems.getDefault();
        this.environment = System.getenv();
    }

    @VisibleForTesting
    ExpectationDefaults(FileSystem fileSystem, Map<String, String> map) {
        this.fileSystem = fileSystem;
        this.environment = map;
    }

    public boolean writeExpectationsFlag() {
        return Optional.ofNullable(this.environment.get(WRITE_EXPECTATIONS_ENV)).map(Boolean::parseBoolean).orElse(false);
    }

    public boolean createExpectationFilesFlag() {
        Optional<Boolean> optional = Optional.ofNullable(this.environment.get(CREATE_EXPECTATION_FILES_ENV)).map(Boolean::parseBoolean);
        return optional.orElseGet(this::writeExpectationsFlag);
    }

    public Optional<Path> testWriteBasePath() {
        Optional<Path> optional = Optional.ofNullable(this.environment.get(TEST_WRITE_BASE_PATH_ENV)).map(string -> this.fileSystem.getPath((String)string, new String[0]));
        if (optional.isPresent()) {
            return optional;
        }
        if (this.writeExpectationsFlag()) {
            return Optional.of(this.findResourceDir(this.fileSystem.getPath(".", new String[0]).toAbsolutePath()));
        }
        return Optional.empty();
    }

    private Path findResourceDir(Path path) {
        Path path2 = path.resolve("src").resolve("main").resolve("rosetta");
        if (Files.exists(path2, new LinkOption[0])) {
            return path.resolve("src").resolve("main").resolve("resources");
        }
        if (path.getParent() == null) {
            throw new IllegalStateException("Could not find the resource dir for " + path);
        }
        return this.findResourceDir(path.getParent());
    }
}

