/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.io.Resources;
import com.regnosys.ingest.test.framework.ingestor.IngestionReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import com.regnosys.ingest.test.framework.ingestor.testing.QualificationExpectation;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationHandler;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationReport;
import com.regnosys.rosetta.common.postprocess.qualify.QualificationResult;
import com.regnosys.rosetta.common.serialisation.RosettaObjectMapper;
import com.regnosys.rosetta.common.util.SimpleProcessor;
import com.regnosys.rosetta.common.validation.ValidationReport;
import com.rosetta.lib.postprocess.PostProcessorReport;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.PostProcessStep;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.qualify.QualifyResult;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertIngestion {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertIngestion.class);

    public static void assertMapped(MappingReport mappingReport, int n) {
        LOGGER.info("[{}] external data points, of which [{}] mapped one-to-one - Mapping completed {}%", new Object[]{mappingReport.getExternalPaths(), mappingReport.getSuccessCount(), String.format("%.1f", mappingReport.getCompleteness())});
        mappingReport.getFailures().stream().sorted(AssertIngestion.sortMappingResult()).map(MappingResult::toString).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
        MatcherAssert.assertThat((String)"Zero paths successfully mapped", (mappingReport.getSuccessCount() > 0L ? 1 : 0) != 0);
        if (n >= 0) {
            MatcherAssert.assertThat((String)"Number of failed mappings", (Object)mappingReport.getFailures().size(), (Matcher)Matchers.is((Object)n));
        } else {
            MatcherAssert.assertThat((String)"All external fields mapped one-to-one", (Object)mappingReport.getFailures().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(n)));
        }
    }

    public static Comparator<MappingResult> sortMappingResult() {
        Function<MappingResult, String> function = mappingResult -> mappingResult.getExternalPath().toString();
        return Comparator.comparing(function);
    }

    public static void assertValidated(ValidationReport validationReport, int n) {
        Assertions.assertNotNull((Object)validationReport);
        Assertions.assertNotNull((Object)validationReport.validationFailures());
        validationReport.logReport();
        MatcherAssert.assertThat((String)"Unexpected number of validation failures", (Object)validationReport.validationFailures().size(), (Matcher)Matchers.is((Object)n));
    }

    public static void assertQualification(QualificationReport qualificationReport, QualificationExpectation qualificationExpectation) {
        if (qualificationExpectation == null) {
            return;
        }
        qualificationReport.logReport();
        List list = qualificationReport.getResults().stream().filter(qualificationResult -> qualificationResult.getUniqueSuccessQualifyResult().isPresent()).map(qualificationResult -> new QualificationExpectation.Result(((QualifyResult)qualificationResult.getUniqueSuccessQualifyResult().get()).getName(), qualificationResult.getQualifiedRosettaObjectType().getName())).sorted().collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Unexpected number of qualifiable objects", (Object)qualificationReport.getResults().size(), (Matcher)Matchers.is((Object)qualificationExpectation.getQualifiableObjectCount()));
        List<QualificationExpectation.Result> list2 = qualificationExpectation.getQualifyResults();
        Collections.sort(list2);
        String string = qualificationReport.getResults().stream().filter(qualificationResult -> qualificationResult.getUniqueSuccessQualifyResult().isEmpty()).map(Objects::toString).collect(Collectors.joining(", "));
        MatcherAssert.assertThat((String)("Mismatch of successfully qualified objects " + string), list, (Matcher)Matchers.is(list2));
        if (qualificationExpectation.isSuccess()) {
            MatcherAssert.assertThat((String)"Not all qualifiable objects were successfully qualified", (Object)list.size(), (Matcher)Matchers.is((Object)qualificationReport.getResults().size()));
        }
    }

    public static void assertQualifiedNames(RosettaModelObject rosettaModelObject, QualificationReport qualificationReport, QualificationExpectation qualificationExpectation, Map<Class<?>, QualificationHandler<?, ?, ?>> map) {
        if (qualificationExpectation == null || qualificationExpectation.getQualifiableObjectCount() == 0) {
            return;
        }
        List list = qualificationReport.getResults().stream().map(QualificationResult::getUniqueSuccessQualifyResult).filter(Optional::isPresent).map(Optional::get).map(QualifyResult::getName).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Unexpected number of objects qualified", (Object)list.size(), (Matcher)Matchers.is((Object)qualificationExpectation.getQualifyResults().size()));
        ArrayList<String> arrayList = new ArrayList<String>();
        new QualifierCollector(map, arrayList).runProcessStep(rosettaModelObject.getType(), rosettaModelObject);
        MatcherAssert.assertThat((String)"Not all qualified results have been stamped on the ingested object", (Object)list.size(), (Matcher)Matchers.is((Object)arrayList.size()));
        List list2 = qualificationExpectation.getQualifyResults().stream().map(QualificationExpectation.Result::getQualifiedName).collect(Collectors.toList());
        arrayList.forEach(string -> {
            MatcherAssert.assertThat((String)"Not all results from qualification service were stamped on the ingested object", (Object)list, (Matcher)Matchers.hasItem((Object)string));
            MatcherAssert.assertThat((String)"Expected qualified names not stamped on ingested object", (Object)list2, (Matcher)Matchers.hasItem((Object)string));
        });
    }

    public static void assertSerialisation(IngestionReport<?> ingestionReport) throws JsonProcessingException {
        RosettaObjectMapper.getNewRosettaObjectMapper().writeValueAsBytes(ingestionReport);
    }

    public static void assertJsonEquals(String string, String string2) {
        Assertions.assertEquals((Object)string.replace("\r", ""), (Object)string2.replace("\r", ""));
    }

    public static String getExpectedJson(String string, Class<?> clazz) {
        try {
            URL uRL = Resources.getResource(clazz, (String)string);
            return Resources.toString((URL)uRL, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception exception) {
            LOGGER.debug("Exception occurred getting expected json resources from path {}", (Object)string, (Object)exception);
            return null;
        }
    }

    private static class QualifierCollector
    extends SimpleProcessor
    implements PostProcessStep {
        private final Map<Class<?>, QualificationHandler<?, ?, ?>> handlerMap;
        private final Set<Class<?>> rootTypes;
        private List<String> collectedQualifiers;

        QualifierCollector(Map<Class<?>, QualificationHandler<?, ?, ?>> map, List<String> list) {
            this.handlerMap = map;
            this.rootTypes = map.keySet();
            this.collectedQualifiers = list;
        }

        public Integer getPriority() {
            return 100;
        }

        public String getName() {
            return "QualifierCollector";
        }

        public <W extends RosettaModelObject> PostProcessorReport runProcessStep(Class<? extends W> clazz, W w) {
            w.process(RosettaPath.valueOf((String)clazz.getSimpleName()), (Processor)this);
            return null;
        }

        public <R extends RosettaModelObject> boolean processRosetta(RosettaPath rosettaPath, Class<? extends R> clazz, R r, RosettaModelObject rosettaModelObject, AttributeMeta ... attributeMetaArray) {
            if (r == null) {
                return false;
            }
            if (this.rootTypes.contains(r.getType())) {
                QualificationHandler<?, ?, ?> qualificationHandler = this.handlerMap.get(r.getType());
                Optional.ofNullable(qualificationHandler.getQualifier(r)).ifPresent(this.collectedQualifiers::add);
            }
            return true;
        }

        public <T> void processBasic(RosettaPath rosettaPath, Class<? extends T> clazz, Collection<? extends T> collection, RosettaModelObject rosettaModelObject, AttributeMeta ... attributeMetaArray) {
        }

        public Processor.Report report() {
            return null;
        }
    }
}

