/*
 * Decompiled with CFR 0.152.
 */
package com.reginald.patternlockview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.reginald.patternlockview.R;
import java.util.ArrayList;
import java.util.List;

public class PatternLockView
extends ViewGroup {
    public static final int CODE_PASSWORD_CORRECT = 1;
    public static final int CODE_PASSWORD_ERROR = 2;
    private static final String TAG = "PatternLockView";
    private static final boolean DEBUG = true;
    private boolean mIsTouchEnabled = true;
    private long mFinishTimeout = 1000L;
    private boolean mIsFinishInterruptable = true;
    private boolean mIsAutoLink;
    private List<NodeView> mNodeList = new ArrayList<NodeView>();
    private NodeView currentNode;
    private float mPositionX;
    private float mPositionY;
    private Drawable mNodeSrc;
    private Drawable mNodeHighlightSrc;
    private Drawable mNodeCorrectSrc;
    private Drawable mNodeErrorSrc;
    private int mSize;
    private float mNodeAreaExpand;
    private int mNodeOnAnim;
    private float mLineWidth;
    private int mLineColor;
    private int mLineCorrectColor;
    private int mLineErrorColor;
    private float mNodeSize;
    private boolean mIsSquareArea = true;
    private float mPadding;
    private float mSpacing;
    private float mMeasuredPadding;
    private float mMeasuredSpacing;
    private Vibrator mVibrator;
    private boolean mEnableVibrate;
    private int mVibrateTime;
    private Paint mPaint;
    private CallBack mCallBack;
    private OnNodeTouchListener mOnNodeTouchListener;
    private Runnable mFinishAction = new Runnable(){

        @Override
        public void run() {
            PatternLockView.this.reset();
            PatternLockView.this.setTouchEnabled(true);
        }
    };

    public PatternLockView(Context context) {
        this(context, null);
    }

    public PatternLockView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PatternLockView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initFromAttributes(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public PatternLockView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initFromAttributes(context, attrs, defStyleAttr);
    }

    public void setCallBack(CallBack callBack) {
        this.mCallBack = callBack;
    }

    public void setOnNodeTouchListener(OnNodeTouchListener callBack) {
        this.mOnNodeTouchListener = callBack;
    }

    public void setTouchEnabled(boolean isEnabled) {
        this.mIsTouchEnabled = isEnabled;
    }

    public void setFinishTimeout(long timeout) {
        if (timeout < 0L) {
            timeout = 0L;
        }
        this.mFinishTimeout = timeout;
    }

    public void setFinishInterruptable(boolean isInterruptable) {
        this.mIsFinishInterruptable = isInterruptable;
    }

    public void setAutoLinkEnabled(boolean isEnabled) {
        this.mIsAutoLink = isEnabled;
    }

    public void setSize(int size) {
        this.mSize = size;
        this.setupNodes(size);
    }

    public void reset() {
        this.mNodeList.clear();
        this.currentNode = null;
        for (int n = 0; n < this.getChildCount(); ++n) {
            NodeView node = (NodeView)this.getChildAt(n);
            node.setState(0);
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mLineWidth);
        this.mPaint.setColor(this.mLineColor);
        this.mPaint.setAntiAlias(true);
        this.invalidate();
    }

    private void initFromAttributes(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.PatternLockView, defStyleAttr, 0);
        this.mSize = a.getInt(R.styleable.PatternLockView_lock_size, 3);
        this.mNodeSrc = a.getDrawable(R.styleable.PatternLockView_lock_nodeSrc);
        this.mNodeHighlightSrc = a.getDrawable(R.styleable.PatternLockView_lock_nodeHighlightSrc);
        this.mNodeCorrectSrc = a.getDrawable(R.styleable.PatternLockView_lock_nodeCorrectSrc);
        this.mNodeErrorSrc = a.getDrawable(R.styleable.PatternLockView_lock_nodeErrorSrc);
        this.mNodeSize = a.getDimension(R.styleable.PatternLockView_lock_nodeSize, 0.0f);
        this.mNodeAreaExpand = a.getDimension(R.styleable.PatternLockView_lock_nodeTouchExpand, 0.0f);
        this.mNodeOnAnim = a.getResourceId(R.styleable.PatternLockView_lock_nodeOnAnim, 0);
        this.mLineColor = a.getColor(R.styleable.PatternLockView_lock_lineColor, Color.argb((int)178, (int)255, (int)255, (int)255));
        this.mLineCorrectColor = a.getColor(R.styleable.PatternLockView_lock_lineCorrectColor, this.mLineColor);
        this.mLineErrorColor = a.getColor(R.styleable.PatternLockView_lock_lineErrorColor, this.mLineColor);
        this.mLineWidth = a.getDimension(R.styleable.PatternLockView_lock_lineWidth, (float)((int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics())));
        this.mPadding = a.getDimension(R.styleable.PatternLockView_lock_padding, 0.0f);
        this.mSpacing = a.getDimension(R.styleable.PatternLockView_lock_spacing, -1.0f);
        this.mIsAutoLink = a.getBoolean(R.styleable.PatternLockView_lock_autoLink, false);
        this.mEnableVibrate = a.getBoolean(R.styleable.PatternLockView_lock_enableVibrate, false);
        this.mVibrateTime = a.getInt(R.styleable.PatternLockView_lock_vibrateTime, 20);
        a.recycle();
        if (this.mNodeSize <= 0.0f) {
            throw new IllegalStateException("nodeSize must be provided and larger than zero!");
        }
        if (this.mEnableVibrate) {
            this.mVibrator = (Vibrator)context.getSystemService("vibrator");
        }
        this.mPaint = new Paint(4);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mLineWidth);
        this.mPaint.setColor(this.mLineColor);
        this.mPaint.setAntiAlias(true);
        this.setupNodes(this.mSize);
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float maxNodeSize;
        float maxNodeHeight;
        float maxNodeWidth;
        boolean needRemeasure = false;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int gaps = this.mSize - 1;
        float nodesize = this.mNodeSize;
        this.mMeasuredPadding = this.mPadding;
        this.mMeasuredSpacing = this.mSpacing;
        Log.v((String)TAG, (String)String.format("onMeasure(), raw width = %d, height = %d)", width, height));
        if (this.mSpacing >= 0.0f) {
            maxNodeWidth = ((float)width - this.mPadding * 2.0f - this.mSpacing * (float)gaps) / (float)this.mSize;
            maxNodeHeight = ((float)height - this.mPadding * 2.0f - this.mSpacing * (float)gaps) / (float)this.mSize;
            maxNodeSize = maxNodeWidth < maxNodeHeight ? maxNodeWidth : maxNodeHeight;
            Log.v((String)TAG, (String)String.format("maxNodeWidth = %f, maxNodeHeight = %f, maxNodeSize = %f)", Float.valueOf(maxNodeWidth), Float.valueOf(maxNodeHeight), Float.valueOf(maxNodeSize)));
            if (nodesize > maxNodeSize) {
                int xRemains = (int)((float)width - (float)this.mSize * nodesize);
                int yRemains = (int)((float)height - (float)this.mSize * nodesize);
                int minRemains = xRemains < yRemains ? xRemains : yRemains;
                int paddingsAndSpacings = (int)(this.mPadding * 2.0f + this.mSpacing * (float)gaps);
                Log.d((String)TAG, (String)String.format("xRemains = %d, yRemains = %d, before shrink: mPadding = %f, mSpacing = %f", xRemains, yRemains, Float.valueOf(this.mPadding), Float.valueOf(this.mSpacing)));
                if (minRemains > 0 && paddingsAndSpacings > 0) {
                    float shrinkRatio = (float)minRemains / (float)paddingsAndSpacings;
                    this.mMeasuredPadding *= shrinkRatio;
                    this.mMeasuredSpacing *= shrinkRatio;
                    Log.d((String)TAG, (String)String.format("shrinkRatio = %f, mMeasuredPadding = %f, mMeasuredSpacing = %f", Float.valueOf(shrinkRatio), Float.valueOf(this.mMeasuredPadding), Float.valueOf(this.mMeasuredSpacing)));
                } else {
                    nodesize = maxNodeSize;
                }
            } else {
                if (!this.isMeasureModeExactly(widthMode)) {
                    width = (int)(this.mPadding * 2.0f + this.mSpacing * (float)gaps + (float)this.mSize * nodesize);
                }
                if (!this.isMeasureModeExactly(heightMode)) {
                    height = (int)(this.mPadding * 2.0f + this.mSpacing * (float)gaps + (float)this.mSize * nodesize);
                }
            }
            if (nodesize <= 0.0f) {
                needRemeasure = true;
                Log.v((String)TAG, (String)String.format("remeasure without using mSpacing", new Object[0]));
            }
        }
        if (needRemeasure || this.mSpacing < 0.0f) {
            this.mMeasuredSpacing = -1.0f;
            nodesize = this.mNodeSize;
            maxNodeWidth = width / this.mSize;
            maxNodeHeight = height / this.mSize;
            maxNodeSize = maxNodeWidth < maxNodeHeight ? maxNodeWidth : maxNodeHeight;
            Log.v((String)TAG, (String)String.format("maxNodeWidth = %f, maxNodeHeight = %f, maxNodeSize = %f)", Float.valueOf(maxNodeWidth), Float.valueOf(maxNodeHeight), Float.valueOf(maxNodeSize)));
            if (nodesize > maxNodeSize) {
                nodesize = maxNodeSize;
            }
        }
        Log.v((String)TAG, (String)String.format("measured nodeSize = %f)", Float.valueOf(nodesize)));
        if (width > height && !this.isMeasureModeExactly(widthMode)) {
            width = height;
        } else if (width < height && !this.isMeasureModeExactly(heightMode)) {
            height = width;
        }
        this.setMeasuredDimension(width, height);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)nodesize), (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)((int)nodesize), (int)0x40000000);
            v.measure(widthSpec, heightSpec);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int gaps = this.mSize - 1;
        int height = bottom - top;
        int width = right - left;
        float nodeSize = this.getChildAt(0).getMeasuredWidth();
        if (this.mMeasuredSpacing < 0.0f) {
            float areaWidth = width / this.mSize;
            float areaHeight = height / this.mSize;
            float areaSize = areaWidth < areaHeight ? areaWidth : areaHeight;
            float widthPadding = 0.0f;
            float heightPadding = 0.0f;
            if (this.mIsSquareArea) {
                areaWidth = areaSize;
                areaHeight = areaSize;
                widthPadding = ((float)width - (float)this.mSize * areaSize) / 2.0f;
                heightPadding = ((float)height - (float)this.mSize * areaSize) / 2.0f;
            }
            Log.v((String)TAG, (String)String.format("nodeSize = %f, areaWidth = %f, areaHeight = %f, widthPadding = %f, heightPadding = %f", Float.valueOf(nodeSize), Float.valueOf(areaWidth), Float.valueOf(areaHeight), Float.valueOf(widthPadding), Float.valueOf(heightPadding)));
            for (int n = 0; n < this.mSize * this.mSize; ++n) {
                NodeView node = (NodeView)this.getChildAt(n);
                int row = n / this.mSize;
                int col = n % this.mSize;
                int l = (int)(widthPadding + (float)col * areaWidth + (areaWidth - (float)node.getMeasuredWidth()) / 2.0f);
                int t = (int)(heightPadding + (float)row * areaHeight + (areaHeight - (float)node.getMeasuredHeight()) / 2.0f);
                int r = l + node.getMeasuredWidth();
                int b = t + node.getMeasuredHeight();
                node.layout(l, t, r, b);
            }
        } else {
            float widthPadding = ((float)width - (float)this.mSize * nodeSize - this.mMeasuredSpacing * (float)gaps) / 2.0f;
            float heightPadding = ((float)height - (float)this.mSize * nodeSize - this.mMeasuredSpacing * (float)gaps) / 2.0f;
            Log.v((String)TAG, (String)String.format("nodeSize = %f, widthPadding = %f, heightPadding = %f", Float.valueOf(nodeSize), Float.valueOf(widthPadding), Float.valueOf(heightPadding)));
            for (int n = 0; n < this.mSize * this.mSize; ++n) {
                NodeView node = (NodeView)this.getChildAt(n);
                int row = n / this.mSize;
                int col = n % this.mSize;
                int l = (int)(widthPadding + (float)col * (nodeSize + this.mMeasuredSpacing));
                int t = (int)(heightPadding + (float)row * (nodeSize + this.mMeasuredSpacing));
                int r = (int)((float)l + nodeSize);
                int b = (int)((float)t + nodeSize);
                node.layout(l, t, r, b);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mIsTouchEnabled || !this.isEnabled()) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                if (this.mIsFinishInterruptable && this.mFinishAction != null) {
                    this.removeCallbacks(this.mFinishAction);
                    this.mFinishAction.run();
                }
            }
            case 2: {
                this.mPositionX = event.getX();
                this.mPositionY = event.getY();
                NodeView nodeAt = this.getNodeAt(this.mPositionX, this.mPositionY);
                if (this.currentNode == null) {
                    if (nodeAt == null) break;
                    this.currentNode = nodeAt;
                    this.currentNode.setState(1);
                    this.addNodeToList(this.currentNode);
                    this.invalidate();
                    break;
                }
                if (nodeAt != null && !nodeAt.isHighLighted()) {
                    if (this.mIsAutoLink) {
                        this.autoLinkNode(this.currentNode, nodeAt);
                    }
                    this.currentNode = nodeAt;
                    this.currentNode.setState(1);
                    this.addNodeToList(this.currentNode);
                }
                this.invalidate();
                break;
            }
            case 1: {
                if (this.mNodeList.size() <= 0) break;
                if (!this.mIsFinishInterruptable) {
                    this.setTouchEnabled(false);
                }
                if (this.mCallBack != null) {
                    int result = this.mCallBack.onFinish(new Password(this.mNodeList));
                    this.setFinishState(result);
                }
                this.currentNode = null;
                this.invalidate();
                this.postDelayed(this.mFinishAction, this.mFinishTimeout);
            }
        }
        return true;
    }

    private void setupNodes(int size) {
        this.removeAllViews();
        for (int n = 0; n < size * size; ++n) {
            NodeView node = new NodeView(this.getContext(), n);
            this.addView(node);
        }
    }

    private void setFinishState(int result) {
        int nodeState = -1;
        int lineColor = this.mLineColor;
        if (result == 1) {
            nodeState = 2;
            lineColor = this.mLineCorrectColor;
        } else if (result == 2) {
            nodeState = 3;
            lineColor = this.mLineErrorColor;
        }
        if (nodeState >= 0) {
            for (NodeView nodeView : this.mNodeList) {
                nodeView.setState(nodeState);
            }
        }
        if (lineColor != this.mLineColor) {
            this.mPaint.setColor(lineColor);
        }
    }

    private void addNodeToList(NodeView nodeView) {
        this.mNodeList.add(nodeView);
        if (this.mOnNodeTouchListener != null) {
            this.mOnNodeTouchListener.onNodeTouched(nodeView.getNodeId());
        }
    }

    private void autoLinkNode(NodeView first, NodeView second) {
        Log.d((String)TAG, (String)String.format("autoLinkNode(%s, %s)", new Object[]{first, second}));
        int xDiff = second.getColumn() - first.getColumn();
        int yDiff = second.getRow() - first.getRow();
        if (yDiff == 0 && xDiff == 0) {
            return;
        }
        if (yDiff == 0) {
            int row = first.getRow();
            int step = xDiff > 0 ? 1 : -1;
            int column = first.getColumn();
            while ((column += step) != second.getColumn()) {
                this.tryAppendMidNode(row, column);
            }
        } else if (xDiff == 0) {
            int column = first.getColumn();
            int step = yDiff > 0 ? 1 : -1;
            int row = first.getRow();
            while ((row += step) != second.getRow()) {
                this.tryAppendMidNode(row, column);
            }
        } else {
            float tan = (float)yDiff / (float)xDiff;
            int xstep = xDiff > 0 ? 1 : -1;
            Log.d((String)TAG, (String)String.format("tan = %f, xstep = %d", Float.valueOf(tan), xstep));
            int xDelta = 0;
            float yDelta = 0.0f;
            while ((xDelta += xstep) != xDiff) {
                yDelta = (float)xDelta * tan;
                int yDeltaRounded = Math.round(yDelta);
                Log.d((String)TAG, (String)String.format("xDelta = %d, yDelta = %f", xDelta, Float.valueOf(yDelta)));
                if (!((double)Math.abs(yDelta - (float)yDeltaRounded) < 1.0E-6)) continue;
                this.tryAppendMidNode(first.getRow() + yDeltaRounded, first.getColumn() + xDelta);
                break;
            }
        }
    }

    private void tryAppendMidNode(int row, int column) {
        Log.d((String)TAG, (String)String.format("tryAppendMidNode(row = %d, column = %d)", row, column));
        NodeView mid = (NodeView)this.getChildAt(row * this.mSize + column);
        if (this.mNodeList.contains((Object)mid)) {
            return;
        }
        mid.setState(1);
        this.addNodeToList(mid);
    }

    protected void onDraw(Canvas canvas) {
        for (int i = 0; i < this.mNodeList.size() - 1; ++i) {
            NodeView first = this.mNodeList.get(i);
            NodeView second = this.mNodeList.get(i + 1);
            canvas.drawLine((float)first.getCenterX(), (float)first.getCenterY(), (float)second.getCenterX(), (float)second.getCenterY(), this.mPaint);
        }
        if (this.currentNode != null) {
            canvas.drawLine((float)this.currentNode.getCenterX(), (float)this.currentNode.getCenterY(), this.mPositionX, this.mPositionY, this.mPaint);
        }
    }

    private NodeView getNodeAt(float x, float y) {
        for (int n = 0; n < this.getChildCount(); ++n) {
            NodeView node = (NodeView)this.getChildAt(n);
            if (!(x >= (float)node.getLeft() - this.mNodeAreaExpand && x < (float)node.getRight() + this.mNodeAreaExpand && y >= (float)node.getTop() - this.mNodeAreaExpand && y < (float)node.getBottom() + this.mNodeAreaExpand)) continue;
            return node;
        }
        return null;
    }

    private boolean isMeasureModeExactly(int measureMode) {
        return measureMode == 0x40000000;
    }

    public static class Password {
        public final List<Integer> list = new ArrayList<Integer>();
        public final String string;

        public Password(List<NodeView> nodeViewList) {
            for (NodeView node : nodeViewList) {
                this.list.add(node.getNodeId());
            }
            this.string = this.buildPasswordString(nodeViewList);
        }

        protected String buildPasswordString(List<NodeView> nodeViewList) {
            StringBuilder passwordBuilder = new StringBuilder("[");
            for (int i = 0; i < nodeViewList.size(); ++i) {
                int id = nodeViewList.get(i).getNodeId();
                if (i != 0) {
                    passwordBuilder.append("-");
                }
                passwordBuilder.append(id);
            }
            passwordBuilder.append("]");
            return passwordBuilder.toString();
        }
    }

    private class NodeView
    extends View {
        public static final int STATE_NORMAL = 0;
        public static final int STATE_HIGHLIGHT = 1;
        public static final int STATE_CORRECT = 2;
        public static final int STATE_ERROR = 3;
        private int mId;
        private int mState;

        public NodeView(Context context, int num) {
            super(context);
            this.mState = 0;
            this.mId = num;
            this.setBackgroundDrawable(PatternLockView.this.mNodeSrc);
        }

        public boolean isHighLighted() {
            return this.mState == 1;
        }

        public void setState(int state) {
            if (this.mState == state) {
                return;
            }
            switch (state) {
                case 0: {
                    this.setBackgroundDrawable(PatternLockView.this.mNodeSrc);
                    this.clearAnimation();
                    break;
                }
                case 1: {
                    if (PatternLockView.this.mNodeHighlightSrc != null) {
                        this.setBackgroundDrawable(PatternLockView.this.mNodeHighlightSrc);
                    }
                    if (PatternLockView.this.mNodeOnAnim != 0) {
                        this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)PatternLockView.this.mNodeOnAnim));
                    }
                    if (!PatternLockView.this.mEnableVibrate) break;
                    PatternLockView.this.mVibrator.vibrate((long)PatternLockView.this.mVibrateTime);
                    break;
                }
                case 2: {
                    if (PatternLockView.this.mNodeCorrectSrc == null) break;
                    this.setBackgroundDrawable(PatternLockView.this.mNodeCorrectSrc);
                    break;
                }
                case 3: {
                    if (PatternLockView.this.mNodeErrorSrc == null) break;
                    this.setBackgroundDrawable(PatternLockView.this.mNodeErrorSrc);
                }
            }
            this.mState = state;
        }

        public int getCenterX() {
            return (this.getLeft() + this.getRight()) / 2;
        }

        public int getCenterY() {
            return (this.getTop() + this.getBottom()) / 2;
        }

        public int getNodeId() {
            return this.mId;
        }

        public int getRow() {
            return this.mId / PatternLockView.this.mSize;
        }

        public int getColumn() {
            return this.mId % PatternLockView.this.mSize;
        }

        public boolean equals(Object obj) {
            return obj instanceof NodeView && this.mId == ((NodeView)((Object)obj)).getNodeId();
        }

        public String toString() {
            return String.format("NodeView[mId = %d, row = %d, column = %d]", this.mId, this.getRow(), this.getColumn());
        }
    }

    public static interface OnNodeTouchListener {
        public void onNodeTouched(int var1);
    }

    public static interface CallBack {
        public int onFinish(Password var1);
    }
}

