/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.ConnectOptions;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.InProgInfo;
import com.refinitiv.eta.transport.Transport;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.common.SelectableBiDirectionalQueue;
import com.refinitiv.eta.valueadd.common.VaIteratableQueue;
import com.refinitiv.eta.valueadd.reactor.ConnectOptionsInfo;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroup;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.TunnelStream;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.quartz.CronExpression;

class Worker
implements Runnable {
    int SELECT_TIME = 100;
    SelectableBiDirectionalQueue _queue;
    Selector _selector = null;
    ReactorChannel _workerReactorChannel = null;
    ReactorChannel _reactorReactorChannel;
    Error _error = TransportFactory.createError();
    InProgInfo _inProg = TransportFactory.createInProgInfo();
    VaIteratableQueue _initChannelQueue = new VaIteratableQueue();
    VaIteratableQueue _activeChannelQueue = new VaIteratableQueue();
    VaIteratableQueue _inactiveChannelQueue = new VaIteratableQueue();
    VaIteratableQueue _reconnectingChannelQueue = new VaIteratableQueue();
    volatile boolean _running = true;
    VaIteratableQueue _timerEventQueue = new VaIteratableQueue();
    ReactorChannel.State _previousReactorChannelState;
    Reactor _reactor;

    Worker(ReactorChannel reactorChannel, SelectableBiDirectionalQueue queue) {
        if (reactorChannel == null) {
            throw new UnsupportedOperationException("reactorChannel cannot be null");
        }
        if (queue == null) {
            throw new UnsupportedOperationException("queue cannot be null");
        }
        this._reactorReactorChannel = reactorChannel;
        this._queue = queue;
        this._reactor = reactorChannel.reactor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.initializeWorker() != 0) {
            System.out.println("Worker.run(): failed to initialize, shutting down");
            this.shutdown();
            return;
        }
        while (this._running || this._queue.readQueueSize() > 0) {
            try {
                ReactorChannel reactorChannel;
                int selectorCount = this._selector.select(this.SELECT_TIME);
                if (selectorCount > 0 || !this._selector.selectedKeys().isEmpty()) {
                    Iterator<SelectionKey> iter = this._selector.selectedKeys().iterator();
                    while (iter.hasNext()) {
                        ReactorChannel reactorChannel2;
                        SelectionKey key = iter.next();
                        iter.remove();
                        if (!key.isValid()) continue;
                        if (key.isConnectable()) {
                            reactorChannel2 = (ReactorChannel)key.attachment();
                            if (reactorChannel2.channel() != null && (reactorChannel2.channel().state() == 0 || reactorChannel2.channel().state() == 1)) {
                                this.initializeChannel(reactorChannel2);
                            }
                            if (!key.isValid()) continue;
                        }
                        if (key.isReadable()) {
                            reactorChannel2 = (ReactorChannel)key.attachment();
                            if (this._workerReactorChannel == reactorChannel2) {
                                this.processWorkerEvent();
                            } else {
                                if (reactorChannel2.channel() != null && (reactorChannel2.channel().state() == 0 || reactorChannel2.channel().state() == 1)) {
                                    this.initializeChannel(reactorChannel2);
                                }
                                if (!key.isValid()) continue;
                            }
                        }
                        if (!key.isWritable()) continue;
                        this.processChannelFlush((ReactorChannel)key.attachment());
                    }
                }
                if (Thread.currentThread().isInterrupted()) {
                    this._running = false;
                }
                this._timerEventQueue.rewind();
                while (this._timerEventQueue.hasNext()) {
                    Object tempReactorChannel;
                    WorkerEvent event = (WorkerEvent)this._timerEventQueue.next();
                    if (event._isCanceled) {
                        this._timerEventQueue.remove(event);
                        event.returnToPool();
                        continue;
                    }
                    if (System.nanoTime() < event.timeout()) continue;
                    if (event.eventType() == WorkerEventTypes.TOKEN_MGNT) {
                        ReactorTokenSession tokenSession = event._tokenSession;
                        if (tokenSession != null && (tokenSession.authTokenInfo().tokenVersion() != ReactorAuthTokenInfo.TokenVersion.V2 || event._reactorChannel != null && event._reactorChannel.state() != ReactorChannel.State.READY && event._reactorChannel.state() != ReactorChannel.State.UP)) {
                            tokenSession.handleTokenReissue();
                        }
                        if (tokenSession != null) {
                            tokenSession.tokenReissueEvent(null);
                        }
                        this._timerEventQueue.remove(event);
                        event.returnToPool();
                        continue;
                    }
                    if (event.eventType() == WorkerEventTypes.PREFERRED_HOST_TIMER) {
                        if (event.reactorChannel()._preferredHostOptions.detectionTimeSchedule() != null && !event.reactorChannel()._preferredHostOptions.detectionTimeSchedule().isEmpty()) {
                            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                this._reactor.debugger.writeDebugInfo("Preferred host: Time schedule triggered to attempt switching to preferred host", this._reactor.hashCode(), this.hashCode());
                            }
                        } else if (event.reactorChannel()._preferredHostOptions.detectionTimeInterval() > 0L && this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                            this._reactor.debugger.writeDebugInfo("Preferred host: Time interval triggered to attempt switching to preferred host", this._reactor.hashCode(), this.hashCode());
                        }
                        event.reactorChannel().switchHostToPreferredHost(true, null);
                        if (event.reactorChannel()._preferredHostOptions.detectionTimeSchedule() != null && !event.reactorChannel()._preferredHostOptions.detectionTimeSchedule().isEmpty()) {
                            try {
                                CronExpression tr = new CronExpression(event.reactorChannel()._preferredHostOptions.detectionTimeSchedule());
                                Date currentTime = new Date(System.currentTimeMillis());
                                Date nextTime = tr.getNextValidTimeAfter(currentTime);
                                event.reactorChannel()._nextReconnectTimeMs = nextTime.getTime();
                                event.timeout(System.nanoTime() + (nextTime.getTime() - currentTime.getTime()) * 1000000L);
                            }
                            catch (ParseException e) {
                                System.out.println("Worker.run() exception=" + e.getLocalizedMessage());
                                this.sendWorkerEvent(this._reactorReactorChannel, WorkerEventTypes.SHUTDOWN, -1, "Worker.run", "exception occurred, " + e.getLocalizedMessage());
                                this._timerEventQueue.remove(event);
                                event.returnToPool();
                            }
                            continue;
                        }
                        if (event.reactorChannel()._preferredHostOptions.detectionTimeInterval() <= 0L) continue;
                        event.reactorChannel()._nextReconnectTimeMs = System.currentTimeMillis() + event.reactorChannel()._preferredHostOptions.detectionTimeInterval() * 1000L;
                        event.timeout(System.nanoTime() + event.reactorChannel()._preferredHostOptions.detectionTimeInterval() * 1000000000L);
                        continue;
                    }
                    if (event.eventType() == WorkerEventTypes.PREFERRED_HOST_START_FALLBACK) {
                        block170: {
                            Object object = tempReactorChannel = event.reactorChannel().warmStandByHandlerImpl != null ? event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel() : event.reactorChannel();
                            if (event.reactorChannel().warmStandByHandlerImpl != null && event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.fallBackWithInWSBGroup()) {
                                ReactorWarmStandbyHandler warmStandByHandlerImpl = event.reactorChannel().warmStandByHandlerImpl;
                                boolean switchingToActive = false;
                                if (event.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                    ReactorWarmStandbyEvent reactorWarmStandbyEvent = this._reactor.reactorWarmStandbyEventPool.getEvent(event.reactorChannel().getEDPErrorInfo());
                                    reactorWarmStandbyEvent.eventType = 11;
                                    reactorWarmStandbyEvent.reactorChannel = event.reactorChannel();
                                    event.reactorChannel().reactor().sendWarmStandbyEvent(event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel(), reactorWarmStandbyEvent, event.reactorChannel().getEDPErrorInfo());
                                    this._timerEventQueue.remove(event);
                                    event.returnToPool();
                                    continue;
                                }
                                if (event.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                                    for (ConnectOptionsInfo standbyOptions : warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyConnectOptionsInfoList) {
                                        Channel channel;
                                        if (warmStandByHandlerImpl.activeReactorChannel() == null || standbyOptions != warmStandByHandlerImpl.activeReactorChannel().getCurrentConnectOptionsInfo() || (channel = warmStandByHandlerImpl.startingReactorChannel().channel()) == null || channel.state() != 2) continue;
                                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this._reactor.reactorWarmStandbyEventPool.getEvent(event.reactorChannel().getEDPErrorInfo());
                                        reactorWarmStandbyEvent.eventType = 11;
                                        reactorWarmStandbyEvent.reactorChannel = event.reactorChannel();
                                        event.reactorChannel().reactor().sendWarmStandbyEvent(event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel(), reactorWarmStandbyEvent, event.reactorChannel().getEDPErrorInfo());
                                        switchingToActive = true;
                                        this._timerEventQueue.remove(event);
                                        event.returnToPool();
                                        break;
                                    }
                                }
                                this.sendWorkerEvent(event.reactorChannel(), WorkerEventTypes.PREFERRED_HOST_COMPLETE, 0, "Worker.run", null);
                                if (switchingToActive) continue;
                            }
                            if ((((ReactorChannel)tempReactorChannel).switchingToPreferredHost() || ((ReactorChannel)tempReactorChannel).switchingToPreferredWSBGroup()) && event.reactorChannel().preferredHostChannel() == null) {
                                ReactorConnectInfo connectInfo = event.reactorChannel().warmStandByHandlerImpl != null ? event.reactorChannel().warmStandByHandlerImpl.warmStandbyGroupList().get(event.reactorChannel()._preferredHostOptions.warmStandbyGroupListIndex()).startingActiveServer().reactorConnectInfo() : event.reactorChannel()._reactorConnectOptions._connectionList.get(event.reactorChannel()._preferredHostOptions.connectionListIndex());
                                if (connectInfo != null && connectInfo.enableSessionManagement() && event.reactorChannel().tokenSession() != null && event.reactorChannel().tokenSession().authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
                                    if (event.reactorChannel().state() != ReactorChannel.State.EDP_RT && event.reactorChannel().state() != ReactorChannel.State.EDP_RT_DONE && event.reactorChannel().state() != ReactorChannel.State.EDP_RT_FAILED) {
                                        this._previousReactorChannelState = event.reactorChannel().state();
                                        event.reactorChannel().tokenSession().authTokenInfo().accessToken(null);
                                        event.reactorChannel().tokenSession().resetSessionMgntState();
                                        event.reactorChannel().reconnectTokenSession(connectInfo, this._error);
                                        continue;
                                    }
                                    if (event.reactorChannel().state() == ReactorChannel.State.EDP_RT || event.reactorChannel().state() == ReactorChannel.State.EDP_RT_DONE || event.reactorChannel().state() == ReactorChannel.State.EDP_RT_FAILED) {
                                        if (!event.reactorChannel().checkAuthTokenReady(this._error) || event.reactorChannel().tokenSession() == null) continue;
                                        this._reactor.sessionManagementStartup(event.reactorChannel().tokenSession(), connectInfo, event.reactorChannel().role(), event.reactorChannel(), false, event.reactorChannel().getEDPErrorInfo());
                                        this.initializeNewPHChannelWithSessionMgnt(event.reactorChannel(), connectInfo);
                                    }
                                } else if (event.reactorChannel().warmStandByHandlerImpl != null && ((ReactorChannel)tempReactorChannel).switchingToPreferredWSBGroup()) {
                                    if (event.reactorChannel().reactor()._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                        event.reactorChannel().reactor().debugger.writeDebugInfo("Attempting to switch to WarmStandByGroup Index: " + event.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupIndex(), event.reactorChannel().reactor().hashCode(), this.hashCode());
                                    }
                                    event.reactorChannel().preferredHostChannel(Transport.connect((ConnectOptions)event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions._reactorWarmStandyGroupList.get(event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.warmStandbyGroupListIndex()).startingActiveServer().reactorConnectInfo().connectOptions(), (Error)this._error));
                                    if (event.reactorChannel().preferredHostChannel() != null) {
                                        event.reactorChannel().initializationTimeout(event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().getCurrentReactorConnectInfo().initTimeout());
                                    }
                                } else {
                                    if (event.reactorChannel().reactor()._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                        event.reactorChannel().reactor().debugger.writeDebugInfo("Attempting to switch to Connection List Index: " + event.reactorChannel()._preferredHostOptions.connectionListIndex(), event.reactorChannel().reactor().hashCode(), this.hashCode());
                                    }
                                    event.reactorChannel().preferredHostChannel(Transport.connect((ConnectOptions)event.reactorChannel()._reactorConnectOptions._connectionList.get((int)event.reactorChannel()._preferredHostOptions.connectionListIndex())._connectOptions, (Error)this._error));
                                    if (event.reactorChannel().preferredHostChannel() != null) {
                                        event.reactorChannel().initializationTimeout(event.reactorChannel().getCurrentReactorConnectInfo().initTimeout());
                                    }
                                }
                            }
                            if (!((ReactorChannel)tempReactorChannel).switchingToPreferredHost() && !((ReactorChannel)tempReactorChannel).switchingToPreferredWSBGroup() || event.reactorChannel().preferredHostChannel() == null) continue;
                            try {
                                if (this._reactor.reactorHandlesWarmStandby(event.reactorChannel()) && event.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupIndex() == event.reactorChannel()._preferredHostOptions.warmStandbyGroupListIndex()) {
                                    event.reactorChannel().initiateSwitch(false, false);
                                    if (this._previousReactorChannelState != null) {
                                        event.reactorChannel().state(this._previousReactorChannelState);
                                        this._previousReactorChannelState = null;
                                    }
                                    this._timerEventQueue.remove(event);
                                    this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                    event.returnToPool();
                                }
                                break block170;
                            }
                            catch (Exception e) {
                                event.reactorChannel().initiateSwitch(false, false);
                                if (this._previousReactorChannelState != null) {
                                    event.reactorChannel().state(this._previousReactorChannelState);
                                    this._previousReactorChannelState = null;
                                }
                                this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                this._timerEventQueue.remove(event);
                                event.returnToPool();
                            }
                            continue;
                        }
                        if (event.reactorChannel().warmStandByHandlerImpl != null) {
                            boolean connectingToWSBGroup = false;
                            for (ReactorWarmStandbyGroup group : event.reactorChannel().warmStandByHandlerImpl.warmStandbyGroupList()) {
                                try {
                                    if (group == null || event.reactorChannel().preferredHostChannel() == null || !group.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().address().equals(event.reactorChannel().preferredHostChannel().hostname()) || !group.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName().equals(String.valueOf(event.reactorChannel().preferredHostChannel().port()))) continue;
                                    connectingToWSBGroup = true;
                                    int ret = event.reactorChannel().preferredHostChannel().init(this._inProg, this._error);
                                    if (ret == 0) {
                                        event.reactorChannel().pingHandler().initPingHandler(event.reactorChannel().preferredHostChannel().pingTimeout());
                                        event.reactorChannel().resetCurrentChannelRetryCount();
                                        event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().preferredHostChannel(event.reactorChannel().preferredHostChannel());
                                        event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().oldPHStartingChannel = event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().channel();
                                        this.sendWorkerEvent(event.reactorChannel(), WorkerEventTypes.PREFERRED_HOST_SWITCH_CHANNEL, 0, "Worker.run", null);
                                        this._timerEventQueue.remove(event);
                                        event.returnToPool();
                                        break;
                                    }
                                    if (ret != -1 && System.currentTimeMillis() <= event.reactorChannel().initializationEndTimeMs()) continue;
                                    event.reactorChannel().initiateSwitch(false, false);
                                    if (this._previousReactorChannelState != null) {
                                        event.reactorChannel().state(this._previousReactorChannelState);
                                        this._previousReactorChannelState = null;
                                    }
                                    this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                    this._timerEventQueue.remove(event);
                                    event.returnToPool();
                                }
                                catch (Exception e) {
                                    if (event.reactorChannel().preferredHostChannel() != null) continue;
                                    event.reactorChannel().initiateSwitch(false, false);
                                    if (this._previousReactorChannelState != null) {
                                        event.reactorChannel().state(this._previousReactorChannelState);
                                        this._previousReactorChannelState = null;
                                    }
                                    this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                    this._timerEventQueue.remove(event);
                                    event.returnToPool();
                                }
                                break;
                            }
                            if (connectingToWSBGroup) continue;
                            try {
                                int ret = event.reactorChannel().preferredHostChannel().init(this._inProg, this._error);
                                if (ret == 0) {
                                    this.sendWorkerEvent(event.reactorChannel(), WorkerEventTypes.PREFERRED_HOST_SWITCH_CHANNEL, 0, "Worker.run", null);
                                    event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().preferredHostChannel(event.reactorChannel().preferredHostChannel());
                                    event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().oldPHStartingChannel = event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel().channel();
                                    this._timerEventQueue.remove(event);
                                    event.returnToPool();
                                    continue;
                                }
                                if (ret != -1 && System.currentTimeMillis() <= event.reactorChannel().initializationEndTimeMs()) continue;
                                event.reactorChannel().initiateSwitch(false, false);
                                if (this._previousReactorChannelState != null) {
                                    event.reactorChannel().state(this._previousReactorChannelState);
                                    this._previousReactorChannelState = null;
                                }
                                this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                this._timerEventQueue.remove(event);
                                event.returnToPool();
                            }
                            catch (Exception e) {
                                if (event.reactorChannel() != null && event.reactorChannel().preferredHostChannel() != null) continue;
                                event.reactorChannel().initiateSwitch(false, false);
                                if (this._previousReactorChannelState != null) {
                                    event.reactorChannel().state(this._previousReactorChannelState);
                                    this._previousReactorChannelState = null;
                                }
                                this.sendPreferredHostCompleteEvent(event.reactorChannel());
                                this._timerEventQueue.remove(event);
                                event.returnToPool();
                            }
                            continue;
                        }
                        int ret = event.reactorChannel().preferredHostChannel().init(this._inProg, this._error);
                        if (ret == 0) {
                            this.sendWorkerEvent(event.reactorChannel(), WorkerEventTypes.PREFERRED_HOST_SWITCH_CHANNEL, 0, "Worker.run", null);
                            event.reactorChannel().oldPHStartingChannel = event.reactorChannel().channel();
                            this._timerEventQueue.remove(event);
                            event.returnToPool();
                            continue;
                        }
                        if (ret != -1 && System.currentTimeMillis() <= event.reactorChannel().initializationEndTimeMs()) continue;
                        event.reactorChannel().initiateSwitch(false, false);
                        if (this._previousReactorChannelState != null) {
                            event.reactorChannel().state(this._previousReactorChannelState);
                            this._previousReactorChannelState = null;
                        }
                        this.sendPreferredHostCompleteEvent(event.reactorChannel());
                        this._timerEventQueue.remove(event);
                        event.returnToPool();
                        continue;
                    }
                    if (event.eventType() == WorkerEventTypes.PREFERRED_HOST_IOCTL) {
                        if (event.reactorChannel().switchingToPreferredHost() || event.reactorChannel().switchingToPreferredWSBGroup()) continue;
                        if (event.reactorChannel()._preferredHostOptionsIoctl == null) {
                            this._reactor.populateErrorInfo(event.reactorChannel().getEDPErrorInfo(), -1, "ReactorChannel.ioctl", "Failed to complete ioctl call, no ioctl changes made.");
                            this._timerEventQueue.remove(event);
                            event.returnToPool();
                            continue;
                        }
                        event.reactorChannel()._preferredHostLock.lock();
                        if (event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeSchedule() != null && !event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeSchedule().isEmpty() && event.reactorChannel()._cronExpressionIoctl != null) {
                            event.reactorChannel()._cronExpression = event.reactorChannel()._cronExpressionIoctl;
                        }
                        if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                            if (event.reactorChannel()._preferredHostOptions.isPreferredHostEnabled() != event.reactorChannel()._preferredHostOptionsIoctl.isPreferredHostEnabled()) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to isPreferredHostEnabled, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.isPreferredHostEnabled(), this._reactor.hashCode(), this.hashCode());
                            }
                            if (event.reactorChannel()._preferredHostOptions.connectionListIndex() != event.reactorChannel()._preferredHostOptionsIoctl.connectionListIndex()) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to connectionListIndex, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.connectionListIndex(), this._reactor.hashCode(), this.hashCode());
                            }
                            if (event.reactorChannel()._preferredHostOptions.warmStandbyGroupListIndex() != event.reactorChannel()._preferredHostOptionsIoctl.warmStandbyGroupListIndex()) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to warmStandbyGroupListIndex, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.warmStandbyGroupListIndex(), this._reactor.hashCode(), this.hashCode());
                            }
                            if (event.reactorChannel()._preferredHostOptions.detectionTimeInterval() != event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeInterval()) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to detectionTimeInterval, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeInterval(), this._reactor.hashCode(), this.hashCode());
                            }
                            if (!event.reactorChannel()._preferredHostOptions.detectionTimeSchedule().equals(event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeSchedule())) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to detectionTimeSchedule, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.detectionTimeSchedule(), this._reactor.hashCode(), this.hashCode());
                            }
                            if (event.reactorChannel()._preferredHostOptions.fallBackWithInWSBGroup() != event.reactorChannel()._preferredHostOptionsIoctl.fallBackWithInWSBGroup()) {
                                this._reactor.debugger.writeDebugInfo("IOCTL Change to fallBackWithInWSBGroup, new value = " + event.reactorChannel()._preferredHostOptionsIoctl.fallBackWithInWSBGroup(), this._reactor.hashCode(), this.hashCode());
                            }
                        }
                        event.reactorChannel()._preferredHostOptions = event.reactorChannel()._preferredHostOptionsIoctl;
                        if (event.reactorChannel()._reactorConnectOptions != null) {
                            event.reactorChannel()._reactorConnectOptions._reactorPreferredHostOptions = event.reactorChannel()._preferredHostOptions;
                            if (!event.reactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                                event.reactorChannel()._haveAttemptedFirstConnectionListEntry = false;
                                event.reactorChannel()._listIndex = 0;
                            }
                        }
                        if (event.reactorChannel().warmStandByHandlerImpl != null && event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel() != null) {
                            event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions = event.reactorChannel()._preferredHostOptions;
                            event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions._reactorPreferredHostOptions = event.reactorChannel()._preferredHostOptions;
                            event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup = false;
                            if (!event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                                event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._haveAttemptedFirstConnectionListEntry = false;
                                event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._listIndex = 0;
                            }
                            event.reactorChannel().warmStandByHandlerImpl.mainReactorChannelImpl()._preferredHostOptions = event.reactorChannel()._preferredHostOptions;
                            event.reactorChannel().warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                            try {
                                tempReactorChannel = event.reactorChannel().warmStandByHandlerImpl.channelList().iterator();
                                while (tempReactorChannel.hasNext()) {
                                    ReactorChannel standbyChannel = (ReactorChannel)tempReactorChannel.next();
                                    standbyChannel._preferredHostOptions = event.reactorChannel().warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions;
                                }
                            }
                            finally {
                                event.reactorChannel().warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                            }
                        }
                        this._reactor.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_TIMER, event.reactorChannel());
                        event.reactorChannel()._preferredHostOptionsIoctl = null;
                        event.reactorChannel()._cronExpressionIoctl = null;
                        this._timerEventQueue.remove(event);
                        event.reactorChannel()._preferredHostLock.unlock();
                        event.returnToPool();
                        continue;
                    }
                    WorkerEventTypes eventType = WorkerEventTypes.TUNNEL_STREAM_DISPATCH_TIMEOUT;
                    if (event.eventType() == WorkerEventTypes.START_WATCHLIST_TIMER) {
                        eventType = WorkerEventTypes.WATCHLIST_TIMEOUT;
                    }
                    this.sendWorkerEvent(event.reactorChannel(), eventType, event.tunnelStream(), 0, null, null);
                    this._timerEventQueue.remove(event);
                    event.returnToPool();
                }
                this._initChannelQueue.rewind();
                while (this._initChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._initChannelQueue.next();
                    if (reactorChannel.state() != ReactorChannel.State.INITIALIZING || reactorChannel.channel() == null || reactorChannel.channel().state() != 0 && reactorChannel.channel().state() != 1) continue;
                    this.initializeChannel(reactorChannel);
                }
                this._activeChannelQueue.rewind();
                while (this._activeChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._activeChannelQueue.next();
                    if (reactorChannel == null || reactorChannel.channel() == null || reactorChannel.channel().state() != 2 || reactorChannel.state() == ReactorChannel.State.DOWN_RECONNECTING || reactorChannel.state() == ReactorChannel.State.DOWN || reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED || reactorChannel.pingHandler().handlePings(reactorChannel, this._error) >= 0) continue;
                    this._activeChannelQueue.remove(reactorChannel);
                    this._inactiveChannelQueue.add(reactorChannel);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.run()", "Ping error for channel: " + this._error.text());
                }
                this._reconnectingChannelQueue.rewind();
                while (this._reconnectingChannelQueue.hasNext()) {
                    reactorChannel = (ReactorChannel)this._reconnectingChannelQueue.next();
                    if (reactorChannel == null || reactorChannel.nextRecoveryTime() > System.currentTimeMillis() && !reactorChannel._reconnectImmedietlyToPH) continue;
                    if (reactorChannel._reconnectImmedietlyToPH) {
                        reactorChannel._reconnectImmedietlyToPH = false;
                    }
                    Channel channel = null;
                    ReactorWarmStandbyServerInfo wsbServerImpl = null;
                    if (!reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                        if (this._reactor.reactorHandlesWarmStandby(reactorChannel)) {
                            ++reactorChannel._reconnectAttempts;
                            ReactorWarmStandbyGroupImpl wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                            if (reactorChannel.isStartingServerConfig) {
                                wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer();
                                reactorChannel.setCurrentReactorConnectInfo(wsbGroup.startingActiveServer().reactorConnectInfo());
                                reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.startingConnectOptionsInfo);
                                reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                                reactorChannel.standByGroupListIndex = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex();
                                if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x20) != 0) {
                                    continue;
                                }
                            } else {
                                wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(reactorChannel.standByServerListIndex);
                                reactorChannel.setCurrentReactorConnectInfo(wsbGroup.standbyServerList().get(reactorChannel.standByServerListIndex).reactorConnectInfo());
                                reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.standbyConnectOptionsInfoList.get(reactorChannel.standByServerListIndex));
                                reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                            }
                            if (!wsbServerImpl.isActiveChannelConfig()) {
                                this._reconnectingChannelQueue.remove(reactorChannel);
                            }
                        } else if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                            reactorChannel._checkedPreferredHostInChannelList = false;
                            if (!reactorChannel.getReactorConnectOptions().connectionList().isEmpty()) {
                                if (reactorChannel._haveAttemptedFirstConnectionListEntry) {
                                    if (++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                        reactorChannel._listIndex = 0;
                                    }
                                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                } else {
                                    if (reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                        reactorChannel._listIndex = 0;
                                    }
                                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                    reactorChannel._haveAttemptedFirstConnectionListEntry = true;
                                }
                            }
                            ++reactorChannel._reconnectAttempts;
                        }
                        if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                            channel = reactorChannel.reconnectReactorChannel(this._error);
                        }
                        if (reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED) {
                            channel = reactorChannel.reconnectEDP(this._error);
                        }
                        if (channel == null && reactorChannel.state() != ReactorChannel.State.EDP_RT) {
                            this._reconnectingChannelQueue.remove(reactorChannel);
                            if (reactorChannel.tokenSession() != null && reactorChannel.tokenSession().sessionMgntState() == ReactorTokenSession.SessionState.STOP_TOKEN_REQUEST) {
                                reactorChannel.getReactorConnectOptions().reconnectAttemptLimit(0);
                            }
                            this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.run()", "Reconnection failed: " + this._error.text());
                            continue;
                        }
                        if (reactorChannel.state() == ReactorChannel.State.EDP_RT) continue;
                        reactorChannel.selectableChannelFromChannel(channel);
                        reactorChannel.state(ReactorChannel.State.INITIALIZING);
                        this._reconnectingChannelQueue.remove(reactorChannel);
                        this.processChannelInit(reactorChannel);
                        continue;
                    }
                    if (this._reactor.reactorHandlesWarmStandby(reactorChannel) || reactorChannel._preferredHostOptions.isPreferredHostEnabled() && reactorChannel.warmStandByHandlerImpl != null) {
                        boolean handlingSessionMgnt = reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED;
                        reactorChannel._phSwitchingFromWSBToChannelList = false;
                        if (reactorChannel._reconnectAttempts + 1 >= reactorChannel.reconnectAttemptLimit() && reactorChannel.reconnectAttemptLimit() >= 0 && reactorChannel._haveAttemptedFirstConnection) {
                            if (!handlingSessionMgnt) {
                                ++reactorChannel._reconnectAttempts;
                            }
                            boolean isAnotherChannelActive = false;
                            reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                            try {
                                for (ReactorChannel wsbChannel : reactorChannel.warmStandByHandlerImpl.channelList()) {
                                    if (wsbChannel.state() != ReactorChannel.State.READY && wsbChannel.state() != ReactorChannel.State.UP && wsbChannel.state() != ReactorChannel.State.INITIALIZING) continue;
                                    isAnotherChannelActive = true;
                                }
                            }
                            finally {
                                reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                            }
                            if (!isAnotherChannelActive && reactorChannel._preferredHostOptions.isPreferredHostEnabled() && reactorChannel.preferredHostChannel() == null && !handlingSessionMgnt) {
                                ReactorWarmStandbyGroupImpl wsbGroup;
                                if (!reactorChannel._switchingToPreferredWSBGroup) {
                                    if ((reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState() & 0x800) != 0) {
                                        reactorChannel._phSwitchingFromChannelListToWSB = true;
                                    }
                                    reactorChannel._switchingToPreferredWSBGroup = true;
                                    if (reactorChannel._phResetPHIndexForRecovery) {
                                        reactorChannel._hitEndOfWSBGroups = true;
                                        reactorChannel._phResetPHIndexForRecovery = false;
                                    }
                                    reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex(reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex());
                                    reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(reactorChannel.getReactorConnectOptions().reactorPreferredHostOptions().warmStandbyGroupListIndex());
                                    wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer();
                                    wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                                    reactorChannel.setCurrentReactorConnectInfo(wsbGroup.startingActiveServer().reactorConnectInfo());
                                    reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.startingConnectOptionsInfo);
                                    reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                                    reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState(8);
                                    reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(1);
                                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.PREFERRED_HOST_SUBMIT_MSG_RECOVERY_QUEUE, 0, null, null);
                                    if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                        reactorChannel.copyActiveServiceOptions();
                                    }
                                    if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                        this._reactor.debugger.writeDebugInfo("Switching to warmStandbyGroup index: " + reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(), this._reactor.hashCode(), this.hashCode());
                                    }
                                } else if (reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 1 < reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().size()) {
                                    boolean checkChannelListInstead = false;
                                    reactorChannel._switchingToPreferredWSBGroup = false;
                                    if (reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 1 >= reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().size() && reactorChannel.getReactorConnectOptions().connectionList().isEmpty()) {
                                        reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(0);
                                        reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex(-1);
                                    }
                                    if (reactorChannel._hitEndOfWSBGroups) {
                                        this.rollbackWsbGroupCurrentIndex(reactorChannel);
                                        reactorChannel._hitEndOfWSBGroups = false;
                                    } else {
                                        if (reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 1 != reactorChannel._preferredHostOptions.warmStandbyGroupListIndex()) {
                                            reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 1);
                                        } else if (reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 2 < reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().size()) {
                                            reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 2);
                                        } else {
                                            checkChannelListInstead = true;
                                        }
                                        if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                            reactorChannel.copyActiveServiceOptions();
                                        }
                                    }
                                    if (checkChannelListInstead && reactorChannel._checkedPreferredHostInChannelList_WSBEnabled && !reactorChannel.getReactorConnectOptions().connectionList().isEmpty()) {
                                        this.checkChannelList(reactorChannel);
                                    } else if (checkChannelListInstead && !reactorChannel._checkedPreferredHostInChannelList_WSBEnabled && !reactorChannel.getReactorConnectOptions().connectionList().isEmpty()) {
                                        this.checkPreferredChannelList(reactorChannel);
                                    } else {
                                        wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer();
                                        ReactorWarmStandbyGroupImpl wsbGroup2 = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                                        reactorChannel.setCurrentReactorConnectInfo(wsbGroup2.startingActiveServer().reactorConnectInfo());
                                        reactorChannel.setCurrentConnectOptionsInfo(wsbGroup2.startingConnectOptionsInfo);
                                        reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                                        reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState(8);
                                        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(1);
                                        this.sendWorkerEvent(reactorChannel, WorkerEventTypes.PREFERRED_HOST_SUBMIT_MSG_RECOVERY_QUEUE, 0, null, null);
                                        if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                            reactorChannel.copyActiveServiceOptions();
                                        }
                                        if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                            this._reactor.debugger.writeDebugInfo("Switching to warmStandbyGroup index: " + reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(), this._reactor.hashCode(), this.hashCode());
                                        }
                                    }
                                } else if (reactorChannel._checkedPreferredHostInChannelList_WSBEnabled && !reactorChannel.getReactorConnectOptions().connectionList().isEmpty()) {
                                    this.checkChannelList(reactorChannel);
                                } else if (!(reactorChannel._switchingToPreferredHost || reactorChannel._checkedPreferredHostInChannelList_WSBEnabled || reactorChannel.getReactorConnectOptions().connectionList().isEmpty())) {
                                    this.checkPreferredChannelList(reactorChannel);
                                } else if (reactorChannel.getReactorConnectOptions().connectionList().isEmpty() && reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex() + 1 >= reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().size()) {
                                    reactorChannel._switchingToPreferredWSBGroup = false;
                                    this.rollbackWsbGroupCurrentIndex(reactorChannel);
                                    wsbServerImpl = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer();
                                    wsbGroup = reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl();
                                    reactorChannel.setCurrentReactorConnectInfo(wsbGroup.startingActiveServer().reactorConnectInfo());
                                    reactorChannel.setCurrentConnectOptionsInfo(wsbGroup.startingConnectOptionsInfo);
                                    reactorChannel.userSpecObj(reactorChannel.getCurrentReactorConnectInfo().connectOptions().userSpecObject());
                                    reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState(8);
                                    reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(1);
                                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.PREFERRED_HOST_SUBMIT_MSG_RECOVERY_QUEUE, 0, null, null);
                                    if (reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                                        reactorChannel.copyActiveServiceOptions();
                                    }
                                    if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                        this._reactor.debugger.writeDebugInfo("Switching to warmStandbyGroup index: " + reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(), this._reactor.hashCode(), this.hashCode());
                                    }
                                }
                            }
                            if (wsbServerImpl != null && !wsbServerImpl.isActiveChannelConfig()) {
                                this._reconnectingChannelQueue.remove(reactorChannel);
                            }
                        } else if (!reactorChannel._haveAttemptedFirstConnection) {
                            reactorChannel._haveAttemptedFirstConnection = true;
                        } else if (!handlingSessionMgnt) {
                            ++reactorChannel._reconnectAttempts;
                        }
                    } else if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                        if (reactorChannel._reactorConnectOptions._reactorPreferredHostOptions.isPreferredHostEnabled() && !reactorChannel.getReactorConnectOptions().connectionList().isEmpty() && (reactorChannel._phResetPHIndexForRecovery || reactorChannel.getCurrentReactorConnectInfo() != reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel.getReactorConnectOptions().reactorPreferredHostOptions().connectionListIndex()) && !reactorChannel._checkedPreferredHostInChannelList)) {
                            if (reactorChannel.warmStandByHandlerImpl != null && (reactorChannel.warmStandByHandlerImpl.startingReactorChannel().channel() == null || reactorChannel.warmStandByHandlerImpl.startingReactorChannel().channel().state() == -1)) {
                                this._reconnectingChannelQueue.remove(reactorChannel);
                                reactorChannel.close(null);
                                continue;
                            }
                            reactorChannel._phResetPHIndexForRecovery = false;
                            reactorChannel._checkedPreferredHostInChannelList = true;
                            reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel.getReactorConnectOptions().reactorPreferredHostOptions().connectionListIndex()));
                            reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel.getReactorConnectOptions().reactorPreferredHostOptions().connectionListIndex()));
                        } else {
                            reactorChannel._checkedPreferredHostInChannelList = false;
                            if (reactorChannel.getReactorConnectOptions().connectionList().size() > 1) {
                                for (ReactorConnectInfo reactorConnectInfo : reactorChannel.getReactorConnectOptions().connectionList()) {
                                    if (reactorConnectInfo != reactorChannel.getCurrentReactorConnectInfo() || reactorConnectInfo == reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._preferredHostOptions.connectionListIndex())) continue;
                                    reactorChannel._haveAttemptedFirstConnectionListEntry = true;
                                }
                                if (!reactorChannel._preferredHostOptions.isPreferredHostEnabled()) {
                                    if (reactorChannel._haveAttemptedFirstConnectionListEntry) {
                                        if (++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                            reactorChannel._listIndex = 0;
                                        }
                                        reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                        reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                    } else {
                                        if (reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                            reactorChannel._listIndex = 0;
                                        }
                                        reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                        reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                        reactorChannel._haveAttemptedFirstConnectionListEntry = true;
                                    }
                                } else if (reactorChannel._haveAttemptedFirstConnectionListEntry) {
                                    if (++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                        reactorChannel._listIndex = 0;
                                    }
                                    if (reactorChannel._listIndex == reactorChannel._reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()) {
                                        ++reactorChannel._listIndex;
                                        if (reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                            reactorChannel._listIndex = 0;
                                        }
                                    }
                                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                } else {
                                    if (reactorChannel._listIndex == reactorChannel._reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()) {
                                        ++reactorChannel._listIndex;
                                    }
                                    if (reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
                                        reactorChannel._listIndex = 0;
                                    }
                                    reactorChannel._haveAttemptedFirstConnectionListEntry = true;
                                    reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
                                    reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
                                }
                            }
                        }
                        ++reactorChannel._reconnectAttempts;
                    }
                    if (reactorChannel.reconnectAttemptLimit() == 0) {
                        reactorChannel._haveAttemptedFirstConnection = true;
                    }
                    if (reactorChannel.preferredHostChannel() != null && reactorChannel.preferredHostChannel().state() == 2) {
                        channel = reactorChannel.preferredHostChannel();
                        reactorChannel.selectableChannelFromChannel(reactorChannel.preferredHostChannel());
                        reactorChannel.preferredHostChannel(null);
                        this._reconnectingChannelQueue.remove(reactorChannel);
                        reactorChannel.pingHandler().initPingHandler(channel.pingTimeout());
                        reactorChannel.resetCurrentChannelRetryCount();
                        reactorChannel.state(ReactorChannel.State.UP);
                        this._activeChannelQueue.add(reactorChannel);
                        reactorChannel._phResetPHIndexForRecovery = true;
                        continue;
                    }
                    if (reactorChannel.state() != ReactorChannel.State.EDP_RT && reactorChannel.state() != ReactorChannel.State.EDP_RT_DONE && reactorChannel.state() != ReactorChannel.State.EDP_RT_FAILED) {
                        channel = reactorChannel.reconnectReactorChannel(this._error);
                    }
                    if (reactorChannel.state() == ReactorChannel.State.EDP_RT || reactorChannel.state() == ReactorChannel.State.EDP_RT_DONE || reactorChannel.state() == ReactorChannel.State.EDP_RT_FAILED) {
                        channel = reactorChannel.reconnectEDP(this._error);
                    }
                    if (channel == null && reactorChannel.state() != ReactorChannel.State.EDP_RT) {
                        this._reconnectingChannelQueue.remove(reactorChannel);
                        if (reactorChannel.tokenSession() != null && reactorChannel.tokenSession().sessionMgntState() == ReactorTokenSession.SessionState.STOP_TOKEN_REQUEST) {
                            reactorChannel.getReactorConnectOptions().reconnectAttemptLimit(0);
                        }
                        this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.run()", "Reconnection failed: " + this._error.text());
                        continue;
                    }
                    if (reactorChannel.state() == ReactorChannel.State.EDP_RT) continue;
                    reactorChannel.selectableChannelFromChannel(channel);
                    reactorChannel.state(ReactorChannel.State.INITIALIZING);
                    this._reconnectingChannelQueue.remove(reactorChannel);
                    this.processChannelInit(reactorChannel);
                }
            }
            catch (CancelledKeyException selectorCount) {
            }
            catch (IOException e) {
                System.out.println("Worker.run() exception=" + e.getLocalizedMessage());
                this.sendWorkerEvent(this._reactorReactorChannel, WorkerEventTypes.SHUTDOWN, -1, "Worker.run", "exception occurred, " + e.getLocalizedMessage());
                break;
            }
        }
        this.shutdown();
    }

    private void initializeNewPHChannelWithSessionMgnt(ReactorChannel reactorChannel, ReactorConnectInfo connectInfo) {
        boolean readyForConnection = true;
        ConnectOptionsInfo connectOptionsInfo = new ConnectOptionsInfo();
        connectOptionsInfo.reconnectAttempts = 0;
        boolean bl = connectOptionsInfo.hostAndPortProvided = connectInfo.connectOptions().unifiedNetworkInfo().address() != null && connectInfo.connectOptions().unifiedNetworkInfo().serviceName() != null && !connectInfo.connectOptions().unifiedNetworkInfo().address().isEmpty() && !connectInfo.connectOptions().unifiedNetworkInfo().serviceName().isEmpty();
        if (connectInfo.enableSessionManagement() && reactorChannel.redoServiceDiscoveryForTargetChannel(connectInfo, connectOptionsInfo)) {
            connectInfo.connectOptions().unifiedNetworkInfo().address("");
            connectInfo.connectOptions().unifiedNetworkInfo().serviceName("");
            reactorChannel.resetCurrentChannelRetryCount();
            if (this._reactor.sessionManagementStartup(reactorChannel.tokenSession(), connectInfo, reactorChannel.role(), reactorChannel, false, reactorChannel.getEDPErrorInfo()) != 0) {
                readyForConnection = false;
            }
        } else {
            reactorChannel.applyAccessToken();
            if (Reactor.requestServiceDiscovery(connectInfo) && reactorChannel.applyServiceDiscoveryEndpoint(connectInfo, reactorChannel.getEDPErrorInfo()) != 0) {
                readyForConnection = false;
            }
        }
        if (readyForConnection) {
            reactorChannel.preferredHostChannel(Transport.connect((ConnectOptions)connectInfo.connectOptions(), (Error)this._error));
            if (reactorChannel.preferredHostChannel() != null) {
                reactorChannel.initializationTimeout(reactorChannel.getCurrentReactorConnectInfo().initTimeout());
            }
        }
    }

    private void checkChannelList(ReactorChannel reactorChannel) {
        reactorChannel._switchingToPreferredWSBGroup = false;
        reactorChannel._switchingToPreferredHost = false;
        reactorChannel._hitEndOfWSBGroups = true;
        if (reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() > 0) {
            this.rollbackWsbGroupCurrentIndex(reactorChannel);
        }
        reactorChannel._checkedPreferredHostInChannelList_WSBEnabled = false;
        reactorChannel._phSwitchingFromWSBToChannelList = true;
        if (reactorChannel._listIndex == reactorChannel._preferredHostOptions.connectionListIndex() && ++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
            reactorChannel._listIndex = 0;
        }
        reactorChannel._haveAttemptedFirstConnectionListEntry = true;
        reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._listIndex));
        reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._listIndex));
        if (++reactorChannel._listIndex == reactorChannel.getReactorConnectOptions().connectionList().size()) {
            reactorChannel._listIndex = 0;
        }
        reactorChannel._reconnectAttempts = reactorChannel.reconnectAttemptLimit() - 1;
        reactorChannel._haveAttemptedFirstConnection = true;
        reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState(16);
        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(0);
    }

    private void checkPreferredChannelList(ReactorChannel reactorChannel) {
        reactorChannel._switchingToPreferredWSBGroup = false;
        reactorChannel._switchingToPreferredHost = true;
        reactorChannel._hitEndOfWSBGroups = true;
        if (reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() > 0) {
            this.rollbackWsbGroupCurrentIndex(reactorChannel);
        }
        reactorChannel._checkedPreferredHostInChannelList_WSBEnabled = true;
        reactorChannel._haveAttemptedFirstConnectionListEntry = true;
        reactorChannel._phSwitchingFromWSBToChannelList = true;
        reactorChannel.setCurrentReactorConnectInfo(reactorChannel.getReactorConnectOptions().connectionList().get(reactorChannel._preferredHostOptions.connectionListIndex()));
        reactorChannel.setCurrentConnectOptionsInfo(reactorChannel._connectOptionsInfoList.get(reactorChannel._preferredHostOptions.connectionListIndex()));
        reactorChannel._reconnectAttempts = reactorChannel.reconnectAttemptLimit() - 1;
        reactorChannel._haveAttemptedFirstConnection = true;
        reactorChannel.warmStandByHandlerImpl.warmStandbyHandlerState(16);
        reactorChannel.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(0);
    }

    void rollbackWsbGroupCurrentIndex(ReactorChannel reactorChannel) {
        if (reactorChannel._preferredHostOptions.warmStandbyGroupListIndex() == 0 && reactorChannel.warmStandByHandlerImpl.warmStandbyGroupList().size() > 1) {
            reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(1);
            reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex(0);
        } else {
            reactorChannel.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(0);
            reactorChannel.warmStandByHandlerImpl.previousWarmStandbyGroupIndex(-1);
        }
    }

    private void sendPreferredHostCompleteEvent(ReactorChannel reactorChannel) {
        this.sendWorkerEvent(reactorChannel, WorkerEventTypes.PREFERRED_HOST_COMPLETE, 0, "Worker.sendPreferredHostCompleteEvent", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelPHTimerEvent(ReactorChannel reactorChannel) {
        if (reactorChannel._currentPHTimerEvent != null) {
            if (this._reactor.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                try {
                    for (ReactorChannel wsbChannel : reactorChannel.warmStandByHandlerImpl.channelList()) {
                        if (reactorChannel == wsbChannel) continue;
                        reactorChannel._currentPHTimerEvent.reactorChannel(wsbChannel);
                        wsbChannel._currentPHTimerEvent = reactorChannel._currentPHTimerEvent;
                        reactorChannel._currentPHTimerEvent = null;
                        return;
                    }
                }
                finally {
                    reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                }
            }
            reactorChannel._currentPHTimerEvent._isCanceled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelExistingPHTimerEvent(ReactorChannel reactorChannel) {
        if (reactorChannel._currentPHTimerEvent != null) {
            if (this._reactor.reactorHandlesWarmStandby(reactorChannel)) {
                reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                try {
                    for (ReactorChannel wsbChannel : reactorChannel.warmStandByHandlerImpl.channelList()) {
                        if (wsbChannel._currentPHTimerEvent == null) continue;
                        wsbChannel._currentPHTimerEvent._isCanceled = true;
                    }
                    return;
                }
                finally {
                    reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                }
            }
            reactorChannel._currentPHTimerEvent._isCanceled = true;
        }
    }

    private void processWorkerEvent() {
        while (this._queue.readQueueSize() != 0) {
            WorkerEvent event = (WorkerEvent)this._queue.read();
            WorkerEventTypes eventType = event.eventType();
            ReactorChannel reactorChannel = event.reactorChannel();
            switch (eventType) {
                case CHANNEL_INIT: {
                    this.processChannelInit(reactorChannel);
                    break;
                }
                case CHANNEL_DOWN: {
                    this.processChannelClose(reactorChannel, reactorChannel.channel());
                    if (!reactorChannel.isClosedAckSent && reactorChannel.server() == null && !event.reactorChannel().recoveryAttemptLimitReached()) {
                        if (reactorChannel.nextRecoveryTime() < System.currentTimeMillis()) {
                            reactorChannel.calculateNextReconnectTime();
                        }
                        if (reactorChannel.tokenSession() != null && reactorChannel.tokenSession().authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2 && !reactorChannel.tokenSession().hasAccessToken()) {
                            reactorChannel.tokenSession().resetSessionMgntState();
                        }
                        this._reconnectingChannelQueue.add(reactorChannel);
                        break;
                    }
                    this.cancelPHTimerEvent(reactorChannel);
                    break;
                }
                case CHANNEL_CLOSE: {
                    this.processChannelClose(reactorChannel, reactorChannel.channel());
                    if (reactorChannel.warmStandByHandlerImpl != null) {
                        this._reactor.removeReactorChannel(reactorChannel);
                    }
                    this.cancelPHTimerEvent(reactorChannel);
                    reactorChannel.isClosedAckSent = true;
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_CLOSE_ACK, 0, null, null);
                    break;
                }
                case SHUTDOWN: {
                    this._running = false;
                    break;
                }
                case FLUSH: {
                    this.processChannelFlush(reactorChannel);
                    break;
                }
                case FD_CHANGE: {
                    this.processChannelFDChange(reactorChannel);
                    break;
                }
                case TOKEN_MGNT: {
                    ReactorTokenSession tokenSession = event._tokenSession;
                    if (tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.REQUEST_TOKEN_FAILURE) {
                        event.timeout(tokenSession.nextTokenReissueAttemptReqTime());
                    } else if (tokenSession.sessionMgntState() == ReactorTokenSession.SessionState.AUTHENTICATE_USING_PASSWD_GRANT) {
                        event.timeout(System.nanoTime());
                    } else {
                        tokenSession.calculateNextAuthTokenRequestTime(tokenSession.authTokenInfo().expiresIn());
                        event.timeout(tokenSession.nextAuthTokenRequestTime());
                    }
                    if (tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V1) {
                        if (tokenSession.tokenReissueEvent() != null && tokenSession.tokenReissueEvent() != event) {
                            tokenSession.tokenReissueEvent()._tokenSession = null;
                            tokenSession.tokenReissueEvent().timeout(System.nanoTime());
                            tokenSession.tokenReissueEvent(event);
                        } else {
                            tokenSession.tokenReissueEvent(event);
                        }
                    }
                    this._timerEventQueue.add(event);
                    return;
                }
                case START_DISPATCH_TIMER: 
                case START_WATCHLIST_TIMER: {
                    this._timerEventQueue.add(event);
                    return;
                }
                case PREFERRED_HOST_TIMER: {
                    if (event.reactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                        this.cancelExistingPHTimerEvent(event.reactorChannel());
                        if (event.reactorChannel()._preferredHostOptions.detectionTimeSchedule() != null && !event.reactorChannel()._preferredHostOptions.detectionTimeSchedule().isEmpty()) {
                            event.reactorChannel()._cronCurrentTime = new Date(System.currentTimeMillis());
                            event.reactorChannel()._cronNextTime = event.reactorChannel()._cronExpression.getNextValidTimeAfter(event.reactorChannel()._cronCurrentTime);
                            event.reactorChannel()._nextReconnectTimeMs = event.reactorChannel()._cronNextTime.getTime();
                            event.timeout(System.nanoTime() + (event.reactorChannel()._cronNextTime.getTime() - event.reactorChannel()._cronCurrentTime.getTime()) * 1000000L);
                            event.reactorChannel()._currentPHTimerEvent = event;
                            this._timerEventQueue.add(event);
                        } else if (event.reactorChannel()._preferredHostOptions.detectionTimeInterval() > 0L) {
                            event.reactorChannel()._nextReconnectTimeMs = System.currentTimeMillis() + event.reactorChannel()._preferredHostOptions.detectionTimeInterval() * 1000L;
                            event.timeout(System.nanoTime() + event.reactorChannel()._preferredHostOptions.detectionTimeInterval() * 1000000000L);
                            event.reactorChannel()._currentPHTimerEvent = event;
                            this._timerEventQueue.add(event);
                            return;
                        }
                    } else {
                        this.cancelExistingPHTimerEvent(event.reactorChannel());
                    }
                    return;
                }
                case PREFERRED_HOST_START_FALLBACK: {
                    this._timerEventQueue.add(event);
                    return;
                }
                case PREFERRED_HOST_IOCTL: {
                    this._timerEventQueue.add(event);
                    return;
                }
                case PREFERRED_HOST_CHANNEL_CLOSE: {
                    if (reactorChannel.oldPHStartingChannel != null) {
                        this.processChannelClose(reactorChannel, reactorChannel.oldPHStartingChannel);
                        this._activeChannelQueue.add(reactorChannel);
                        reactorChannel.oldPHStartingChannel = null;
                    }
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.PREFERRED_HOST_CHANNEL_CLOSE_ACK, 0, null, null);
                    break;
                }
                case PREFERRED_HOST_CHANNEL_DOWN: {
                    this.processChannelClose(reactorChannel, reactorChannel.channel());
                    if (reactorChannel.warmStandByHandlerImpl == null) break;
                    this._reactor.removeReactorChannel(reactorChannel);
                    break;
                }
                default: {
                    System.out.println("Worker.processWorkerEvent(): received unexpected eventType=" + (Object)((Object)eventType));
                }
            }
            event.returnToPool();
        }
    }

    private void processChannelInit(ReactorChannel reactorChannel) {
        this._initChannelQueue.add(reactorChannel);
        try {
            if (reactorChannel.selectableChannel() != null) {
                reactorChannel.selectableChannel().register(this._selector, 9, reactorChannel);
            }
        }
        catch (ClosedChannelException e) {
            if (reactorChannel.state() != ReactorChannel.State.CLOSED) {
                reactorChannel.state(ReactorChannel.State.CLOSED);
            }
            this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelInit", "Exception=" + e.getLocalizedMessage());
        }
    }

    private void processChannelClose(ReactorChannel reactorChannel, Channel channel) {
        if (reactorChannel == null) {
            return;
        }
        if (channel != null && channel.state() != 0) {
            channel.close(this._error);
            reactorChannel.selectableChannelFromChannel(null);
            reactorChannel.flushRequested(false);
        }
        if (!(this._activeChannelQueue.remove(reactorChannel) || this._inactiveChannelQueue.remove(reactorChannel) || this._initChannelQueue.remove(reactorChannel))) {
            this._reconnectingChannelQueue.remove(reactorChannel);
        }
    }

    private void processChannelFlush(ReactorChannel reactorChannel) {
        if (reactorChannel == null) {
            return;
        }
        Channel channel = reactorChannel.channel();
        if (channel != null && channel.state() != 0 && channel.state() != -1) {
            int retval = channel.flush(this._error);
            if (retval > 0) {
                if (!this.addSelectOption(reactorChannel, 4) && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                    this._activeChannelQueue.remove(reactorChannel);
                    this._inactiveChannelQueue.add(reactorChannel);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to add OP_WRITE to selectableChannel.");
                }
            } else if (retval == 0) {
                if (!this.removeSelectOption(reactorChannel, 4) && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                    this._activeChannelQueue.remove(reactorChannel);
                    this._inactiveChannelQueue.add(reactorChannel);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to remove OP_WRITE to selectableChannel.");
                }
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.FLUSH_DONE, 0, null, null);
            } else if (retval < 0 && retval != -9 && retval != -10 && reactorChannel.state() != ReactorChannel.State.CLOSED && reactorChannel.state() != ReactorChannel.State.DOWN && reactorChannel.state() != ReactorChannel.State.DOWN_RECONNECTING) {
                this._activeChannelQueue.remove(reactorChannel);
                this._inactiveChannelQueue.add(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFlush", "failed to flush selectableChannel, errorId=" + this._error.errorId() + " errorText=" + this._error.text());
            }
        }
    }

    private void processChannelFDChange(ReactorChannel reactorChannel) {
        block6: {
            int options = 0;
            try {
                SelectionKey key = reactorChannel.oldSelectableChannel().keyFor(this._selector);
                if (key != null) {
                    options = key.interestOps();
                    key.cancel();
                }
            }
            catch (Exception key) {
                // empty catch block
            }
            try {
                if (options != 0) {
                    reactorChannel.selectableChannel().register(this._selector, options, reactorChannel);
                }
            }
            catch (Exception e) {
                if (reactorChannel.state() == ReactorChannel.State.CLOSED || reactorChannel.state() == ReactorChannel.State.DOWN || reactorChannel.state() == ReactorChannel.State.DOWN_RECONNECTING) break block6;
                this._activeChannelQueue.remove(reactorChannel);
                this._inactiveChannelQueue.add(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.processChannelFDChange", "selector register failed.");
            }
        }
    }

    private void initializeChannel(ReactorChannel reactorChannel) {
        Channel channel = reactorChannel.channel();
        int retval = channel.init(this._inProg, this._error);
        if (retval < 0) {
            this.cancelRegister(reactorChannel);
            reactorChannel.state(ReactorChannel.State.DOWN);
            this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error initializing channel: errorId=" + this._error.errorId() + " text=" + this._error.text());
            return;
        }
        switch (retval) {
            case 2: {
                if (this._inProg.flags() == 1) {
                    retval = this.reRegister(this._inProg, reactorChannel, this._error);
                    if (retval == 0) break;
                    this.cancelRegister(reactorChannel);
                    this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - failed to re-register on SCKT_CHNL_CHANGE: " + this._error.text());
                    break;
                }
                if (System.currentTimeMillis() <= reactorChannel.initializationEndTimeMs()) break;
                this.cancelRegister(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - exceeded initialization timeout (" + reactorChannel.initializationTimeout() + " s)");
                break;
            }
            case 0: {
                this.cancelRegister(reactorChannel);
                reactorChannel.pingHandler().initPingHandler(channel.pingTimeout());
                reactorChannel.resetCurrentChannelRetryCount();
                reactorChannel._haveAttemptedFirstConnection = true;
                reactorChannel._switchingToPreferredHost = false;
                reactorChannel._switchingToPreferredWSBGroup = false;
                this._initChannelQueue.remove(reactorChannel);
                this._activeChannelQueue.add(reactorChannel);
                reactorChannel._phResetPHIndexForRecovery = true;
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_UP, 0, null, null);
                break;
            }
            default: {
                this.cancelRegister(reactorChannel);
                this.sendWorkerEvent(reactorChannel, WorkerEventTypes.CHANNEL_DOWN, -1, "Worker.initializeChannel", "Error - invalid return code: " + retval);
            }
        }
    }

    private void cancelRegister(ReactorChannel reactorChannel) {
        try {
            SelectionKey key = reactorChannel.channel().selectableChannel().keyFor(this._selector);
            if (key != null) {
                key.cancel();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean addSelectOption(ReactorChannel reactorChannel, int options) {
        if (reactorChannel == null || reactorChannel.state() != ReactorChannel.State.INITIALIZING && reactorChannel.state() != ReactorChannel.State.UP && reactorChannel.state() != ReactorChannel.State.READY) {
            return false;
        }
        Channel channel = reactorChannel.channel();
        if (channel == null) {
            return false;
        }
        SelectionKey key = channel.selectableChannel().keyFor(this._selector);
        if (key != null) {
            if ((key.interestOps() & options) != 0) {
                return true;
            }
            options |= key.interestOps();
        }
        try {
            channel.selectableChannel().register(this._selector, options, reactorChannel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    private boolean removeSelectOption(ReactorChannel reactorChannel, int options) {
        block8: {
            if (reactorChannel == null || reactorChannel.state() != ReactorChannel.State.INITIALIZING && reactorChannel.state() != ReactorChannel.State.UP && reactorChannel.state() != ReactorChannel.State.READY) {
                return false;
            }
            Channel channel = reactorChannel.channel();
            if (channel == null) {
                return false;
            }
            SelectionKey key = channel.selectableChannel().keyFor(this._selector);
            if (key != null) {
                try {
                    int newOptions = key.interestOps() - options;
                    if (newOptions != 0) {
                        try {
                            channel.selectableChannel().register(this._selector, newOptions, reactorChannel);
                            break block8;
                        }
                        catch (ClosedChannelException e) {
                            return false;
                        }
                    }
                    key.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private int reRegister(InProgInfo inProg, ReactorChannel reactorChannel, Error error) {
        try {
            SelectionKey key = inProg.oldSelectableChannel().keyFor(this._selector);
            if (key != null) {
                key.cancel();
            }
        }
        catch (Exception e) {
            error.text(e.getMessage());
            return -1;
        }
        try {
            reactorChannel.channel().selectableChannel().register(this._selector, 1, reactorChannel);
        }
        catch (Exception e) {
            error.text(e.getMessage());
            return -1;
        }
        reactorChannel.selectableChannelFromChannel(reactorChannel.channel());
        reactorChannel.oldSelectableChannel(inProg.oldSelectableChannel());
        return 0;
    }

    private void sendWorkerEvent(ReactorChannel reactorChannel, WorkerEventTypes eventType, int reactorReturnCode, String location, String text) {
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.reactorChannel(reactorChannel);
        event.eventType(eventType);
        event.errorInfo().code(reactorReturnCode);
        event.errorInfo().error().errorId(reactorReturnCode);
        if (location != null) {
            event.errorInfo().location(location);
        }
        if (text != null) {
            event.errorInfo().error().text(text);
        }
        this._queue.write(event);
    }

    private void sendWorkerEvent(ReactorChannel reactorChannel, WorkerEventTypes eventType, TunnelStream tunnelStream, int reactorReturnCode, String location, String text) {
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.reactorChannel(reactorChannel);
        event.eventType(eventType);
        event.tunnelStream(tunnelStream);
        event.errorInfo().code(reactorReturnCode);
        event.errorInfo().error().errorId(reactorReturnCode);
        if (location != null) {
            event.errorInfo().location(location);
        }
        if (text != null) {
            event.errorInfo().error().text(text);
        }
        this._queue.write(event);
    }

    private void shutdown() {
        this._running = false;
        if (this._selector != null) {
            Set<SelectionKey> keys = this._selector.keys();
            if (keys != null) {
                for (SelectionKey key : keys) {
                    key.cancel();
                    ReactorChannel reactorChannel = (ReactorChannel)key.attachment();
                    if (reactorChannel == null) continue;
                    if (reactorChannel.channel() != null) {
                        reactorChannel.channel().close(this._error);
                        if (!(this._activeChannelQueue.remove(reactorChannel) || this._inactiveChannelQueue.remove(reactorChannel) || this._initChannelQueue.remove(reactorChannel))) {
                            this._reconnectingChannelQueue.remove(reactorChannel);
                        }
                    } else if (reactorChannel == this._workerReactorChannel) {
                        this._queue = null;
                        this._workerReactorChannel = null;
                    }
                    reactorChannel.returnToPool();
                }
            }
            try {
                this._selector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._selector = null;
            Worker.clearChannelQueue(this._initChannelQueue, this._error);
            Worker.clearChannelQueue(this._activeChannelQueue, this._error);
            Worker.clearChannelQueue(this._inactiveChannelQueue, this._error);
            Worker.clearChannelQueue(this._reconnectingChannelQueue, this._error);
            if (this._reactor.numberOfTokenSession() != 0) {
                this._reactor.removeAllTokenSession();
            }
        }
        this._error = null;
    }

    private static void clearChannelQueue(VaIteratableQueue channelQueue, Error _error) {
        while (channelQueue.size() > 0) {
            ReactorChannel reactorChannel = (ReactorChannel)channelQueue.poll();
            if (reactorChannel == null) continue;
            if (reactorChannel.channel() != null) {
                reactorChannel.channel().close(_error);
            }
            if (reactorChannel.reactor() != null) {
                reactorChannel.reactor().removeReactorChannel(reactorChannel);
            }
            reactorChannel.returnToPool();
        }
    }

    private int initializeWorker() {
        try {
            this._selector = SelectorProvider.provider().openSelector();
            this._workerReactorChannel = ReactorFactory.createReactorChannel(this._reactor);
            this._workerReactorChannel.selectableChannel(this._queue.readChannel());
            this._queue.readChannel().register(this._selector, 1, this._workerReactorChannel);
        }
        catch (IOException e) {
            this._running = false;
            System.out.println("Worker.initializeWorker() failed, exception=" + e.getLocalizedMessage());
            return -1;
        }
        return 0;
    }
}

