/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.PostMsg;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConsumerConnectionStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRTT;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginStatus;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlHandler;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import java.util.Objects;

class WlLoginHandler
implements WlHandler {
    Watchlist _watchlist;
    WlStream _stream;
    int _loginStreamId;
    EncodeIterator _eIter = CodecFactory.createEncodeIterator();
    DecodeIterator _dIter = CodecFactory.createDecodeIterator();
    LoginRequest _loginRequest;
    LoginRequest _loginRequestForEDP;
    LoginRequest _tempLoginRequest;
    ReactorErrorInfo _errorInfo = ReactorFactory.createReactorErrorInfo();
    ReactorSubmitOptions _submitOptions = ReactorFactory.createReactorSubmitOptions();
    Msg _tempMsg = CodecFactory.createMsg();
    LoginConsumerConnectionStatus _loginCCS;
    LoginRefresh _loginRefresh;
    LoginStatus _loginStatus;
    LoginRTT _loginRTT;
    StatusMsg _statusMsg;
    Buffer _tempBuffer;
    boolean _awaitingResumeAll;
    boolean _userloginStreamOpen;
    int _requestCount;
    boolean _hasPendingRequest;
    boolean rttEnabled;
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();

    WlLoginHandler(Watchlist watchlist) {
        this._watchlist = watchlist;
        this._loginRefresh = (LoginRefresh)LoginMsgFactory.createMsg();
        this._loginRefresh.rdmMsgType(LoginMsgType.REFRESH);
        this._loginStatus = (LoginStatus)LoginMsgFactory.createMsg();
        this._loginStatus.rdmMsgType(LoginMsgType.STATUS);
        this._loginCCS = (LoginConsumerConnectionStatus)LoginMsgFactory.createMsg();
        this._loginCCS.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
        this._loginRTT = (LoginRTT)LoginMsgFactory.createMsg();
        this._loginRTT.rdmMsgType(LoginMsgType.RTT);
        this._statusMsg = (StatusMsg)CodecFactory.createMsg();
        this._statusMsg.msgClass(3);
        this._statusMsg.domainType(1);
        this._tempBuffer = CodecFactory.createBuffer();
        this._tempBuffer.data("");
        this._tempLoginRequest = (LoginRequest)LoginMsgFactory.createMsg();
        this._tempLoginRequest.rdmMsgType(LoginMsgType.REQUEST);
        this._userloginStreamOpen = true;
        this._loginStreamId = this._watchlist.nextStreamId();
        this._hasPendingRequest = false;
    }

    @Override
    public int submitRequest(WlRequest wlRequest, RequestMsg requestMsg, boolean isReissue, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret;
        if (this._loginRequest != null && requestMsg.streamId() != this._loginRequest.streamId() && this._stream != null && this._stream.state().streamState() != 4) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitRequest", "Cannot have more than one login stream with watchlist enabled.");
        }
        WlInteger wlInteger = ReactorFactory.createWlInteger();
        wlInteger.value(requestMsg.streamId());
        if (this._stream == null) {
            if (!this._watchlist.streamIdtoWlStreamTable().containsKey(wlInteger)) {
                this._stream = ReactorFactory.createWlStream();
                this._stream.handler(this);
                this._stream.watchlist(this._watchlist);
                this._stream.streamId(requestMsg.streamId());
                this._stream.domainType(requestMsg.domainType());
            } else {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitRequest", "Stream already exists with id of " + requestMsg.streamId() + ".");
            }
        }
        if (isReissue) {
            this._tempLoginRequest.clear();
            this._watchlist.convertCodecToRDMMsg((Msg)requestMsg, this._tempLoginRequest);
            ret = this.handleReissue(this._tempLoginRequest, errorInfo);
            if (ret < 0) {
                return ret;
            }
            this._loginRequest.clear();
            this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
            this._tempLoginRequest.copy(this._loginRequest);
            if (!(this._loginRefresh.checkHasFeatures() && this._loginRefresh.features().checkHasSupportOptimizedPauseResume() && this._loginRefresh.features().supportOptimizedPauseResume() == 1L || !requestMsg.checkPause())) {
                requestMsg.flags(requestMsg.flags() & 0xFFFFFDFF);
            }
        } else {
            if (this._loginRequest == null) {
                this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
            } else {
                this._loginRequest.clear();
            }
            this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
            this._watchlist.convertCodecToRDMMsg((Msg)requestMsg, this._loginRequest);
            if (requestMsg.checkPause()) {
                requestMsg.flags(requestMsg.flags() & 0xFFFFFDFF);
            }
        }
        if (this._requestCount == 0 && this._stream.isChannelUp() && (ret = this._stream.sendMsgOutOfLoop((Msg)requestMsg, submitOptions, errorInfo)) < 0) {
            if (!isReissue) {
                this._loginRequest = null;
                this._stream.returnToPool();
                this._stream = null;
            }
            return ret;
        }
        if (!requestMsg.checkNoRefresh() && this._stream.isChannelUp()) {
            ++this._requestCount;
        }
        if (!isReissue) {
            wlRequest.streamInfo().serviceName(submitOptions.serviceName());
            this._stream.tableKey(wlInteger);
            this._watchlist.streamIdtoWlStreamTable().put(wlInteger, this._stream);
        } else {
            wlInteger.returnToPool();
        }
        wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
        return 0;
    }

    @Override
    public int submitMsg(WlRequest wlRequest, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        switch (msg.msgClass()) {
            case 5: {
                int ret1 = this._watchlist.itemHandler().loginStreamClosed(null);
                int ret2 = this._watchlist.directoryHandler().loginStreamClosed();
                if (ret1 < 0) {
                    return ret1;
                }
                if (ret2 < 0) {
                    return ret2;
                }
                int ret = this._stream.sendMsgOutOfLoop(msg, submitOptions, errorInfo);
                if (ret < 0) {
                    return ret;
                }
                this._watchlist.closeWlRequest(wlRequest);
                wlRequest.returnToPool();
                this._stream.close();
                this._stream.returnToPool();
                this._stream = null;
                break;
            }
            case 8: {
                if (this._loginRefresh.features().checkHasSupportPost()) {
                    if (this._stream.state().streamState() == 1) {
                        boolean resetServiceId = false;
                        int ret = this._stream.validatePostSubmit((PostMsg)msg, errorInfo);
                        if (ret != 0) {
                            return ret;
                        }
                        if (submitOptions.serviceName() != null) {
                            if (!((PostMsg)msg).checkHasMsgKey()) {
                                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitMsg", "Post message submitted with service name but no message key.");
                            }
                            ret = this._watchlist.changeServiceNameToID(((PostMsg)msg).msgKey(), submitOptions.serviceName(), errorInfo);
                            if (ret < 0) {
                                return ret;
                            }
                            resetServiceId = true;
                        }
                        int userStreamId = msg.streamId();
                        msg.streamId(this._stream._streamId);
                        ret = this._stream.sendMsgOutOfLoop(msg, submitOptions, errorInfo);
                        msg.streamId(userStreamId);
                        if (resetServiceId && (!((PostMsg)msg).checkAck() || ret < 0)) {
                            ((PostMsg)msg).msgKey().flags(((PostMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                            ((PostMsg)msg).msgKey().serviceId(0);
                            resetServiceId = false;
                        }
                        if (ret < 0) {
                            return ret;
                        }
                        if (!((PostMsg)msg).checkAck()) break;
                        this._watchlist.numOutstandingPosts(this._watchlist.numOutstandingPosts() + 1);
                        ret = this._stream.updatePostTables((PostMsg)msg, errorInfo);
                        if (!resetServiceId) break;
                        ((PostMsg)msg).msgKey().flags(((PostMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                        ((PostMsg)msg).msgKey().serviceId(0);
                        break;
                    }
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitMsg", "Cannot submit PostMsg when stream not in open state.");
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitMsg", "Posting not supported by provider");
            }
            case 7: {
                if (this._stream.state().streamState() == 1) {
                    int ret;
                    boolean resetServiceId = false;
                    if (submitOptions.serviceName() != null) {
                        if (!((GenericMsg)msg).checkHasMsgKey()) {
                            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitMsg", "Generic message submitted with service name but no message key.");
                        }
                        ret = this._watchlist.changeServiceNameToID(((GenericMsg)msg).msgKey(), submitOptions.serviceName(), errorInfo);
                        if (ret < 0) {
                            return ret;
                        }
                        resetServiceId = true;
                    }
                    ret = this._stream.sendMsgOutOfLoop(msg, submitOptions, errorInfo);
                    if (resetServiceId) {
                        ((GenericMsg)msg).msgKey().flags(((GenericMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                        ((GenericMsg)msg).msgKey().serviceId(0);
                    }
                    if (ret >= 0) break;
                    return ret;
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.submitMsg", "Cannot submit GenericMsg when stream not in open state.");
            }
            default: {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlLoginHandler.submitMsg", "Invalid message class (" + msg.msgClass() + ") submitted to Watchlist login handler");
            }
        }
        return 0;
    }

    int handleReissue(LoginRequest loginRequest, ReactorErrorInfo errorInfo) {
        int ret = this.validateReissue(loginRequest, errorInfo);
        if (ret != 0) {
            return ret;
        }
        if (loginRequest.checkPause()) {
            if (this._loginRefresh.checkHasFeatures() && this._loginRefresh.features().checkHasSupportOptimizedPauseResume() && this._loginRefresh.features().supportOptimizedPauseResume() == 1L) {
                this._awaitingResumeAll = true;
                ret = this._watchlist.itemHandler().pauseAll();
                if (ret < 0) {
                    return ret;
                }
                loginRequest.flags(loginRequest.flags() | 0x80);
            }
        } else if (this._awaitingResumeAll && !this.isTokenChange(loginRequest)) {
            this._awaitingResumeAll = false;
            ret = this._watchlist.itemHandler().resumeAll();
            if (ret < 0) {
                return ret;
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int validateReissue(LoginRequest loginRequest, ReactorErrorInfo errorInfo) {
        if (loginRequest.checkHasRole() && loginRequest.role() != 0L) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login role is not consumer");
        }
        if (this._loginRequest.checkHasUserNameType() != loginRequest.checkHasUserNameType()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login userNameType does not match existing request");
        if (this._loginRequest.checkHasUserNameType() && (loginRequest.userNameType() != this._loginRequest.userNameType() || this._loginRequest.userNameType() != 3 && this._loginRequest.userNameType() != 5 && !this._loginRequest.userName().equals(loginRequest.userName()))) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login userNameType does not match existing request");
        }
        if (this._loginRequest.checkHasDownloadConnectionConfig() != loginRequest.checkHasDownloadConnectionConfig()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login downloadConnectionConfig does not match existing request");
        if (this._loginRequest.checkHasDownloadConnectionConfig() && this._loginRequest.downloadConnectionConfig() != loginRequest.downloadConnectionConfig()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login downloadConnectionConfig does not match existing request");
        }
        if (this._loginRequest.checkHasInstanceId() != loginRequest.checkHasInstanceId()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login instanceId does not match existing request");
        if (this._loginRequest.checkHasInstanceId() && !this._loginRequest.instanceId().equals(loginRequest.instanceId())) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login instanceId does not match existing request");
        }
        if (this._loginRequest.checkHasPassword() != loginRequest.checkHasPassword()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login password does not match existing request");
        if (this._loginRequest.checkHasPassword() && !this._loginRequest.password().equals(loginRequest.password())) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login password does not match existing request");
        }
        if (this._loginRequest.checkHasAttrib() != loginRequest.checkHasAttrib()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login attrib does not match existing request");
        if (!this._loginRequest.checkHasAttrib()) return 0;
        if (this._loginRequest.attrib().checkHasApplicationId() != loginRequest.attrib().checkHasApplicationId()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login applicationId does not match existing request");
        if (this._loginRequest.attrib().checkHasApplicationId() && !this._loginRequest.attrib().applicationId().equals(loginRequest.attrib().applicationId())) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login applicationId does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasApplicationName() != loginRequest.attrib().checkHasApplicationName()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login applicationName does not match existing request");
        if (this._loginRequest.attrib().checkHasApplicationName() && !this._loginRequest.attrib().applicationName().equals(loginRequest.attrib().applicationName())) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login applicationName does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasPosition() != loginRequest.attrib().checkHasPosition()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login position does not match existing request");
        if (this._loginRequest.attrib().checkHasPosition() && !this._loginRequest.attrib().position().equals(loginRequest.attrib().position())) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login position does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasSingleOpen() != loginRequest.attrib().checkHasSingleOpen()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login singleOpen does not match existing request");
        if (this._loginRequest.attrib().checkHasSingleOpen() && this._loginRequest.attrib().singleOpen() != loginRequest.attrib().singleOpen()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login singleOpen does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasAllowSuspectData() != loginRequest.attrib().checkHasAllowSuspectData()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login allowSuspectData does not match existing request");
        if (this._loginRequest.attrib().checkHasAllowSuspectData() && this._loginRequest.attrib().allowSuspectData() != loginRequest.attrib().allowSuspectData()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login allowSuspectData does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasProvidePermissionExpressions() != loginRequest.attrib().checkHasProvidePermissionExpressions()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login providePermissionExpressions does not match existing request");
        if (this._loginRequest.attrib().checkHasProvidePermissionExpressions() && this._loginRequest.attrib().providePermissionExpressions() != loginRequest.attrib().providePermissionExpressions()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login providePermissionExpressions does not match existing request");
        }
        if (this._loginRequest.attrib().checkHasProvidePermissionProfile() != loginRequest.attrib().checkHasProvidePermissionProfile()) return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login providePermissionProfile does not match existing request");
        if (!this._loginRequest.attrib().checkHasProvidePermissionProfile() || this._loginRequest.attrib().providePermissionProfile() == loginRequest.attrib().providePermissionProfile()) return 0;
        return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlLoginHandler.validateReissue", "Login providePermissionProfile does not match existing request");
    }

    boolean isTokenChange(LoginRequest loginRequest) {
        return !(loginRequest.userNameType() != 3 && loginRequest.userNameType() != 5 || loginRequest.userName().equals(this._loginRequest.userName()) && loginRequest.authenticationExtended().equals(this._loginRequest.authenticationExtended()));
    }

    @Override
    public int readMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, boolean wsbSendClosedRecover, ReactorErrorInfo errorInfo) {
        assert (this._stream == wlStream);
        if (this._watchlist.reactorChannel().enableSessionManagement() ? !$assertionsDisabled && msg.streamId() != this._loginRequestForEDP.streamId() : !$assertionsDisabled && msg.streamId() != this._loginRequest.streamId()) {
            throw new AssertionError();
        }
        int ret = 0;
        switch (msg.msgClass()) {
            case 2: {
                ret = this.readRefreshMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 3: {
                ret = this.readStatusMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 7: {
                ret = this.readGenericMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 6: {
                ret = this.readAckMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            default: {
                ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlLoginHandler.readMsg", "Invalid message class (" + msg.msgClass() + ") received by Watchlist login handler");
            }
        }
        if (this._stream == null) {
            return ret;
        }
        if (ret == 0) {
            switch (wlStream.state().streamState()) {
                case 3: 
                case 4: 
                case 5: {
                    int ret1 = this._watchlist.itemHandler().loginStreamClosed(wlStream.state());
                    int ret2 = this._watchlist.directoryHandler().loginStreamClosed();
                    if (ret1 < 0) {
                        return ret1;
                    }
                    if (ret2 < 0) {
                        return ret2;
                    }
                    if (wlStream.state().streamState() != 4 && wlStream.state().streamState() != 5) break;
                    this._tempWlInteger.value(msg.streamId());
                    WlRequest wlRequest = this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger);
                    this._watchlist.closeWlRequest(wlRequest);
                    wlRequest.returnToPool();
                    this._stream.close();
                    this._stream.returnToPool();
                    this._stream = null;
                    this._loginRequestForEDP = null;
                    break;
                }
                case 1: {
                    if (wlStream.state().dataState() != 1) break;
                    this._watchlist.reactorChannel().resetReconnectTimers();
                    int ret1 = this._watchlist.directoryHandler().loginStreamOpen(errorInfo);
                    int ret2 = this._watchlist.itemHandler().loginStreamOpen(errorInfo);
                    if (ret1 < 0) {
                        return ret1;
                    }
                    if (ret2 >= 0) break;
                    return ret2;
                }
            }
        }
        return ret;
    }

    int readRefreshMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        if (!((RefreshMsg)msg).checkRefreshComplete()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlLoginHandler.readRefreshMsg", "Watchlist doesn't handle multi-part login refresh.");
        }
        if (((RefreshMsg)msg).checkSolicited()) {
            wlStream.responseReceived();
        }
        this._loginRefresh.decode(dIter, msg);
        this._loginRefresh.applyHasAttrib();
        this._loginRefresh.attrib().applyHasSingleOpen();
        this._loginRefresh.attrib().singleOpen(this.supportSingleOpen() ? 1L : 0L);
        this._loginRefresh.attrib().applyHasAllowSuspectData();
        this._loginRefresh.attrib().allowSuspectData(this.supportAllowSuspectData() ? 1L : 0L);
        this._loginRefresh.applyHasFeatures();
        this._loginRefresh.features().applyHasSupportBatchRequests();
        this._loginRefresh.features().supportBatchRequests(1L);
        this._loginRefresh.features().applyHasSupportEnhancedSymbolList();
        this._loginRefresh.features().supportEnhancedSymbolList(1L);
        this._loginRefresh.state().copy(wlStream.state());
        if (this._loginRefresh.state().streamState() == 3) {
            this._loginRefresh.state().streamState(1);
            this._loginRefresh.state().dataState(2);
            return this.callbackUserAndDisconnect("WlLoginHandler.readRefreshMsg", msg, this._loginRefresh, errorInfo);
        }
        this._tempWlInteger.value(msg.streamId());
        int ret = this.callbackUser("WlLoginHandler.readRefreshMsg", msg, this._loginRefresh, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
        if (this._requestCount > 0) {
            --this._requestCount;
        }
        if (this._requestCount > 0 && ret != -1) {
            this._tempMsg.clear();
            this._watchlist.convertRDMToCodecMsg(this._loginRequest, this._tempMsg);
            ret = wlStream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo);
            if (ret == 0) {
                this._requestCount = !this._loginRequest.checkNoRefresh() ? 1 : 0;
            }
        }
        return ret;
    }

    int readStatusMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        this._loginStatus.decode(dIter, msg);
        wlStream.responseReceived();
        if (this._loginStatus.checkHasState()) {
            this._loginStatus.state().copy(wlStream.state());
            if (this._loginStatus.state().streamState() == 3) {
                this._loginStatus.state().streamState(1);
                this._loginStatus.state().dataState(2);
                return this.callbackUserAndDisconnect("WlLoginHandler.readStatusMsg", msg, this._loginStatus, errorInfo);
            }
        }
        this._tempWlInteger.value(msg.streamId());
        return this.callbackUser("WlLoginHandler.readStatusMsg", msg, this._loginStatus, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
    }

    int callbackUserAndDisconnect(String location, Msg msg, LoginMsg loginMsg, ReactorErrorInfo errorInfo) {
        this._tempWlInteger.value(msg.streamId());
        int ret = this.callbackUser(location, msg, loginMsg, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
        if (ret != 0) {
            return ret;
        }
        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, location, "Received login response with Closed/Recover stream state. Disconnecting.");
        return this._watchlist._reactor.disconnect(this._watchlist.reactorChannel(), location, errorInfo);
    }

    int readGenericMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        WlRequest wlRequest = this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger);
        if (Objects.equals(133, msg.containerType())) {
            boolean isRttMessage;
            this._loginRTT.clear();
            boolean bl = isRttMessage = this._loginRTT.decode(dIter, msg) == 0;
            if (isRttMessage) {
                if (this.rttEnabled) {
                    this.submitMsg(wlRequest, msg, this._submitOptions, errorInfo);
                }
                return this._watchlist.reactor().sendAndHandleLoginMsgCallback("WlLoginHandler.readGenericMsg", this._watchlist.reactorChannel(), null, msg, this._loginRTT, wlRequest, errorInfo);
            }
        } else {
            boolean isCCSMessage;
            this._loginCCS.clear();
            boolean bl = isCCSMessage = this._loginCCS.decode(dIter, msg) == 0;
            if (isCCSMessage) {
                return this._watchlist.reactor().sendAndHandleLoginMsgCallback("WlLoginHandler.readGenericMsg", this._watchlist.reactorChannel(), null, msg, this._loginCCS, wlRequest, errorInfo);
            }
        }
        return this._watchlist.reactor().sendAndHandleDefaultMsgCallback("WlLoginHandler.readGenericMsg", this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
    }

    int readAckMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (wlStream.handlePostAck(msg)) {
            this._tempWlInteger.value(msg.streamId());
            ret = msg.domainType() != 1 ? this._watchlist.itemHandler().callbackUser("WlLoginHandler.readAckMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo) : this.callbackUser("WlLoginHandler.readAckMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
        }
        return ret;
    }

    @Override
    public int callbackUser(String location, Msg msg, MsgBase rdmMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int ret = 0;
        ret = this._watchlist.reactor().sendAndHandleLoginMsgCallback(location, this._watchlist.reactorChannel(), null, msg, (LoginMsg)rdmMsg, wlRequest, errorInfo);
        if (ret == -2) {
            ret = this._watchlist.reactor().sendAndHandleDefaultMsgCallback(location, this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
        }
        return ret;
    }

    @Override
    public void addPendingRequest(WlStream wlStream) {
        this._hasPendingRequest = true;
    }

    int dispatch(ReactorErrorInfo errorInfo) {
        if (this._stream != null && this._hasPendingRequest) {
            this._hasPendingRequest = false;
            return this._stream.sendMsgOutOfLoop((Msg)this._stream._requestMsg, this._submitOptions, errorInfo);
        }
        return 0;
    }

    boolean supportSingleOpen() {
        if (this._loginRequest != null && this._loginRequest.checkHasAttrib() && this._loginRequest.attrib().checkHasSingleOpen()) {
            return this._loginRequest.attrib().singleOpen() > 0L;
        }
        if (this._watchlist._role != null && this._watchlist._role._loginRequest != null && this._watchlist._role._loginRequest.attrib() != null) {
            return this._watchlist._role._loginRequest.attrib().singleOpen() > 0L;
        }
        return false;
    }

    boolean supportAllowSuspectData() {
        if (this._loginRequest != null && this._loginRequest.checkHasAttrib() && this._loginRequest.attrib().checkHasAllowSuspectData()) {
            return this._loginRequest.attrib().allowSuspectData() > 0L;
        }
        if (this._watchlist._role != null && this._watchlist._role._loginRequest != null && this._watchlist._role._loginRequest.attrib() != null) {
            return this._watchlist._role._loginRequest.attrib().allowSuspectData() > 0L;
        }
        return false;
    }

    boolean userLoginStreamProvided() {
        if (!this._userloginStreamOpen) {
            return false;
        }
        return this._loginRequest != null || this._watchlist._role._loginRequest != null;
    }

    boolean supportBatchRequests() {
        return true;
    }

    boolean supportEnhancedSymbolList() {
        return true;
    }

    boolean supportOptimizedPauseResume() {
        if (this._loginRefresh != null && this._loginRefresh.features().checkHasSupportOptimizedPauseResume()) {
            return this._loginRefresh.features().supportOptimizedPauseResume() > 0L;
        }
        return false;
    }

    boolean supportViewRequests() {
        if (this._loginRefresh != null && this._loginRefresh.features().checkHasSupportViewRequests()) {
            return this._loginRefresh.features().supportViewRequests() > 0L;
        }
        return false;
    }

    boolean supportPost() {
        if (this._loginRefresh != null && this._loginRefresh.features().checkHasSupportPost()) {
            return this._loginRefresh.features().supportOMMPost() > 0L;
        }
        return false;
    }

    WlStream wlStream() {
        return this._stream;
    }

    void channelDown() {
        int streamId;
        int n = streamId = this._loginRequest != null ? this._loginRequest.streamId() : 0;
        if (this._stream != null) {
            this._stream.channelDown();
            this._hasPendingRequest = false;
            if (this._stream.state().streamState() == 1) {
                this._stream.state().clear();
                this._stream.state().streamState(3);
                this._stream.state().dataState(2);
                this._statusMsg.clear();
                this._statusMsg.msgClass(3);
                this._statusMsg.domainType(1);
                this._statusMsg.streamId(streamId);
                this._statusMsg.applyHasState();
                this._statusMsg.state().streamState(1);
                this._statusMsg.state().dataState(2);
                this._statusMsg.state().code(0);
                this._statusMsg.state().text(this._tempBuffer);
                this._loginStatus.clear();
                this._loginStatus.rdmMsgType(LoginMsgType.STATUS);
                this._loginStatus.streamId(streamId);
                this._loginStatus.applyHasState();
                this._loginStatus.state().streamState(1);
                this._loginStatus.state().dataState(2);
                this._loginStatus.state().code(0);
                this._loginStatus.state().text(this._tempBuffer);
                this._userloginStreamOpen = false;
                this._tempWlInteger.value(this._statusMsg.streamId());
                this.callbackUser("WlLoginHandler.channelDown", (Msg)this._statusMsg, this._loginStatus, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo);
            }
        }
    }

    void sendLoginRequest(boolean noRefresh, ReactorErrorInfo errorInfo) {
        boolean newStream = false;
        boolean newRequest = false;
        this._userloginStreamOpen = true;
        LoginRequest loginRequest = null;
        if (this._watchlist.reactorChannel().enableSessionManagement()) {
            String authToken = this._watchlist.reactorChannel()._loginRequestForEDP.userName().toString();
            if (authToken.isEmpty()) {
                return;
            }
            if (this._loginRequestForEDP == null && this._watchlist.role().rdmLoginRequest() != null) {
                newRequest = true;
                this._loginRequestForEDP = (LoginRequest)LoginMsgFactory.createMsg();
                this._loginRequestForEDP.rdmMsgType(LoginMsgType.REQUEST);
                this._watchlist.reactorChannel()._loginRequestForEDP.copy(this._loginRequestForEDP);
            } else {
                this._loginRequestForEDP.userName().data(authToken);
            }
            loginRequest = this._loginRequestForEDP;
            if (noRefresh) {
                loginRequest.applyNoRefresh();
            }
            if (this._stream == null) {
                newStream = true;
                this._loginRequestForEDP.streamId(this._loginStreamId);
                this._stream = ReactorFactory.createWlStream();
                this._stream.handler(this);
                this._stream.watchlist(this._watchlist);
                this._stream.streamId(this._loginRequestForEDP.streamId());
                this._stream.domainType(this._loginRequestForEDP.domainType());
            }
            this._loginRequest = this._loginRequestForEDP;
        } else {
            if (this._loginRequest == null && this._watchlist.role().rdmLoginRequest() != null) {
                newRequest = true;
                this._loginRequest = (LoginRequest)LoginMsgFactory.createMsg();
                this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
                this._watchlist.role().rdmLoginRequest().copy(this._loginRequest);
                if (this._stream == null) {
                    newStream = true;
                    this._loginRequest.streamId(this._loginStreamId);
                    this._stream = ReactorFactory.createWlStream();
                    this._stream.handler(this);
                    this._stream.watchlist(this._watchlist);
                    this._stream.streamId(this._loginRequest.streamId());
                    this._stream.domainType(this._loginRequest.domainType());
                }
            }
            this._loginRequest.rdmMsgType(LoginMsgType.REQUEST);
            loginRequest = this._loginRequest;
            if (noRefresh) {
                loginRequest.applyNoRefresh();
            }
        }
        if (loginRequest != null && this._stream != null) {
            if (loginRequest.checkPause()) {
                loginRequest.flags(loginRequest.flags() & 0xFFFFFF7F);
            }
            if (!noRefresh && loginRequest.checkNoRefresh()) {
                loginRequest.flags(loginRequest.flags() & 0xFFFFFFBF);
            }
            this._tempMsg.clear();
            this._watchlist.convertRDMToCodecMsg(loginRequest, this._tempMsg);
            if (this._stream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo) >= 0) {
                if (newRequest) {
                    WlRequest wlRequest = ReactorFactory.createWlRequest();
                    this._tempMsg.clear();
                    this._watchlist.convertRDMToCodecMsg(loginRequest, this._tempMsg);
                    wlRequest.requestMsg().clear();
                    this._tempMsg.copy((Msg)wlRequest.requestMsg(), 4095);
                    wlRequest.handler(this);
                    WlInteger wlInteger = ReactorFactory.createWlInteger();
                    wlInteger.value(loginRequest.streamId());
                    wlRequest.tableKey(wlInteger);
                    this._watchlist.streamIdtoWlRequestTable().put(wlInteger, wlRequest);
                }
                if (newStream) {
                    WlInteger wlInteger = ReactorFactory.createWlInteger();
                    wlInteger.value(loginRequest.streamId());
                    this._stream.tableKey(wlInteger);
                    this._watchlist.streamIdtoWlStreamTable().put(wlInteger, this._stream);
                }
                this._requestCount = 1;
            } else {
                if (newRequest) {
                    this._loginRequest = null;
                    this._loginRequestForEDP = null;
                }
                if (newStream) {
                    this._stream.returnToPool();
                    this._stream = null;
                }
            }
        }
    }

    void channelUp(ReactorErrorInfo errorInfo) {
        this.sendLoginRequest(false, errorInfo);
    }

    @Override
    public int requestTimeout(WlStream wlStream, ReactorErrorInfo errorInfo) {
        LoginRequest loginRequest = null;
        loginRequest = this._watchlist.reactorChannel().enableSessionManagement() ? this._loginRequestForEDP : this._loginRequest;
        int streamId = loginRequest != null ? loginRequest.streamId() : 0;
        this._statusMsg.clear();
        this._statusMsg.msgClass(3);
        this._statusMsg.domainType(1);
        this._statusMsg.streamId(streamId);
        this._statusMsg.applyHasState();
        this._statusMsg.state().streamState(1);
        this._statusMsg.state().dataState(2);
        this._statusMsg.state().code(0);
        this._statusMsg.state().text(this._tempBuffer);
        this._loginStatus.clear();
        this._loginStatus.rdmMsgType(LoginMsgType.STATUS);
        this._loginStatus.streamId(streamId);
        this._loginStatus.applyHasState();
        this._loginStatus.state().streamState(1);
        this._loginStatus.state().dataState(2);
        this._loginStatus.state().code(0);
        this._loginStatus.state().text(this._tempBuffer);
        this._tempWlInteger.value(this._statusMsg.streamId());
        this.callbackUser("WlLoginHandler.channelDown", (Msg)this._statusMsg, this._loginStatus, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo);
        this._tempMsg.clear();
        this._watchlist.convertRDMToCodecMsg(loginRequest, this._tempMsg);
        return wlStream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo);
    }

    void clear() {
        this._stream = null;
        this._loginRequest = null;
        this._loginRequestForEDP = null;
        this._tempLoginRequest.clear();
        this._tempLoginRequest.rdmMsgType(LoginMsgType.REQUEST);
        this._errorInfo.clear();
        this._eIter.clear();
        this._dIter.clear();
        this._loginRefresh.clear();
        this._loginRefresh.rdmMsgType(LoginMsgType.REFRESH);
        this._loginStatus.clear();
        this._loginStatus.rdmMsgType(LoginMsgType.STATUS);
        this._statusMsg.clear();
        this._statusMsg.msgClass(3);
        this._statusMsg.domainType(1);
        this._tempBuffer.clear();
        this._tempBuffer.data("");
        this._tempMsg.clear();
        this._errorInfo.clear();
        this._awaitingResumeAll = false;
        this._requestCount = 0;
        this._hasPendingRequest = false;
        this._loginRTT.clear();
        this.rttEnabled = false;
        this._loginCCS.clear();
    }
}

