/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.transport.ConnectOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorOAuthCredentialRenewalOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorRestProxyOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceDiscoveryOptions;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.net.URIBuilder;

class RestConnectOptions {
    static final int DEFAULT_HTTPS_PORT = 443;
    static final int DEFAULT_HTTP_PORT = 80;
    static final String DEFAULT_SCHEME = "https";
    static final String API_GATEWAY_HOST = "api.refinitiv.com";
    static final String TOKEN_SERVICE_PATH = "/auth/oauth2/v1/token";
    private int _transport;
    private int _dataFormat;
    private RestResultClosure _resultClosure;
    private String _proxyHost;
    private int _proxyPort;
    private String _proxyUserName;
    private String _proxyPassword;
    private String _proxyDomain;
    private String _proxyLocalHostName;
    private String _proxyKrb5ConfigFile;
    private ReactorOptions _reactorOptions;
    private Buffer _tokenServiceURLV1 = CodecFactory.createBuffer();
    private Buffer _tokenServiceURLV2 = CodecFactory.createBuffer();
    private HttpHost _tokenServiceHost;
    private HttpHost _tokenServiceHostV2;
    private boolean _authRedirect = false;
    private String _authRedirectLocation = null;
    private boolean _discoveryRedirect = false;
    private String _discoveryRedirectLocation = null;

    public RestConnectOptions(ReactorOptions options) {
        this.clear();
        this._reactorOptions = options;
        if (options.tokenServiceURL() != null) {
            this.tokenServiceURLV1(options.tokenServiceURL());
        }
        if (options.tokenServiceURL_V2() != null) {
            this.tokenServiceURLV2(options.tokenServiceURL_V2());
        }
    }

    public void clear() {
        this._resultClosure = null;
        this._transport = 1;
        this._dataFormat = 1;
        this._proxyHost = null;
        this._proxyPort = -1;
        this._proxyUserName = null;
        this._proxyPassword = null;
        this._proxyDomain = null;
        this._proxyLocalHostName = "localhost";
        this._proxyKrb5ConfigFile = "krb5.conf";
        this._tokenServiceURLV1.clear();
        this._tokenServiceHost = null;
        this._authRedirect = false;
        this._authRedirectLocation = null;
        this._discoveryRedirect = false;
        this._discoveryRedirectLocation = null;
    }

    static final int convertToPortNumber(Buffer proxyPort) {
        int port = -1;
        if (proxyPort.length() > 0) {
            try {
                port = Integer.parseInt(proxyPort.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return port;
    }

    void applyServiceDiscoveryOptions(ReactorServiceDiscoveryOptions options, ReactorRestProxyOptions restProxyOptions) {
        this.dataFormat(options.dataFormat());
        this.transport(options.transport());
        if (restProxyOptions.proxyHostName() != null && restProxyOptions.proxyHostName().length() > 0 && restProxyOptions.proxyPort() != null && restProxyOptions.proxyPort().length() > 0) {
            this.proxyHost(restProxyOptions.proxyHostName().toString());
            this.proxyPort(RestConnectOptions.convertToPortNumber(restProxyOptions.proxyPort()));
            if (restProxyOptions.proxyUserName() != null && restProxyOptions.proxyUserName().length() > 0) {
                this.proxyUserName(restProxyOptions.proxyUserName().toString());
            }
            if (restProxyOptions.proxyPassword() != null && restProxyOptions.proxyPassword().length() > 0) {
                this.proxyPassword(restProxyOptions.proxyPassword().toString());
            }
            if (restProxyOptions.proxyDomain() != null && restProxyOptions.proxyDomain().length() > 0) {
                this.proxyDomain(restProxyOptions.proxyDomain().toString());
            }
            if (restProxyOptions.proxyLocalHostName() != null && restProxyOptions.proxyLocalHostName().length() > 0) {
                this.proxyLocalHostName(restProxyOptions.proxyLocalHostName().toString());
            }
            if (restProxyOptions.proxyKrb5ConfigFile() != null && restProxyOptions.proxyKrb5ConfigFile().length() > 0) {
                this.proxyKRB5ConfigFile(restProxyOptions.proxyKrb5ConfigFile().toString());
            }
        } else {
            this.proxyHost(options.proxyHostName().toString());
            this.proxyPort(RestConnectOptions.convertToPortNumber(options.proxyPort()));
            this.proxyUserName(options.proxyUserName().toString());
            this.proxyPassword(options.proxyPassword().toString());
            this.proxyDomain(options.proxyDomain().toString());
            this.proxyLocalHostName(options.proxyLocalHostName().toString());
            this.proxyKRB5ConfigFile(options.proxyKRB5ConfigFile().toString());
        }
    }

    void applyProxyInfo(ConnectOptions connectOptions, ReactorRestProxyOptions restProxyOptions) {
        if (connectOptions.tunnelingInfo() != null) {
            this.proxyHost(connectOptions.tunnelingInfo().HTTPproxyHostName());
            this.proxyPort(connectOptions.tunnelingInfo().HTTPproxyPort());
        }
        if (connectOptions.credentialsInfo() != null) {
            this.proxyUserName(connectOptions.credentialsInfo().HTTPproxyUsername());
            this.proxyPassword(connectOptions.credentialsInfo().HTTPproxyPasswd());
            this.proxyDomain(connectOptions.credentialsInfo().HTTPproxyDomain());
            this.proxyLocalHostName(connectOptions.credentialsInfo().HTTPproxyLocalHostname());
            this.proxyKRB5ConfigFile(connectOptions.credentialsInfo().HTTPproxyKRB5configFile());
        }
        this.applyProxyInfo(restProxyOptions);
    }

    void applyProxyInfo(ReactorRestProxyOptions restProxyOptions) {
        if (restProxyOptions.proxyHostName() != null && restProxyOptions.proxyHostName().length() > 0 && restProxyOptions.proxyPort() != null && restProxyOptions.proxyPort().length() > 0) {
            this.proxyHost(restProxyOptions.proxyHostName().toString());
            this.proxyPort(RestConnectOptions.convertToPortNumber(restProxyOptions.proxyPort()));
            if (restProxyOptions.proxyUserName() != null && restProxyOptions.proxyUserName().length() > 0) {
                this.proxyUserName(restProxyOptions.proxyUserName().toString());
            }
            if (restProxyOptions.proxyPassword() != null && restProxyOptions.proxyPassword().length() > 0) {
                this.proxyPassword(restProxyOptions.proxyPassword().toString());
            }
            if (restProxyOptions.proxyDomain() != null && restProxyOptions.proxyDomain().length() > 0) {
                this.proxyDomain(restProxyOptions.proxyDomain().toString());
            }
            if (restProxyOptions.proxyLocalHostName() != null && restProxyOptions.proxyLocalHostName().length() > 0) {
                this.proxyLocalHostName(restProxyOptions.proxyLocalHostName().toString());
            }
            if (restProxyOptions.proxyKrb5ConfigFile() != null && restProxyOptions.proxyKrb5ConfigFile().length() > 0) {
                this.proxyKRB5ConfigFile(restProxyOptions.proxyKrb5ConfigFile().toString());
            }
        }
    }

    void applyProxyInfo(ReactorOAuthCredentialRenewalOptions renewalOptions) {
        if (renewalOptions.proxyHostName() != null && renewalOptions.proxyHostName().length() > 0 && renewalOptions.proxyPort() != null && renewalOptions.proxyPort().length() > 0) {
            this.proxyHost(renewalOptions.proxyHostName().toString());
            this.proxyPort(RestConnectOptions.convertToPortNumber(renewalOptions.proxyPort()));
            if (renewalOptions.proxyUserName() != null && renewalOptions.proxyUserName().length() > 0) {
                this.proxyUserName(renewalOptions.proxyUserName().toString());
            }
            if (renewalOptions.proxyPassword() != null && renewalOptions.proxyPassword().length() > 0) {
                this.proxyPassword(renewalOptions.proxyPassword().toString());
            }
            if (renewalOptions.proxyDomain() != null && renewalOptions.proxyDomain().length() > 0) {
                this.proxyDomain(renewalOptions.proxyDomain().toString());
            }
            if (renewalOptions.proxyLocalHostName() != null && renewalOptions.proxyLocalHostName().length() > 0) {
                this.proxyLocalHostName(renewalOptions.proxyLocalHostName().toString());
            }
            if (renewalOptions.proxyKRB5ConfigFile() != null && renewalOptions.proxyKRB5ConfigFile().length() > 0) {
                this.proxyKRB5ConfigFile(renewalOptions.proxyKRB5ConfigFile().toString());
            }
        }
    }

    public void restResultClosure(RestResultClosure resultClosure) {
        this._resultClosure = resultClosure;
    }

    public RestResultClosure restResultClosure() {
        return this._resultClosure;
    }

    public String tokenServiceURLV1() {
        return this._tokenServiceURLV1.toString();
    }

    public String tokenServiceURLV2() {
        return this._tokenServiceURLV2.toString();
    }

    int tokenServiceURLV1(Buffer tokenServiceURL) {
        this._tokenServiceURLV1.data(tokenServiceURL.data(), tokenServiceURL.position(), tokenServiceURL.length());
        if (tokenServiceURL == null || tokenServiceURL.length() == 0) {
            return -5;
        }
        try {
            URI uri = new URIBuilder(tokenServiceURL.toString()).build();
            HttpHost tokenServiceHost = URIUtils.extractHost((URI)uri);
            if (tokenServiceHost == null) {
                return -5;
            }
            this._tokenServiceHost = tokenServiceHost;
            if (this._tokenServiceHost.getPort() == -1) {
                this._tokenServiceHost = this._tokenServiceHost.getSchemeName().equals(DEFAULT_SCHEME) ? new HttpHost(this._tokenServiceHost.getSchemeName(), this._tokenServiceHost.getHostName(), 443) : new HttpHost(this._tokenServiceHost.getSchemeName(), this._tokenServiceHost.getHostName(), 80);
            }
        }
        catch (URISyntaxException e) {
            return -5;
        }
        return 0;
    }

    int tokenServiceURLV2(Buffer tokenServiceURL) {
        this._tokenServiceURLV2.data(tokenServiceURL.data(), tokenServiceURL.position(), tokenServiceURL.length());
        if (tokenServiceURL == null || tokenServiceURL.length() == 0) {
            return -5;
        }
        try {
            URI uri = new URIBuilder(tokenServiceURL.toString()).build();
            HttpHost tokenServiceHost = URIUtils.extractHost((URI)uri);
            if (tokenServiceHost == null) {
                return -5;
            }
            this._tokenServiceHostV2 = tokenServiceHost;
            if (this._tokenServiceHostV2.getPort() == -1) {
                this._tokenServiceHostV2 = this._tokenServiceHostV2.getSchemeName().equals(DEFAULT_SCHEME) ? new HttpHost(this._tokenServiceHostV2.getSchemeName(), this._tokenServiceHostV2.getHostName(), 443) : new HttpHost(this._tokenServiceHostV2.getSchemeName(), this._tokenServiceHostV2.getHostName(), 80);
            }
        }
        catch (URISyntaxException e) {
            return -5;
        }
        return 0;
    }

    public String serviceDiscoveryURL() {
        return this._reactorOptions.serviceDiscoveryURL().toString();
    }

    public HttpHost tokenServiceHost() {
        return this._tokenServiceHost;
    }

    public HttpHost tokenServiceHostV2() {
        return this._tokenServiceHostV2;
    }

    public HttpHost serviceDiscoveryHost() {
        return this._reactorOptions.serviceDiscoveryHost();
    }

    public String toString() {
        return "RestConnectOptions\n\ttokenServiceURL: " + this.tokenServiceURLV1() + "\n\tserviceDiscoveryURL: " + this.serviceDiscoveryURL() + "\n\tuserSpecObject: " + this._resultClosure + "\n";
    }

    public int copy(RestConnectOptions destOpts) {
        if (destOpts == null) {
            return -1;
        }
        destOpts._reactorOptions = this._reactorOptions;
        destOpts._resultClosure = this._resultClosure;
        return 0;
    }

    void dataFormat(int dataFormat) {
        this._dataFormat = dataFormat;
    }

    void transport(int transport) {
        this._transport = transport;
    }

    int dataFormat() {
        return this._dataFormat;
    }

    int transport() {
        return this._transport;
    }

    void proxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    String proxyHost() {
        return this._proxyHost;
    }

    void proxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    int proxyPort() {
        return this._proxyPort;
    }

    void proxyUserName(String proxyUserName) {
        this._proxyUserName = proxyUserName;
    }

    String proxyUserName() {
        return this._proxyUserName;
    }

    void proxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    String proxyPassword() {
        return this._proxyPassword;
    }

    void proxyDomain(String proxyDomain) {
        this._proxyDomain = proxyDomain;
    }

    String proxyDomain() {
        return this._proxyDomain;
    }

    void proxyLocalHostName(String proxyLocalHostName) {
        this._proxyLocalHostName = proxyLocalHostName;
    }

    String proxyLocalHostName() {
        return this._proxyLocalHostName;
    }

    void proxyKRB5ConfigFile(String proxyKrb5ConfigFile) {
        this._proxyKrb5ConfigFile = proxyKrb5ConfigFile;
    }

    String proxyKRB5ConfigFile() {
        return this._proxyKrb5ConfigFile;
    }

    public boolean authRedirect() {
        return this._authRedirect;
    }

    public void authRedirect(boolean value) {
        this._authRedirect = value;
    }

    public String authRedirectLocation() {
        return this._authRedirectLocation;
    }

    public void authRedirectLocation(String value) {
        this._authRedirectLocation = value;
    }

    public boolean discoveryRedirect() {
        return this._discoveryRedirect;
    }

    public void discoveryRedirect(boolean value) {
        this._discoveryRedirect = value;
    }

    public String discoveryRedirectLocation() {
        return this._discoveryRedirectLocation;
    }

    public void discoveryRedirectLocation(String value) {
        this._discoveryRedirectLocation = value;
    }

    public ReactorOptions reactorOptions() {
        return this._reactorOptions;
    }
}

