/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointEventCallback;
import java.nio.ByteBuffer;

public class ReactorServiceDiscoveryOptions {
    private Buffer _username = CodecFactory.createBuffer();
    private Buffer _password = CodecFactory.createBuffer();
    private Buffer _clientId = CodecFactory.createBuffer();
    private Buffer _clientSecret = CodecFactory.createBuffer();
    private Buffer _audience = CodecFactory.createBuffer();
    private Buffer _clientJWK = CodecFactory.createBuffer();
    private Buffer _tokenScope = CodecFactory.createBuffer();
    private int _transport = 0;
    private int _dataFormat = 0;
    private ReactorServiceEndpointEventCallback _reactorServiceEndpointEventCallback = null;
    private Object _userSpecObject = null;
    private Buffer _proxyHostName = CodecFactory.createBuffer();
    private Buffer _proxyPort = CodecFactory.createBuffer();
    private Buffer _proxyUserName = CodecFactory.createBuffer();
    private Buffer _proxyPassword = CodecFactory.createBuffer();
    private Buffer _proxyDomain = CodecFactory.createBuffer();
    private Buffer _proxyLocalHostName = CodecFactory.createBuffer();
    private Buffer _proxyKrb5ConfigFile = CodecFactory.createBuffer();
    private boolean _takeExclusiveSignOnControl = true;

    ReactorServiceDiscoveryOptions() {
        this.clear();
    }

    public void clear() {
        this._username.clear();
        this._password.clear();
        this._clientId.clear();
        this._clientSecret.clear();
        this._clientJWK.clear();
        this._audience.data("https://login.ciam.refinitiv.com/as/token.oauth2");
        this._tokenScope.data("trapi.streaming.pricing.read");
        this._transport = 0;
        this._dataFormat = 0;
        this._reactorServiceEndpointEventCallback = null;
        this._userSpecObject = null;
        this._proxyHostName.clear();
        this._proxyPort.clear();
        this._proxyUserName.clear();
        this._proxyPassword.clear();
        this._proxyDomain.clear();
        this._proxyLocalHostName.clear();
        this._proxyKrb5ConfigFile.clear();
        this._takeExclusiveSignOnControl = true;
    }

    public int copy(ReactorServiceDiscoveryOptions dest) {
        if (dest == null) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(this._username.length());
        this._username.copy(byteBuffer);
        dest.userName().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._password.length());
        this._password.copy(byteBuffer);
        dest.password().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._clientId.length());
        this._clientId.copy(byteBuffer);
        dest.clientId().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._clientSecret.length());
        this._clientSecret.copy(byteBuffer);
        dest.clientSecret().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._audience.length());
        this._audience.copy(byteBuffer);
        dest.audience().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._clientJWK.length());
        this._clientJWK.copy(byteBuffer);
        dest.clientJWK().data(byteBuffer);
        byteBuffer = ByteBuffer.allocate(this._tokenScope.length());
        this._tokenScope.copy(byteBuffer);
        dest.tokenScope().data(byteBuffer);
        dest._transport = this._transport;
        dest._dataFormat = this._dataFormat;
        dest._userSpecObject = this._userSpecObject;
        dest._reactorServiceEndpointEventCallback = this._reactorServiceEndpointEventCallback;
        return 0;
    }

    public void userName(Buffer userName) {
        assert (userName != null) : "userName can not be null";
        this.userName().data(userName.data(), userName.position(), userName.length());
    }

    public Buffer userName() {
        return this._username;
    }

    public void password(Buffer password) {
        assert (password != null) : "password can not be null";
        this.password().data(password.data(), password.position(), password.length());
    }

    public Buffer password() {
        return this._password;
    }

    public void clientId(Buffer clientId) {
        assert (clientId != null) : "clientId can not be null";
        this.clientId().data(clientId.data(), clientId.position(), clientId.length());
    }

    public Buffer clientId() {
        return this._clientId;
    }

    public void clientSecret(Buffer clientSecret) {
        assert (clientSecret != null) : "clientSecret can not be null";
        this.clientSecret().data(clientSecret.data(), clientSecret.position(), clientSecret.length());
    }

    public Buffer clientSecret() {
        return this._clientSecret;
    }

    public void clientJWK(Buffer clientJWK) {
        assert (clientJWK != null) : "clientSecret can not be null";
        this.clientJWK().data(clientJWK.data(), clientJWK.position(), clientJWK.length());
    }

    public Buffer clientJWK() {
        return this._clientJWK;
    }

    public void audience(Buffer audience) {
        assert (audience != null) : "clientSecret can not be null";
        this.audience().data(audience.data(), audience.position(), audience.length());
    }

    public Buffer audience() {
        return this._audience;
    }

    public void tokenScope(Buffer tokenScope) {
        assert (tokenScope != null) : "tokenScope can not be null";
        this.tokenScope().data(tokenScope.data(), tokenScope.position(), tokenScope.length());
    }

    public Buffer tokenScope() {
        return this._tokenScope;
    }

    public void transport(int transport) {
        this._transport = transport;
    }

    public int transport() {
        return this._transport;
    }

    public void dataFormat(int dataFormat) {
        this._dataFormat = dataFormat;
    }

    public int dataFormat() {
        return this._dataFormat;
    }

    public void proxyHostName(Buffer proxyHostName) {
        assert (proxyHostName != null) : "proxyHostName can not be null";
        this.proxyHostName().data(proxyHostName.data(), proxyHostName.position(), proxyHostName.length());
    }

    public Buffer proxyHostName() {
        return this._proxyHostName;
    }

    public void proxyPort(Buffer proxyPort) {
        this._proxyPort = proxyPort;
    }

    public Buffer proxyPort() {
        return this._proxyPort;
    }

    public void proxyUserName(Buffer proxyUserName) {
        assert (proxyUserName != null) : "proxyUserName can not be null";
        this.proxyUserName().data(proxyUserName.data(), proxyUserName.position(), proxyUserName.length());
    }

    public Buffer proxyUserName() {
        return this._proxyUserName;
    }

    public void proxyPassword(Buffer proxyPassword) {
        assert (proxyPassword != null) : "proxyPassword can not be null";
        this.proxyPassword().data(proxyPassword.data(), proxyPassword.position(), proxyPassword.length());
    }

    public Buffer proxyPassword() {
        return this._proxyPassword;
    }

    public void proxyDomain(Buffer proxyDomain) {
        assert (proxyDomain != null) : "proxyDomain can not be null";
        this.proxyDomain().data(proxyDomain.data(), proxyDomain.position(), proxyDomain.length());
    }

    public Buffer proxyDomain() {
        return this._proxyDomain;
    }

    public void proxyLocalHostName(Buffer proxyLocalHostName) {
        assert (proxyLocalHostName != null) : "proxyLocalHostName can not be null";
        this.proxyLocalHostName().data(proxyLocalHostName.data(), proxyLocalHostName.position(), proxyLocalHostName.length());
    }

    public Buffer proxyLocalHostName() {
        return this._proxyLocalHostName;
    }

    public void proxyKRB5ConfigFile(Buffer proxyKRB5ConfigFile) {
        assert (proxyKRB5ConfigFile != null) : "proxyKRB5ConfigFile can not be null";
        this.proxyKRB5ConfigFile().data(proxyKRB5ConfigFile.data(), proxyKRB5ConfigFile.position(), proxyKRB5ConfigFile.length());
    }

    public Buffer proxyKRB5ConfigFile() {
        return this._proxyKrb5ConfigFile;
    }

    public int reactorServiceEndpointEventCallback(ReactorServiceEndpointEventCallback callback) {
        if (callback == null) {
            return -5;
        }
        this._reactorServiceEndpointEventCallback = callback;
        return 0;
    }

    public ReactorServiceEndpointEventCallback reactorServiceEndpointEventCallback() {
        return this._reactorServiceEndpointEventCallback;
    }

    public int userSpecObj(Object userSpecObj) {
        if (userSpecObj == null) {
            return -5;
        }
        this._userSpecObject = userSpecObj;
        return 0;
    }

    public Object userSpecObject() {
        return this._userSpecObject;
    }

    public boolean takeExclusiveSignOnControl() {
        return this._takeExclusiveSignOnControl;
    }

    public void takeExclusiveSignOnControl(boolean takeExclusiveSignOnControl) {
        this._takeExclusiveSignOnControl = takeExclusiveSignOnControl;
    }
}

