/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.valueadd.reactor.ReactorDebugger;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

class ReactorDebuggerImpl
implements ReactorDebugger {
    private static final int SB_START_CAPACITY = 512;
    private OutputStream _stream;
    private int _numOfCloseCalls;
    private int _numOfDispatchCalls;
    private SimpleDateFormat _formatter = new SimpleDateFormat("HH:mm:ss.SSS");
    private boolean _streamProvided;
    private StringBuilder sb = new StringBuilder(512);
    private int _capacity;
    private boolean _noLimitSet;

    ReactorDebuggerImpl(OutputStream outputStream, int streamCapacity) {
        if (outputStream != null) {
            this._stream = outputStream;
            this._streamProvided = true;
        } else {
            this._noLimitSet = streamCapacity == -1;
            this._capacity = Math.max(65535, streamCapacity);
            this._stream = new ByteArrayOutputStream(this._capacity);
        }
    }

    ReactorDebuggerImpl(int streamCapacity) {
        this._noLimitSet = streamCapacity == -1;
        this._capacity = Math.max(65535, streamCapacity);
        this._stream = new ByteArrayOutputStream(this._capacity);
    }

    ReactorDebuggerImpl(OutputStream outputStream) {
        if (outputStream != null) {
            this._stream = outputStream;
            this._streamProvided = true;
        } else {
            this._capacity = 65535;
            this._stream = new ByteArrayOutputStream(65535);
        }
    }

    @Override
    public synchronized void writeDebugInfo(String msg, Object ... args) {
        try {
            this.sb.delete(0, this.sb.length());
            this.sb.append('[');
            this.sb.append(this._formatter.format(new Date()));
            this.sb.append(" : ");
            this.sb.append(String.format(msg, args));
            byte[] bytes = this.sb.toString().getBytes();
            if (this._streamProvided || this._noLimitSet || bytes.length + ((ByteArrayOutputStream)this._stream).size() <= this._capacity) {
                this._stream.write(bytes);
                this._stream.flush();
            }
        }
        catch (Exception e) {
            System.out.println("Error writing debug to OutputStream: " + e.getMessage());
        }
    }

    @Override
    public synchronized void incNumOfCloseCalls() {
        ++this._numOfCloseCalls;
    }

    @Override
    public synchronized int getNumOfCloseCalls() {
        return this._numOfCloseCalls;
    }

    @Override
    public synchronized void incNumOfDispatchCalls() {
        ++this._numOfDispatchCalls;
    }

    @Override
    public synchronized int getNumOfDispatchCalls() {
        return this._numOfDispatchCalls;
    }

    @Override
    public OutputStream getOutputStream() {
        return this._stream;
    }

    @Override
    public synchronized byte[] toByteArray() {
        if (this._streamProvided && !(this._stream instanceof ByteArrayOutputStream)) {
            return null;
        }
        ByteArrayOutputStream byteStream = (ByteArrayOutputStream)this._stream;
        byte[] result = byteStream.toByteArray();
        byteStream.reset();
        return result;
    }
}

