/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.Codec;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.transport.Channel;
import com.refinitiv.eta.transport.ConnectOptions;
import com.refinitiv.eta.transport.Error;
import com.refinitiv.eta.transport.Server;
import com.refinitiv.eta.transport.Transport;
import com.refinitiv.eta.transport.TransportBuffer;
import com.refinitiv.eta.transport.TransportFactory;
import com.refinitiv.eta.valueadd.common.VaDoubleLinkList;
import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.ConsumerStatusService;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryConsumerStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginConsumerConnectionStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.login.LoginRequest;
import com.refinitiv.eta.valueadd.reactor.ClassOfService;
import com.refinitiv.eta.valueadd.reactor.ConnectOptionsInfo;
import com.refinitiv.eta.valueadd.reactor.ConsumerRole;
import com.refinitiv.eta.valueadd.reactor.NIProviderRole;
import com.refinitiv.eta.valueadd.reactor.PingHandler;
import com.refinitiv.eta.valueadd.reactor.ProviderRole;
import com.refinitiv.eta.valueadd.reactor.Reactor;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenEventCallback;
import com.refinitiv.eta.valueadd.reactor.ReactorAuthTokenInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorChannelStats;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorConnectOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorDebugger;
import com.refinitiv.eta.valueadd.reactor.ReactorDispatchOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorPackedBuffer;
import com.refinitiv.eta.valueadd.reactor.ReactorPerServiceBasedOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorPreferredHostOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorRole;
import com.refinitiv.eta.valueadd.reactor.ReactorServiceEndpointInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorTokenSession;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWSRecoveryMsgInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyChannelInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyEvent;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyGroupImpl;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyServerInfo;
import com.refinitiv.eta.valueadd.reactor.RestConnectOptions;
import com.refinitiv.eta.valueadd.reactor.RestResultClosure;
import com.refinitiv.eta.valueadd.reactor.TunnelStream;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamAcceptOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamManager;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamOpenOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRejectOptions;
import com.refinitiv.eta.valueadd.reactor.TunnelStreamRequestEvent;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WorkerEvent;
import com.refinitiv.eta.valueadd.reactor.WorkerEventTypes;
import java.nio.channels.SelectableChannel;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import org.quartz.CronExpression;

public class ReactorChannel
extends VaNode {
    private Reactor _reactor = null;
    private ReactorRole _role = null;
    private SelectableChannel _selectableChannel = null;
    private SelectableChannel _oldSelectableChannel = null;
    private Channel _channel = null;
    private Channel _preferredHostChannel = null;
    private Server _server = null;
    private Object _userSpecObj = null;
    private StringBuilder _stringBuilder = new StringBuilder();
    private int _initializationTimeout = 0;
    private long _initializationEndTimeMs = 0L;
    private boolean _flushRequested = false;
    private boolean _flushAgain = false;
    private int _reactorChannelType = 0;
    private ReactorWarmStandbyChannelInfo _warmStandbyChInfo = new ReactorWarmStandbyChannelInfo();
    Error _error = TransportFactory.createError();
    private long _tunnelStreamManagerNextDispatchTime = 0L;
    private boolean _hasTunnelStreamManagerNextDispatchTime = false;
    private PingHandler _pingHandler = new PingHandler();
    private boolean _sendPingMessage = false;
    private final int NO_RECONNECT_LIMIT = -1;
    ReactorConnectOptions _reactorConnectOptions;
    private ReactorConnectInfo _currentConnectInfo;
    private ConnectOptionsInfo _currentConnectOptionsInfo;
    int _reconnectAttempts;
    private int _reconnectDelay;
    private long _nextRecoveryTime;
    int _listIndex;
    List<ConnectOptionsInfo> _connectOptionsInfoList = new ArrayList<ConnectOptionsInfo>();
    private TunnelStreamManager _tunnelStreamManager = new TunnelStreamManager();
    private HashMap<WlInteger, TunnelStream> _streamIdtoTunnelStreamTable = new HashMap();
    private Msg _tunnelStreamRespMsg = CodecFactory.createMsg();
    private ReactorSubmitOptions _reactorSubmitOptions = ReactorFactory.createReactorSubmitOptions();
    private ReactorChannelInfo _reactorChannelInfo = ReactorFactory.createReactorChannelInfo();
    private ClassOfService _defaultClassOfService = ReactorFactory.createClassOfService();
    private TunnelStreamRejectOptions _tunnelStreamRejectOptions = ReactorFactory.createTunnelStreamRejectOptions();
    private Watchlist _watchlist;
    ReactorWarmStandbyHandler warmStandByHandlerImpl;
    boolean isActiveServer;
    int standByServerListIndex = -1;
    int standByGroupListIndex = -1;
    boolean isStartingServerConfig;
    long lastSubmitOptionsTime;
    Queue<ReactorWSRecoveryMsgInfo> _watchlistRecoveryMsgList = new LinkedList<ReactorWSRecoveryMsgInfo>();
    DirectoryMsg _wsbDirectoryUpdate = null;
    LoginConsumerConnectionStatus _loginConsumerStatus = (LoginConsumerConnectionStatus)LoginMsgFactory.createMsg();
    DirectoryConsumerStatus _directoryConsumerStatus = (DirectoryConsumerStatus)DirectoryMsgFactory.createMsg();
    ConsumerStatusService _serviceConsumerStatus = DirectoryMsgFactory.createConsumerStatusService();
    boolean sendReqFromQueue = false;
    ReactorPreferredHostOptions _preferredHostOptions;
    ReactorPreferredHostOptions _preferredHostOptionsOriginal = this._preferredHostOptions = ReactorFactory.createReactorPreferredHostOptions();
    ReactorPreferredHostOptions _preferredHostOptionsIoctl;
    boolean _switchingToPreferredHost = false;
    boolean _switchingToPreferredWSBGroup = false;
    boolean _hitEndOfWSBGroups = false;
    boolean _checkedPreferredHostInChannelList_WSBEnabled = false;
    boolean _checkedPreferredHostInChannelList = false;
    boolean _phForcingChannelDown = false;
    boolean _phForcingChannelDown_isStartingActive = false;
    CronExpression _cronExpression;
    CronExpression _cronExpressionIoctl;
    Date _cronCurrentTime;
    Date _cronNextTime;
    ReentrantLock _preferredHostLock = new ReentrantLock();
    long _nextReconnectTimeMs;
    boolean _haveAttemptedFirstConnectionListEntry;
    boolean _haveAttemptedFirstConnection;
    boolean _reconnectImmedietlyToPH;
    boolean _ignoreClosedStandbyCount;
    boolean _queueRequestsForDiscovery;
    boolean _phSwitchingFromChannelListToWSB;
    boolean _phSwitchingFromWSBToChannelList;
    ReactorConnectInfo _phTempReactorConnectInfo;
    ConnectOptionsInfo _phTempConnectOptionsInfo;
    Object _phTempUserSpecObj;
    ReactorConnectOptions _phTempReactorConnectOptions;
    boolean _preferredHostTimersStartedByChannelUp = false;
    WorkerEvent _currentPHTimerEvent = null;
    boolean _phResetPHIndexForRecovery = false;
    Channel oldPHStartingChannel;
    Buffer userName;
    int flags;
    int userNameType;
    boolean isClosedAckSent = false;
    State _state = State.UNKNOWN;
    private ReactorChannel _reactorChannelNext;
    private ReactorChannel _reactorChannelPrev;
    private ReactorErrorInfo _errorInfoEDP = ReactorFactory.createReactorErrorInfo();
    LoginRequest _loginRequestForEDP;
    private RestConnectOptions _restConnectOptions;
    private ReactorTokenSession _tokenSession;
    private List<ReactorServiceEndpointInfo> _reactorServiceEndpointInfoList = new ArrayList<ReactorServiceEndpointInfo>();
    static final ReactorChannelLink REACTOR_CHANNEL_LINK = new ReactorChannelLink();
    private SessionMgntState _sessionMgntState = SessionMgntState.UNKNOWN;

    public State state() {
        return this._state;
    }

    void state(State state) {
        this._state = state;
    }

    public SessionMgntState sessionMgntState() {
        return this._sessionMgntState;
    }

    public void sessionMgntState(SessionMgntState sessionMgntState) {
        this._sessionMgntState = sessionMgntState;
    }

    void tokenSession(ReactorTokenSession tokenSession) {
        this._tokenSession = tokenSession;
        if (tokenSession != null) {
            this._tokenSession.addReactorChannel(this);
        }
    }

    ReactorTokenSession tokenSession() {
        return this._tokenSession;
    }

    void copyEDPErrorInfo(ReactorErrorInfo errorInfo) {
        this._errorInfoEDP.code(errorInfo.code());
        this._errorInfoEDP.location(errorInfo.location());
        this._errorInfoEDP.error().errorId(errorInfo.error().errorId());
        this._errorInfoEDP.error().sysError(errorInfo.error().sysError());
        this._errorInfoEDP.error().text(errorInfo.error().text());
    }

    ReactorErrorInfo getEDPErrorInfo() {
        return this._errorInfoEDP;
    }

    RestConnectOptions restConnectOptions() {
        if (this._restConnectOptions == null) {
            this._restConnectOptions = new RestConnectOptions(this._reactor._reactorOptions);
            this._restConnectOptions.restResultClosure(new RestResultClosure(this._reactor._restClient, this));
        }
        ReactorConnectInfo reactorConnectInfo = this._currentConnectInfo;
        this._restConnectOptions.proxyHost(reactorConnectInfo.connectOptions().tunnelingInfo().HTTPproxyHostName());
        this._restConnectOptions.proxyPort(reactorConnectInfo.connectOptions().tunnelingInfo().HTTPproxyPort());
        this._restConnectOptions.proxyUserName(reactorConnectInfo.connectOptions().credentialsInfo().HTTPproxyUsername());
        this._restConnectOptions.proxyPassword(reactorConnectInfo.connectOptions().credentialsInfo().HTTPproxyPasswd());
        this._restConnectOptions.proxyDomain(reactorConnectInfo.connectOptions().credentialsInfo().HTTPproxyDomain());
        this._restConnectOptions.proxyLocalHostName(reactorConnectInfo.connectOptions().credentialsInfo().HTTPproxyLocalHostname());
        this._restConnectOptions.proxyKRB5ConfigFile(reactorConnectInfo.connectOptions().credentialsInfo().HTTPproxyKRB5configFile());
        if (this._reactor._reactorOptions.restProxyOptions() != null && this._reactor._reactorOptions.restProxyOptions().proxyHostName() != null && this._reactor._reactorOptions.restProxyOptions().proxyHostName().length() > 0 && this._reactor._reactorOptions.restProxyOptions().proxyPort() != null && this._reactor._reactorOptions.restProxyOptions().proxyPort().length() > 0) {
            this._restConnectOptions.proxyHost(this._reactor._reactorOptions.restProxyOptions().proxyHostName().toString());
            this._restConnectOptions.proxyPort(Integer.valueOf(this._reactor._reactorOptions.restProxyOptions().proxyPort().toString()));
            if (this._reactor._reactorOptions.restProxyOptions().proxyUserName() != null) {
                this._restConnectOptions.proxyUserName(this._reactor._reactorOptions.restProxyOptions().proxyUserName().toString());
            }
            if (this._reactor._reactorOptions.restProxyOptions().proxyPassword() != null) {
                this._restConnectOptions.proxyPassword(this._reactor._reactorOptions.restProxyOptions().proxyPassword().toString());
            }
            if (this._reactor._reactorOptions.restProxyOptions().proxyDomain() != null) {
                this._restConnectOptions.proxyDomain(this._reactor._reactorOptions.restProxyOptions().proxyDomain().toString());
            }
            if (this._reactor._reactorOptions.restProxyOptions().proxyLocalHostName() != null) {
                this._restConnectOptions.proxyLocalHostName(this._reactor._reactorOptions.restProxyOptions().proxyLocalHostName().toString());
            }
            if (this._reactor._reactorOptions.restProxyOptions().proxyKrb5ConfigFile() != null) {
                this._restConnectOptions.proxyKRB5ConfigFile(this._reactor._reactorOptions.restProxyOptions().proxyKrb5ConfigFile().toString());
            }
        }
        return this._restConnectOptions;
    }

    List<ReactorServiceEndpointInfo> reactorServiceEndpointInfoList() {
        return this._reactorServiceEndpointInfoList;
    }

    public String toString() {
        this._stringBuilder.setLength(0);
        this._stringBuilder.append("ReactorChannel: ");
        if (this._role != null) {
            this._stringBuilder.append(this._role.toString() + " ");
        } else {
            this._stringBuilder.append("no Role defined. ");
        }
        if (this._channel == null && this._selectableChannel != null) {
            this._stringBuilder.append("Reactor's internal channel. ");
        } else {
            this._stringBuilder.append("Associated with a transport.Channel. ");
        }
        if (this._server != null) {
            this._stringBuilder.append("Associated with a transport.Server. ");
        }
        if (this._userSpecObj != null) {
            this._stringBuilder.append("_userSpecObj=" + this._userSpecObj.toString());
        }
        return this._stringBuilder.toString();
    }

    void clear() {
        this._state = State.UNKNOWN;
        this._sessionMgntState = SessionMgntState.UNKNOWN;
        this._tokenSession = null;
        this._reactor = null;
        this._selectableChannel = null;
        this._channel = null;
        this._preferredHostChannel = null;
        this._server = null;
        this._userSpecObj = null;
        this._initializationTimeout = 0;
        this._initializationEndTimeMs = 0L;
        this._flushRequested = false;
        this._flushAgain = false;
        this._pingHandler.clear();
        this._sendPingMessage = false;
        this._streamIdtoTunnelStreamTable.clear();
        this._tunnelStreamRespMsg.clear();
        this._hasTunnelStreamManagerNextDispatchTime = false;
        this._tunnelStreamManagerNextDispatchTime = 0L;
        this._tunnelStreamManager.clear();
        if (this._watchlist != null) {
            this._watchlist.returnToPool();
            this._watchlist = null;
        }
        this._reactorChannelType = 0;
        this._warmStandbyChInfo.clear();
        this._reconnectAttempts = 0;
        this._reconnectDelay = 0;
        this._nextRecoveryTime = 0L;
        this._reactorConnectOptions = null;
        this._listIndex = 0;
        this._errorInfoEDP.clear();
        this._loginRequestForEDP = null;
        this._reactorServiceEndpointInfoList.clear();
        this._restConnectOptions = null;
        this._role = null;
        this._connectOptionsInfoList.clear();
        this._loginConsumerStatus.rdmMsgType(LoginMsgType.CONSUMER_CONNECTION_STATUS);
        this._loginConsumerStatus.clear();
        this._directoryConsumerStatus.rdmMsgType(DirectoryMsgType.CONSUMER_STATUS);
        this._directoryConsumerStatus.clear();
        this._serviceConsumerStatus.clear();
        this._watchlistRecoveryMsgList.clear();
        this.standByServerListIndex = -1;
        this.standByGroupListIndex = -1;
        this.isActiveServer = false;
        this.isStartingServerConfig = false;
        this.sendReqFromQueue = false;
        this._currentConnectOptionsInfo = null;
        if (this._wsbDirectoryUpdate == null) {
            this._wsbDirectoryUpdate = DirectoryMsgFactory.createMsg();
            this._wsbDirectoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        }
        this._wsbDirectoryUpdate.clear();
        this._preferredHostTimersStartedByChannelUp = false;
        this._currentPHTimerEvent = null;
        if (this._preferredHostOptions != this._preferredHostOptionsOriginal) {
            this._preferredHostOptions = this._preferredHostOptionsOriginal;
        }
        this._preferredHostOptions.clear();
        this.isClosedAckSent = false;
        this.oldPHStartingChannel = null;
        this.lastSubmitOptionsTime = 0L;
        this._phResetPHIndexForRecovery = false;
        this._queueRequestsForDiscovery = false;
        this._haveAttemptedFirstConnectionListEntry = false;
        this._switchingToPreferredHost = false;
        this._switchingToPreferredWSBGroup = false;
        this._hitEndOfWSBGroups = false;
        this._checkedPreferredHostInChannelList_WSBEnabled = false;
        this._checkedPreferredHostInChannelList = false;
        this._phForcingChannelDown = false;
        this._phForcingChannelDown_isStartingActive = false;
        this._haveAttemptedFirstConnection = false;
        this._reconnectImmedietlyToPH = false;
        this._ignoreClosedStandbyCount = false;
        this._phSwitchingFromChannelListToWSB = false;
        this._phSwitchingFromWSBToChannelList = false;
    }

    @Override
    public void returnToPool() {
        this._userSpecObj = null;
        this._tokenSession = null;
        this._reactor = null;
        this._selectableChannel = null;
        this._channel = null;
        this._preferredHostChannel = null;
        this._server = null;
        this._reactorConnectOptions = null;
        this._loginRequestForEDP = null;
        this._restConnectOptions = null;
        this._role = null;
        this._currentPHTimerEvent = null;
        super.returnToPool();
    }

    int checkTunnelManagerEvents(ReactorErrorInfo errorInfo) {
        if (this._tunnelStreamManager.needsDispatchNow() && !this._reactor.sendDispatchNowEvent(this)) {
            this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, this);
            this._state = State.DOWN;
            this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.acceptTunnelStream", 2, this, errorInfo);
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.checkIfTunnelManagerNeedsDispatch", "_reactor.sendDispatchNowEvent() failed");
        }
        if (this._tunnelStreamManager.hasNextDispatchTime() && (!this._hasTunnelStreamManagerNextDispatchTime || this._tunnelStreamManager.nextDispatchTime() < this._tunnelStreamManagerNextDispatchTime)) {
            if (!this._reactor.sendWorkerEvent(WorkerEventTypes.START_DISPATCH_TIMER, this, this._tunnelStreamManager.nextDispatchTime())) {
                this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, this);
                this._state = State.DOWN;
                this._reactor.sendAndHandleChannelEventCallback("TunnelStream.dispatchChannel", 2, this, errorInfo);
                return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.checkIfTunnelManagerNeedsDispatch", "_reactor.sendWorkerEvent() failed");
            }
            this._hasTunnelStreamManagerNextDispatchTime = true;
            this._tunnelStreamManagerNextDispatchTime = this._tunnelStreamManager.nextDispatchTime();
        }
        if (this._tunnelStreamManager.needsFlush() && !this._reactor.sendWorkerEvent(WorkerEventTypes.FLUSH, this)) {
            this._reactor.sendWorkerEvent(WorkerEventTypes.CHANNEL_DOWN, this);
            this._state = State.DOWN;
            this._reactor.sendAndHandleChannelEventCallback("Reactor.dispatchChannel", 2, this, errorInfo);
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.checkIfTunnelManagerNeedsDispatch", "sendWorkerEvent() failed");
        }
        return 0;
    }

    public Reactor reactor() {
        return this._reactor;
    }

    public void reactor(Reactor reactor) {
        this._reactor = reactor;
    }

    public SelectableChannel oldSelectableChannel() {
        return this._oldSelectableChannel;
    }

    void oldSelectableChannel(SelectableChannel oldSelectableChannel) {
        this._oldSelectableChannel = oldSelectableChannel;
    }

    public SelectableChannel selectableChannel() {
        return this._selectableChannel;
    }

    void selectableChannel(SelectableChannel selectableChannel) {
        this._channel = null;
        this._selectableChannel = selectableChannel;
    }

    void selectableChannelFromChannel(Channel channel) {
        this._channel = channel;
        this._selectableChannel = channel != null ? channel.selectableChannel() : null;
    }

    public Channel channel() {
        return this._channel;
    }

    void channel(Channel channel) {
        this._channel = channel;
    }

    Channel preferredHostChannel() {
        return this._preferredHostChannel;
    }

    void preferredHostChannel(Channel channel) {
        this._preferredHostChannel = channel;
    }

    public Server server() {
        return this._server;
    }

    void server(Server server) {
        this._server = server;
    }

    ReactorRole role() {
        return this._role;
    }

    void role(ReactorRole role) {
        switch (role.type()) {
            case 1: {
                ConsumerRole consumerRole;
                if (this._role == null || this._role.type() != role.type()) {
                    consumerRole = ReactorFactory.createConsumerRole();
                    this._role = consumerRole;
                } else {
                    consumerRole = (ConsumerRole)this._role;
                }
                consumerRole.copy((ConsumerRole)role);
                break;
            }
            case 3: {
                NIProviderRole niProviderRole;
                if (this._role == null || this._role.type() != role.type()) {
                    niProviderRole = ReactorFactory.createNIProviderRole();
                    this._role = niProviderRole;
                } else {
                    niProviderRole = (NIProviderRole)this._role;
                }
                niProviderRole.copy((NIProviderRole)role);
                break;
            }
            case 2: {
                ProviderRole providerRole;
                if (this._role == null || this._role.type() != role.type()) {
                    providerRole = ReactorFactory.createProviderRole();
                    this._role = providerRole;
                } else {
                    providerRole = (ProviderRole)this._role;
                }
                providerRole.copy((ProviderRole)role);
                break;
            }
            default: {
                assert (false);
                return;
            }
        }
    }

    public Object userSpecObj() {
        return this._userSpecObj;
    }

    void userSpecObj(Object userSpecObj) {
        this._userSpecObj = userSpecObj;
    }

    Watchlist watchlist() {
        return this._watchlist;
    }

    void watchlist(Watchlist watchlist) {
        this._watchlist = watchlist;
    }

    void initializationTimeout(int timeout) {
        this._initializationTimeout = timeout;
        this._initializationEndTimeMs = (long)(timeout * 1000) + System.currentTimeMillis();
    }

    int initializationTimeout() {
        return this._initializationTimeout;
    }

    long initializationEndTimeMs() {
        return this._initializationEndTimeMs;
    }

    PingHandler pingHandler() {
        return this._pingHandler;
    }

    void sendPingMessage(boolean sendPingMessage) {
        this._sendPingMessage = sendPingMessage;
    }

    boolean sendPingMessage() {
        return this._sendPingMessage;
    }

    public int dispatch(ReactorDispatchOptions dispatchOptions, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (dispatchOptions == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.dispatch", "dispatchOptions cannot be null.");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.dispatch", "Reactor is shutdown, dispatch aborted.");
        }
        if (this._reactor.reactorHandlesWarmStandby(this)) {
            return this.reactor().populateErrorInfo(errorInfo, -6, "ReactorChannel.dispatch", "Cannot dispatch on a channel with Warm Standby enabled. Use Reactor.dispatchAll() instead.");
        }
        ReactorChannel channelImpl = this;
        if (this.warmStandByHandlerImpl != null && this == this.warmStandByHandlerImpl.mainReactorChannelImpl()) {
            channelImpl = this.warmStandByHandlerImpl.startingReactorChannel();
        }
        return channelImpl._reactor.dispatchChannel(channelImpl, dispatchOptions, errorInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submit(TransportBuffer buffer, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (submitOptions == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "submitOptions cannot be null.");
        }
        this._reactor._reactorLock.lock();
        try {
            if (this._watchlist != null || this.warmStandByHandlerImpl != null) {
                int n = this.reactor().populateErrorInfo(errorInfo, -6, "ReactorChannel.submit", "Cannot submit buffer when watchlist is enabled.");
                return n;
            }
            if (this._reactor.isShutdown()) {
                int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.submit", "Reactor is shutdown, submit aborted.");
                return n;
            }
            if (this._state == State.CLOSED) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "ReactorChannel is closed, submit aborted.");
                return n;
            }
            int n = this._reactor.submitChannel(this, buffer, submitOptions, errorInfo);
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submit(Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (submitOptions == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "submitOptions cannot be null.");
        }
        this._reactor._reactorLock.lock();
        try {
            if (this._reactor.isShutdown()) {
                int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.submit", "Reactor is shutdown, submit aborted.");
                return n;
            }
            if (this._state == State.CLOSED) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "ReactorChannel is closed, submit aborted.");
                return n;
            }
            ReactorChannel channelImpl = this;
            if (this.warmStandByHandlerImpl != null && this == this.warmStandByHandlerImpl.mainReactorChannelImpl()) {
                channelImpl = this.warmStandByHandlerImpl.startingReactorChannel();
            }
            if (this._reactor.reactorHandlesWarmStandby(channelImpl)) {
                if (this.warmStandByHandlerImpl.lastMsgRecoveryCheckTime > this.warmStandByHandlerImpl.latestMsgSubmissionTime) {
                    this.warmStandByHandlerImpl.latestMsgSubmissionTime = System.nanoTime();
                }
                int n = this._reactor.submitWSBMsg(this, msg, submitOptions, errorInfo);
                return n;
            }
            if (this.warmStandByHandlerImpl != null) {
                if (this.warmStandByHandlerImpl.lastMsgRecoveryCheckTime > this.warmStandByHandlerImpl.latestMsgSubmissionTime) {
                    this.warmStandByHandlerImpl.latestMsgSubmissionTime = System.nanoTime();
                }
                int n = this.warmStandByHandlerImpl.startingReactorChannel().watchlist().submitMsg(msg, submitOptions, errorInfo);
                return n;
            }
            if (this._watchlist == null) {
                int n = this._reactor.submitChannel(this, msg, submitOptions, errorInfo);
                return n;
            }
            int n = channelImpl._watchlist.submitMsg(msg, submitOptions, errorInfo);
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submit(MsgBase rdmMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (submitOptions == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "submitOptions cannot be null.");
        }
        this._reactor._reactorLock.lock();
        try {
            if (this._reactor.isShutdown()) {
                int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.submit", "Reactor is shutdown, submit aborted.");
                return n;
            }
            if (this._state == State.CLOSED) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.submit", "ReactorChannel is closed, submit aborted.");
                return n;
            }
            ReactorChannel channelImpl = this;
            if (this.warmStandByHandlerImpl != null && this == this.warmStandByHandlerImpl.mainReactorChannelImpl()) {
                channelImpl = this.warmStandByHandlerImpl.startingReactorChannel();
            }
            if (this._reactor.reactorHandlesWarmStandby(channelImpl)) {
                int n = this._reactor.submitWSBRDMMsg(channelImpl, rdmMsg, submitOptions, errorInfo);
                return n;
            }
            if (this._watchlist == null) {
                int n = this._reactor.submitChannel(this, rdmMsg, submitOptions, errorInfo);
                return n;
            }
            int n = this._watchlist.submitMsg(rdmMsg, submitOptions, errorInfo);
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int close(ReactorErrorInfo errorInfo) {
        int retVal = 0;
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        this._reactor._reactorLock.lock();
        if (this._reactor.reactorHandlesWarmStandby(this)) {
            this.warmStandByHandlerImpl.setClosingState();
            this.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
            try {
                while (this.warmStandByHandlerImpl.channelList().size() != 0) {
                    ReactorChannel wsbChnl = this.warmStandByHandlerImpl.channelList().remove(0);
                    retVal = this._reactor.closeChannel(wsbChnl, errorInfo);
                    this._reactor.removeReactorChannel(wsbChnl);
                    if (retVal == 0) continue;
                    this._reactor._reactorLock.unlock();
                    int n = retVal;
                    return n;
                }
            }
            finally {
                this.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
            }
            this._reactor._reactorLock.unlock();
            if (!this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled()) {
                this.returnToPool();
            }
            return retVal;
        }
        try {
            if (this._reactor.isShutdown()) {
                retVal = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.close", "Reactor is shutdown, close aborted.");
            }
            if (this.state() != State.CLOSED) {
                retVal = this._reactor.closeChannel(this, errorInfo);
            }
            this._reactor.removeReactorChannel(this);
            int n = retVal;
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportBuffer getBuffer(int size, boolean packedBuffer, ReactorErrorInfo errorInfo) {
        Channel channel = this.channel();
        if (errorInfo == null || this._reactor == null || channel == null) {
            return null;
        }
        if (channel.protocolType() == 2 && packedBuffer) {
            this._reactor._reactorLock.lock();
            try {
                if (this._reactor.isShutdown()) {
                    this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.getBuffer", "Reactor is shutdown, getBuffer aborted.");
                    TransportBuffer transportBuffer = null;
                    return transportBuffer;
                }
                TransportBuffer transportBuffer = channel.getBuffer(size, packedBuffer, errorInfo.error());
                if (Objects.isNull(transportBuffer)) {
                    errorInfo.location("ReactorChannel.getBuffer");
                    errorInfo.code(-1);
                    TransportBuffer transportBuffer2 = transportBuffer;
                    return transportBuffer2;
                }
                ReactorPackedBuffer packedBufferImpl = ReactorFactory.createPackedBuffer();
                packedBufferImpl.totalSize = size;
                packedBufferImpl.remainingSize = size;
                this._reactor.packedBufferHashMap.put(transportBuffer, packedBufferImpl);
                TransportBuffer transportBuffer3 = transportBuffer;
                return transportBuffer3;
            }
            finally {
                this._reactor._reactorLock.unlock();
            }
        }
        return channel.getBuffer(size, packedBuffer, errorInfo.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int releaseBuffer(TransportBuffer buffer, ReactorErrorInfo errorInfo) {
        Channel channel = this.channel();
        if (errorInfo == null || this._reactor == null || channel == null) {
            return -1;
        }
        if (buffer == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.releaseBuffer", "TransportBuffer is null.");
        }
        if (channel.protocolType() == 2) {
            this._reactor._reactorLock.lock();
            try {
                if (this._reactor.isShutdown()) {
                    int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.releaseBuffer", "Reactor is shutdown, releaseBuffer aborted.");
                    return n;
                }
                ReactorPackedBuffer packedBufferImpl = this._reactor.packedBufferHashMap.get(buffer);
                if (Objects.nonNull(packedBufferImpl)) {
                    this._reactor.packedBufferHashMap.remove(buffer);
                    packedBufferImpl.returnToPool();
                }
                int n = channel.releaseBuffer(buffer, errorInfo.error());
                return n;
            }
            finally {
                this._reactor._reactorLock.unlock();
            }
        }
        return channel.releaseBuffer(buffer, errorInfo.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int packBuffer(TransportBuffer buffer, ReactorErrorInfo errorInfo) {
        Channel channel = this.channel();
        if (errorInfo == null || this._reactor == null || channel == null) {
            return -1;
        }
        if (buffer == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.packBuffer", "TransportBuffer is null.");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.packBuffer", "Reactor is shutdown, packBuffer aborted.");
        }
        if (channel.protocolType() == 2) {
            int ret = 0;
            this._reactor._reactorLock.lock();
            try {
                ReactorPackedBuffer packedBufferImpl = this._reactor.packedBufferHashMap.get(buffer);
                if (Objects.isNull(packedBufferImpl)) {
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.packBuffer", "Failed to find the packed buffer handling for JSON protocol.");
                    return n;
                }
                if (Objects.isNull(this._reactor.jsonConverter)) {
                    int n = this._reactor.populateErrorInfo(errorInfo, -1, "Reactor.packBuffer", "The JSON converter library has not been initialized properly.");
                    return n;
                }
                this._reactor._msg.clear();
                this._reactor._dIter.clear();
                Buffer decodeBuffer = packedBufferImpl.decodeBuffer(buffer);
                ret = this._reactor._dIter.setBufferAndRWFVersion(decodeBuffer, this.majorVersion(), this.minorVersion());
                ret = this._reactor._msg.decode(this._reactor._dIter);
                if (ret == 0) {
                    this._reactor.converterError.clear();
                    this._reactor.rwfToJsonOptions.clear();
                    this._reactor.rwfToJsonOptions.setJsonProtocolType(2);
                    if (this._reactor.jsonConverter.convertRWFToJson(this._reactor._msg, this._reactor.rwfToJsonOptions, this._reactor.conversionResults, this._reactor.converterError) != 0) {
                        int n = this._reactor.populateErrorInfo(errorInfo, -1, "Reactor.packBuffer", "Failed to convert RWF to JSON protocol. Error text: " + this._reactor.converterError.getText());
                        return n;
                    }
                    Buffer jsonBuffer = packedBufferImpl.jsonBuffer(this._reactor.conversionResults.getLength());
                    this._reactor.getJsonMsgOptions.clear();
                    this._reactor.getJsonMsgOptions.jsonProtocolType(2);
                    this._reactor.getJsonMsgOptions.streamId(this._reactor._msg.streamId());
                    this._reactor.getJsonMsgOptions.isCloseMsg(this._reactor._msg.msgClass() == 5);
                    if (this._reactor.jsonConverter.getJsonBuffer(jsonBuffer, this._reactor.getJsonMsgOptions, this._reactor.converterError) != 0) {
                        int n = this._reactor.populateErrorInfo(errorInfo, -1, "Reactor.packBuffer", "Failed to get converted JSON message. Error text: " + this._reactor.converterError.getText());
                        return n;
                    }
                    int neededSize = 0;
                    neededSize = packedBufferImpl.totalSize == packedBufferImpl.remainingSize ? jsonBuffer.length() : jsonBuffer.length() + 1;
                    if (neededSize < packedBufferImpl.remainingSize) {
                        packedBufferImpl.remainingSize -= neededSize;
                        if (packedBufferImpl.nextRWFBufferPosition() == 0) {
                            buffer.data().position(buffer.dataStartPosition());
                            buffer.data().put(jsonBuffer.data().array(), jsonBuffer.position(), jsonBuffer.length());
                        } else {
                            buffer.data().position(packedBufferImpl.nextRWFBufferPosition());
                            buffer.data().put(jsonBuffer.data().array(), jsonBuffer.position(), jsonBuffer.length());
                        }
                        ret = channel.packBuffer(buffer, errorInfo.error());
                        if (ret >= 0) {
                            packedBufferImpl.nextRWFBufferPosition(buffer.data().position());
                        }
                        int n = ret;
                        return n;
                    }
                    if (packedBufferImpl.nextRWFBufferPosition() == 0) {
                        buffer.data().position(buffer.dataStartPosition());
                    } else {
                        buffer.data().position(packedBufferImpl.nextRWFBufferPosition());
                    }
                    int n = this._reactor.populateErrorInfo(errorInfo, -21, "Reactor.packBuffer", "Failed to pack buffer as the required buffer size(" + neededSize + ") is larger than the remaining packed buffer size(" + packedBufferImpl.remainingSize + ").");
                    return n;
                }
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "Reactor.packBuffer", "Failed to decode the passed in buffer as RWF messages.");
                return n;
            }
            finally {
                this._reactor._reactorLock.unlock();
            }
        }
        return channel.packBuffer(buffer, errorInfo.error());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int info(ReactorChannelInfo info, ReactorErrorInfo errorInfo) {
        try {
            if (this._preferredHostOptions.isPreferredHostEnabled()) {
                this._preferredHostLock.lock();
            }
            if (errorInfo == null || this._reactor == null) {
                int n = -1;
                return n;
            }
            if (this._reactor.isShutdown()) {
                int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.info", "Reactor is shutdown, info aborted.");
                return n;
            }
            Channel channel = this.channel();
            if (channel == null) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.info", "The channel is no longer available.");
                return n;
            }
            info.preferredHostInfo(this._preferredHostOptions);
            info.preferredHostInfo()._remainingDetectionTime = this.warmStandByHandlerImpl != null ? (this.warmStandByHandlerImpl.startingReactorChannel()._nextReconnectTimeMs > 0L && this.warmStandByHandlerImpl.startingReactorChannel()._nextReconnectTimeMs > System.currentTimeMillis() ? (this.warmStandByHandlerImpl.startingReactorChannel()._nextReconnectTimeMs - System.currentTimeMillis()) / 1000L : 0L) : (this._nextReconnectTimeMs > 0L && this._nextReconnectTimeMs > System.currentTimeMillis() ? (this._nextReconnectTimeMs - System.currentTimeMillis()) / 1000L : 0L);
            int n = channel.info(info.channelInfo(), errorInfo.error());
            return n;
        }
        finally {
            if (this._preferredHostOptions.isPreferredHostEnabled()) {
                this._preferredHostLock.unlock();
            }
        }
    }

    public int bufferUsage(ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.bufferUsage", "Reactor is shutdown, bufferUsage aborted.");
        }
        Channel channel = this.channel();
        if (channel == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.bufferUsage", "The channel is no longer available.");
        }
        return channel.bufferUsage(errorInfo.error());
    }

    public int ioctl(int code, int value, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.ioctl", "Reactor is shutdown, ioctl aborted.");
        }
        Channel channel = this.channel();
        if (channel == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "The channel is no longer available.");
        }
        if (this.reactor().reactorHandlesWarmStandby(this)) {
            ret = channel.ioctl(code, value, errorInfo.error());
            if (ret < 0) {
                return ret;
            }
            for (int i = 0; i < this.warmStandByHandlerImpl.channelList().size(); ++i) {
                ReactorChannel tmpChannel = this.warmStandByHandlerImpl.channelList().get(i);
                if (tmpChannel.channel() == null || tmpChannel == channel || (ret = tmpChannel.channel().ioctl(code, value, errorInfo.error())) >= 0) continue;
                return ret;
            }
            if (code == 1) {
                this.warmStandByHandlerImpl.maxNumBuffers(value);
            } else if (code == 2) {
                this.warmStandByHandlerImpl.numGuaranteedBuffers(value);
            } else if (code == 3) {
                this.warmStandByHandlerImpl.highWaterMark(value);
            } else if (code == 5) {
                this.warmStandByHandlerImpl.systemWriteBuffers(value);
            } else if (code == 4) {
                this.warmStandByHandlerImpl.systemReadBuffers(value);
            } else if (code == 9) {
                this.warmStandByHandlerImpl.compressionThreshold(value);
            }
            return ret;
        }
        return channel.ioctl(code, value, errorInfo.error());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int ioctl(int code, Object value, ReactorErrorInfo errorInfo) {
        ReactorConnectOptions connectOptions;
        int ret = 0;
        if (errorInfo == null) return -1;
        if (this._reactor == null) return -1;
        if (value == null) {
            return -1;
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.ioctl", "Reactor is shutdown, ioctl aborted.");
        }
        Channel channel = this.channel();
        if (channel == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "The channel is no longer available.");
        }
        if (code != 201) return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Code is not valid.");
        ReactorChannel reactorChannel = this;
        if (value.getClass() != ReactorPreferredHostOptions.class) return this._reactor.populateErrorInfo(errorInfo, -6, "ReactorChannel.ioctl", "Invalid use of Fallback Preferred Host Options Ioctl code.");
        if (this.warmStandByHandlerImpl != null) {
            connectOptions = this.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions;
            reactorChannel = this.warmStandByHandlerImpl.startingReactorChannel();
        } else {
            connectOptions = this._reactorConnectOptions;
        }
        ReactorPreferredHostOptions tempOptions = (ReactorPreferredHostOptions)value;
        if (tempOptions.isPreferredHostEnabled() && connectOptions._connectionList != null && connectOptions._connectionList.size() > 0) {
            if (tempOptions.connectionListIndex() >= connectOptions._connectionList.size()) return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Configured preferredHostOptions connectionListIndex is out of bounds, aborting ioctl call.");
            if (tempOptions.connectionListIndex() < 0) {
                return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Configured preferredHostOptions connectionListIndex is out of bounds, aborting ioctl call.");
            }
        }
        if (tempOptions.isPreferredHostEnabled() && connectOptions._reactorWarmStandyGroupList != null && connectOptions.reactorWarmStandbyGroupList() != null && connectOptions.reactorWarmStandbyGroupList().size() > 0) {
            if (tempOptions.warmStandbyGroupListIndex() >= connectOptions._reactorWarmStandyGroupList.size()) return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Configured preferredHostOptions warmStandbyGroupListIndex is out of bounds, aborting ioctl call.");
            if (tempOptions.warmStandbyGroupListIndex() < 0) {
                return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Configured preferredHostOptions warmStandbyGroupListIndex is out of bounds, aborting ioctl call.");
            }
        }
        if (tempOptions.isPreferredHostEnabled() && tempOptions.detectionTimeInterval() < 0L) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Configured preferredHostOptions detectionTimeInterval is invalid, aborting ioctl call.");
        }
        try {
            if (tempOptions.detectionTimeSchedule() != null && !tempOptions.detectionTimeSchedule().isEmpty()) {
                reactorChannel._cronExpressionIoctl = new CronExpression(tempOptions.detectionTimeSchedule());
            }
        }
        catch (ParseException e) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.ioctl", "Parse exception occured on preferredHostOptions scheduled cron time, aborting ioctl call.");
        }
        reactorChannel._preferredHostOptionsIoctl = new ReactorPreferredHostOptions();
        ((ReactorPreferredHostOptions)value).copy(reactorChannel._preferredHostOptionsIoctl);
        this._reactor.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_IOCTL, reactorChannel);
        return ret;
    }

    public int majorVersion() {
        Channel channel = this.channel();
        return channel != null ? channel.majorVersion() : Codec.majorVersion();
    }

    public String hostname() {
        Channel channel = this.channel();
        if (channel == null) {
            return null;
        }
        return channel.hostname();
    }

    public int port() {
        Channel channel = this.channel();
        if (channel == null) {
            return 0;
        }
        return channel.port();
    }

    public int minorVersion() {
        Channel channel = this.channel();
        return channel != null ? channel.minorVersion() : Codec.minorVersion();
    }

    public int protocolType() {
        Channel channel = this.channel();
        if (channel != null) {
            return this.channel().protocolType();
        }
        return -1;
    }

    TunnelStreamManager tunnelStreamManager() {
        return this._tunnelStreamManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int openTunnelStream(TunnelStreamOpenOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (options == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "TunnelStreamOpenOptions cannot be null");
        }
        if (options.statusEventCallback() == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "TunnelStream statusEventCallback must be specified");
        }
        if (options.defaultMsgCallback() == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "TunnelStream defaultMsgCallback must be specified");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.openTunnelStream", "Reactor is shutdown, openTunnelStream aborted");
        }
        this._reactor._reactorLock.lock();
        try {
            boolean isServer;
            boolean bl = isServer = this._server != null;
            if (!options.classOfService().isValid(isServer, errorInfo)) {
                int n = -1;
                return n;
            }
            if (options.name() != null && options.name().length() > 255) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "TunnelStream name is too long.");
                return n;
            }
            WlInteger wlInteger = ReactorFactory.createWlInteger();
            wlInteger.value(options.streamId());
            if (this._streamIdtoTunnelStreamTable.containsKey(wlInteger)) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "TunnelStream is already open for stream id " + options.streamId());
                return n;
            }
            if (this._state != State.UP && this._state != State.READY) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "Cannot open TunnelStreams while channel is down.");
                return n;
            }
            if (options.classOfService().flowControl().recvWindowSize() == -1) {
                options.classOfService().flowControl().recvWindowSize(12288);
            }
            if (options.classOfService().flowControl().recvWindowSize() < options.classOfService().common().maxFragmentSize()) {
                options.classOfService().flowControl().recvWindowSize(options.classOfService().common().maxFragmentSize());
            }
            TunnelStream tunnelStream = this._tunnelStreamManager.createTunnelStream(options);
            wlInteger.value(tunnelStream.streamId());
            tunnelStream.tableKey(wlInteger);
            this._streamIdtoTunnelStreamTable.put(wlInteger, tunnelStream);
            if (tunnelStream.openStream(errorInfo.error()) < 0) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.openTunnelStream", "tunnelStream.openStream() failed");
                return n;
            }
            int ret = this.checkTunnelManagerEvents(errorInfo);
            if (ret != 0) {
                int n = ret;
                return n;
            }
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acceptTunnelStream(TunnelStreamRequestEvent event, TunnelStreamAcceptOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (event == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "TunnelStreamRequestEvent cannot be null");
        }
        if (options == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "TunnelStreamAcceptOptions cannot be null");
        }
        if (options.statusEventCallback() == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "TunnelStream statusEventCallback must be specified");
        }
        if (options.defaultMsgCallback() == null) {
            return this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "TunnelStream defaultMsgCallback must be specified");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.acceptTunnelStream", "Reactor is shutdown, acceptTunnelStream aborted");
        }
        this._reactor._reactorLock.lock();
        try {
            int ret;
            if (event.classOfService().common().streamVersion() > 2) {
                this._tunnelStreamRejectOptions.clear();
                this._tunnelStreamRejectOptions.state().streamState(4);
                this._tunnelStreamRejectOptions.state().dataState(2);
                this._tunnelStreamRejectOptions.state().text().data("Unsupported class of service stream version: " + event.classOfService().common().streamVersion());
                this._tunnelStreamRejectOptions.expectedClassOfService(this._defaultClassOfService);
                this.rejectTunnelStream(event, this._tunnelStreamRejectOptions, errorInfo);
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "Unsupported class of service stream version: " + event.classOfService().common().streamVersion());
                return n;
            }
            if (!event.classOfService().decodedProperly()) {
                this._tunnelStreamRejectOptions.clear();
                this._tunnelStreamRejectOptions.state().streamState(4);
                this._tunnelStreamRejectOptions.state().dataState(2);
                this._tunnelStreamRejectOptions.state().text().data("Requested class of service could not be fully decoded");
                this._tunnelStreamRejectOptions.expectedClassOfService(this._defaultClassOfService);
                this.rejectTunnelStream(event, this._tunnelStreamRejectOptions, errorInfo);
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "Requested class of service could not be fully decoded");
                return n;
            }
            boolean isServer = this._server != null;
            options.classOfService().common().streamVersion(event.classOfService().common().streamVersion());
            if (!options.classOfService().isValid(isServer, errorInfo)) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "Accepted class of service is invalid");
                return n;
            }
            this._tunnelStreamRespMsg.clear();
            this._tunnelStreamRespMsg.msgClass(2);
            RefreshMsg refreshMsg = (RefreshMsg)this._tunnelStreamRespMsg;
            refreshMsg.applyPrivateStream();
            refreshMsg.applyQualifiedStream();
            refreshMsg.applySolicited();
            refreshMsg.applyRefreshComplete();
            refreshMsg.applyDoNotCache();
            refreshMsg.domainType(event.domainType());
            refreshMsg.streamId(event.streamId());
            refreshMsg.applyHasMsgKey();
            refreshMsg.msgKey().applyHasServiceId();
            refreshMsg.msgKey().serviceId(event.serviceId());
            refreshMsg.msgKey().applyHasName();
            refreshMsg.msgKey().name().data(event.name());
            refreshMsg.state().streamState(1);
            refreshMsg.state().dataState(1);
            refreshMsg.state().code(0);
            refreshMsg.state().text().data("Successful open of TunnelStream: " + event.name());
            refreshMsg.containerType(135);
            refreshMsg.msgKey().applyHasFilter();
            refreshMsg.msgKey().filter((long)options.classOfService().filterFlags());
            if (options.classOfService().flowControl().recvWindowSize() == -1) {
                options.classOfService().flowControl().recvWindowSize(12288);
            }
            if (options.classOfService().flowControl().recvWindowSize() < options.classOfService().common().maxFragmentSize()) {
                options.classOfService().flowControl().recvWindowSize(options.classOfService().common().maxFragmentSize());
            }
            refreshMsg.encodedDataBody(options.classOfService().encode(this));
            this._reactorSubmitOptions.clear();
            while ((ret = this.submit((Msg)refreshMsg, this._reactorSubmitOptions, errorInfo)) < 0) {
                int n;
                if (ret != -3) {
                    n = ret;
                    return n;
                }
                this._reactorChannelInfo.clear();
                ret = this.info(this._reactorChannelInfo, errorInfo);
                if (ret < 0) {
                    n = ret;
                    return n;
                }
                int newNumberOfBuffers = this._reactorChannelInfo.channelInfo().guaranteedOutputBuffers() + 10;
                ret = this.ioctl(2, newNumberOfBuffers, errorInfo);
                if (ret >= 0) continue;
                int n2 = ret;
                return n2;
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d submitted a tunnel stream open response (stream ID=%d) on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), event.streamId(), ReactorDebugger.getChannelId(this));
            }
            TunnelStream tunnelStream = this._tunnelStreamManager.createTunnelStream(event, options);
            tunnelStream.channelStreamId(tunnelStream.streamId());
            WlInteger wlInteger = ReactorFactory.createWlInteger();
            wlInteger.value(tunnelStream.streamId());
            tunnelStream.tableKey(wlInteger);
            this._streamIdtoTunnelStreamTable.put(wlInteger, tunnelStream);
            if (tunnelStream.openStream(errorInfo.error()) < 0) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.acceptTunnelStream", "tunnelStream.openStream() failed");
                return n;
            }
            ret = this.checkTunnelManagerEvents(errorInfo);
            if (ret != 0) {
                int n = ret;
                return n;
            }
            tunnelStream.state().streamState(1);
            tunnelStream.state().dataState(1);
            tunnelStream.state().code(0);
            tunnelStream.classOfService().flowControl().sendWindowSize(event.classOfService().flowControl().recvWindowSize());
            if (tunnelStream.classOfService().flowControl().sendWindowSize() < tunnelStream.classOfService().common().maxFragmentSize()) {
                tunnelStream.classOfService().flowControl().sendWindowSize(tunnelStream.classOfService().common().maxFragmentSize());
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d accepts a tunnel stream request (stream ID=%d) on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), tunnelStream.streamId(), ReactorDebugger.getChannelId(this));
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d, Tunnel stream established (stream ID=%d) on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), event.streamId(), ReactorDebugger.getChannelId(this));
            }
            int n = this._reactor.sendAndHandleTunnelStreamStatusEventCallback("ReactorChannel.acceptTunnelStream", this, tunnelStream, null, (Msg)refreshMsg, refreshMsg.state(), errorInfo);
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int rejectTunnelStream(TunnelStreamRequestEvent event, TunnelStreamRejectOptions options, ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        if (event == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.rejectTunnelStream", "TunnelStreamRequestEvent cannot be null");
        }
        if (options == null) {
            return this.reactor().populateErrorInfo(errorInfo, -1, "ReactorChannel.rejectTunnelStream", "options cannot be null");
        }
        if (this._reactor.isShutdown()) {
            return this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.rejectTunnelStream", "Reactor is shutdown, rejectTunnelStream aborted");
        }
        this._reactor._reactorLock.lock();
        try {
            int ret;
            this._tunnelStreamRespMsg.clear();
            this._tunnelStreamRespMsg.msgClass(3);
            StatusMsg statusMsg = (StatusMsg)this._tunnelStreamRespMsg;
            statusMsg.applyPrivateStream();
            statusMsg.applyQualifiedStream();
            statusMsg.domainType(event.domainType());
            statusMsg.streamId(event.streamId());
            statusMsg.applyClearCache();
            statusMsg.applyHasState();
            options.state().copy(statusMsg.state());
            if (options.expectedClassOfService() != null) {
                statusMsg.applyHasMsgKey();
                statusMsg.msgKey().applyHasServiceId();
                statusMsg.msgKey().serviceId(event.serviceId());
                statusMsg.msgKey().applyHasName();
                statusMsg.msgKey().name().data(event.name());
                statusMsg.containerType(135);
                statusMsg.msgKey().applyHasFilter();
                statusMsg.msgKey().filter((long)options.expectedClassOfService().filterFlags());
                statusMsg.encodedDataBody(options.expectedClassOfService().encode(this));
            }
            this._reactorSubmitOptions.clear();
            while ((ret = this.submit((Msg)statusMsg, this._reactorSubmitOptions, errorInfo)) < 0) {
                int n;
                if (ret != -3) {
                    n = ret;
                    return n;
                }
                this._reactorChannelInfo.clear();
                ret = this.info(this._reactorChannelInfo, errorInfo);
                if (ret < 0) {
                    n = ret;
                    return n;
                }
                int newNumberOfBuffers = this._reactorChannelInfo.channelInfo().guaranteedOutputBuffers() + 10;
                ret = this.ioctl(2, newNumberOfBuffers, errorInfo);
                if (ret >= 0) continue;
                int n2 = ret;
                return n2;
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugTunnelStreamLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d rejects a tunnel stream request (stream ID=%d) on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), event.streamId(), ReactorDebugger.getChannelId(this));
            }
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
        return 0;
    }

    HashMap<WlInteger, TunnelStream> streamIdtoTunnelStreamTable() {
        return this._streamIdtoTunnelStreamTable;
    }

    void clearTunnelStreamManagerExpireTime() {
        this._hasTunnelStreamManagerNextDispatchTime = false;
    }

    void reactorConnectOptions(ReactorConnectOptions reactorConnectOptions) {
        if (this._reactorConnectOptions == null) {
            this._reactorConnectOptions = ReactorFactory.createReactorConnectOptions();
        }
        reactorConnectOptions.copy(this._reactorConnectOptions);
        this._reconnectDelay = 0;
        this._nextRecoveryTime = 0L;
        this._connectOptionsInfoList = new ArrayList<ConnectOptionsInfo>(this._reactorConnectOptions.connectionList().size());
        this._reactorConnectOptions.connectionList().forEach(conn -> {
            ConnectOptionsInfo connectOptions = new ConnectOptionsInfo();
            connectOptions.hostAndPortProvided = conn.connectOptions().unifiedNetworkInfo().address() != null && conn.connectOptions().unifiedNetworkInfo().serviceName() != null && !conn.connectOptions().unifiedNetworkInfo().address().equals("") && !conn.connectOptions().unifiedNetworkInfo().serviceName().equals("");
            connectOptions.reconnectAttempts = 0;
            this._connectOptionsInfoList.add(connectOptions);
        });
        this._reactorConnectOptions._reactorWarmStandyGroupList.forEach(wsbGroup -> {
            ReactorWarmStandbyGroupImpl wsbGroupImpl = (ReactorWarmStandbyGroupImpl)wsbGroup;
            wsbGroupImpl.startingConnectOptionsInfo.hostAndPortProvided = wsbGroupImpl.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().address() != null && wsbGroupImpl.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName() != null && !wsbGroupImpl.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().address().equals("") && !wsbGroupImpl.startingActiveServer().reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName().equals("");
            wsbGroupImpl.startingConnectOptionsInfo.reconnectAttempts = 0;
            wsbGroupImpl.standbyServerList().forEach(wsbConnectInfo -> {
                ConnectOptionsInfo connectOptions = new ConnectOptionsInfo();
                connectOptions.hostAndPortProvided = wsbConnectInfo.reactorConnectInfo().connectOptions().unifiedNetworkInfo().address() != null && wsbConnectInfo.reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName() != null && !wsbConnectInfo.reactorConnectInfo().connectOptions().unifiedNetworkInfo().address().equals("") && !wsbConnectInfo.reactorConnectInfo().connectOptions().unifiedNetworkInfo().serviceName().equals("");
                connectOptions.reconnectAttempts = 0;
                wsbGroupImpl.standbyConnectOptionsInfoList.add(connectOptions);
            });
        });
    }

    void calculateNextReconnectTime() {
        if (this._reconnectDelay < this._reactorConnectOptions.reconnectMaxDelay()) {
            this._reconnectDelay = this._reconnectDelay != 0 ? (this._reconnectDelay *= 2) : this._reactorConnectOptions.reconnectMinDelay();
            if (this._reconnectDelay > this._reactorConnectOptions.reconnectMaxDelay()) {
                this._reconnectDelay = this._reactorConnectOptions.reconnectMaxDelay();
            }
        }
        this._nextRecoveryTime = System.currentTimeMillis() + (long)this._reconnectDelay;
    }

    void resetReconnectTimers() {
        this._reconnectAttempts = 0;
        this._reconnectDelay = 0;
        this._nextRecoveryTime = 0L;
    }

    boolean recoveryAttemptLimitReached() {
        return this._reactorConnectOptions.reconnectAttemptLimit() != -1 && this._reconnectAttempts >= this._reactorConnectOptions.reconnectAttemptLimit();
    }

    boolean redoServiceDiscoveryForCurrentChannel() {
        return this._currentConnectInfo.serviceDiscoveryRetryCount() != 0 && this._currentConnectOptionsInfo != null && !this._currentConnectOptionsInfo.hostAndPortProvided && this._currentConnectOptionsInfo.reconnectAttempts == this._currentConnectInfo.serviceDiscoveryRetryCount();
    }

    boolean redoServiceDiscoveryForTargetChannel(ReactorConnectInfo connectInfo, ConnectOptionsInfo connectOptionsInfo) {
        return connectInfo.serviceDiscoveryRetryCount() != 0 && connectOptionsInfo != null && !connectOptionsInfo.hostAndPortProvided && connectOptionsInfo.reconnectAttempts == connectInfo.serviceDiscoveryRetryCount();
    }

    ReactorConnectInfo getCurrentReactorConnectInfo() {
        return this._currentConnectInfo;
    }

    void setCurrentReactorConnectInfo(ReactorConnectInfo connectInfo) {
        this._currentConnectInfo = connectInfo;
    }

    ConnectOptionsInfo getCurrentConnectOptionsInfo() {
        return this._currentConnectOptionsInfo;
    }

    void setCurrentConnectOptionsInfo(ConnectOptionsInfo connectInfo) {
        this._currentConnectOptionsInfo = connectInfo;
    }

    private Channel reconnect(Error error) {
        this.increaseRetryCountForCurrentChannel();
        this.userSpecObj(this._currentConnectInfo.connectOptions().userSpecObject());
        this._currentConnectInfo.connectOptions().channelReadLocking(true);
        this._currentConnectInfo.connectOptions().channelWriteLocking(true);
        Channel channel = Transport.connect((ConnectOptions)this._currentConnectInfo.connectOptions(), (Error)error);
        this.initializationTimeout(this._currentConnectInfo.initTimeout());
        return channel;
    }

    Channel reconnectEDP(Error error) {
        ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
        this.userSpecObj(this._currentConnectInfo.connectOptions().userSpecObject());
        if (this._state == State.EDP_RT_DONE) {
            if (this._currentConnectInfo.enableSessionManagement() && this.redoServiceDiscoveryForCurrentChannel()) {
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().address("");
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().serviceName("");
                this.resetCurrentChannelRetryCount();
                if (this._reactor.sessionManagementStartup(this._tokenSession, this._currentConnectInfo, this._role, this, false, errorInfo) != 0) {
                    error.text(errorInfo.error().text());
                }
            } else {
                this.applyAccessToken();
                if (Reactor.requestServiceDiscovery(this._currentConnectInfo) && this.applyServiceDiscoveryEndpoint(this._currentConnectInfo, errorInfo) != 0) {
                    this._state = State.DOWN;
                    error.text(errorInfo.error().text());
                    return null;
                }
                return this.reconnect(error);
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d reconnecting to LDP on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), ReactorDebugger.getChannelId(this));
            }
            return this.reconnect(error);
        }
        if (this._state == State.EDP_RT_FAILED) {
            error.text(this._errorInfoEDP.error().text());
            this._state = State.DOWN;
        }
        return null;
    }

    boolean checkAuthTokenReady(Error error) {
        ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
        this.userSpecObj(this._currentConnectInfo.connectOptions().userSpecObject());
        if (this._state == State.EDP_RT_DONE) {
            if (this._currentConnectInfo.enableSessionManagement() && this.redoServiceDiscoveryForCurrentChannel()) {
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().address("");
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().serviceName("");
                this.resetCurrentChannelRetryCount();
                if (this._reactor.sessionManagementStartup(this._tokenSession, this._currentConnectInfo, this._role, this, false, errorInfo) != 0) {
                    error.text(errorInfo.error().text());
                }
            } else {
                this.applyAccessToken();
                if (Reactor.requestServiceDiscovery(this._currentConnectInfo) && this.applyServiceDiscoveryEndpoint(this._currentConnectInfo, errorInfo) != 0) {
                    this._state = State.DOWN;
                    error.text(errorInfo.error().text());
                    return false;
                }
                return true;
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d reconnecting to LDP on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), ReactorDebugger.getChannelId(this));
            }
            return true;
        }
        if (this._state == State.EDP_RT_FAILED) {
            error.text(this._errorInfoEDP.error().text());
            this._state = State.DOWN;
        }
        return false;
    }

    boolean enableSessionManagement() {
        return this._currentConnectInfo.enableSessionManagement();
    }

    void reconnectTokenSession(ReactorConnectInfo connectInfo, Error error) {
        if (connectInfo.enableSessionManagement()) {
            if (this.redoServiceDiscoveryForCurrentChannel()) {
                connectInfo.connectOptions().unifiedNetworkInfo().address("");
                connectInfo.connectOptions().unifiedNetworkInfo().serviceName("");
                this.resetCurrentChannelRetryCount();
            }
            ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
            if (this._tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
                this._tokenSession.resetSessionMgntState();
                this._tokenSession.HandleTokenRenewalCallbackForOAuthV2();
            } else if (this._tokenSession.sessionMgntState() != ReactorTokenSession.SessionState.UNKNOWN && this._state == State.DOWN_RECONNECTING) {
                this._tokenSession.authTokenInfo().accessToken("");
                String refreshToken = this._tokenSession.authTokenInfo().refreshToken();
                if (refreshToken != null && !refreshToken.isEmpty()) {
                    this._tokenSession.handleTokenReissue();
                }
            }
            if (this._reactor.sessionManagementStartup(this._tokenSession, connectInfo, this._role, this, false, errorInfo) != 0) {
                error.text(errorInfo.error().text());
            }
        }
    }

    Channel reconnectReactorChannel(Error error) {
        if (this._currentConnectInfo.enableSessionManagement()) {
            if (this.redoServiceDiscoveryForCurrentChannel()) {
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().address("");
                this._currentConnectInfo.connectOptions().unifiedNetworkInfo().serviceName("");
                this.resetCurrentChannelRetryCount();
            }
            ReactorErrorInfo errorInfo = ReactorFactory.createReactorErrorInfo();
            if (this._tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
                this._tokenSession.resetSessionMgntState();
                this._tokenSession.HandleTokenRenewalCallbackForOAuthV2();
            } else if (this._tokenSession.sessionMgntState() != ReactorTokenSession.SessionState.UNKNOWN && this._state == State.DOWN_RECONNECTING) {
                this._tokenSession.authTokenInfo().accessToken("");
                String refreshToken = this._tokenSession.authTokenInfo().refreshToken();
                if (refreshToken != null && !refreshToken.isEmpty()) {
                    this._tokenSession.handleTokenReissue();
                }
            }
            if (this._reactor.sessionManagementStartup(this._tokenSession, this._currentConnectInfo, this._role, this, false, errorInfo) != 0) {
                error.text(errorInfo.error().text());
            }
            return null;
        }
        if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
            this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d reconnecting on channel fd=%d.]\n", this._reactor.hashCode(), this.hashCode(), ReactorDebugger.getChannelId(this));
        }
        return this.reconnect(error);
    }

    private void increaseRetryCountForCurrentChannel() {
        if (this._currentConnectOptionsInfo != null) {
            ++this._currentConnectOptionsInfo.reconnectAttempts;
        }
    }

    void resetCurrentChannelRetryCount() {
        if (this._currentConnectOptionsInfo != null) {
            this._currentConnectOptionsInfo.reconnectAttempts = 0;
        }
    }

    long nextRecoveryTime() {
        return this._nextRecoveryTime;
    }

    boolean flushRequested() {
        return this._flushRequested;
    }

    void flushRequested(boolean flushRequested) {
        this._flushRequested = flushRequested;
    }

    boolean flushAgain() {
        return this._flushAgain;
    }

    void flushAgain(boolean flushAgain) {
        this._flushAgain = flushAgain;
    }

    ReactorAuthTokenEventCallback reactorAuthTokenEventCallback() {
        return this._currentConnectInfo.reactorAuthTokenEventCallback();
    }

    private void sendEventToReactorQueue(ReactorChannel reactorChannel, WorkerEventTypes eventType, int reactorReturnCode, String location, String text) {
        WorkerEvent event = ReactorFactory.createWorkerEvent();
        event.reactorChannel(reactorChannel);
        event.eventType(eventType);
        event.errorInfo().code(reactorReturnCode);
        event.errorInfo().error().errorId(reactorReturnCode);
        if (location != null) {
            event.errorInfo().location(location);
        }
        if (text != null) {
            event.errorInfo().error().text(text);
        }
        this._reactor._workerQueue.remote().write(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int switchHostToPreferredHost(boolean callByTimer, ReactorErrorInfo errorInfo) {
        ReactorChannel reactorChannel;
        block33: {
            block34: {
                if ((this.warmStandByHandlerImpl == null ? this._switchingToPreferredHost : this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredHost) || (this.warmStandByHandlerImpl != null ? this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup : this._switchingToPreferredWSBGroup)) {
                    return 0;
                }
                if (this.warmStandByHandlerImpl != null && !this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.isPreferredHostEnabled() || this.warmStandByHandlerImpl == null && !this._preferredHostOptions.isPreferredHostEnabled()) {
                    if (errorInfo != null) {
                        this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.fallbackPreferredHost", "Preferred host feature is not enabled for the specified ReactorChannel: fallback is not feasible.");
                    }
                    return -1;
                }
                reactorChannel = this;
                if (reactorChannel.state() != State.DOWN && reactorChannel.state() != State.DOWN_RECONNECTING) break block33;
                if (!callByTimer || !this._reactor.reactorHandlesWarmStandby(reactorChannel)) break block34;
                reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().lock();
                try {
                    for (ReactorChannel reactorChannel2 : reactorChannel.warmStandByHandlerImpl.channelList()) {
                        if (reactorChannel == reactorChannel2 || reactorChannel2.state() == State.DOWN || reactorChannel2.state() == State.DOWN_RECONNECTING) continue;
                        reactorChannel = reactorChannel2;
                        break;
                    }
                }
                finally {
                    reactorChannel.warmStandByHandlerImpl.warmStandByHandlerLock().unlock();
                }
                if (reactorChannel != this) break block33;
            }
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d ignores fallback to preferred host during reconnection or down state.]\\n", this._reactor.hashCode(), reactorChannel.hashCode());
            }
            return 0;
        }
        if (this.warmStandByHandlerImpl != null) {
            if (this._reactor.reactorHandlesWarmStandby(reactorChannel)) {
                if (this.warmStandByHandlerImpl.currentWarmStandbyGroupIndex() == this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.warmStandbyGroupListIndex()) {
                    boolean checkActiveReactorChannel = false;
                    if (this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                        checkActiveReactorChannel = !Reactor.isWarmStandbyChannelClosed(this.warmStandByHandlerImpl, null);
                    } else {
                        boolean bl = checkActiveReactorChannel = this.warmStandByHandlerImpl.activeReactorChannel() != null;
                    }
                    if (checkActiveReactorChannel) {
                        if (!this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.fallBackWithInWSBGroup()) {
                            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                                this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is already connected to the preferred host.]\\n", this._reactor.hashCode(), reactorChannel.hashCode());
                            }
                            this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_NO_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                            return 0;
                        }
                        if (this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                            for (ReactorConnectInfo connectInfo : this.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions.connectionList()) {
                                if (connectInfo != reactorChannel._currentConnectInfo) continue;
                                this.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(0);
                                break;
                            }
                            this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                            this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup = true;
                            ReactorWarmStandbyGroupImpl reactorWarmStandbyGroupImpl = (ReactorWarmStandbyGroupImpl)this.warmStandByHandlerImpl.warmStandbyGroupList().get(this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.warmStandbyGroupListIndex());
                            reactorChannel._phTempReactorConnectInfo = reactorWarmStandbyGroupImpl.startingActiveServer().reactorConnectInfo();
                            reactorChannel._phTempConnectOptionsInfo = reactorWarmStandbyGroupImpl.startingConnectOptionsInfo;
                            reactorChannel._phTempReactorConnectOptions = this.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions;
                            reactorChannel._phTempUserSpecObj = reactorChannel._phTempReactorConnectInfo.connectOptions().userSpecObject();
                            reactorChannel.preferredHostChannel(null);
                            this._reactor.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, reactorChannel);
                            return 0;
                        }
                        if (this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.fallBackWithInWSBGroup() && this.warmStandByHandlerImpl.activeReactorChannel() != null) {
                            for (ConnectOptionsInfo standbyOptions : this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyConnectOptionsInfoList) {
                                Channel channel;
                                if (standbyOptions != this.warmStandByHandlerImpl.activeReactorChannel().getCurrentConnectOptionsInfo() || (channel = this.warmStandByHandlerImpl.startingReactorChannel()._channel) == null || channel.state() != 2) continue;
                                this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                                ReactorWarmStandbyEvent reactorWarmStandbyEvent = this._reactor.reactorWarmStandbyEventPool.getEvent(reactorChannel._errorInfoEDP);
                                reactorWarmStandbyEvent.eventType = 11;
                                reactorWarmStandbyEvent.reactorChannel = this.warmStandByHandlerImpl.startingReactorChannel();
                                this._reactor.sendWarmStandbyEvent(this.warmStandByHandlerImpl.startingReactorChannel(), reactorWarmStandbyEvent, reactorChannel._errorInfoEDP);
                                return 0;
                            }
                            this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_NO_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                            return 0;
                        }
                    }
                } else if (this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.fallBackWithInWSBGroup() && this.warmStandByHandlerImpl.activeReactorChannel() != null) {
                    for (ConnectOptionsInfo connectOptionsInfo : this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyConnectOptionsInfoList) {
                        Channel channel;
                        if (connectOptionsInfo != this.warmStandByHandlerImpl.activeReactorChannel().getCurrentConnectOptionsInfo() || (channel = this.warmStandByHandlerImpl.startingReactorChannel()._channel) == null || channel.state() != 2) continue;
                        this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                        ReactorWarmStandbyEvent reactorWarmStandbyEvent = this._reactor.reactorWarmStandbyEventPool.getEvent(reactorChannel._errorInfoEDP);
                        reactorWarmStandbyEvent.eventType = 11;
                        reactorWarmStandbyEvent.reactorChannel = this.warmStandByHandlerImpl.startingReactorChannel();
                        this._reactor.sendWarmStandbyEvent(this.warmStandByHandlerImpl.startingReactorChannel(), reactorWarmStandbyEvent, reactorChannel._errorInfoEDP);
                        return 0;
                    }
                    this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_NO_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                    return 0;
                }
            }
            for (ReactorConnectInfo reactorConnectInfo : this.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions.connectionList()) {
                if (reactorConnectInfo != reactorChannel._currentConnectInfo) continue;
                this.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(0);
                break;
            }
            this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
            this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup = true;
            ReactorWarmStandbyGroupImpl wsbGroup = (ReactorWarmStandbyGroupImpl)this.warmStandByHandlerImpl.warmStandbyGroupList().get(this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.warmStandbyGroupListIndex());
            reactorChannel._phTempReactorConnectInfo = wsbGroup.startingActiveServer().reactorConnectInfo();
            reactorChannel._phTempConnectOptionsInfo = wsbGroup.startingConnectOptionsInfo;
            reactorChannel._phTempReactorConnectOptions = this.warmStandByHandlerImpl.startingReactorChannel()._reactorConnectOptions;
            reactorChannel._phTempUserSpecObj = reactorChannel._phTempReactorConnectInfo.connectOptions().userSpecObject();
            reactorChannel.preferredHostChannel(null);
            this._reactor.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, reactorChannel);
        } else {
            if (reactorChannel._reactorConnectOptions.connectionList().get(reactorChannel._preferredHostOptions.connectionListIndex()) == reactorChannel._currentConnectInfo) {
                if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                    this._reactor.debugger.writeDebugInfo("Reactor@%d, Reactor channel@%d is already connected to the preferred host.]\\n", this._reactor.hashCode(), reactorChannel.hashCode());
                }
                this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_NO_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
                return 0;
            }
            this.sendEventToReactorQueue(reactorChannel, WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, 0, "ReactorChannel.switchToPreferredHost", null);
            reactorChannel._switchingToPreferredHost = true;
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Attempting to switch to Connection List Index: " + reactorChannel._preferredHostOptions.connectionListIndex(), this._reactor.hashCode(), reactorChannel.hashCode());
            }
            this._reactor.sendWorkerEvent(WorkerEventTypes.PREFERRED_HOST_START_FALLBACK, reactorChannel);
        }
        return 0;
    }

    public int fallbackPreferredHost(ReactorErrorInfo errorInfo) {
        if (errorInfo == null || this._reactor == null) {
            return -1;
        }
        this._reactor._reactorLock.lock();
        try {
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Preferred host: fallback function called to attempt switching to preferred host", this._reactor.hashCode(), this.hashCode());
            }
            if (this._reactor.isShutdown()) {
                int n = this._reactor.populateErrorInfo(errorInfo, -10, "ReactorChannel.fallbackPreferredHost", "Reactor is shutdown, fallbackPreferredHost aborted.");
                return n;
            }
            if (this._role.type() != 1) {
                int n = this._reactor.populateErrorInfo(errorInfo, -1, "ReactorChannel.fallbackPreferredHost", "Preferred host feature is not enabled for Interactive and Non-interactive Provider.");
                return n;
            }
            int n = this.switchHostToPreferredHost(false, errorInfo);
            return n;
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    void copyActiveServiceOptions() {
        int j;
        ReactorPerServiceBasedOptions serviceOpts = this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().startingActiveServer().perServiceBasedOptions();
        for (j = 0; j < serviceOpts.serviceNameList().size(); ++j) {
            Buffer serviceName = serviceOpts.serviceNameList().get(j);
            if (serviceName.length() <= 0) continue;
            ReactorWSBService service = ReactorFactory.createWsbService();
            service.serviceName.data(serviceName.toString().strip());
            if (this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.containsKey(service.serviceName)) continue;
            service.standbyListIndex = -1;
            this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.put(service.serviceName, service);
        }
        for (j = 0; j < this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().size(); ++j) {
            ReactorWarmStandbyServerInfo serverInfo = this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().standbyServerList().get(j);
            for (int k = 0; k < serverInfo.perServiceBasedOptions().serviceNameList().size(); ++k) {
                Buffer serviceName = serverInfo.perServiceBasedOptions().serviceNameList().get(k);
                if (serviceName.length() <= 0) continue;
                ReactorWSBService service = ReactorFactory.createWsbService();
                service.serviceName.data(serviceName.toString().strip());
                if (this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.containsKey(service.serviceName)) continue;
                service.standbyListIndex = j;
                this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._startupServiceNameList.put(service.serviceName, service);
            }
        }
    }

    void initiateSwitch(boolean shouldInitiate, boolean switchingFromChannelListToWSB) {
        if (shouldInitiate && this.warmStandByHandlerImpl != null) {
            ReactorChannel startingActive = null;
            boolean movingToNextWSBGroup = false;
            this.warmStandByHandlerImpl.warmStandbyHandlerState(8);
            if (!switchingFromChannelListToWSB) {
                this.warmStandByHandlerImpl.startingReactorChannel().reactorChannelType(1);
            }
            for (int i = 0; i < this.warmStandByHandlerImpl.channelList().size(); ++i) {
                this.warmStandByHandlerImpl.channelList().get((int)i)._phForcingChannelDown = true;
                if (this.warmStandByHandlerImpl.channelList().get(i) != this.warmStandByHandlerImpl.startingReactorChannel()) {
                    if (!switchingFromChannelListToWSB) {
                        this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.initiateSwitch", 2, this.warmStandByHandlerImpl.channelList().get(i), this._errorInfoEDP);
                        continue;
                    }
                    this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.initiateSwitch", 3, this.warmStandByHandlerImpl.channelList().get(i), this._errorInfoEDP);
                    continue;
                }
                this.warmStandByHandlerImpl.channelList().get((int)i)._phForcingChannelDown_isStartingActive = true;
                startingActive = this.warmStandByHandlerImpl.channelList().get(i);
                movingToNextWSBGroup = true;
                startingActive._switchingToPreferredWSBGroup = true;
            }
            if (startingActive != null) {
                if (movingToNextWSBGroup) {
                    this.warmStandByHandlerImpl.warmStandbyHandlerState(64);
                }
                this.userSpecObj(this.warmStandByHandlerImpl.startingReactorChannel().userSpecObj());
                if (!switchingFromChannelListToWSB) {
                    this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.initiateSwitch", 2, startingActive, this._errorInfoEDP);
                } else {
                    startingActive._queueRequestsForDiscovery = true;
                    this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.initiateSwitch", 3, startingActive, this._errorInfoEDP);
                }
                this.warmStandByHandlerImpl.previousWarmStandbyGroupIndex(this.warmStandByHandlerImpl.currentWarmStandbyGroupIndex());
                this.warmStandByHandlerImpl.currentWarmStandbyGroupIndex(this.warmStandByHandlerImpl.startingReactorChannel()._preferredHostOptions.warmStandbyGroupListIndex());
            }
            if (this.warmStandByHandlerImpl.currentWarmStandbyGroupImpl().warmStandbyMode() == 2) {
                this.copyActiveServiceOptions();
            }
            this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredWSBGroup = false;
            this.warmStandByHandlerImpl.startingReactorChannel()._switchingToPreferredHost = false;
        } else if (shouldInitiate) {
            this._phForcingChannelDown = true;
            this._reactor.sendAndHandleChannelEventCallback("ReactorChannel.initiateSwitch", 2, this, this._errorInfoEDP);
            this.userSpecObj(this._reactorConnectOptions.connectionList().get(this._reactorConnectOptions.reactorPreferredHostOptions().connectionListIndex()).connectOptions().userSpecObject());
            this._currentConnectInfo = this._reactorConnectOptions.connectionList().get(this._preferredHostOptions.connectionListIndex());
            if (this._reactor._reactorOptions.debuggerOptions().debugConnectionLevel()) {
                this._reactor.debugger.writeDebugInfo("Switched to Connection List Index: " + this._preferredHostOptions.connectionListIndex(), this._reactor.hashCode(), this.hashCode());
            }
        } else {
            this.preferredHostChannel(null);
        }
        this._switchingToPreferredHost = false;
        this._switchingToPreferredWSBGroup = false;
    }

    int applyServiceDiscoveryEndpoint(ReactorConnectInfo reactorConnectInfo, ReactorErrorInfo errorInfo) {
        ReactorServiceEndpointInfo endpointInfo = null;
        String transportType = "";
        boolean foundLocation = false;
        for (ReactorServiceEndpointInfo serviceEndpointInfo : this._reactorServiceEndpointInfoList) {
            if (reactorConnectInfo.connectOptions().connectionType() == 1) {
                transportType = reactorConnectInfo.connectOptions().encryptionOptions().connectionType() == 7 ? "websocket" : "tcp";
            }
            if (serviceEndpointInfo.locationList().size() >= 2 && serviceEndpointInfo.transport().equals(transportType) && serviceEndpointInfo.locationList().get(0).startsWith(reactorConnectInfo.location())) {
                foundLocation = true;
                endpointInfo = serviceEndpointInfo;
                break;
            }
            if (serviceEndpointInfo.locationList().size() <= 0 || foundLocation || !serviceEndpointInfo.transport().equals(transportType) || !serviceEndpointInfo.locationList().get(0).startsWith(reactorConnectInfo.location())) continue;
            foundLocation = true;
            endpointInfo = serviceEndpointInfo;
        }
        if (foundLocation) {
            reactorConnectInfo.connectOptions().unifiedNetworkInfo().address(endpointInfo.endPoint());
            reactorConnectInfo.connectOptions().unifiedNetworkInfo().serviceName(endpointInfo.port());
            return 0;
        }
        this._reactor.populateErrorInfo(errorInfo, -5, "ReactorChannel.applyServiceDiscoveryEndpoint", "ReactorChannel.applyServiceDiscoveryEndpoint(): Could not find matching location: " + reactorConnectInfo.location() + " for requesting LDP service discovery.");
        return -5;
    }

    int applyAccessToken() {
        if (this._loginRequestForEDP != null) {
            this._loginRequestForEDP.userNameType(5);
            this._loginRequestForEDP.userName().data(this._tokenSession.authTokenInfo().accessToken());
            this._loginRequestForEDP.flags(this._loginRequestForEDP.flags() & 0xFFFFFFF7);
        }
        return 0;
    }

    public void getReactorChannelStats(ReactorChannelStats stats) {
        if (stats == null || this._reactor == null) {
            return;
        }
        if (this._reactor.isShutdown()) {
            return;
        }
        this._reactor._reactorLock.lock();
        try {
            stats.bytesRead(this._reactor._readArgsAggregator.bytesRead());
            stats.bytesWritten(this._reactor._writeArgsAggregator.bytesWritten());
            stats.uncompressedBytesRead(this._reactor._readArgsAggregator.uncompressedBytesRead());
            stats.uncompressedBytesWritten(this._reactor._writeArgsAggregator.uncompressedBytesWritten());
            stats.pingsReceived((int)this.pingHandler().getPingsReceived());
            stats.pingsSent((int)this.pingHandler().getPingsSent());
            this.pingHandler().resetAggregatedStats();
            this._reactor._readArgsAggregator.clear();
            this._reactor._writeArgsAggregator.clear();
        }
        finally {
            this._reactor._reactorLock.unlock();
        }
    }

    public void clearAccessTokenForV2() {
        if (this._tokenSession != null && this._tokenSession.authTokenInfo().tokenVersion() == ReactorAuthTokenInfo.TokenVersion.V2) {
            this._tokenSession.authTokenInfo().accessToken("");
        }
    }

    public ReactorConnectOptions getReactorConnectOptions() {
        return this._reactorConnectOptions;
    }

    public int reactorChannelType() {
        return this._reactorChannelType;
    }

    void reactorChannelType(int reactorChannelType) {
        this._reactorChannelType = reactorChannelType;
    }

    public ReactorWarmStandbyChannelInfo warmStandbyChannelInfo() {
        return this._warmStandbyChInfo;
    }

    void warmStandbyChannelInfo(ReactorWarmStandbyChannelInfo warmStandbyChInfo) {
        this._warmStandbyChInfo = warmStandbyChInfo;
    }

    int reconnectAttemptLimit() {
        return this._reactorConnectOptions._reconnectAttemptLimit;
    }

    void reconnectAttemptLimit(int reconnectAttempts) {
        this._reactorConnectOptions._reconnectAttemptLimit = reconnectAttempts;
    }

    int reconnectMinDelay() {
        return this._reactorConnectOptions._reconnectMinDelay;
    }

    void reconnectMinDelay(int reconnectMinDelay) {
        this._reactorConnectOptions._reconnectMinDelay = reconnectMinDelay;
    }

    int reconnectMaxDelay() {
        return this._reactorConnectOptions._reconnectMaxDelay;
    }

    void reconnectMaxDelay(int reconnectMaxDelay) {
        this._reactorConnectOptions._reconnectMaxDelay = reconnectMaxDelay;
    }

    void reconnectAttemptCount(int i) {
        this._reconnectAttempts = i;
    }

    void userName(Buffer userName) {
        this.userName = userName;
    }

    void flags(int flags) {
        this.flags = flags;
    }

    void userNameType(int userNameType) {
        this.userNameType = userNameType;
    }

    boolean switchingToPreferredHost() {
        return this._switchingToPreferredHost;
    }

    boolean switchingToPreferredWSBGroup() {
        return this._switchingToPreferredWSBGroup;
    }

    static enum SessionMgntState {
        UNKNOWN,
        REQ_FAILURE_FOR_TOKEN_SERVICE,
        REQ_FAILURE_FOR_SERVICE_DISCOVERY,
        REQ_AUTH_TOKEN_USING_REFRESH_TOKEN,
        REQ_AUTH_TOKEN_USING_PASSWORD,
        RECEIVED_AUTH_TOKEN,
        QUERYING_SERVICE_DISCOVERY,
        RECEIVED_ENDPOINT_INFO,
        AUTHENTICATE_USING_PASSWD_GRANT,
        STOP_QUERYING_SERVICE_DISCOVERY;

    }

    static class ReactorChannelLink
    implements VaDoubleLinkList.Link<ReactorChannel> {
        ReactorChannelLink() {
        }

        @Override
        public ReactorChannel getPrev(ReactorChannel thisPrev) {
            return thisPrev._reactorChannelPrev;
        }

        @Override
        public void setPrev(ReactorChannel thisPrev, ReactorChannel thatPrev) {
            thisPrev._reactorChannelPrev = thatPrev;
        }

        @Override
        public ReactorChannel getNext(ReactorChannel thisNext) {
            return thisNext._reactorChannelNext;
        }

        @Override
        public void setNext(ReactorChannel thisNext, ReactorChannel thatNext) {
            thisNext._reactorChannelNext = thatNext;
        }
    }

    public static enum State {
        UNKNOWN,
        INITIALIZING,
        UP,
        READY,
        DOWN,
        DOWN_RECONNECTING,
        CLOSED,
        EDP_RT,
        EDP_RT_DONE,
        EDP_RT_FAILED;

    }
}

