/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.domainrep.rdm.directory;

import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBaseImpl;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRequest;

class DirectoryRequestImpl
extends MsgBaseImpl {
    private long filter;
    private int serviceId;
    private int flags;
    private static final String eol = System.getProperty("line.separator");
    private static final String tab = "\t";
    private RequestMsg requestMsg = (RequestMsg)CodecFactory.createMsg();

    DirectoryRequestImpl() {
    }

    public void flags(int flags) {
        this.flags = flags;
    }

    public int flags() {
        return this.flags;
    }

    @Override
    public void clear() {
        super.clear();
        this.flags = 0;
        this.filter = 0L;
        this.serviceId = 0;
    }

    public long filter() {
        return this.filter;
    }

    public void filter(long filter) {
        this.filter = filter;
    }

    public int serviceId() {
        return this.serviceId;
    }

    public void applyStreaming() {
        this.flags |= 1;
    }

    public boolean checkStreaming() {
        return (this.flags & 1) != 0;
    }

    public void applyHasServiceId() {
        this.flags |= 2;
    }

    public boolean checkHasServiceId() {
        return (this.flags & 2) != 0;
    }

    public void serviceId(int serviceId) {
        assert (this.checkHasServiceId());
        this.serviceId = serviceId;
    }

    @Override
    public int encode(EncodeIterator encodeIter) {
        this.requestMsg.clear();
        this.requestMsg.msgClass(1);
        this.requestMsg.streamId(this.streamId());
        this.requestMsg.domainType(4);
        this.requestMsg.containerType(128);
        if (this.checkStreaming()) {
            this.requestMsg.applyStreaming();
        }
        this.requestMsg.msgKey().applyHasFilter();
        this.requestMsg.msgKey().filter(this.filter());
        if (this.checkHasServiceId()) {
            this.requestMsg.msgKey().applyHasServiceId();
            this.requestMsg.msgKey().serviceId(this.serviceId());
        }
        return this.requestMsg.encode(encodeIter);
    }

    @Override
    public int decode(DecodeIterator dIter, Msg msg) {
        MsgKey msgKey;
        this.clear();
        if (msg.msgClass() != 1) {
            return -1;
        }
        RequestMsg requestMsg = (RequestMsg)msg;
        if (requestMsg.checkStreaming()) {
            this.applyStreaming();
        }
        if ((msgKey = msg.msgKey()) == null || !msgKey.checkHasFilter()) {
            return -1;
        }
        if (msgKey.checkHasFilter()) {
            this.filter(requestMsg.msgKey().filter());
        }
        this.streamId(msg.streamId());
        if (msgKey.checkHasServiceId()) {
            this.applyHasServiceId();
            this.serviceId(msgKey.serviceId());
        }
        return 0;
    }

    public int copy(DirectoryRequest destRequestMsg) {
        assert (destRequestMsg != null) : "destRequestMsg must be non-null";
        destRequestMsg.streamId(this.streamId());
        destRequestMsg.filter(this.filter());
        if (this.checkHasServiceId()) {
            destRequestMsg.applyHasServiceId();
            destRequestMsg.serviceId(this.serviceId());
        }
        if (this.checkStreaming()) {
            destRequestMsg.applyStreaming();
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuilder stringBuf = super.buildStringBuffer();
        stringBuf.insert(0, "DirectoryRequest: \n");
        if (this.checkHasServiceId()) {
            stringBuf.append(tab);
            stringBuf.append("serviceId: ");
            stringBuf.append(this.serviceId());
            stringBuf.append(eol);
        }
        stringBuf.append(tab);
        stringBuf.append("streaming: ");
        stringBuf.append(this.checkStreaming());
        stringBuf.append(eol);
        stringBuf.append(tab);
        stringBuf.append("filter: ");
        long filter = this.filter();
        boolean addOr = false;
        if ((filter & 1L) != 0L) {
            stringBuf.append("INFO");
            addOr = true;
        }
        if ((filter & 0x10L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("DATA");
            addOr = true;
        }
        if ((filter & 4L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("GROUP");
            addOr = true;
        }
        if ((filter & 0x20L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("LINK");
            addOr = true;
        }
        if ((filter & 8L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("LOAD");
            addOr = true;
        }
        if ((filter & 2L) != 0L) {
            if (addOr) {
                stringBuf.append(" | ");
            }
            stringBuf.append("STATE");
        }
        stringBuf.append(eol);
        return stringBuf.toString();
    }

    @Override
    public int domainType() {
        return 4;
    }
}

