/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.common.VaQueue;
import com.refinitiv.eta.valueadd.common.ValueAddQueue;

public class LimitedVaQueue
extends VaQueue
implements ValueAddQueue {
    int _limit = -1;

    @Override
    public void add(VaNode node) {
        if (this.checkPoolLimit(this._limit)) {
            super.add(node);
        }
    }

    @Override
    public void setLimit(int newLimit) {
        this._limit = newLimit;
        if (newLimit > 0 && this._size > newLimit) {
            int diff = this._size - newLimit;
            VaNode node = this._head;
            if (diff > newLimit) {
                for (int i = 0; i < newLimit - 1; ++i) {
                    node = node.next();
                }
                this._tail = node;
                node.next(null);
            } else {
                for (int i = 0; i < diff - 1; ++i) {
                    node = node.next();
                }
                this._head = node.next();
                node.next(null);
            }
            this._size = newLimit;
        }
    }

    private boolean checkPoolLimit(int limit) {
        return limit < 0 || this._size < limit;
    }
}

