/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.common;

import com.refinitiv.eta.valueadd.common.VaNode;
import com.refinitiv.eta.valueadd.common.VaQueue;
import com.refinitiv.eta.valueadd.common.ValueAddQueue;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrentVaQueue
implements ValueAddQueue {
    ReentrantLock _lock = new ReentrantLock();
    ValueAddQueue _queue;

    public ConcurrentVaQueue() {
        this._queue = new VaQueue();
    }

    public ConcurrentVaQueue(ValueAddQueue queue) {
        this._queue = queue;
    }

    @Override
    public void add(VaNode node) {
        this._lock.lock();
        try {
            this._queue.add(node);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public VaNode poll() {
        this._lock.lock();
        try {
            VaNode vaNode = this._queue.poll();
            return vaNode;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public VaNode peek() {
        this._lock.lock();
        try {
            VaNode vaNode = this._queue.peek();
            return vaNode;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean remove(VaNode node) {
        this._lock.lock();
        try {
            boolean bl = this._queue.remove(node);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public int size() {
        this._lock.lock();
        try {
            int n = this._queue.size();
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setLimit(int newLimit) {
        this._lock.lock();
        try {
            this._queue.setLimit(newLimit);
        }
        finally {
            this._lock.unlock();
        }
    }
}

