/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.AckMsg;
import com.refinitiv.eta.codec.Array;
import com.refinitiv.eta.codec.ArrayEntry;
import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CloseMsg;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.CodecReturnCodes;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.ElementEntry;
import com.refinitiv.eta.codec.ElementList;
import com.refinitiv.eta.codec.EncodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Int;
import com.refinitiv.eta.codec.Map;
import com.refinitiv.eta.codec.MapEntry;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.MsgClasses;
import com.refinitiv.eta.codec.MsgKey;
import com.refinitiv.eta.codec.PostMsg;
import com.refinitiv.eta.codec.Qos;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.State;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.codec.UInt;
import com.refinitiv.eta.codec.UpdateMsg;
import com.refinitiv.eta.rdm.ElementNames;
import com.refinitiv.eta.rdm.SymbolList;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.dictionary.DictionaryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.ReactorWSBService;
import com.refinitiv.eta.valueadd.reactor.ReactorWarmStandbyHandler;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlHandler;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlItemAggregationKey;
import com.refinitiv.eta.valueadd.reactor.WlItemGroup;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlService;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import com.refinitiv.eta.valueadd.reactor.WlStreamStatusFlags;
import com.refinitiv.eta.valueadd.reactor.WlView;
import com.refinitiv.eta.valueadd.reactor.WlViewHandler;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;

class WlItemHandler
implements WlHandler {
    int defaultCopyFlags = 4047;
    int privateStreamCopyFlags = 4095;
    Watchlist _watchlist;
    boolean _directoryStreamOpen;
    LinkedHashMap<WlInteger, LinkedHashSet<WlRequest>> _pendingRequestByIdTable = new LinkedHashMap();
    LinkedHashMap<String, LinkedHashSet<WlRequest>> _pendingRequestByNameTable = new LinkedHashMap();
    LinkedList<LinkedHashSet<WlRequest>> _pendingRequestListPool = new LinkedList();
    ReactorErrorInfo _errorInfo = ReactorFactory.createReactorErrorInfo();
    ReactorSubmitOptions _submitOptions = ReactorFactory.createReactorSubmitOptions();
    LinkedHashSet<WlStream> _streamList = new LinkedHashSet();
    HashMap<WlItemAggregationKey, WlStream> _itemAggregationKeytoWlStreamTable;
    WlItemAggregationKey _tempItemAggregationKey = ReactorFactory.createWlItemAggregationKey();
    RequestMsg _tempItemAggregationRequest = (RequestMsg)CodecFactory.createMsg();
    Qos _defaultQos = CodecFactory.createQos();
    Qos _tempMatchedQos = CodecFactory.createQos();
    StatusMsg _statusMsg = (StatusMsg)CodecFactory.createMsg();
    CloseMsg _closeMsg = (CloseMsg)CodecFactory.createMsg();
    LinkedList<StatusMsg> _statusMsgPool = new LinkedList();
    LinkedHashMap<WlInteger, StatusMsg> _statusMsgDispatchList = new LinkedHashMap();
    LinkedList<WlStream> _pendingSendMsgList = new LinkedList();
    LinkedList<WlRequest> _requestTimeoutList = new LinkedList();
    DictionaryMsg _rdmDictionaryMsg = DictionaryMsgFactory.createMsg();
    LinkedHashSet<WlInteger> _userStreamIdListToRecover = new LinkedHashSet();
    HashMap<WlItemAggregationKey, RequestMsg> _providerRequestTable = new HashMap();
    RequestMsg _requestMsg = (RequestMsg)CodecFactory.createMsg();
    WlItemAggregationKey _symbolListRequestKey = ReactorFactory.createWlItemAggregationKey();
    Map _map = CodecFactory.createMap();
    MapEntry _mapEntry = CodecFactory.createMapEntry();
    Buffer _mapKey = CodecFactory.createBuffer();
    ElementList _elementList = CodecFactory.createElementList();
    ElementList _behaviourElementList = CodecFactory.createElementList();
    ElementEntry _elementEntry = CodecFactory.createElementEntry();
    ElementEntry _behaviourEntry = CodecFactory.createElementEntry();
    UInt _dataStreamFlag = CodecFactory.createUInt();
    DecodeIterator _dIter = CodecFactory.createDecodeIterator();
    DecodeIterator _dIterBatch = CodecFactory.createDecodeIterator();
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();
    UInt _viewType = CodecFactory.createUInt();
    boolean _hasViewType;
    Buffer _viewDataElement = CodecFactory.createBuffer();
    boolean _viewDataFound;
    Int _fieldId = CodecFactory.createInt();
    final int VIEW_ACTION_SET = 1;
    final int VIEW_ACTION_MAINTAIN = 2;
    final int VIEW_ACTION_NONE = 3;
    int _viewElemCount;
    WlViewHandler _wlViewHandler;
    Array _viewArray = CodecFactory.createArray();
    ArrayEntry _viewArrayEntry = CodecFactory.createArrayEntry();
    Buffer _elementName = CodecFactory.createBuffer();
    Buffer _viewElemList = CodecFactory.createBuffer();
    boolean _snapshotViewClosed;
    WlStream _currentFanoutStream;
    boolean _hasPendingViewRequest = false;
    State _msgState;

    WlItemHandler(Watchlist watchlist) {
        this._watchlist = watchlist;
        this._defaultQos.clear();
        this._defaultQos.timeliness(1);
        this._defaultQos.rate(1);
        this._statusMsg.msgClass(3);
        this._wlViewHandler = new WlViewHandler(watchlist);
        this._itemAggregationKeytoWlStreamTable = new LinkedHashMap<WlItemAggregationKey, WlStream>(this._watchlist.role().watchlistOptions().itemCountHint() + 10, 1.0f);
    }

    @Override
    public int submitRequest(WlRequest wlRequest, RequestMsg requestMsg, boolean isReissue, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        if (!isReissue) {
            if (requestMsg.checkHasQos() && requestMsg.qos() != null && (requestMsg.qos().timeliness() == 0 || requestMsg.qos().rate() == 0 || requestMsg.qos().timeliness() > 3 || requestMsg.qos().rate() > 3)) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -29, "WlItemHandler.submitRequest", "Request has invalid QoS (Timeliness: " + requestMsg.qos().timeliness() + ", Rate: " + requestMsg.qos().rate() + ").");
            }
            if (requestMsg.checkHasWorstQos() && requestMsg.worstQos() != null && (requestMsg.worstQos().timeliness() == 0 || requestMsg.worstQos().rate() == 0 || requestMsg.worstQos().timeliness() > 3 || requestMsg.worstQos().rate() > 3)) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -29, "WlItemHandler.submitRequest", "Request has invalid worst QoS (Timeliness: " + requestMsg.worstQos().timeliness() + ", Rate: " + requestMsg.worstQos().rate() + ").");
            }
            if (requestMsg.checkHasBatch()) {
                return this.handleBatchRequest(wlRequest, requestMsg, submitOptions, errorInfo);
            }
            return this.handleRequest(wlRequest, requestMsg, submitOptions, true, errorInfo);
        }
        return this.handleReissue(wlRequest, requestMsg, submitOptions, errorInfo);
    }

    int handleRequest(WlRequest wlRequest, RequestMsg requestMsg, ReactorSubmitOptions submitOptions, boolean sendNow, ReactorErrorInfo errorInfo) {
        Qos staticQos;
        int ret = 0;
        if (requestMsg.domainType() == 10 && (ret = this.extractSymbolListFromMsg(wlRequest, requestMsg, errorInfo)) < 0) {
            return ret;
        }
        if (requestMsg.checkHasView() && (ret = this.extractViewFromMsg(wlRequest, requestMsg, errorInfo)) < 0) {
            return ret;
        }
        this._tempMatchedQos.clear();
        WlService wlService = null;
        if (submitOptions.serviceName() != null) {
            wlService = this._watchlist.directoryHandler().service(submitOptions.serviceName());
        } else if (requestMsg.msgKey().checkHasServiceId()) {
            wlService = this._watchlist.directoryHandler().service(requestMsg.msgKey().serviceId());
        }
        Qos qos = staticQos = wlRequest.hasStaticQos() ? wlRequest.matchedQos() : null;
        if (wlService != null && this.canItemBeOpened(requestMsg, submitOptions, this._tempMatchedQos, staticQos, wlService.rdmService(), errorInfo)) {
            wlRequest.serviceId(wlService.rdmService().serviceId());
            if (requestMsg.domainType() == 5 || this.isWindowOpen(wlService)) {
                WlStream wlStream = null;
                wlStream = this.findItemAggregationStream(requestMsg, this._tempMatchedQos, submitOptions);
                if (wlStream == null) {
                    wlStream = this.createNewStream(requestMsg);
                    wlRequest.stream(wlStream);
                    wlStream.userRequestList().add(wlRequest);
                    if (requestMsg.checkHasView() && requestMsg.domainType() != 10 && (ret = this.handleViews(wlRequest, errorInfo)) < 0) {
                        return ret;
                    }
                    WlItemAggregationKey itemAggregationKey = null;
                    if (!requestMsg.checkPrivateStream()) {
                        itemAggregationKey = ReactorFactory.createWlItemAggregationKey();
                        this._tempItemAggregationKey.copy(itemAggregationKey);
                    }
                    this._tempItemAggregationRequest.clear();
                    if (!requestMsg.checkPrivateStream()) {
                        requestMsg.copy((Msg)this._tempItemAggregationRequest, this.defaultCopyFlags);
                        this._tempItemAggregationRequest.containerType(128);
                    } else {
                        requestMsg.copy((Msg)this._tempItemAggregationRequest, this.privateStreamCopyFlags);
                        if (requestMsg.checkHasView()) {
                            this._tempItemAggregationRequest.containerType(133);
                            this._tempItemAggregationRequest.applyHasView();
                            this._tempItemAggregationRequest.encodedDataBody(this._viewElemList);
                        }
                    }
                    this._tempItemAggregationRequest.streamId(wlStream.streamId());
                    this._tempItemAggregationRequest.msgKey().applyHasServiceId();
                    this._tempItemAggregationRequest.msgKey().serviceId(this._tempItemAggregationKey.msgKey().serviceId());
                    if (requestMsg.domainType() != 5) {
                        this._tempItemAggregationRequest.applyHasQos();
                        this._tempItemAggregationKey.qos().copy(this._tempItemAggregationRequest.qos());
                        this._tempItemAggregationRequest.flags(this._tempItemAggregationRequest.flags() & 0xFFFFFF7F);
                    }
                    if (requestMsg.checkHasPriority()) {
                        this._tempItemAggregationRequest.applyHasPriority();
                        this._tempItemAggregationRequest.priority().priorityClass(requestMsg.priority().priorityClass());
                        this._tempItemAggregationRequest.priority().count(requestMsg.priority().count());
                    } else if (!requestMsg.checkPrivateStream()) {
                        this._tempItemAggregationRequest.applyHasPriority();
                        this._tempItemAggregationRequest.priority().priorityClass(1);
                        this._tempItemAggregationRequest.priority().count(1);
                    }
                    if (this._tempItemAggregationRequest.checkMsgKeyInUpdates()) {
                        this._tempItemAggregationRequest.flags(this._tempItemAggregationRequest.flags() & 0xFFFFFFF7);
                    }
                    if (requestMsg.checkPause() && requestMsg.checkStreaming()) {
                        wlStream.numPausedRequestsCount(1);
                    }
                    if (sendNow) {
                        ret = wlStream.sendMsgOutOfLoop((Msg)this._tempItemAggregationRequest, submitOptions, this._errorInfo);
                        wlStream.refreshState(this._tempItemAggregationRequest.checkHasView() ? 2 : 1);
                    } else {
                        ret = wlStream.requestMsg(this._tempItemAggregationRequest);
                    }
                    if (requestMsg.domainType() != 5 && !requestMsg.checkNoRefresh()) {
                        wlService.numOutstandingRequests(wlService.numOutstandingRequests() + 1L);
                    }
                    if (ret >= 0) {
                        wlRequest.streamInfo().serviceName(submitOptions.serviceName());
                        wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
                        if (requestMsg.domainType() != 5) {
                            this._tempMatchedQos.copy(wlRequest.matchedQos());
                        }
                        this._streamList.add(wlStream);
                        WlInteger wlInteger = ReactorFactory.createWlInteger();
                        wlInteger.value(wlStream.streamId());
                        wlStream.tableKey(wlInteger);
                        this._watchlist.streamIdtoWlStreamTable().put(wlInteger, wlStream);
                        if (!requestMsg.checkPrivateStream()) {
                            this._itemAggregationKeytoWlStreamTable.put(itemAggregationKey, wlStream);
                        }
                        if (!requestMsg.checkPrivateStream()) {
                            wlStream.itemAggregationKey(itemAggregationKey);
                        }
                        wlStream.wlService(wlService);
                        wlService.streamList().add(wlStream);
                        wlRequest.state(WlRequest.State.PENDING_REFRESH);
                        wlStream.wlService(wlService);
                        if (!sendNow) {
                            this._pendingSendMsgList.add(wlStream);
                        }
                    } else {
                        wlStream.returnToPool();
                    }
                } else {
                    wlRequest.streamInfo().serviceName(submitOptions.serviceName());
                    wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
                    if (requestMsg.domainType() != 5) {
                        this._tempMatchedQos.copy(wlRequest.matchedQos());
                    }
                    wlRequest.stream(wlStream);
                    if (!wlStream.requestPending() || wlStream.refreshState() == 0 || wlStream.requestMsg().checkStreaming() && wlStream.refreshState() != 3 && wlStream.refreshState() != 2) {
                        if (requestMsg.checkHasView() && (ret = this.handleViews(wlRequest, errorInfo)) < 0) {
                            return ret;
                        }
                        wlStream.userRequestList().add(wlRequest);
                        if (wlRequest.requestMsg().checkPause() && wlRequest.requestMsg().checkStreaming()) {
                            wlStream.numPausedRequestsCount(wlStream.numPausedRequestsCount() + 1);
                        }
                        wlRequest.state(WlRequest.State.PENDING_REFRESH);
                        RequestMsg streamRequestMsg = wlStream.requestMsg();
                        if (!requestMsg.checkStreaming()) {
                            if (wlStream.refreshState() == 1) {
                                return ret;
                            }
                        } else {
                            if (requestMsg.checkHasPriority()) {
                                if (requestMsg.priority().priorityClass() > streamRequestMsg.priority().priorityClass()) {
                                    streamRequestMsg.priority().priorityClass(requestMsg.priority().priorityClass());
                                }
                                if (!streamRequestMsg.checkStreaming()) {
                                    streamRequestMsg.priority().count(requestMsg.priority().count());
                                } else {
                                    streamRequestMsg.priority().count(streamRequestMsg.priority().count() + requestMsg.priority().count());
                                }
                            } else {
                                streamRequestMsg.applyHasPriority();
                                if (!streamRequestMsg.checkStreaming()) {
                                    streamRequestMsg.priority().count(1);
                                } else {
                                    streamRequestMsg.priority().count(streamRequestMsg.priority().count() + 1);
                                }
                            }
                            if (!streamRequestMsg.checkStreaming()) {
                                streamRequestMsg.applyStreaming();
                            }
                        }
                        if (sendNow) {
                            if (requestMsg.domainType() != 5 && !wlStream.requestPending() && !requestMsg.checkNoRefresh()) {
                                wlService.numOutstandingRequests(wlService.numOutstandingRequests() + 1L);
                            }
                            ret = wlStream.sendMsgOutOfLoop((Msg)streamRequestMsg, submitOptions, this._errorInfo);
                            wlStream.refreshState(streamRequestMsg.checkHasView() ? 2 : 1);
                        } else if (!this._pendingSendMsgList.contains(wlStream)) {
                            this._pendingSendMsgList.add(wlStream);
                            if (requestMsg.domainType() != 5 && !wlStream.requestPending() && !requestMsg.checkNoRefresh()) {
                                wlService.numOutstandingRequests(wlService.numOutstandingRequests() + 1L);
                            }
                        } else {
                            RequestMsg pendingRequestMsg = this._pendingSendMsgList.get(this._pendingSendMsgList.indexOf(wlStream)).requestMsg();
                            if (pendingRequestMsg.checkPause() && !requestMsg.checkPause()) {
                                pendingRequestMsg.flags(pendingRequestMsg.flags() & 0xFFFFFDFF);
                            }
                        }
                    } else if (!(wlStream.requestMsg().checkStreaming() || wlStream.refreshState() != 1 || requestMsg.checkStreaming() || requestMsg.checkHasView())) {
                        wlRequest.state(WlRequest.State.PENDING_REFRESH);
                        wlStream.userRequestList().add(wlRequest);
                    } else {
                        wlRequest.state(WlRequest.State.PENDING_REQUEST);
                        wlStream.waitingRequestList().add(wlRequest);
                    }
                }
            } else {
                wlRequest.streamInfo().serviceName(submitOptions.serviceName());
                wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
                wlService.waitingRequestList().add(wlRequest);
            }
        } else {
            wlRequest.streamInfo().serviceName(submitOptions.serviceName());
            wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
            if (wlService == null) {
                errorInfo.error().text("Service not available");
            }
            if (this._userStreamIdListToRecover.size() == 0 || sendNow) {
                this.queueStatusForDispatch(requestMsg.streamId(), requestMsg.domainType(), errorInfo.error().text(), requestMsg.checkPrivateStream());
            } else {
                this._tempWlInteger.value(requestMsg.streamId());
                if (this._userStreamIdListToRecover.contains(this._tempWlInteger)) {
                    this.queueStatusForDispatch(requestMsg.streamId(), requestMsg.domainType(), errorInfo.error().text(), requestMsg.checkPrivateStream());
                }
            }
            if (!requestMsg.checkPrivateStream() && this._watchlist.loginHandler().supportSingleOpen()) {
                if (submitOptions.serviceName() == null) {
                    wlRequest.requestMsg().msgKey().serviceId(requestMsg.msgKey().serviceId());
                }
                this.addToPendingRequestTable(wlRequest, submitOptions);
            }
        }
        return ret;
    }

    int handleBatchRequest(WlRequest wlRequest, RequestMsg requestMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        ElementList elementList = CodecFactory.createElementList();
        ElementEntry elementEntry = CodecFactory.createElementEntry();
        Array batchArray = CodecFactory.createArray();
        ArrayEntry batchArrayEntry = CodecFactory.createArrayEntry();
        boolean foundBatch = false;
        int originalStreamId = requestMsg.streamId();
        int currentStreamId = requestMsg.streamId();
        Buffer itemName = CodecFactory.createBuffer();
        Buffer encodedDataBody = null;
        ArrayDeque<String> itemNames = new ArrayDeque<String>();
        int retDecodeVal = 0;
        if (requestMsg.msgKey().checkHasName()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.processBatchRequest", "Requested batch has name in message key.");
        }
        if (requestMsg.domainType() == 10 && (ret = this.extractSymbolListFromMsg(wlRequest, requestMsg, errorInfo)) < 0) {
            return ret;
        }
        this._dIterBatch.clear();
        this._dIterBatch.setBufferAndRWFVersion(requestMsg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
        wlRequest.streamInfo().serviceName(submitOptions.serviceName());
        wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
        WlInteger wlInteger = ReactorFactory.createWlInteger();
        wlInteger.value(requestMsg.streamId());
        this._watchlist.streamIdtoWlRequestTable().put(wlInteger, wlRequest);
        if (requestMsg.containerType() == 133) {
            retDecodeVal = elementList.decode(this._dIterBatch, null);
            if (retDecodeVal <= -1) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementList.decode() failure.");
            }
            int entryCount = 0;
            int itemListDataSize = 0;
            while ((retDecodeVal = elementEntry.decode(this._dIterBatch)) != 14) {
                if (retDecodeVal <= -1) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementEntry.decode() failure.");
                }
                ++entryCount;
                if (elementEntry.name().toString().contains(ElementNames.BATCH_ITEM_LIST.toString())) {
                    itemListDataSize = ElementNames.BATCH_ITEM_LIST.length();
                    itemListDataSize += elementEntry.encodedData().length();
                    foundBatch = true;
                    retDecodeVal = batchArray.decode(this._dIterBatch);
                    if (retDecodeVal <= -1) {
                        return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "Array.decode() failure.");
                    }
                    while ((retDecodeVal = batchArrayEntry.decode(this._dIterBatch)) != 14) {
                        retDecodeVal = itemName.decode(this._dIterBatch);
                        if (retDecodeVal == 0) {
                            itemNames.add(itemName.toString());
                            continue;
                        }
                        return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "Invalid BLANK_DATA while decoding :ItemList -- " + CodecReturnCodes.toString((int)ret));
                    }
                }
                if (!foundBatch || entryCount <= 1) continue;
                Buffer encodedBuffer = CodecFactory.createBuffer();
                encodedBuffer.data(ByteBuffer.allocate(requestMsg.encodedDataBody().length() - itemListDataSize));
                EncodeIterator encodeIter = CodecFactory.createEncodeIterator();
                ElementEntry elementEntryEnc = CodecFactory.createElementEntry();
                ElementList elementListEnc = CodecFactory.createElementList();
                DecodeIterator decodeIter = CodecFactory.createDecodeIterator();
                encodeIter.clear();
                encodeIter.setBufferAndRWFVersion(encodedBuffer, this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
                elementListEnc.clear();
                elementListEnc.flags(elementList.flags());
                if (elementList.checkHasInfo()) {
                    elementListEnc.elementListNum(elementList.elementListNum());
                }
                if (elementList.checkHasSetData()) {
                    elementListEnc.encodedSetData(elementList.encodedSetData());
                }
                if (elementList.checkHasSetId()) {
                    elementListEnc.setId(elementList.setId());
                }
                if ((ret = elementListEnc.encodeInit(encodeIter, null, 0)) <= -1) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementList.encodeInit() failure.");
                }
                decodeIter.clear();
                decodeIter.setBufferAndRWFVersion(requestMsg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
                ret = elementList.decode(decodeIter, null);
                if (ret <= -1) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementList.decode() failure.");
                }
                while ((ret = elementEntry.decode(decodeIter)) != 14) {
                    if (ret <= -1) {
                        return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementEntry.decode() failure.");
                    }
                    if (elementEntry.name().toString().contains(ElementNames.BATCH_ITEM_LIST.toString())) continue;
                    elementEntryEnc.clear();
                    elementEntryEnc.name(elementEntry.name());
                    elementEntryEnc.dataType(elementEntry.dataType());
                    elementEntryEnc.encodedData(elementEntry.encodedData());
                    ret = elementEntryEnc.encode(encodeIter);
                    if (ret > -1) continue;
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementEntry.encode() failure.");
                }
                ret = elementListEnc.encodeComplete(encodeIter, true);
                if (ret <= -1) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "ElementList.encodeComplete() failure.");
                }
                encodedDataBody = encodeIter.buffer();
                break;
            }
            if (!foundBatch) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", ":ItemList not found.");
            }
        } else {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "Unexpected container type or decoding error.");
        }
        this._tempWlInteger.value(++currentStreamId);
        if (this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger) != null) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "Item in batch has same ID as existing stream.");
        }
        HashMap<Integer, WlRequest> wlRequestList = new HashMap<Integer, WlRequest>(itemNames.size());
        HashMap<Integer, RequestMsg> requestMsgList = new HashMap<Integer, RequestMsg>(itemNames.size());
        int possibleStreamId = currentStreamId;
        while (!itemNames.isEmpty()) {
            itemName.data((String)itemNames.remove());
            this._tempWlInteger.value(possibleStreamId);
            if (this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger) != null) {
                while (!wlRequestList.isEmpty()) {
                    WlRequest removeWlRequest = (WlRequest)wlRequestList.remove(currentStreamId);
                    this.repoolWlRequest(removeWlRequest);
                    requestMsgList.remove(currentStreamId);
                    ++currentStreamId;
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "Item in batch has same ID as existing stream.");
            }
            WlRequest newWlRequest = ReactorFactory.createWlRequest();
            RequestMsg newRequestMsg = (RequestMsg)CodecFactory.createMsg();
            newWlRequest.handler(wlRequest.handler());
            newWlRequest.stream(wlRequest.stream());
            requestMsg.copy((Msg)newRequestMsg, 4063);
            newRequestMsg.flags(newRequestMsg.flags() & 0xFFFFF7FF);
            newRequestMsg.streamId(possibleStreamId);
            newRequestMsg.msgClass(1);
            newRequestMsg.applyMsgKeyInUpdates();
            newRequestMsg.msgKey().applyHasName();
            newRequestMsg.msgKey().name(itemName);
            if (encodedDataBody != null) {
                newRequestMsg.encodedDataBody(encodedDataBody);
            } else {
                newRequestMsg.containerType(128);
            }
            ret = newRequestMsg.copy((Msg)newWlRequest.requestMsg(), 4095);
            if (ret <= -1) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleBatchRequest", "RequestMsg.copy() failure.");
            }
            wlRequestList.put(possibleStreamId, newWlRequest);
            requestMsgList.put(possibleStreamId, newRequestMsg);
            ++possibleStreamId;
        }
        while (!wlRequestList.isEmpty()) {
            wlInteger = ReactorFactory.createWlInteger();
            wlInteger.value(currentStreamId);
            this._watchlist.streamIdtoWlRequestTable().put(wlInteger, (WlRequest)wlRequestList.get(currentStreamId));
            ret = this.handleRequest((WlRequest)wlRequestList.get(currentStreamId), (RequestMsg)requestMsgList.get(currentStreamId), submitOptions, true, errorInfo);
            if (ret <= -1) {
                return ret;
            }
            wlRequestList.remove(currentStreamId);
            requestMsgList.remove(currentStreamId);
            ++currentStreamId;
        }
        StatusMsg statusMsg = this._statusMsgPool.poll();
        if (statusMsg == null) {
            statusMsg = (StatusMsg)CodecFactory.createMsg();
        }
        statusMsg.clear();
        statusMsg.domainType(requestMsg.domainType());
        statusMsg.msgClass(3);
        statusMsg.streamId(originalStreamId);
        statusMsg.applyHasState();
        statusMsg.state().streamState(4);
        statusMsg.state().dataState(1);
        Buffer statusText = CodecFactory.createBuffer();
        statusText.data("Stream closed for batch");
        statusMsg.state().text(statusText);
        wlInteger = ReactorFactory.createWlInteger();
        wlInteger.value(originalStreamId);
        this._statusMsgDispatchList.put(wlInteger, statusMsg);
        if (this._statusMsgDispatchList.size() == 1) {
            this._watchlist.reactor().sendWatchlistDispatchNowEvent(this._watchlist.reactorChannel());
        }
        return ret;
    }

    int handleReissue(WlRequest wlRequest, RequestMsg requestMsg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (wlRequest.stream() == null) {
            ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleReissue", "Reissue request not allowed on an unopen stream.");
            return ret;
        }
        wlRequest._reissue_hasChange = !requestMsg.checkNoRefresh() && !requestMsg.checkPause();
        wlRequest._reissue_hasViewChange = false;
        if (requestMsg.domainType() == 10) {
            ret = this.extractSymbolListFromMsg(wlRequest, requestMsg, errorInfo);
            if (ret < 0) {
                return ret;
            }
            wlRequest._reissue_hasChange = true;
        }
        if (requestMsg.checkStreaming() == wlRequest.requestMsg().checkStreaming()) {
            if (requestMsg.checkStreaming()) {
                if (requestMsg.checkPause() && !wlRequest.requestMsg().checkPause()) {
                    wlRequest.stream().numPausedRequestsCount(wlRequest.stream().numPausedRequestsCount() + 1);
                    if (wlRequest.stream().numPausedRequestsCount() == wlRequest.stream()._userRequestList.size()) {
                        wlRequest._reissue_hasChange = true;
                    }
                }
                if (!requestMsg.checkPause() && wlRequest.requestMsg().checkPause()) {
                    wlRequest.stream().numPausedRequestsCount(wlRequest.stream().numPausedRequestsCount() - 1);
                    wlRequest._reissue_hasChange = true;
                }
            }
            RequestMsg streamRequestMsg = wlRequest.stream().requestMsg();
            boolean removeOldView = true;
            boolean effectiveViewChange = true;
            boolean repooled = false;
            WlRequest tempWlRequest = ReactorFactory.createWlRequest();
            if (requestMsg.checkHasView()) {
                if (requestMsg.encodedDataBody().data() == null) {
                    requestMsg.encodedDataBody(wlRequest.requestMsg().encodedDataBody());
                    requestMsg.containerType(wlRequest.requestMsg().containerType());
                }
                if ((ret = this.extractViewFromMsg(tempWlRequest, requestMsg, errorInfo)) < 0) {
                    if (!this._hasViewType && tempWlRequest._viewElemCount == 0) {
                        removeOldView = false;
                        wlRequest._reissue_hasViewChange = true;
                    } else {
                        return ret;
                    }
                }
                if (wlRequest.viewElemCount() > 0) {
                    if (wlRequest.viewType() != tempWlRequest.viewType()) {
                        ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleReissue", "Requested view type does not match existing stream.");
                        return ret;
                    }
                    if (this._wlViewHandler.aggregateViewContainsView(wlRequest.stream()._aggregateView, tempWlRequest) && streamRequestMsg.checkHasView()) {
                        effectiveViewChange = false;
                    }
                }
            }
            WlView oldView = null;
            if (wlRequest.viewElemCount() > 0 && removeOldView) {
                oldView = this.removeRequestView(wlRequest.stream(), wlRequest, errorInfo);
                wlRequest._reissue_hasViewChange = true;
            }
            if (requestMsg.checkHasView()) {
                this.extractViewFromMsg(wlRequest, requestMsg, errorInfo);
                ret = this.handleViews(wlRequest, errorInfo);
                if (ret < 0) {
                    return ret;
                }
                wlRequest._reissue_hasViewChange = true;
                if (this._wlViewHandler.aggregateViewContainsNewViews(wlRequest.stream()._aggregateView) && streamRequestMsg.checkHasView()) {
                    wlRequest._reissue_hasViewChange = false;
                }
                if (!streamRequestMsg.checkHasView() && wlRequest.stream()._requestsWithViewCount != wlRequest.stream()._userRequestList.size()) {
                    wlRequest._reissue_hasViewChange = false;
                }
                if (!effectiveViewChange) {
                    wlRequest._reissue_hasViewChange = false;
                }
            }
            if (tempWlRequest != null) {
                this.repoolWlRequest(tempWlRequest);
                repooled = true;
            }
            if (requestMsg.checkNoRefresh()) {
                streamRequestMsg.applyNoRefresh();
            }
            if (requestMsg.checkHasPriority()) {
                if (!wlRequest.requestMsg().checkHasPriority()) {
                    wlRequest.requestMsg().applyHasPriority();
                    wlRequest.requestMsg().priority().priorityClass(1);
                    wlRequest.requestMsg().priority().count(1);
                }
                if (requestMsg.priority().priorityClass() != wlRequest.requestMsg().priority().priorityClass() && (streamRequestMsg.checkPrivateStream() || requestMsg.priority().priorityClass() > streamRequestMsg.priority().priorityClass())) {
                    streamRequestMsg.priority().priorityClass(requestMsg.priority().priorityClass());
                    wlRequest._reissue_hasChange = true;
                }
                if (requestMsg.priority().count() != wlRequest.requestMsg().priority().count()) {
                    int priorityCountDiff = requestMsg.priority().count() - wlRequest.requestMsg().priority().count();
                    streamRequestMsg.priority().count(streamRequestMsg.priority().count() + priorityCountDiff);
                    wlRequest._reissue_hasChange = true;
                }
            }
            if (requestMsg.domainType() == 5 && requestMsg.msgKey().filter() != streamRequestMsg.msgKey().filter()) {
                streamRequestMsg.msgKey().filter(requestMsg.msgKey().filter());
                wlRequest._reissue_hasChange = true;
            }
            if (wlRequest.stream().state().streamState() == 1) {
                if (wlRequest.stream().refreshState() != 3) {
                    if (wlRequest._reissue_hasChange || wlRequest._reissue_hasViewChange) {
                        if (wlRequest._reissue_hasViewChange) {
                            wlRequest.stream()._pendingViewChange = true;
                        }
                        ret = wlRequest.stream().sendMsgOutOfLoop((Msg)streamRequestMsg, submitOptions, this._errorInfo);
                        if (!repooled && oldView != null && wlRequest._reissue_hasViewChange) {
                            if (requestMsg.checkNoRefresh()) {
                                wlRequest.stream().refreshState(2);
                            }
                            this._wlViewHandler.destroyView(oldView);
                        }
                        if (!requestMsg.checkNoRefresh()) {
                            wlRequest.state(WlRequest.State.PENDING_REFRESH);
                        }
                    }
                    if (streamRequestMsg.checkNoRefresh()) {
                        streamRequestMsg.flags(streamRequestMsg.flags() & 0xFFFFFFDF);
                    }
                    if (this._hasPendingViewRequest) {
                        wlRequest.stream().waitingRequestList().add(wlRequest);
                        this._hasPendingViewRequest = false;
                    }
                } else if (wlRequest._reissue_hasChange) {
                    wlRequest.stream().waitingRequestList().add(wlRequest);
                }
            } else {
                ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleReissue", "Reissue requests must occur while stream state is known as open.");
            }
        } else {
            ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.handleReissue", "Reissue requests may not alter streaming flag.");
        }
        return ret;
    }

    boolean canItemBeOpened(RequestMsg requestMsg, ReactorSubmitOptions submitOptions, Qos matchedQos, Qos staticQos, Service service, ReactorErrorInfo errorInfo) {
        boolean ret = false;
        if (this.isServiceUpAndAcceptingRequests(service)) {
            if (this.isCapabilitySupported(requestMsg.domainType(), service)) {
                if (requestMsg.domainType() != 5) {
                    if (staticQos == null) {
                        if (requestMsg.checkHasQos()) {
                            Qos worstQos = null;
                            Qos qos = requestMsg.qos();
                            if (requestMsg.checkHasWorstQos()) {
                                worstQos = requestMsg.worstQos();
                            }
                            if (this.isQosSupported(qos, worstQos, service, matchedQos)) {
                                ret = true;
                            } else {
                                errorInfo.error().text("Service does not provide a matching QoS");
                            }
                        } else {
                            if (service.info().qosList().size() > 0) {
                                service.info().bestQos().copy(matchedQos);
                            } else {
                                matchedQos.rate(1);
                                matchedQos.timeliness(1);
                            }
                            ret = true;
                        }
                    } else if (this.isQosSupported(staticQos, null, service, matchedQos)) {
                        ret = true;
                    } else {
                        errorInfo.error().text("Service does not provide a matching QoS");
                    }
                } else {
                    ret = true;
                }
            } else {
                errorInfo.error().text("Capability not supported");
            }
        } else {
            errorInfo.error().text("Service not up");
        }
        return ret;
    }

    WlStream findItemAggregationStream(RequestMsg requestMsg, Qos matchedQos, ReactorSubmitOptions submitOptions) {
        WlStream wlStream = null;
        this._tempItemAggregationKey.clear();
        requestMsg.msgKey().copy(this._tempItemAggregationKey.msgKey());
        if (submitOptions.serviceName() != null) {
            int serviceId = this._watchlist.directoryHandler().serviceId(submitOptions.serviceName());
            this._tempItemAggregationKey.msgKey().applyHasServiceId();
            this._tempItemAggregationKey.msgKey().serviceId(serviceId);
        }
        this._tempItemAggregationKey.domainType(requestMsg.domainType());
        this._tempItemAggregationKey.qos(matchedQos);
        if (!requestMsg.checkPrivateStream()) {
            wlStream = this._itemAggregationKeytoWlStreamTable.get(this._tempItemAggregationKey);
        }
        return wlStream;
    }

    void addToPendingRequestTable(WlRequest wlRequest, ReactorSubmitOptions submitOptions) {
        wlRequest.stream(null);
        LinkedHashSet<WlRequest> pendingRequestList = null;
        if (submitOptions.serviceName() != null) {
            pendingRequestList = this._pendingRequestByNameTable.get(submitOptions.serviceName());
        } else {
            this._tempWlInteger.value(wlRequest.requestMsg().msgKey().serviceId());
            pendingRequestList = this._pendingRequestByIdTable.get(this._tempWlInteger);
        }
        if (pendingRequestList != null) {
            pendingRequestList.add(wlRequest);
        } else {
            pendingRequestList = this._pendingRequestListPool.poll();
            if (pendingRequestList == null) {
                pendingRequestList = new LinkedHashSet();
            }
            pendingRequestList.add(wlRequest);
            if (submitOptions.serviceName() != null) {
                this._pendingRequestByNameTable.put(submitOptions.serviceName(), pendingRequestList);
            } else {
                WlInteger wlInteger = ReactorFactory.createWlInteger();
                wlInteger.value(wlRequest.requestMsg().msgKey().serviceId());
                this._pendingRequestByIdTable.put(wlInteger, pendingRequestList);
            }
        }
    }

    WlStream createNewStream(RequestMsg requestMsg) {
        WlStream wlStream = ReactorFactory.createWlStream();
        wlStream.handler(this);
        wlStream.watchlist(this._watchlist);
        wlStream.streamId(this._watchlist.nextStreamId());
        wlStream.domainType(requestMsg.domainType());
        wlStream._pendingViewChange = false;
        wlStream._requestsWithViewCount = 0;
        wlStream.refreshState(0);
        return wlStream;
    }

    boolean isServiceUpAndAcceptingRequests(Service service) {
        return !(this._watchlist.reactorChannel().state() != ReactorChannel.State.UP && this._watchlist.reactorChannel().state() != ReactorChannel.State.READY || !service.checkHasState() || service.state().checkHasAcceptingRequests() && service.state().acceptingRequests() != 1L || service.state().serviceState() != 1L);
    }

    boolean isCapabilitySupported(int domainType, Service service) {
        boolean ret = false;
        if (service.checkHasInfo()) {
            for (int i = 0; i < service.info().capabilitiesList().size(); ++i) {
                if (service.info().capabilitiesList().get(i) != (long)domainType) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    boolean isQosSupported(Qos qos, Qos worstQos, Service service, Qos matchedQos) {
        boolean ret = false;
        if (service.checkHasInfo()) {
            if (service.info().checkHasQos()) {
                for (int i = 0; i < service.info().qosList().size(); ++i) {
                    Qos serviceQos = service.info().qosList().get(i);
                    if (worstQos == null) {
                        if (!serviceQos.equals(qos)) continue;
                        ret = true;
                        serviceQos.copy(matchedQos);
                        break;
                    }
                    if (!serviceQos.isInRange(qos, worstQos) || !serviceQos.isBetter(matchedQos)) continue;
                    ret = true;
                    serviceQos.copy(matchedQos);
                }
            } else {
                ret = worstQos == null ? this._defaultQos.equals(qos) : this._defaultQos.isInRange(qos, worstQos);
                if (ret) {
                    this._defaultQos.copy(matchedQos);
                }
            }
        }
        if (ret) {
            matchedQos.dynamic(qos.isDynamic());
        }
        return ret;
    }

    boolean isWindowOpen(WlService wlService) {
        long openWindow;
        boolean ret = true;
        if (this._watchlist.watchlistOptions().obeyOpenWindow() && wlService.rdmService().checkHasLoad() && wlService.rdmService().load().checkHasOpenWindow() && ((openWindow = wlService.rdmService().load().openWindow()) == 0L || wlService.numOutstandingRequests() == openWindow)) {
            ret = false;
        }
        return ret;
    }

    @Override
    public int submitMsg(WlRequest wlRequest, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        switch (msg.msgClass()) {
            case 5: {
                WlStream wlStream = wlRequest.stream();
                if (wlStream != null) {
                    if (wlStream.requestPending() && wlStream.wlService() != null) {
                        wlStream.wlService().numOutstandingRequests(wlStream.wlService().numOutstandingRequests() - 1L);
                    }
                    ret = this.removeUserRequestFromOpenStream(wlRequest, msg, wlStream, submitOptions, errorInfo);
                    break;
                }
                ret = this.removeUserRequestFromClosedStream(wlRequest);
                break;
            }
            case 8: {
                if (this._watchlist.loginHandler().supportPost()) {
                    if (wlRequest.state() == WlRequest.State.OPEN) {
                        return this.handlePost(wlRequest, msg, submitOptions, errorInfo);
                    }
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.submitMsg", "Cannot submit PostMsg when stream not in open state.");
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.submitMsg", "Posting not supported by provider");
            }
            case 7: {
                if (wlRequest.state() == WlRequest.State.OPEN) {
                    boolean resetServiceId = false;
                    if (submitOptions.serviceName() != null) {
                        if (!((GenericMsg)msg).checkHasMsgKey()) {
                            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.submitMsg", "Generic message submitted with service name but no message key.");
                        }
                        ret = this._watchlist.changeServiceNameToID(((GenericMsg)msg).msgKey(), submitOptions.serviceName(), errorInfo);
                        if (ret < 0) {
                            return ret;
                        }
                        resetServiceId = true;
                    }
                    msg.streamId(wlRequest.stream().streamId());
                    ret = wlRequest.stream().sendMsgOutOfLoop(msg, submitOptions, errorInfo);
                    if (resetServiceId) {
                        msg.msgKey().flags(msg.msgKey().flags() & 0xFFFFFFFE);
                        msg.msgKey().serviceId(0);
                    }
                    if (ret >= 0) break;
                    return ret;
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.submitMsg", "Cannot submit GenericMsg when stream not in open state.");
            }
            default: {
                ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.submitMsg", "Invalid message class (" + msg.msgClass() + ") submitted to Watchlist item handler");
            }
        }
        return ret;
    }

    private int removeUserRequestFromOpenStream(WlRequest wlRequest, Msg msg, WlStream wlStream, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        WlRequest wlRequestInList;
        int ret = 0;
        Iterator wlRequestIter = wlStream.waitingRequestList().iterator();
        while (wlRequestIter.hasNext()) {
            wlRequestInList = (WlRequest)wlRequestIter.next();
            if (wlRequestInList.requestMsg().streamId() != wlRequest.requestMsg().streamId()) continue;
            wlRequestIter.remove();
            this.closeWlRequest(wlRequest);
            this.repoolWlRequest(wlRequest);
            return ret;
        }
        wlRequestIter = wlStream.userRequestList().iterator();
        while (wlRequestIter.hasNext()) {
            wlRequestInList = (WlRequest)wlRequestIter.next();
            if (wlRequestInList.requestMsg().streamId() != wlRequest.requestMsg().streamId()) continue;
            wlRequestIter.remove();
            wlStream.refreshState(0);
            if (wlRequest.requestMsg().checkPause()) {
                wlStream.numPausedRequestsCount(wlStream.numPausedRequestsCount() - 1);
            }
            if (wlRequest.requestMsg().checkHasView() && wlStream._requestsWithViewCount > 0) {
                this.removeRequestView(wlStream, wlRequest, errorInfo);
                wlStream._pendingViewChange = true;
            } else if (wlStream._requestsWithViewCount > 0) {
                wlStream._pendingViewChange = true;
            }
            if (wlStream.state().streamState() == 1) {
                if (wlStream.userRequestList().size() == 0) {
                    this.closeWlStream(wlRequest.stream());
                    msg.copy((Msg)this._closeMsg, 0);
                    this._closeMsg.streamId(wlRequest.stream().streamId());
                    ret = wlRequest.stream().sendMsgOutOfLoop((Msg)this._closeMsg, submitOptions, errorInfo);
                    if (ret < 0) {
                        return ret;
                    }
                    if (wlStream == this._currentFanoutStream) {
                        this._currentFanoutStream = null;
                    } else {
                        wlRequest.stream().returnToPool();
                    }
                } else {
                    int streamPriorityCount = wlRequest.stream().requestMsg().checkHasPriority() ? wlRequest.stream().requestMsg().priority().count() : 1;
                    int userRequestPriorityCount = wlRequest.requestMsg().checkHasPriority() ? wlRequest.requestMsg().priority().count() : 1;
                    wlRequest.stream().requestMsg().priority().count(streamPriorityCount - userRequestPriorityCount);
                    wlRequest.stream().requestMsg().flags(wlStream.requestMsg().flags() | 0x20);
                    wlRequest.stream().sendMsgOutOfLoop((Msg)wlRequest.stream().requestMsg(), submitOptions, errorInfo);
                    wlRequest.stream().requestMsg().flags(wlStream.requestMsg().flags() & 0xFFFFFFDF);
                }
            }
            this.closeWlRequest(wlRequest);
            this.repoolWlRequest(wlRequest);
            break;
        }
        this._requestTimeoutList.remove(wlRequest);
        return ret;
    }

    private int removeUserRequestFromClosedStream(WlRequest wlRequest) {
        int ret = 0;
        this._tempWlInteger.value(wlRequest.requestMsg().streamId());
        this._userStreamIdListToRecover.remove(this._tempWlInteger);
        this._tempWlInteger.value(wlRequest.requestMsg().streamId());
        StatusMsg statusMsg = (StatusMsg)this._statusMsgDispatchList.remove(this._tempWlInteger);
        if (statusMsg != null) {
            this._statusMsgPool.add(statusMsg);
        }
        Iterator<Map.Entry<WlInteger, LinkedHashSet<WlRequest>>> I = this._pendingRequestByIdTable.entrySet().iterator();
        while (I.hasNext()) {
            Map.Entry<WlInteger, LinkedHashSet<WlRequest>> entry = I.next();
            LinkedHashSet<WlRequest> pendingRequests = entry.getValue();
            pendingRequests.remove(wlRequest);
            if (!pendingRequests.isEmpty()) continue;
            entry.getKey().returnToPool();
            I.remove();
            this._pendingRequestListPool.add(pendingRequests);
        }
        Iterator<Map.Entry<String, LinkedHashSet<WlRequest>>> J = this._pendingRequestByNameTable.entrySet().iterator();
        while (J.hasNext()) {
            Map.Entry<String, LinkedHashSet<WlRequest>> entry = J.next();
            LinkedHashSet<WlRequest> pendingRequests = entry.getValue();
            pendingRequests.remove(wlRequest);
            if (!pendingRequests.isEmpty()) continue;
            J.remove();
            this._pendingRequestListPool.add(pendingRequests);
        }
        this.closeWlRequest(wlRequest);
        this.repoolWlRequest(wlRequest);
        return ret;
    }

    int handlePost(WlRequest wlRequest, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        WlStream wlStream = wlRequest.stream();
        if (this._watchlist.numOutstandingPosts() < this._watchlist.watchlistOptions().maxOutstandingPosts()) {
            boolean resetServiceId = false;
            ret = wlStream.validatePostSubmit((PostMsg)msg, errorInfo);
            if (ret != 0) {
                return ret;
            }
            if (submitOptions.serviceName() != null) {
                if (!((PostMsg)msg).checkHasMsgKey()) {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.handlePost", "Post message submitted with service name but no message key.");
                }
                ret = this._watchlist.changeServiceNameToID(((PostMsg)msg).msgKey(), submitOptions.serviceName(), errorInfo);
                if (ret < 0) {
                    return ret;
                }
                resetServiceId = true;
            }
            int userStreamId = msg.streamId();
            msg.streamId(wlStream._streamId);
            ret = wlStream.sendMsgOutOfLoop(msg, submitOptions, errorInfo);
            msg.streamId(userStreamId);
            if (resetServiceId && (!((PostMsg)msg).checkAck() || ret < 0)) {
                ((PostMsg)msg).msgKey().flags(((PostMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                ((PostMsg)msg).msgKey().serviceId(0);
                resetServiceId = false;
            }
            if (ret < 0) {
                return ret;
            }
            if (((PostMsg)msg).checkAck()) {
                this._watchlist.numOutstandingPosts(this._watchlist.numOutstandingPosts() + 1);
                ret = wlStream.updatePostTables((PostMsg)msg, errorInfo);
                if (resetServiceId) {
                    ((PostMsg)msg).msgKey().flags(((PostMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                    ((PostMsg)msg).msgKey().serviceId(0);
                }
            }
        } else {
            ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlItemHandler.handlePost", "maxOutstandingPosts limit reached.");
        }
        return ret;
    }

    int sendStatus(int streamId, int domainType, String text, boolean privateStream) {
        this._statusMsg.streamId(streamId);
        this._statusMsg.domainType(domainType);
        this._statusMsg.applyHasState();
        if (!privateStream && (this._watchlist.loginHandler().supportSingleOpen() || this._watchlist.loginHandler().supportAllowSuspectData())) {
            this._statusMsg.state().streamState(1);
        } else {
            this._statusMsg.state().streamState(3);
        }
        this._statusMsg.state().dataState(2);
        this._statusMsg.state().text().data(text);
        this._tempWlInteger.value(this._statusMsg.streamId());
        return this.callbackUser("WlItemHandler.sendStatus", (Msg)this._statusMsg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo);
    }

    void queueStatusForDispatch(int streamId, int domainType, String text, boolean privateStream) {
        StatusMsg statusMsg = this._statusMsgPool.poll();
        if (statusMsg == null) {
            statusMsg = (StatusMsg)CodecFactory.createMsg();
        }
        statusMsg.clear();
        statusMsg.msgClass(3);
        statusMsg.streamId(streamId);
        statusMsg.domainType(domainType);
        statusMsg.applyHasState();
        if (!privateStream && this._watchlist.loginHandler().supportSingleOpen()) {
            statusMsg.state().streamState(1);
        } else {
            statusMsg.state().streamState(3);
        }
        statusMsg.state().dataState(2);
        statusMsg.state().text().data(text);
        WlInteger wlInteger = ReactorFactory.createWlInteger();
        wlInteger.value(streamId);
        this._statusMsgDispatchList.put(wlInteger, statusMsg);
        if (this._statusMsgDispatchList.size() == 1) {
            this._watchlist.reactor().sendWatchlistDispatchNowEvent(this._watchlist.reactorChannel());
        }
    }

    void removeWlStreamFromService(WlStream wlStream) {
        this.removeStreamFromItemGroup(wlStream);
        wlStream.wlService().streamList().remove(wlStream);
        wlStream.wlService(null);
    }

    void closeWlStream(WlStream wlStream) {
        if (wlStream.itemAggregationKey() != null) {
            this._itemAggregationKeytoWlStreamTable.remove(wlStream.itemAggregationKey());
            wlStream.itemAggregationKey().returnToPool();
            wlStream.itemAggregationKey(null);
        }
        this._pendingSendMsgList.remove(wlStream);
        this._streamList.remove(wlStream);
        if (wlStream.wlService() != null) {
            this.removeWlStreamFromService(wlStream);
        }
        wlStream.close();
    }

    @Override
    public int readMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, boolean wsbSendCloseRecover, ReactorErrorInfo errorInfo) {
        int ret = 0;
        WlService wlService = wlStream.wlService();
        this._currentFanoutStream = wlStream;
        this._msgState = null;
        switch (msg.msgClass()) {
            case 2: {
                RefreshMsg refreshMsg = (RefreshMsg)msg;
                this._msgState = refreshMsg.state();
                this.readRefreshMsg(wlStream, refreshMsg, errorInfo);
                break;
            }
            case 3: {
                StatusMsg statusMsg = (StatusMsg)msg;
                if (statusMsg.checkHasState()) {
                    this._msgState = statusMsg.state();
                }
                this.readStatusMsg(wlStream, (Msg)statusMsg, errorInfo);
                break;
            }
            case 4: {
                ret = this.readUpdateMsg(wlStream, msg, errorInfo);
                break;
            }
            case 7: {
                ret = this.readGenericMsg(wlStream, msg, errorInfo);
                break;
            }
            case 6: {
                ret = this.readAckMsg(wlStream, msg, errorInfo);
                break;
            }
            default: {
                ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlItemHandler.readMsg", "Invalid message class (" + msg.msgClass() + ") received by Watchlist directory handler");
            }
        }
        if (this._currentFanoutStream == null) {
            wlStream.returnToPool();
        } else if (this._msgState != null) {
            assert (this._msgState.streamState() != 1);
            wlStream.userRequestList().addAll(wlStream.waitingRequestList());
            wlStream.waitingRequestList().clear();
            this.closeWlStream(wlStream);
            WlRequest usrRequest = null;
            usrRequest = wlStream.userRequestList().poll();
            while (usrRequest != null) {
                msg.streamId(usrRequest.requestMsg().streamId());
                msg.domainType(usrRequest.requestMsg().domainType());
                if (this._watchlist.isRequestRecoverable(usrRequest, this._msgState.streamState()) && !wsbSendCloseRecover) {
                    int origDataState = this._msgState.dataState();
                    WlInteger wlInteger = ReactorFactory.createWlInteger();
                    wlInteger.value(usrRequest.requestMsg().streamId());
                    this._userStreamIdListToRecover.add(wlInteger);
                    usrRequest.state(WlRequest.State.PENDING_REQUEST);
                    this._msgState.streamState(1);
                    this._msgState.dataState(2);
                    this._submitOptions.serviceName(usrRequest.streamInfo().serviceName());
                    this._submitOptions.requestMsgOptions().userSpecObj(usrRequest.streamInfo().userSpecObject());
                    this.addToPendingRequestTable(usrRequest, this._submitOptions);
                    ret = this.callbackUser("WlItemHandler.readMsg", msg, null, usrRequest, errorInfo);
                    if (ret < 0) break;
                    this._msgState.streamState(3);
                    this._msgState.dataState(origDataState);
                } else {
                    this.closeWlRequest(usrRequest);
                    ret = this.callbackUser("WlItemHandler.readMsg", msg, null, usrRequest, errorInfo);
                    if (ret < 0) break;
                    this.repoolWlRequest(usrRequest);
                }
                usrRequest = wlStream.userRequestList().poll();
            }
            if (ret < 0) {
                wlStream.returnToPool();
                this._currentFanoutStream = null;
                return ret;
            }
            wlStream.returnToPool();
            if (wlService != null) {
                this.serviceAdded(wlService);
            }
        }
        if (wlService != null && wlService.waitingRequestList().size() > 0 && msg.msgClass() != 2) {
            WlRequest waitingRequest = wlService.waitingRequestList().poll();
            this._submitOptions.serviceName(waitingRequest.streamInfo().serviceName());
            this._submitOptions.requestMsgOptions().userSpecObj(waitingRequest.streamInfo().userSpecObject());
            ret = this.handleRequest(waitingRequest, waitingRequest.requestMsg(), this._submitOptions, true, this._errorInfo);
        }
        this._currentFanoutStream = null;
        return ret;
    }

    int readRefreshMsg(WlStream wlStream, RefreshMsg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._snapshotViewClosed = false;
        int currentViewCount = 0;
        boolean isRefreshComplete = msg.checkRefreshComplete();
        boolean fanoutViewPendingRefresh = wlStream.refreshState() == 2 && wlStream.aggregateView() != null && wlStream.aggregateView().elemCount() != wlStream._requestsWithViewCount;
        boolean solicitedRefresh = wlStream.refreshState() == 1 || wlStream.refreshState() == 3;
        WlService wlService = wlStream.wlService();
        if (msg.checkSolicited()) {
            wlStream.responseReceived();
        }
        if (msg.domainType() == 10) {
            this.handleSymbolList(wlStream, (Msg)msg, errorInfo);
        }
        msg.state().copy(wlStream.state());
        if (msg.state().streamState() != 1 && msg.state().streamState() != 2) {
            return 0;
        }
        int listSize = wlStream.userRequestList().size();
        if (isRefreshComplete && listSize != 0) {
            wlService.numOutstandingRequests(wlService.numOutstandingRequests() - 1L);
        }
        int numRequestsProcessed = 0;
        for (int i = 0; i < wlStream.userRequestList().size() && numRequestsProcessed < listSize; ++i) {
            ++numRequestsProcessed;
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            wlRequest.handlePendingViewFanout(fanoutViewPendingRefresh);
            if ((wlRequest.requestMsg().checkNoRefresh() || msg.checkSolicited() && !wlRequest.solicitedRefreshNeededForView(solicitedRefresh) && wlRequest.state() != WlRequest.State.PENDING_REFRESH && wlRequest.state() != WlRequest.State.PENDING_COMPLETE_REFRESH) && !fanoutViewPendingRefresh) continue;
            if (isRefreshComplete) {
                wlStream.refreshState(0);
                this.removeStreamFromItemGroup(wlStream);
                WlItemGroup wlItemGroup = wlService.itemGroupTableGet(msg.groupId());
                if (wlItemGroup == null) {
                    Buffer groupId = CodecFactory.createBuffer();
                    groupId.data(ByteBuffer.allocate(msg.groupId().length()));
                    msg.groupId().copy(groupId);
                    wlItemGroup = ReactorFactory.createWlItemGroup();
                    wlItemGroup.groupId(groupId);
                    wlItemGroup.wlService(wlService);
                    wlService.itemGroupTablePut(groupId, wlItemGroup);
                }
                this.addStreamToItemGroup(wlItemGroup, wlStream);
                if (wlRequest.requestMsg().checkStreaming() && msg.state().streamState() != 2) {
                    wlRequest.state(WlRequest.State.OPEN);
                    if (msg.domainType() != 5 && !wlRequest.hasStaticQos() && !wlRequest.matchedQos().isDynamic()) {
                        wlRequest.hasStaticQos(true);
                    }
                } else if (wlRequest.requestMsg().checkStreaming() && wlRequest.requestMsg().checkPause()) {
                    wlRequest.stream().numPausedRequestsCount(wlRequest.stream().numPausedRequestsCount() - 1);
                }
            } else if (wlRequest.state() == WlRequest.State.PENDING_REFRESH) {
                wlRequest.state(WlRequest.State.PENDING_COMPLETE_REFRESH);
                wlStream.refreshState(3);
                wlStream.startRequestTimer(errorInfo);
            }
            msg.streamId(wlRequest.requestMsg().streamId());
            int tmpStreamState = msg.state().streamState();
            if (!wlRequest.requestMsg().checkStreaming() && tmpStreamState == 1) {
                msg.state().streamState(2);
            }
            if ((!wlRequest.requestMsg().checkStreaming() || msg.state().streamState() == 2) && isRefreshComplete) {
                wlStream.userRequestList().remove(i--);
                if (wlStream._requestsWithViewCount > 0) {
                    if (wlRequest.requestMsg().checkHasView()) {
                        this.removeRequestView(wlStream, wlRequest, errorInfo);
                    }
                    wlStream._pendingViewChange = true;
                    this._snapshotViewClosed = true;
                    currentViewCount = wlStream._requestsWithViewCount;
                }
                this.closeWlRequest(wlRequest);
                boolean allRequestsClosed = wlStream.userRequestList().size() == 0 && wlStream.waitingRequestList().size() == 0;
                wlStream.refreshState(0);
                if (allRequestsClosed) {
                    this.closeWlStream(wlStream);
                }
                ret = this.callbackUser("WlItemHandler.readRefreshMsg", (Msg)msg, null, wlRequest, errorInfo);
                wlRequest.returnToPool();
                if (ret < 0) break;
                if (allRequestsClosed) {
                    this._currentFanoutStream = null;
                    break;
                }
            } else {
                this._tempWlInteger.value(msg.streamId());
                ret = this.callbackUser("WlItemHandler.readRefreshMsg", (Msg)msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
                if (ret < 0) break;
            }
            msg.state().streamState(tmpStreamState);
        }
        if (this._currentFanoutStream != null) {
            if (wlStream.waitingRequestList().size() > 0 && wlStream.refreshState() != 3) {
                WlRequest waitingRequest = null;
                while (wlStream.refreshState() < 1 && (waitingRequest = wlStream.waitingRequestList().poll()) != null) {
                    this._submitOptions.serviceName(waitingRequest.streamInfo().serviceName());
                    this._submitOptions.requestMsgOptions().userSpecObj(waitingRequest.streamInfo().userSpecObject());
                    ret = waitingRequest._reissue_hasViewChange ? this.handleReissue(waitingRequest, waitingRequest.requestMsg(), this._submitOptions, errorInfo) : this.handleRequest(waitingRequest, waitingRequest.requestMsg(), this._submitOptions, true, errorInfo);
                    if (ret >= 0) continue;
                    return ret;
                }
            }
            if (this._snapshotViewClosed) {
                this._snapshotViewClosed = false;
                if (currentViewCount > 0 && wlStream._requestsWithViewCount == currentViewCount && wlStream.userRequestList().size() > 0 && (this._wlViewHandler.resorted() || !this._wlViewHandler.commitedViewsContainsAggregateView(wlStream._aggregateView)) && wlStream._requestsWithViewCount == wlStream._userRequestList.size()) {
                    wlStream.requestMsg().flags(wlStream.requestMsg().flags() | 0x20);
                    wlStream.sendMsgOutOfLoop((Msg)wlStream.requestMsg(), this._submitOptions, errorInfo);
                    wlStream.requestMsg().flags(wlStream.requestMsg().flags() & 0xFFFFFFDF);
                    if (this._wlViewHandler.resorted()) {
                        this._wlViewHandler.resorted(false);
                    }
                }
            }
        }
        if (wlService != null && wlService.waitingRequestList().size() > 0 && isRefreshComplete) {
            WlRequest waitingRequest = wlService.waitingRequestList().poll();
            this._submitOptions.serviceName(waitingRequest.streamInfo().serviceName());
            this._submitOptions.requestMsgOptions().userSpecObj(waitingRequest.streamInfo().userSpecObject());
            ret = this.handleRequest(waitingRequest, waitingRequest.requestMsg(), this._submitOptions, true, errorInfo);
            if (ret < 0) {
                return ret;
            }
        }
        this._msgState = null;
        return ret;
    }

    int readUpdateMsg(WlStream wlStream, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (msg.domainType() == 10) {
            this.handleSymbolList(wlStream, msg, errorInfo);
        }
        for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            if (wlRequest.state() != WlRequest.State.PENDING_COMPLETE_REFRESH && wlRequest.state() != WlRequest.State.OPEN) continue;
            msg.streamId(wlRequest.requestMsg().streamId());
            this._tempWlInteger.value(msg.streamId());
            ret = this.callbackUser("WlItemHandler.readUpdateMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
            if (ret < 0) break;
        }
        return ret;
    }

    int readStatusMsg(WlStream wlStream, Msg msg, ReactorErrorInfo errorInfo) {
        if (wlStream.wlService() != null && wlStream.requestPending()) {
            wlStream.wlService().numOutstandingRequests(wlStream.wlService().numOutstandingRequests() - 1L);
        }
        wlStream.responseReceived();
        if (((StatusMsg)msg).checkHasState()) {
            ((StatusMsg)msg).state().copy(wlStream.state());
        }
        if (!((StatusMsg)msg).checkHasState() || ((StatusMsg)msg).state().streamState() == 1) {
            for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
                WlRequest wlRequest = wlStream.userRequestList().get(i);
                msg.streamId(wlRequest.requestMsg().streamId());
                this._tempWlInteger.value(msg.streamId());
                if (this.callbackUser("WlItemHandler.readStatusMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo) < 0) break;
            }
            this._msgState = null;
        }
        return 0;
    }

    int readGenericMsg(WlStream wlStream, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            if (wlRequest.state() != WlRequest.State.PENDING_REFRESH && wlRequest.state() != WlRequest.State.PENDING_COMPLETE_REFRESH && wlRequest.state() != WlRequest.State.OPEN) continue;
            msg.streamId(wlRequest.requestMsg().streamId());
            this._tempWlInteger.value(msg.streamId());
            ret = this.callbackUser("WlItemHandler.readGenericMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
            if (ret < 0) break;
        }
        return ret;
    }

    int readAckMsg(WlStream wlStream, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (wlStream.handlePostAck(msg)) {
            this._tempWlInteger.value(msg.streamId());
            ret = this.callbackUser("WlItemHandler.readAckMsg", msg, null, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
        }
        return ret;
    }

    int dispatch(ReactorErrorInfo errorInfo) {
        int ret = 0;
        StatusMsg statusMsg = null;
        Iterator<Map.Entry<WlInteger, StatusMsg>> statusMsgIter = this._statusMsgDispatchList.entrySet().iterator();
        while (statusMsgIter.hasNext()) {
            boolean requestClosed;
            Map.Entry<WlInteger, StatusMsg> entry = statusMsgIter.next();
            statusMsg = entry.getValue();
            this._tempWlInteger.value(statusMsg.streamId());
            WlRequest wlRequest = this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger);
            boolean bl = requestClosed = statusMsg.checkHasState() && statusMsg.state().streamState() != 1;
            if (requestClosed) {
                this.closeWlRequest(wlRequest);
            }
            ret = this.callbackUser("WlItemHandler.dispatch", (Msg)statusMsg, null, wlRequest, errorInfo);
            if (requestClosed) {
                this.repoolWlRequest(wlRequest);
            }
            this._statusMsgPool.add(statusMsg);
            entry.getKey().returnToPool();
            statusMsgIter.remove();
            if (ret >= 0) continue;
            return ret;
        }
        WlRequest wlRequest = null;
        while ((wlRequest = this._requestTimeoutList.poll()) != null) {
            this._submitOptions.serviceName(wlRequest.streamInfo().serviceName());
            this._submitOptions.requestMsgOptions().userSpecObj(wlRequest.streamInfo().userSpecObject());
            ret = this.handleRequest(wlRequest, wlRequest.requestMsg(), this._submitOptions, false, errorInfo);
            if (ret >= 0) continue;
            return ret;
        }
        WlStream wlStream = null;
        int loopCount = this._pendingSendMsgList.size();
        while ((wlStream = this._pendingSendMsgList.poll()) != null) {
            ret = wlStream.sendMsgOnLoop((Msg)wlStream.requestMsg(), this._submitOptions, this._errorInfo);
            if (ret < 0) {
                if (ret == -3) {
                    return 0;
                }
                return ret;
            }
            if (--loopCount != 0) continue;
            return 0;
        }
        return ret;
    }

    int loginStreamOpen(ReactorErrorInfo errorInfo) {
        return 0;
    }

    int loginStreamClosed(State state) {
        this._statusMsg.clear();
        this._statusMsg.applyHasState();
        this._statusMsg.msgClass(3);
        if (state != null) {
            this._statusMsg.state().streamState(state.streamState());
            this._statusMsg.state().dataState(state.dataState());
        } else {
            this._statusMsg.state().streamState(4);
            this._statusMsg.state().dataState(2);
        }
        this._statusMsg.state().text().data("Login stream was closed.");
        this.fanoutToAllStreams((Msg)this._statusMsg);
        return 0;
    }

    int directoryStreamOpen() {
        this._directoryStreamOpen = true;
        return 0;
    }

    int directoryStreamClosed(Msg msg) {
        this._directoryStreamOpen = false;
        this.fanoutToAllStreams(msg);
        return 0;
    }

    int pauseAll() {
        LinkedHashSet pendingRequestList;
        for (WlStream wlStream : this._streamList) {
            LinkedList<WlRequest> requestList = wlStream.userRequestList();
            for (WlRequest usrRequest : requestList) {
                usrRequest.requestMsg().applyPause();
            }
            wlStream.numPausedRequestsCount(requestList.size());
        }
        for (Map.Entry entry : this._pendingRequestByNameTable.entrySet()) {
            pendingRequestList = (LinkedHashSet)entry.getValue();
            for (WlRequest usrRequest : pendingRequestList) {
                usrRequest.requestMsg().applyPause();
            }
        }
        for (Map.Entry entry : this._pendingRequestByIdTable.entrySet()) {
            pendingRequestList = (LinkedHashSet)entry.getValue();
            for (WlRequest usrRequest : pendingRequestList) {
                usrRequest.requestMsg().applyPause();
            }
        }
        return 0;
    }

    int resumeAll() {
        LinkedHashSet pendingRequestList;
        for (WlStream wlStream : this._streamList) {
            LinkedList<WlRequest> requestList = wlStream.userRequestList();
            if (wlStream.numPausedRequestsCount() <= 0) continue;
            for (WlRequest usrRequest : requestList) {
                usrRequest.requestMsg().flags(usrRequest.requestMsg().flags() & 0xFFFFFDFF);
            }
            wlStream.numPausedRequestsCount(0);
        }
        for (Map.Entry entry : this._pendingRequestByNameTable.entrySet()) {
            pendingRequestList = (LinkedHashSet)entry.getValue();
            for (WlRequest usrRequest : pendingRequestList) {
                usrRequest.requestMsg().flags(usrRequest.requestMsg().flags() & 0xFFFFFDFF);
            }
        }
        for (Map.Entry entry : this._pendingRequestByIdTable.entrySet()) {
            pendingRequestList = (LinkedHashSet)entry.getValue();
            for (WlRequest usrRequest : pendingRequestList) {
                usrRequest.requestMsg().flags(usrRequest.requestMsg().flags() & 0xFFFFFDFF);
            }
        }
        return 0;
    }

    void channelUp(ReactorErrorInfo errorInfo) {
        this._streamList.clear();
    }

    int serviceAdded(WlService wlService) {
        int ret = 0;
        LinkedHashSet pendingRequestList = null;
        this._tempWlInteger.value(wlService.rdmService().serviceId());
        pendingRequestList = (LinkedHashSet)this._pendingRequestByIdTable.remove(this._tempWlInteger);
        if (pendingRequestList == null) {
            pendingRequestList = (LinkedHashSet)this._pendingRequestByNameTable.remove(wlService.rdmService().info().serviceName().toString());
        }
        if (pendingRequestList != null) {
            WlRequest wlRequest = null;
            Iterator wlRequestIter = pendingRequestList.iterator();
            while (wlRequestIter.hasNext()) {
                wlRequest = (WlRequest)wlRequestIter.next();
                this._submitOptions.serviceName(wlRequest.streamInfo().serviceName());
                this._submitOptions.requestMsgOptions().userSpecObj(wlRequest.streamInfo().userSpecObject());
                if (wlRequest.requestMsg().checkNoRefresh()) {
                    wlRequest.requestMsg().flags(wlRequest.requestMsg().flags() & 0xFFFFFFDF);
                }
                if ((ret = this.handleRequest(wlRequest, wlRequest.requestMsg(), this._submitOptions, false, this._errorInfo)) < 0) {
                    wlRequestIter.remove();
                    return ret;
                }
                wlRequestIter.remove();
            }
            this._pendingRequestListPool.add(pendingRequestList);
        }
        WlStream wlStream = null;
        int loopCount = this._pendingSendMsgList.size();
        while ((wlStream = this._pendingSendMsgList.poll()) != null) {
            ret = wlStream.sendMsgOnLoop((Msg)wlStream.requestMsg(), this._submitOptions, this._errorInfo);
            if (ret < 0) {
                if (ret == -3) {
                    return 0;
                }
                return ret;
            }
            if (--loopCount != 0) continue;
            return 0;
        }
        this._userStreamIdListToRecover.clear();
        return ret;
    }

    int serviceUpdated(WlService wlService, boolean containsServiceStateUpdate) {
        int ret = 0;
        this._errorInfo.clear();
        if (wlService.streamList().isEmpty()) {
            ret = this.serviceAdded(wlService);
            wlService.rdmService().groupStateList().clear();
            return ret;
        }
        boolean userRequestExists = false;
        for (int streamCount = 0; streamCount < wlService.streamList().size(); ++streamCount) {
            if (wlService.streamList().get(streamCount).userRequestList().size() == 0) continue;
            userRequestExists = true;
            break;
        }
        if (!userRequestExists) {
            ret = this.serviceAdded(wlService);
            wlService.rdmService().groupStateList().clear();
            return ret;
        }
        ret = this.serviceAdded(wlService);
        if (ret < 0) {
            return ret;
        }
        if (containsServiceStateUpdate && wlService.rdmService().checkHasState() && wlService.rdmService().state().checkHasStatus()) {
            for (int streamCount = 0; streamCount < wlService.streamList().size(); ++streamCount) {
                int streamListSizeBefore = wlService.streamList().size();
                StatusMsg statusMsg = this._statusMsgPool.poll();
                if (statusMsg == null) {
                    statusMsg = (StatusMsg)CodecFactory.createMsg();
                }
                statusMsg.clear();
                statusMsg.domainType(wlService.streamList().get(streamCount).requestMsg().domainType());
                statusMsg.msgClass(3);
                statusMsg.streamId(wlService.streamList().get(streamCount).requestMsg().streamId());
                statusMsg.applyHasState();
                wlService.rdmService().state().status().copy(statusMsg.state());
                ret = this.readMsg(wlService.streamList().get(streamCount), null, (Msg)statusMsg, false, this._errorInfo);
                int streamListSizeAfter = wlService.streamList().size();
                streamCount -= streamListSizeBefore - streamListSizeAfter;
                this._statusMsgPool.add(statusMsg);
                if (ret >= 0) continue;
                return ret;
            }
        }
        for (int groupIndex = 0; groupIndex < wlService.rdmService().groupStateList().size(); ++groupIndex) {
            WlItemGroup wlItemGroup;
            Service.ServiceGroup serviceGroup = wlService.rdmService().groupStateList().get(groupIndex);
            if (serviceGroup.checkHasStatus() && (wlItemGroup = wlService.itemGroupTableGet(serviceGroup.group())) != null) {
                for (int i = 0; i < wlItemGroup.openStreamList().size(); ++i) {
                    StatusMsg statusMsg = this._statusMsgPool.poll();
                    if (statusMsg == null) {
                        statusMsg = (StatusMsg)CodecFactory.createMsg();
                    }
                    statusMsg.clear();
                    statusMsg.domainType(wlService.itemGroupTableGet(serviceGroup.group()).openStreamList().get(i).domainType());
                    statusMsg.msgClass(3);
                    statusMsg.streamId(wlService.itemGroupTableGet(serviceGroup.group()).openStreamList().get(i).streamId());
                    statusMsg.applyHasState();
                    statusMsg.applyHasGroupId();
                    statusMsg.groupId(wlItemGroup.groupId());
                    serviceGroup.status().copy(statusMsg.state());
                    ret = this.readMsg(wlService.itemGroupTableGet(serviceGroup.group()).openStreamList().get(i), null, (Msg)statusMsg, false, this._errorInfo);
                    this._statusMsgPool.add(statusMsg);
                    if (ret >= 0) continue;
                    return ret;
                }
            }
            if (!serviceGroup.checkHasMergedToGroup()) continue;
            wlItemGroup = wlService.itemGroupTableRemove(serviceGroup.group());
            WlItemGroup newItemGroup = wlService.itemGroupTableGet(serviceGroup.mergedToGroup());
            if (wlItemGroup == null) continue;
            if (newItemGroup != null) {
                newItemGroup.openStreamList().addAll(wlItemGroup.openStreamList());
                newItemGroup.streamIdToItemGroupTable().putAll(wlItemGroup.streamIdToItemGroupTable());
                continue;
            }
            Buffer groupId = CodecFactory.createBuffer();
            groupId.data(ByteBuffer.allocate(serviceGroup.mergedToGroup().length()));
            serviceGroup.mergedToGroup().copy(groupId);
            wlItemGroup.groupId(groupId);
            wlService.itemGroupTablePut(wlItemGroup.groupId(), wlItemGroup);
        }
        wlService.rdmService().groupStateList().clear();
        return ret;
    }

    int serviceDeleted(WlService wlService, boolean channelIsDown) {
        WlStream wlStream;
        boolean forceClose = false;
        boolean sendChannelDownText = channelIsDown;
        int statusFlags = 0;
        if (this._watchlist.reactor().reactorHandlesWarmStandby(this._watchlist.reactorChannel())) {
            ReactorWarmStandbyHandler wsbHandler = this._watchlist.reactorChannel().warmStandByHandlerImpl;
            if (wsbHandler.currentWarmStandbyGroupImpl().warmStandbyMode() == 1) {
                if (wsbHandler.nextActiveReactorChannel() != null && wsbHandler.nextActiveReactorChannel().channel() != null && wsbHandler.nextActiveReactorChannel().channel().state() == 2) {
                    ReactorWSBService wsbService;
                    statusFlags = WlStreamStatusFlags.SEND_STATUS;
                    sendChannelDownText = false;
                    if (wsbHandler.nextActiveReactorChannel().watchlist()._directoryHandler._serviceCache._servicesByIdTable.get(wlService._tableKey) == null && ((wsbService = this._watchlist.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(wlService.tableKey())) == null || wsbService.channels.size() == 0)) {
                        forceClose = true;
                    }
                }
            } else {
                boolean hasService = false;
                ReactorWSBService wsbService = this._watchlist.reactorChannel().warmStandByHandlerImpl.currentWarmStandbyGroupImpl()._perServiceById.get(wlService.tableKey());
                if (wsbService != null) {
                    boolean containsChannel = wsbService.channels.contains(this._watchlist.reactorChannel());
                    if (wsbService != null && (!containsChannel && wsbService.channels.size() > 0 || containsChannel && wsbService.channels.size() > 1)) {
                        hasService = true;
                        sendChannelDownText = false;
                    }
                }
                boolean hasChannelDown = false;
                for (int i = 0; i < wsbHandler.channelList().size(); ++i) {
                    ReactorChannel processChannel = wsbHandler.channelList().get(i);
                    if (this._watchlist.reactorChannel() == null || processChannel == this._watchlist.reactorChannel() || processChannel.state() == ReactorChannel.State.READY && processChannel.state() == ReactorChannel.State.UP) continue;
                    hasChannelDown = true;
                    break;
                }
                if (!hasChannelDown && !hasService) {
                    forceClose = true;
                    sendChannelDownText = false;
                    statusFlags = WlStreamStatusFlags.SEND_STATUS;
                }
            }
        }
        String stateText = sendChannelDownText ? "channel down." : "Service for this item was lost.";
        this._statusMsg.clear();
        this._statusMsg.msgClass(3);
        this._statusMsg.applyHasState();
        this._statusMsg.state().streamState(3);
        this._statusMsg.state().dataState(2);
        this._statusMsg.msgClass(3);
        this._statusMsg.state().text().data(stateText);
        while ((wlStream = wlService.streamList().peek()) != null) {
            this.removeWlStreamFromService(wlStream);
            this._statusMsg.domainType(wlStream.domainType());
            int ret = this.readMsg(wlStream, null, (Msg)this._statusMsg, forceClose, this._errorInfo);
            if (ret == 0) continue;
            return ret;
        }
        WlRequest wlRequest = wlService.waitingRequestList().poll();
        while (wlRequest != null) {
            boolean isRecoverable = this._watchlist.isRequestRecoverable(wlRequest, 3) && !forceClose;
            this._statusMsg.streamId(wlRequest.requestMsg().streamId());
            this._statusMsg.domainType(wlRequest.requestMsg().domainType());
            wlRequest.statusFlags(statusFlags);
            if (isRecoverable) {
                this._statusMsg.state().streamState(1);
                this._submitOptions.serviceName(wlRequest.streamInfo().serviceName());
                this._submitOptions.requestMsgOptions().userSpecObj(wlRequest.streamInfo().userSpecObject());
                this.addToPendingRequestTable(wlRequest, this._submitOptions);
            } else {
                this.closeWlRequest(wlRequest);
                this._statusMsg.state().streamState(3);
            }
            int ret = this.callbackUser("WlItemHandler.serviceDeleted", (Msg)this._statusMsg, null, wlRequest, this._errorInfo);
            if (ret < 0) {
                return ret;
            }
            if (!isRecoverable) {
                this.repoolWlRequest(wlRequest);
            }
            wlRequest = wlService.waitingRequestList().poll();
        }
        return 0;
    }

    private void copyRequestKeyReferencesToMsg(WlRequest wlRequest, Msg destMsg) {
        MsgKey destKey = destMsg.msgKey();
        MsgKey srcKey = wlRequest.requestMsg().msgKey();
        destKey.flags(srcKey.flags());
        destKey.nameType(srcKey.nameType());
        destKey.name(srcKey.name());
        destKey.filter(srcKey.filter());
        destKey.identifier(srcKey.identifier());
        destKey.attribContainerType(srcKey.attribContainerType());
        destKey.encodedAttrib(srcKey.encodedAttrib());
        if (wlRequest.hasServiceId()) {
            destKey.applyHasServiceId();
            destKey.serviceId((int)wlRequest.serviceId());
        } else {
            destKey.serviceId(srcKey.serviceId());
        }
    }

    @Override
    public int callbackUser(String location, Msg msg, MsgBase rdmMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int ret = 0;
        int msgFlagsToReset = 0;
        if (wlRequest != null && (wlRequest.requestMsg().checkMsgKeyInUpdates() || wlRequest.providerDriven() && !wlRequest.initialResponseReceived())) {
            switch (msg.msgClass()) {
                case 4: {
                    if (((UpdateMsg)msg).checkHasMsgKey()) break;
                    ((UpdateMsg)msg).applyHasMsgKey();
                    this.copyRequestKeyReferencesToMsg(wlRequest, msg);
                    msgFlagsToReset = 8;
                    break;
                }
                case 2: {
                    if (!((RefreshMsg)msg).checkHasMsgKey()) {
                        ((RefreshMsg)msg).applyHasMsgKey();
                        this.copyRequestKeyReferencesToMsg(wlRequest, msg);
                        msgFlagsToReset = 8;
                    }
                    if (!((RefreshMsg)msg).state().isFinal()) break;
                    wlRequest.unsetServiceId();
                    break;
                }
                case 3: {
                    if (!((StatusMsg)msg).checkHasMsgKey()) {
                        ((StatusMsg)msg).applyHasMsgKey();
                        this.copyRequestKeyReferencesToMsg(wlRequest, msg);
                        msgFlagsToReset = 8;
                    }
                    if (!((StatusMsg)msg).checkHasState() || !((StatusMsg)msg).state().isFinal()) break;
                    wlRequest.unsetServiceId();
                    break;
                }
                case 7: {
                    if (((GenericMsg)msg).checkHasMsgKey()) break;
                    ((GenericMsg)msg).applyHasMsgKey();
                    this.copyRequestKeyReferencesToMsg(wlRequest, msg);
                    msgFlagsToReset = 4;
                    break;
                }
                case 6: {
                    if (((AckMsg)msg).checkHasMsgKey()) break;
                    ((AckMsg)msg).applyHasMsgKey();
                    this.copyRequestKeyReferencesToMsg(wlRequest, msg);
                    msgFlagsToReset = 16;
                    break;
                }
            }
            wlRequest.initialResponseReceived(true);
        }
        if (msg.domainType() != 5) {
            ret = this._watchlist.reactor().sendAndHandleDefaultMsgCallback(location, this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
        } else {
            this._rdmDictionaryMsg.clear();
            switch (msg.msgClass()) {
                case 2: {
                    this._rdmDictionaryMsg.rdmMsgType(DictionaryMsgType.REFRESH);
                    break;
                }
                case 3: {
                    this._rdmDictionaryMsg.rdmMsgType(DictionaryMsgType.STATUS);
                    break;
                }
                default: {
                    return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.callbackUser", "Unknown message class for dictionary: < " + MsgClasses.toString((int)msg.msgClass()) + ">");
                }
            }
            this._dIter.clear();
            if (msg.encodedDataBody().data() != null) {
                this._dIter.setBufferAndRWFVersion(msg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
            }
            if ((ret = this._rdmDictionaryMsg.decode(this._dIter, msg)) < 0) {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, ret, "ItemHandler.callbackUser", "DictionaryMsg.decode() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
            }
            ret = this._watchlist.reactor().sendAndHandleDictionaryMsgCallback(location, this._watchlist.reactorChannel(), null, msg, this._rdmDictionaryMsg, wlRequest, errorInfo);
            if (ret == -2) {
                ret = this._watchlist.reactor().sendAndHandleDefaultMsgCallback(location, this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
            }
        }
        msg.flags(msg.flags() & ~msgFlagsToReset);
        return ret;
    }

    @Override
    public void addPendingRequest(WlStream wlStream) {
        if (wlStream != null) {
            if (!this._pendingSendMsgList.contains(wlStream)) {
                this._pendingSendMsgList.addFirst(wlStream);
            }
        } else {
            this._hasPendingViewRequest = true;
        }
    }

    void fanoutToAllStreams(Msg msg) {
        Iterator streamListIterator = this._streamList.iterator();
        while (streamListIterator.hasNext()) {
            WlStream wlStream = (WlStream)streamListIterator.next();
            streamListIterator.remove();
            this.readMsg(wlStream, null, msg, false, this._errorInfo);
        }
    }

    @Override
    public int requestTimeout(WlStream wlStream, ReactorErrorInfo errorInfo) {
        this.closeWlStream(wlStream);
        LinkedList<WlRequest> requestList = wlStream.userRequestList();
        WlRequest usrRequest = null;
        usrRequest = requestList.poll();
        while (usrRequest != null) {
            usrRequest.state(WlRequest.State.PENDING_REQUEST);
            if (this._watchlist.loginHandler().supportSingleOpen()) {
                this._requestTimeoutList.add(usrRequest);
            }
            this.sendStatus(usrRequest.requestMsg().streamId(), usrRequest.requestMsg().domainType(), "Request timeout", usrRequest.requestMsg().checkPrivateStream());
            usrRequest = requestList.poll();
        }
        wlStream.returnToPool();
        this._watchlist.reactor().sendWatchlistDispatchNowEvent(this._watchlist.reactorChannel());
        return 0;
    }

    void removeStreamFromItemGroup(WlStream wlStream) {
        WlItemGroup wlItemGroup = wlStream.itemGroup();
        if (wlItemGroup != null) {
            wlItemGroup.openStreamList().remove(wlStream);
            this._tempWlInteger.value(wlStream.streamId());
            wlItemGroup.streamIdToItemGroupTable().remove(this._tempWlInteger);
            wlStream.groupTableKey().returnToPool();
            wlStream.groupTableKey(null);
            if (wlItemGroup.openStreamList().isEmpty()) {
                wlStream.wlService().itemGroupTableRemove(wlItemGroup.groupId());
            }
            wlStream.itemGroup(null);
        }
    }

    void addStreamToItemGroup(WlItemGroup wlItemGroup, WlStream wlStream) {
        this._tempWlInteger.value(wlStream.streamId());
        if (!wlItemGroup.streamIdToItemGroupTable().containsKey(this._tempWlInteger)) {
            wlStream.itemGroup(wlItemGroup);
            wlItemGroup.openStreamList().add(wlStream);
            WlInteger wlInteger = ReactorFactory.createWlInteger();
            wlInteger.value(wlStream.streamId());
            wlStream.groupTableKey(wlInteger);
            wlItemGroup.streamIdToItemGroupTable().put(wlInteger, wlStream);
        }
    }

    void clear() {
        this._directoryStreamOpen = false;
        this._tempItemAggregationRequest.clear();
        this._itemAggregationKeytoWlStreamTable.clear();
        this._providerRequestTable.clear();
        this._streamList.clear();
        this._pendingRequestByIdTable.clear();
        this._pendingRequestByNameTable.clear();
        this._statusMsgDispatchList.clear();
        this._pendingSendMsgList.clear();
        this._userStreamIdListToRecover.clear();
        this._currentFanoutStream = null;
        this._hasPendingViewRequest = false;
    }

    private int extractSymbolListFromMsg(WlRequest wlRequest, RequestMsg requestMsg, ReactorErrorInfo errorInfo) {
        this._elementList.clear();
        this._elementEntry.clear();
        this._behaviourElementList.clear();
        this._behaviourEntry.clear();
        this._dataStreamFlag.clear();
        if (requestMsg.containerType() != 133) {
            return 0;
        }
        this._dIter.clear();
        this._dIter.setBufferAndRWFVersion(requestMsg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
        int ret = this._elementList.decode(this._dIter, null);
        if (ret != 0) {
            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbolListFromMsg", "DecodeElementList() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
            return ret;
        }
        while ((ret = this._elementEntry.decode(this._dIter)) != 14) {
            if (ret != 0) {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbolListFromMsg", "DecodeMapEntry() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
                return ret;
            }
            if (!this._elementEntry.name().equals(SymbolList.ElementNames.SYMBOL_LIST_BEHAVIORS)) continue;
            wlRequest.hasBehaviour(true);
            if (this._elementEntry.dataType() != 133) {
                return 0;
            }
            ret = this._behaviourElementList.decode(this._dIter, null);
            if (ret != 0) continue;
            while ((ret = this._behaviourEntry.decode(this._dIter)) != 14) {
                if (ret < 0) {
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbollistFromMsg", "Error decoding element entry in RequestMsg.");
                    return ret;
                }
                if (!this._behaviourEntry.name().equals(SymbolList.ElementNames.SYMBOL_LIST_DATA_STREAMS)) continue;
                if (this._behaviourEntry.dataType() != 4) {
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbollistFromMsg", "Error decoding Symbol List Data Streams -- Element has wrong data type.");
                    return ret;
                }
                ret = this._dataStreamFlag.decode(this._dIter);
                if (ret != 0) {
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbollistFromMsg", "Error decoding Symbol List Data Streams");
                    return ret;
                }
                if (this._dataStreamFlag.toBigInteger().intValue() < 0 || this._dataStreamFlag.toBigInteger().intValue() > 2) {
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractSymbollistFromMsg", "Invalid symbol list request flags.");
                    return -1;
                }
                wlRequest.symbolListFlags(this._dataStreamFlag.toBigInteger().intValue());
            }
        }
        return 0;
    }

    private int handleSymbolList(WlStream wlStream, Msg msg, ReactorErrorInfo errorInfo) {
        block6: for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            if (!wlRequest.hasBehaviour() || wlRequest.symbolListFlags() == 0) continue;
            int ret = 0;
            int serviceId = 0;
            if (wlRequest.requestMsg().msgKey().checkHasServiceId()) {
                serviceId = wlRequest.requestMsg().msgKey().serviceId();
            } else if (wlRequest.streamInfo().serviceName() != null) {
                serviceId = this._watchlist.directoryHandler().service(wlRequest.streamInfo().serviceName()).rdmService().serviceId();
            }
            WlService wlService = this._watchlist.directoryHandler().service(serviceId);
            if (wlService == null) {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.handleSymbolList", "Service for Symbol List stream is missing name. Cannot create data streams.");
                return -1;
            }
            if (msg.containerType() != 137) continue;
            this._requestMsg.clear();
            this._requestMsg.msgClass(1);
            this._requestMsg.domainType(6);
            this._requestMsg.containerType(128);
            this._requestMsg.applyHasQos();
            if ((wlRequest.symbolListFlags() & 1) > 0) {
                this._requestMsg.applyStreaming();
            }
            this._requestMsg.msgKey().applyHasNameType();
            this._requestMsg.msgKey().nameType(1);
            this._requestMsg.msgKey().applyHasName();
            if (wlService.rdmService().info().qosList().size() > 0) {
                Qos itemQos = wlService.rdmService().info().bestQos();
                itemQos.copy(this._requestMsg.qos());
            } else {
                this._requestMsg.qos().rate(1);
                this._requestMsg.qos().timeliness(1);
            }
            this._dIter.clear();
            this._dIter.setBufferAndRWFVersion(msg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
            this._map.clear();
            this._mapEntry.clear();
            this._mapKey.clear();
            switch (msg.msgClass()) {
                case 2: 
                case 4: {
                    ret = this._map.decode(this._dIter);
                    if (ret != 0) {
                        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.handleSymbolList", "DecodeMap() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
                        return ret;
                    }
                    block7: while ((ret = this._mapEntry.decode(this._dIter, (Object)this._mapKey)) != 14) {
                        if (ret != 0) {
                            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.handleSymbolList", "DecodeMapEntry() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
                            return ret;
                        }
                        switch (this._mapEntry.action()) {
                            case 1: 
                            case 2: {
                                this._requestMsg.msgKey().name(this._mapKey);
                                this._symbolListRequestKey.clear();
                                this._symbolListRequestKey.msgKey(this._requestMsg.msgKey());
                                this._symbolListRequestKey.msgKey().serviceId(serviceId);
                                this._symbolListRequestKey.domainType(this._requestMsg.domainType());
                                this._symbolListRequestKey.qos(this._requestMsg.qos());
                                if (this._providerRequestTable.containsKey(this._symbolListRequestKey)) continue block7;
                                int providerProvideStreamId = this._watchlist.nextProviderStreamId();
                                this._requestMsg.streamId(providerProvideStreamId);
                                WlRequest newWlRequest = ReactorFactory.createWlRequest();
                                newWlRequest.providerDriven(true);
                                newWlRequest.streamInfo().serviceName(wlRequest.streamInfo().serviceName());
                                this._submitOptions.serviceName(wlRequest.streamInfo().serviceName());
                                this._submitOptions.requestMsgOptions().userSpecObj(wlRequest.streamInfo().userSpecObject());
                                ret = this.handleRequest(newWlRequest, this._requestMsg, this._submitOptions, true, errorInfo);
                                if (ret >= 0) {
                                    newWlRequest.requestMsg().clear();
                                    this._requestMsg.copy((Msg)newWlRequest.requestMsg(), 4095);
                                    WlInteger wlInteger = ReactorFactory.createWlInteger();
                                    wlInteger.value(providerProvideStreamId);
                                    newWlRequest.handler(this);
                                    newWlRequest.tableKey(wlInteger);
                                    this._watchlist.streamIdtoWlRequestTable().put(wlInteger, newWlRequest);
                                    if (!this._requestMsg.checkStreaming()) continue block7;
                                    this._providerRequestTable.put(this._symbolListRequestKey, newWlRequest.requestMsg());
                                    continue block7;
                                }
                                this.repoolWlRequest(newWlRequest);
                                continue block7;
                            }
                        }
                    }
                    continue block6;
                }
                default: {
                    return 0;
                }
            }
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int extractViewFromMsg(WlRequest wlRequest, RequestMsg requestMsg, ReactorErrorInfo errorInfo) {
        int ret;
        wlRequest.viewElemCount(0);
        this._viewDataFound = false;
        this._viewElemCount = 0;
        this._elementList.clear();
        this._elementEntry.clear();
        this._hasViewType = false;
        this._viewType.clear();
        this._viewDataElement.clear();
        this._viewElemList = requestMsg.encodedDataBody();
        this._dIter.clear();
        this._dIter.setBufferAndRWFVersion(requestMsg.encodedDataBody(), this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
        if (requestMsg.containerType() != 133) {
            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Unexpected container type <" + requestMsg.containerType() + ">");
            return -1;
        }
        if (this._elementList.decode(this._dIter, null) != 0) {
            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Unexpected container type <" + requestMsg.containerType() + ">");
            return -1;
        }
        while ((ret = this._elementEntry.decode(this._dIter)) != 14) {
            if (ret != 0) {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "ElementEntry.decode() failed: < " + CodecReturnCodes.toString((int)ret) + ">");
                return ret;
            }
            if (this._elementEntry.name().equals(ElementNames.VIEW_TYPE) && this._elementEntry.dataType() == 4) {
                this._viewType.decode(this._dIter);
                this._hasViewType = true;
            }
            if (!this._elementEntry.name().equals(ElementNames.VIEW_DATA) || this._elementEntry.dataType() != 15) continue;
            this._viewDataElement = this._elementEntry.encodedData();
            this._viewDataFound = true;
        }
        int viewType = this._viewType.toBigInteger().intValue();
        wlRequest.viewType(viewType);
        wlRequest.viewAction(1);
        if (viewType == 1 || viewType == 2 || !this._hasViewType) {
            if (requestMsg.domainType() == 10) {
                return 0;
            }
            if (!this._viewDataFound) {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", ":ViewData element not found <-26>");
                return -1;
            }
            this._dIter.clear();
            this._dIter.setBufferAndRWFVersion(this._viewDataElement, this._watchlist.reactorChannel().majorVersion(), this._watchlist.reactorChannel().minorVersion());
            switch (viewType) {
                case 1: {
                    this._viewArray.clear();
                    ret = this._viewArray.decode(this._dIter);
                    if (ret == 0) {
                        if (this._viewArray.primitiveType() != 3) {
                            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Unexpected primitive type in array  <" + this._viewArray.primitiveType() + ">");
                            return -1;
                        }
                        if (wlRequest._viewFieldIdList == null) {
                            wlRequest._viewFieldIdList = this._wlViewHandler._viewFieldIdListPool.poll();
                        }
                        if (wlRequest._viewFieldIdList == null) {
                            wlRequest._viewFieldIdList = new ArrayList();
                        } else {
                            wlRequest._viewFieldIdList.clear();
                        }
                        while ((ret = this._viewArrayEntry.decode(this._dIter)) != 14) {
                            if (ret < 0) {
                                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array entry   <" + ret + ">");
                                return ret;
                            }
                            ret = this._fieldId.decode(this._dIter);
                            if (ret == 0) {
                                if (this._fieldId.toLong() < -32768L || this._fieldId.toLong() > 32767L) {
                                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Field id in view request is outside the valid ID range <" + this._fieldId + ">");
                                    return -1;
                                }
                                wlRequest._viewFieldIdList.add((int)this._fieldId.toLong());
                                ++this._viewElemCount;
                                continue;
                            }
                            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Invalid BLANK_DATA or incomplete data while decoding :ViewData <" + ret + ">");
                            return ret;
                        }
                        wlRequest.viewElemCount(this._viewElemCount);
                        return 0;
                    }
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array  <" + ret + ">");
                    return ret;
                }
                case 2: {
                    ret = this._viewArray.decode(this._dIter);
                    if (ret == 0) {
                        if (this._viewArray.primitiveType() != 17 && this._viewArray.primitiveType() != 18 && this._viewArray.primitiveType() != 19) {
                            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Unexpected primitive type in array  <" + this._viewArray.primitiveType() + ">");
                            return -1;
                        }
                        if (wlRequest._viewElementNameList == null) {
                            wlRequest._viewElementNameList = this._wlViewHandler._viewElementNameListPool.poll();
                        }
                        if (wlRequest._viewElementNameList == null) {
                            wlRequest._viewElementNameList = new ArrayList();
                        } else {
                            wlRequest._viewElementNameList.clear();
                        }
                        while ((ret = this._viewArrayEntry.decode(this._dIter)) != 14) {
                            if (ret < 0) {
                                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array entry   <" + ret + ">");
                                return ret;
                            }
                            if (this._elementName.decode(this._dIter) == 0) {
                                wlRequest._viewElementNameList.add(this._elementName.toString());
                                ++this._viewElemCount;
                                continue;
                            }
                            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Invalid BLANK_DATA or incomplete data while decoding :ViewData <" + ret + ">");
                            return ret;
                        }
                        wlRequest.viewElemCount(this._viewElemCount);
                        return 0;
                    }
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array  <" + ret + ">");
                    return ret;
                }
                default: {
                    this._viewArray.clear();
                    ret = this._viewArray.decode(this._dIter);
                    if (ret == 0) {
                        if (this._viewArray.primitiveType() == 3) {
                            if (wlRequest._viewFieldIdList == null) {
                                wlRequest._viewFieldIdList = this._wlViewHandler._viewFieldIdListPool.poll();
                            }
                            if (wlRequest._viewFieldIdList == null) {
                                wlRequest._viewFieldIdList = new ArrayList();
                            } else {
                                wlRequest._viewFieldIdList.clear();
                            }
                            while ((ret = this._viewArrayEntry.decode(this._dIter)) != 14) {
                                if (ret < 0) {
                                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array entry   <" + ret + ">");
                                    return ret;
                                }
                                ret = this._fieldId.decode(this._dIter);
                                if (ret == 0) {
                                    if (this._fieldId.toLong() < -32768L || this._fieldId.toLong() > 32767L) {
                                        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Field id in view request is outside the valid ID range <" + this._fieldId + ">");
                                        return -1;
                                    }
                                    wlRequest._viewFieldIdList.add((int)this._fieldId.toLong());
                                    ++this._viewElemCount;
                                    continue;
                                }
                                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Invalid BLANK_DATA or incomplete data while decoding :ViewData <" + ret + ">");
                                return ret;
                            }
                            wlRequest.viewElemCount(this._viewElemCount);
                            return -1;
                        }
                        if (this._viewArray.primitiveType() == 17 || this._viewArray.primitiveType() == 18 || this._viewArray.primitiveType() == 19) {
                            if (wlRequest._viewElementNameList == null) {
                                wlRequest._viewElementNameList = this._wlViewHandler._viewElementNameListPool.poll();
                            }
                            if (wlRequest._viewElementNameList == null) {
                                wlRequest._viewElementNameList = new ArrayList();
                            } else {
                                wlRequest._viewElementNameList.clear();
                            }
                            while ((ret = this._viewArrayEntry.decode(this._dIter)) != 14) {
                                if (ret < 0) {
                                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array entry   <" + ret + ">");
                                    return ret;
                                }
                                if (this._elementName.decode(this._dIter) == 0) {
                                    wlRequest._viewElementNameList.add(this._elementName.toString());
                                    ++this._viewElemCount;
                                    continue;
                                }
                                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Invalid BLANK_DATA or incomplete data while decoding :ViewData <" + ret + ">");
                                return ret;
                            }
                            wlRequest.viewElemCount(this._viewElemCount);
                            return -1;
                        }
                        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array  <" + ret + ">");
                        return ret;
                    }
                    this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", "Error decoding array  <" + ret + ">");
                    return ret;
                }
            }
        }
        this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler.extractViewFromMsg", ":Invalid :ViewType or :ViewType not found  <" + viewType + ">");
        return -1;
    }

    private int handleViews(WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        switch (wlRequest.viewAction()) {
            case 1: {
                WlView view = this._wlViewHandler.viewCreate(wlRequest.viewFieldIdList(), wlRequest.viewElementNameList(), wlRequest.viewElemCount(), wlRequest.viewType(), errorInfo);
                if (view == null) {
                    return -1;
                }
                wlRequest.view(view);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler", "Invalid View Action  <" + wlRequest.viewAction() + ">");
                return -1;
            }
        }
        return this.addRequestView(wlRequest, errorInfo);
    }

    private int addRequestView(WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        WlStream wlStream = wlRequest.stream();
        if (wlRequest.view() != null && wlStream.aggregateView() != null && wlRequest.view().viewType() != wlStream.aggregateView().viewType()) {
            this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "ItemHandler", "ViewType mismatch, cannot be aggregated.");
            return -1;
        }
        ++wlStream._requestsWithViewCount;
        wlStream._pendingViewChange = true;
        if (wlStream.aggregateView() == null) {
            WlView aggView = this._wlViewHandler.aggregateViewCreate(wlRequest.view(), errorInfo);
            if (aggView == null) {
                return -1;
            }
            wlStream.aggregateView(aggView);
        } else if (this._wlViewHandler.aggregateViewAdd(wlStream.aggregateView(), wlRequest.view(), errorInfo) < 0) {
            return -1;
        }
        return 0;
    }

    private WlView removeRequestView(WlStream wlStream, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        this._wlViewHandler.removeRequestView(wlStream, wlRequest, errorInfo);
        wlStream._pendingViewChange = true;
        return wlRequest.view();
    }

    public void repoolWlRequest(WlRequest wlRequest) {
        if (wlRequest.view() != null) {
            switch (wlRequest.view().viewType()) {
                case 1: {
                    this._wlViewHandler._viewFieldIdListPool.add(wlRequest._viewFieldIdList);
                    wlRequest._viewFieldIdList = null;
                    break;
                }
                case 2: {
                    this._wlViewHandler._viewElementNameListPool.add(wlRequest._viewElementNameList);
                    wlRequest._viewElementNameList = null;
                    break;
                }
            }
            this._wlViewHandler.destroyView(wlRequest._view);
        }
        wlRequest.returnToPool();
    }

    void closeWlRequest(WlRequest wlRequest) {
        if (wlRequest.providerDriven()) {
            this._symbolListRequestKey.clear();
            this._symbolListRequestKey.msgKey(wlRequest.requestMsg().msgKey());
            this._symbolListRequestKey.msgKey().serviceId(wlRequest.requestMsg().msgKey().serviceId());
            this._symbolListRequestKey.domainType(wlRequest.requestMsg().domainType());
            this._symbolListRequestKey.qos(wlRequest.requestMsg().qos());
            this._providerRequestTable.remove(this._symbolListRequestKey);
        }
        this._watchlist.closeWlRequest(wlRequest);
    }
}

