/*
 * Decompiled with CFR 0.152.
 */
package com.refinitiv.eta.valueadd.reactor;

import com.refinitiv.eta.codec.Buffer;
import com.refinitiv.eta.codec.CodecFactory;
import com.refinitiv.eta.codec.DecodeIterator;
import com.refinitiv.eta.codec.GenericMsg;
import com.refinitiv.eta.codec.Msg;
import com.refinitiv.eta.codec.RefreshMsg;
import com.refinitiv.eta.codec.RequestMsg;
import com.refinitiv.eta.codec.StatusMsg;
import com.refinitiv.eta.codec.UpdateMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.MsgBase;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsg;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgFactory;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryMsgType;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRefresh;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryRequest;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryStatus;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.DirectoryUpdate;
import com.refinitiv.eta.valueadd.domainrep.rdm.directory.Service;
import com.refinitiv.eta.valueadd.reactor.ReactorChannel;
import com.refinitiv.eta.valueadd.reactor.ReactorErrorInfo;
import com.refinitiv.eta.valueadd.reactor.ReactorFactory;
import com.refinitiv.eta.valueadd.reactor.ReactorSubmitOptions;
import com.refinitiv.eta.valueadd.reactor.Watchlist;
import com.refinitiv.eta.valueadd.reactor.WlHandler;
import com.refinitiv.eta.valueadd.reactor.WlInteger;
import com.refinitiv.eta.valueadd.reactor.WlRequest;
import com.refinitiv.eta.valueadd.reactor.WlService;
import com.refinitiv.eta.valueadd.reactor.WlServiceCache;
import com.refinitiv.eta.valueadd.reactor.WlStream;
import java.util.LinkedList;
import java.util.List;

class WlDirectoryHandler
implements WlHandler {
    final long ALL_FILTERS = 63L;
    Watchlist _watchlist;
    WlStream _stream;
    DirectoryRequest _directoryRequest;
    DirectoryRefresh _directoryRefresh;
    DirectoryStatus _directoryStatus;
    DirectoryUpdate _directoryUpdate;
    DirectoryUpdate _directoryUpdateCopy;
    ReactorErrorInfo _errorInfo = ReactorFactory.createReactorErrorInfo();
    ReactorSubmitOptions _submitOptions = ReactorFactory.createReactorSubmitOptions();
    Msg _tempMsg = CodecFactory.createMsg();
    StatusMsg _statusMsg;
    Buffer _tempBuffer;
    WlServiceCache _serviceCache;
    RefreshMsg _tempRefreshMsg;
    DirectoryStatus _tempDirectoryStatus;
    UpdateMsg _tempUpdateMsg;
    boolean _receivedRefresh;
    boolean _roleDirectoryRequestAdded;
    int _directoryStreamId;
    boolean _hasPendingRequest;
    LinkedList<Service> _servicePool = new LinkedList();
    LinkedList<DirectoryRefresh> _directoryRefreshPool = new LinkedList();
    boolean _requestDispatchFlag;
    WlInteger _tempWlInteger = ReactorFactory.createWlInteger();

    WlDirectoryHandler(Watchlist watchlist) {
        this._watchlist = watchlist;
        this._serviceCache = new WlServiceCache(this._watchlist);
        this._directoryRequest = (DirectoryRequest)DirectoryMsgFactory.createMsg();
        this._directoryRequest.rdmMsgType(DirectoryMsgType.REQUEST);
        this._directoryRequest.filter(63L);
        this._directoryRequest.applyStreaming();
        this._directoryRefresh = (DirectoryRefresh)DirectoryMsgFactory.createMsg();
        this._directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
        this._directoryStatus = (DirectoryStatus)DirectoryMsgFactory.createMsg();
        this._directoryStatus.rdmMsgType(DirectoryMsgType.STATUS);
        this._directoryStatus.applyHasState();
        this._directoryStatus.state().code(0);
        this._directoryStatus.state().text(this._tempBuffer);
        this._directoryUpdate = (DirectoryUpdate)DirectoryMsgFactory.createMsg();
        this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        this._directoryUpdateCopy = (DirectoryUpdate)DirectoryMsgFactory.createMsg();
        this._directoryUpdateCopy.rdmMsgType(DirectoryMsgType.UPDATE);
        this._statusMsg = (StatusMsg)CodecFactory.createMsg();
        this._statusMsg.msgClass(3);
        this._statusMsg.domainType(4);
        this._statusMsg.applyHasState();
        this._statusMsg.state().code(0);
        this._statusMsg.state().text(this._tempBuffer);
        this._tempBuffer = CodecFactory.createBuffer();
        this._tempBuffer.data("");
        this._tempRefreshMsg = (RefreshMsg)CodecFactory.createMsg();
        this._tempDirectoryStatus = (DirectoryStatus)DirectoryMsgFactory.createMsg();
        this._tempUpdateMsg = (UpdateMsg)CodecFactory.createMsg();
        this._receivedRefresh = false;
        this._roleDirectoryRequestAdded = false;
        this._hasPendingRequest = false;
        this._directoryStreamId = this._watchlist.nextStreamId();
        this._stream = ReactorFactory.createWlStream();
        this._stream.handler(this);
        this._stream.watchlist(this._watchlist);
        this._stream.streamId(this._directoryStreamId);
        this._stream.domainType(4);
    }

    @Override
    public int submitRequest(WlRequest wlRequest, RequestMsg requestMsg, boolean isReissue, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        int ret = 0;
        wlRequest.streamInfo().serviceName(submitOptions.serviceName());
        wlRequest.streamInfo().userSpecObject(submitOptions.requestMsgOptions().userSpecObj());
        if (!isReissue) {
            this._stream.userRequestList().add(wlRequest);
            wlRequest.stream(this._stream);
        }
        if (!(wlRequest.requestMsg().checkNoRefresh() || this._serviceCache._serviceList.isEmpty() || this._requestDispatchFlag)) {
            this._watchlist.reactor().sendWatchlistDispatchNowEvent(this._watchlist.reactorChannel());
            this._requestDispatchFlag = true;
        }
        wlRequest.state(WlRequest.State.PENDING_REFRESH);
        return ret;
    }

    @Override
    public int submitMsg(WlRequest wlRequest, Msg msg, ReactorSubmitOptions submitOptions, ReactorErrorInfo errorInfo) {
        switch (msg.msgClass()) {
            case 5: {
                this._stream.userRequestList().remove(wlRequest);
                this._watchlist.closeWlRequest(wlRequest);
                break;
            }
            case 7: {
                if (this._stream.state().streamState() == 1) {
                    int ret;
                    boolean resetServiceId = false;
                    if (submitOptions.serviceName() != null) {
                        if (!((GenericMsg)msg).checkHasMsgKey()) {
                            return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlDirectoryHandler.submitMsg", "Generic message submitted with service name but no message key.");
                        }
                        ret = this._watchlist.changeServiceNameToID(((GenericMsg)msg).msgKey(), submitOptions.serviceName(), errorInfo);
                        if (ret < 0) {
                            return ret;
                        }
                        resetServiceId = true;
                    }
                    msg.streamId(wlRequest.stream().streamId());
                    ret = this._stream.sendMsgOutOfLoop(msg, submitOptions, errorInfo);
                    if (resetServiceId) {
                        ((GenericMsg)msg).msgKey().flags(((GenericMsg)msg).msgKey().flags() & 0xFFFFFFFE);
                        ((GenericMsg)msg).msgKey().serviceId(0);
                    }
                    if (ret >= 0) break;
                    return ret;
                }
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -6, "WlDirectoryHandler.submitMsg", "Cannot submit GenericMsg when stream not in open state.");
            }
            default: {
                return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlDirectoryHandler.submitMsg", "Invalid message class (" + msg.msgClass() + ") submitted to Watchlist directory handler");
            }
        }
        return 0;
    }

    public void fillDirectoryRefreshFromRequestMsg(DirectoryRefresh directoryRefresh, RequestMsg requestMsg) {
        directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
        directoryRefresh.streamId(requestMsg.streamId());
        if (requestMsg.msgKey().checkHasFilter()) {
            directoryRefresh.filter(requestMsg.msgKey().filter());
        } else {
            directoryRefresh.filter(this._directoryRefresh.filter());
        }
        directoryRefresh.applySolicited();
        directoryRefresh.state().dataState(this._directoryRefresh.state().dataState());
        directoryRefresh.state().streamState(this._directoryRefresh.state().streamState());
        if (requestMsg.msgKey().checkHasServiceId()) {
            directoryRefresh.applyHasServiceId();
            directoryRefresh.serviceId(requestMsg.msgKey().serviceId());
        }
    }

    private void fillDirectoryRefreshServiceListFromCache(DirectoryRefresh directoryRefresh, String serviceName) {
        Service service = null;
        if (this._servicePool.isEmpty()) {
            service = DirectoryMsgFactory.createService();
        } else {
            service = this._servicePool.poll();
            service.clear();
        }
        if (serviceName != null) {
            if (this._serviceCache.service(serviceName) != null) {
                this._serviceCache.service(serviceName).rdmService().copy(service);
                directoryRefresh.serviceList().add(service);
                this.setFilterFlagsRefresh(directoryRefresh.filter(), directoryRefresh.serviceList().get(0));
            }
        } else if (directoryRefresh.checkHasServiceId()) {
            if (this._serviceCache.service(directoryRefresh.serviceId()) != null) {
                this._serviceCache.service(directoryRefresh.serviceId()).rdmService().copy(service);
                directoryRefresh.serviceList().add(service);
                this.setFilterFlagsRefresh(directoryRefresh.filter(), directoryRefresh.serviceList().get(0));
            }
        } else {
            for (int i = 0; i < this.serviceList().size(); ++i) {
                if (this._servicePool.isEmpty()) {
                    service = DirectoryMsgFactory.createService();
                } else {
                    service = this._servicePool.poll();
                    service.clear();
                }
                this.serviceList().get(i).rdmService().copy(service);
                this.setFilterFlagsRefresh(directoryRefresh.filter(), service);
                directoryRefresh.serviceList().add(service);
            }
        }
    }

    void fillDirectoryUpdateFromRequestMsg(DirectoryUpdate directoryUpdate, WlRequest wlRequest) {
        int serviceId;
        long filter;
        directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        directoryUpdate.streamId(wlRequest.requestMsg().streamId());
        if (!directoryUpdate.checkHasFilter()) {
            directoryUpdate.applyHasFilter();
        }
        if (wlRequest.requestMsg().msgKey().checkHasFilter()) {
            filter = wlRequest.requestMsg().msgKey().filter();
            if (filter == 0L) {
                directoryUpdate.filter(63L);
            } else {
                directoryUpdate.filter(filter);
            }
        } else {
            filter = this._directoryUpdate.filter();
            if (filter == 0L) {
                directoryUpdate.filter(63L);
            } else {
                directoryUpdate.filter(filter);
            }
        }
        if (wlRequest.requestMsg().msgKey().checkHasServiceId()) {
            directoryUpdate.applyHasServiceId();
            directoryUpdate.serviceId(wlRequest.requestMsg().msgKey().serviceId());
        } else if (wlRequest.streamInfo().serviceName() != null && (serviceId = this._serviceCache.serviceId(wlRequest.streamInfo().serviceName())) >= 0) {
            directoryUpdate.applyHasServiceId();
            directoryUpdate.serviceId(serviceId);
        }
    }

    void fillDirectoryUpdateServiceListFromUpdateMsgServices(DirectoryUpdate directoryUpdate, List<Service> services) {
        Service service = null;
        for (int i = 0; i < services.size(); ++i) {
            if ((!directoryUpdate.checkHasServiceId() || directoryUpdate.serviceId() != services.get(i).serviceId()) && directoryUpdate.checkHasServiceId()) continue;
            if (this._servicePool.isEmpty()) {
                service = DirectoryMsgFactory.createService();
            } else {
                service = this._servicePool.poll();
                service.clear();
            }
            services.get(i).copy(service);
            int ret = this.setFilterFlagsUpdate(directoryUpdate.filter(), service, services.get(i));
            if (services.get(i).action() == 3 || services.get(i).action() == 2) {
                directoryUpdate.serviceList().add(service);
                continue;
            }
            if (ret > 0 || directoryUpdate.filter() == 0L) {
                directoryUpdate.serviceList().add(service);
                continue;
            }
            this._servicePool.add(service);
        }
    }

    void setFilterFlagsRefresh(long filter, Service service) {
        if (service.checkHasInfo() && (filter & 1L) == 0L) {
            service.flags(service.flags() & 0xFFFFFFFE);
        }
        if (service.checkHasData() && (filter & 0x10L) == 0L) {
            service.flags(service.flags() & 0xFFFFFFF7);
        }
        if (service.groupStateList().size() > 0 && (filter & 4L) == 0L) {
            service.groupStateList().clear();
        }
        if (service.checkHasLink() && (filter & 0x20L) == 0L) {
            service.flags(service.flags() & 0xFFFFFFEF);
        }
        if (service.checkHasLoad() && (filter & 8L) == 0L) {
            service.flags(service.flags() & 0xFFFFFFFB);
        }
        if (service.checkHasState() && (filter & 2L) == 0L) {
            service.flags(service.flags() & 0xFFFFFFFD);
        }
    }

    int setFilterFlagsUpdate(long filter, Service service, Service serviceReceived) {
        int retNumFilters = 0;
        if (serviceReceived.checkHasInfo() && (filter & 1L) != 0L) {
            service.applyHasInfo();
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFFE);
        }
        if (serviceReceived.checkHasData() && (filter & 0x10L) != 0L) {
            service.applyHasData();
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFEF);
        }
        if (serviceReceived.groupStateList().size() > 0 && (filter & 4L) != 0L) {
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFFB);
            service.groupStateList().clear();
        }
        if (serviceReceived.checkHasLink() && (filter & 0x20L) != 0L) {
            service.applyHasLink();
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFDF);
        }
        if (serviceReceived.checkHasLoad() && (filter & 8L) != 0L) {
            service.applyHasLoad();
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFF7);
        }
        if (serviceReceived.checkHasState() && (filter & 2L) != 0L) {
            service.applyHasState();
            ++retNumFilters;
        } else {
            service.flags(service.flags() & 0xFFFFFFFD);
        }
        return retNumFilters;
    }

    int getResultingFilter(long userFilter, long responseFilter) {
        int resultingFilter = 0;
        if (responseFilter != 0L) {
            if ((responseFilter & 1L) != 0L && (userFilter & 1L) != 0L) {
                resultingFilter |= 1;
            }
            if ((responseFilter & 0x10L) != 0L && (userFilter & 0x10L) != 0L) {
                resultingFilter |= 0x10;
            }
            if ((responseFilter & 4L) != 0L && (userFilter & 4L) != 0L) {
                resultingFilter |= 4;
            }
            if ((responseFilter & 0x20L) != 0L && (userFilter & 0x20L) != 0L) {
                resultingFilter |= 0x20;
            }
            if ((responseFilter & 8L) != 0L && (userFilter & 8L) != 0L) {
                resultingFilter |= 8;
            }
            if ((responseFilter & 2L) != 0L && (userFilter & 2L) != 0L) {
                resultingFilter |= 2;
            }
        } else {
            resultingFilter = (int)userFilter;
        }
        return resultingFilter;
    }

    @Override
    public int readMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, boolean wsbSendClosedRecover, ReactorErrorInfo errorInfo) {
        assert (this._stream == wlStream);
        assert (msg.streamId() == this._directoryRequest.streamId());
        int ret = 0;
        switch (msg.msgClass()) {
            case 2: {
                if (!this._receivedRefresh) {
                    ret = this.readRefreshMsg(wlStream, dIter, msg, errorInfo);
                    break;
                }
                ret = this.readRefreshMsgAsUpdate(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 3: {
                ret = this.readStatusMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 4: {
                ret = this.readUpdateMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            case 7: {
                ret = this.readGenericMsg(wlStream, dIter, msg, errorInfo);
                break;
            }
            default: {
                ret = this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlDirectoryHandler.readMsg", "Invalid message class (" + msg.msgClass() + ") received by Watchlist directory handler");
            }
        }
        if (ret == 0) {
            switch (wlStream.state().streamState()) {
                case 3: 
                case 4: 
                case 5: {
                    this.handleClose(wlStream, errorInfo);
                    break;
                }
                case 1: {
                    if (wlStream.state().dataState() != 1 || msg.msgClass() != 2 || this._watchlist.reactorChannel().state() == ReactorChannel.State.READY || (ret = this._watchlist.reactor().sendAndHandleChannelEventCallback("WlDirectoryHandler.readRefreshMsg", 4, this._watchlist.reactorChannel(), errorInfo)) != 0) break;
                    this._watchlist.reactorChannel().state(ReactorChannel.State.READY);
                    this._watchlist.reactorChannel().clearAccessTokenForV2();
                    ret = this._watchlist.itemHandler().directoryStreamOpen();
                    break;
                }
            }
        }
        return ret;
    }

    void handleClose(WlStream wlStream, ReactorErrorInfo errorInfo) {
        int i;
        LinkedList<WlRequest> requestList = wlStream.userRequestList();
        WlRequest usrRequest = null;
        Service service = null;
        this.closeDirectoryStream();
        this._directoryUpdate.clear();
        this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        usrRequest = requestList.poll();
        while (usrRequest != null) {
            this._directoryUpdate.streamId(usrRequest.requestMsg().streamId());
            for (i = 0; i < this.serviceList().size(); ++i) {
                if (this.serviceList().get(i).rdmService().serviceId() != usrRequest.requestMsg().msgKey().serviceId() && usrRequest.requestMsg().msgKey().serviceId() != 0) continue;
                if (this._servicePool.isEmpty()) {
                    service = DirectoryMsgFactory.createService();
                } else {
                    service = this._servicePool.poll();
                    service.clear();
                }
                this.serviceList().get(i).rdmService().copy(service);
                service.action(3);
                this._directoryUpdate.serviceList().add(service);
            }
            this._tempUpdateMsg.clear();
            this._watchlist.convertRDMToCodecMsg(this._directoryUpdate, (Msg)this._tempUpdateMsg);
            int returnFilter = this.getResultingFilter(usrRequest.requestMsg().msgKey().filter(), this._directoryUpdate.filter());
            if (this._tempUpdateMsg.checkHasMsgKey()) {
                this._tempUpdateMsg.msgKey().filter((long)returnFilter);
            }
            if (this._directoryUpdate.checkHasFilter()) {
                this._directoryUpdate.filter(returnFilter);
            }
            this._tempWlInteger.value(this._tempUpdateMsg.streamId());
            if (this.callbackUser("WlDirectoryHandler.handleClose", (Msg)this._tempUpdateMsg, this._directoryUpdate, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo) < 0) break;
            usrRequest = requestList.poll();
        }
        for (i = 0; i < this._directoryUpdate.serviceList().size(); ++i) {
            this._servicePool.add(this._directoryUpdate.serviceList().get(i));
        }
        this._serviceCache.clearCache(false);
    }

    void deleteAllServices(WlStream wlStream, boolean isChannelDown, ReactorErrorInfo errorInfo) {
        LinkedList<WlRequest> requestList = wlStream.userRequestList();
        WlRequest usrRequest = null;
        Service service = null;
        this._stream.channelDown();
        if (this._stream.state().streamState() == 1) {
            this._stream.state().clear();
            this._stream.state().streamState(3);
            this._stream.state().dataState(2);
            this._watchlist.streamIdtoWlStreamTable().remove(this._stream.tableKey());
            this._directoryUpdate.clear();
            this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
            for (int j = 0; j < requestList.size(); ++j) {
                usrRequest = requestList.get(j);
                usrRequest.state(WlRequest.State.PENDING_REFRESH);
                this._directoryUpdate.streamId(usrRequest.requestMsg().streamId());
                for (int i = 0; i < this.serviceList().size(); ++i) {
                    if (this.serviceList().get(i).rdmService().serviceId() != usrRequest.requestMsg().msgKey().serviceId() && usrRequest.requestMsg().msgKey().serviceId() != 0) continue;
                    if (this._servicePool.isEmpty()) {
                        service = DirectoryMsgFactory.createService();
                    } else {
                        service = this._servicePool.poll();
                        service.clear();
                    }
                    this.serviceList().get(i).rdmService().copy(service);
                    service.action(3);
                    this._directoryUpdate.serviceList().add(service);
                }
                this._tempUpdateMsg.clear();
                this._watchlist.convertRDMToCodecMsg(this._directoryUpdate, (Msg)this._tempUpdateMsg);
                int returnFilter = this.getResultingFilter(usrRequest.requestMsg().msgKey().filter(), this._directoryUpdate.filter());
                if (this._tempUpdateMsg.checkHasMsgKey()) {
                    this._tempUpdateMsg.msgKey().filter((long)returnFilter);
                }
                if (this._directoryUpdate.checkHasFilter()) {
                    this._directoryUpdate.filter(returnFilter);
                }
                this._tempWlInteger.value(this._tempUpdateMsg.streamId());
                if (this.callbackUser("WlDirectoryHandler.handleClose", (Msg)this._tempUpdateMsg, this._directoryUpdate, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo) < 0) break;
                this._directoryUpdate.clear();
                this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
            }
            for (int i = 0; i < this._directoryUpdate.serviceList().size(); ++i) {
                this._servicePool.add(this._directoryUpdate.serviceList().get(i));
            }
            this._serviceCache.clearCache(isChannelDown);
        }
    }

    int readRefreshMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        List<Service> serviceList;
        int ret = 0;
        if (!((RefreshMsg)msg).checkRefreshComplete()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlDirectoryHandler.readRefreshMsg", "Watchlist doesn't handle multi-part directory refresh.");
        }
        if (((RefreshMsg)msg).checkSolicited()) {
            wlStream.responseReceived();
        }
        this._directoryRefresh.decode(dIter, msg);
        if (((RefreshMsg)msg).checkClearCache()) {
            this._serviceCache.clearCache(false);
            if (!((RefreshMsg)msg).checkSolicited()) {
                this._watchlist.directoryHandler().deleteAllServices(false);
            }
        }
        this._directoryRefresh.state().copy(wlStream.state());
        if (this._directoryRefresh.state().streamState() == 3) {
            this._directoryRefresh.state().streamState(1);
            this._directoryRefresh.state().dataState(2);
            ((RefreshMsg)msg).state().streamState(1);
            ((RefreshMsg)msg).state().dataState(2);
        }
        if ((serviceList = this._directoryRefresh.serviceList()) != null) {
            ret = this._serviceCache.processServiceList(serviceList, msg, errorInfo);
        }
        if (ret == 0) {
            for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
                int j;
                WlRequest wlRequest = wlStream.userRequestList().get(i);
                if (((RefreshMsg)msg).checkSolicited() && wlRequest.state() != WlRequest.State.PENDING_REFRESH) continue;
                DirectoryRefresh newDirectoryRefresh = null;
                if (!this._directoryRefreshPool.isEmpty()) {
                    newDirectoryRefresh = this._directoryRefreshPool.poll();
                    newDirectoryRefresh.clear();
                } else {
                    newDirectoryRefresh = (DirectoryRefresh)DirectoryMsgFactory.createMsg();
                }
                wlRequest.state(WlRequest.State.OPEN);
                this.fillDirectoryRefreshFromRequestMsg(newDirectoryRefresh, wlRequest.requestMsg());
                this.fillDirectoryRefreshServiceListFromCache(newDirectoryRefresh, wlRequest.streamInfo()._serviceName);
                this._tempRefreshMsg.clear();
                this._watchlist.convertRDMToCodecMsg(newDirectoryRefresh, (Msg)this._tempRefreshMsg);
                int returnFilter = this.getResultingFilter(wlRequest.requestMsg().msgKey().filter(), newDirectoryRefresh.filter());
                if (this._tempRefreshMsg.checkHasMsgKey()) {
                    this._tempRefreshMsg.msgKey().filter((long)returnFilter);
                }
                newDirectoryRefresh.filter(returnFilter);
                this._tempWlInteger.value(this._tempRefreshMsg.streamId());
                ret = this.callbackUser("WlDirectoryHandler.readRefreshMsg", (Msg)this._tempRefreshMsg, newDirectoryRefresh, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
                if (ret < 0) {
                    for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                        this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                    }
                    this._directoryRefreshPool.add(newDirectoryRefresh);
                    break;
                }
                for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                    this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                }
                this._directoryRefreshPool.add(newDirectoryRefresh);
            }
        }
        this._receivedRefresh = true;
        return ret;
    }

    int readRefreshMsgAsUpdate(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        List<Service> serviceList;
        int ret = 0;
        if (!((RefreshMsg)msg).checkRefreshComplete()) {
            return this._watchlist.reactor().populateErrorInfo(errorInfo, -1, "WlDirectoryHandler.readRefreshMsg", "Watchlist doesn't handle multi-part directory refresh.");
        }
        if (((RefreshMsg)msg).checkSolicited()) {
            wlStream.responseReceived();
        }
        this._directoryRefresh.decode(dIter, msg);
        if (((RefreshMsg)msg).checkClearCache()) {
            this._serviceCache.clearCache(false);
            if (!((RefreshMsg)msg).checkSolicited()) {
                this._watchlist.directoryHandler().deleteAllServices(false);
            }
        }
        this._directoryRefresh.state().copy(wlStream.state());
        if (this._directoryRefresh.state().streamState() == 3) {
            this._directoryRefresh.state().streamState(1);
            this._directoryRefresh.state().dataState(2);
            ((RefreshMsg)msg).state().streamState(1);
            ((RefreshMsg)msg).state().dataState(2);
        }
        if ((serviceList = this._directoryRefresh.serviceList()) != null) {
            ret = this._serviceCache.processServiceList(serviceList, msg, errorInfo);
        }
        if (ret == 0) {
            for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
                int j;
                WlRequest wlRequest = wlStream.userRequestList().get(i);
                if (((RefreshMsg)msg).checkSolicited() && wlRequest.state() != WlRequest.State.PENDING_REFRESH) continue;
                DirectoryRefresh newDirectoryRefresh = null;
                if (!this._directoryRefreshPool.isEmpty()) {
                    newDirectoryRefresh = this._directoryRefreshPool.poll();
                    newDirectoryRefresh.clear();
                } else {
                    newDirectoryRefresh = (DirectoryRefresh)DirectoryMsgFactory.createMsg();
                }
                wlRequest.state(WlRequest.State.OPEN);
                this.fillDirectoryRefreshFromRequestMsg(newDirectoryRefresh, wlRequest.requestMsg());
                this.fillDirectoryRefreshServiceListFromCache(newDirectoryRefresh, wlRequest.streamInfo()._serviceName);
                this._directoryUpdate.clear();
                this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
                this._directoryUpdate.serviceList().addAll(newDirectoryRefresh.serviceList());
                this._directoryUpdate.applyHasFilter();
                this._directoryUpdate.filter(newDirectoryRefresh.filter());
                this._directoryUpdate.streamId(newDirectoryRefresh.streamId());
                this._directoryUpdate.applyHasServiceId();
                this._directoryUpdate.serviceId(newDirectoryRefresh.serviceId());
                this._directoryUpdate.flags(newDirectoryRefresh.flags());
                this._tempUpdateMsg.clear();
                this._watchlist.convertRDMToCodecMsg(this._directoryUpdate, (Msg)this._tempUpdateMsg);
                int returnFilter = this.getResultingFilter(wlRequest.requestMsg().msgKey().filter(), this._directoryUpdate.filter());
                if (this._tempUpdateMsg.checkHasMsgKey()) {
                    this._tempUpdateMsg.msgKey().filter((long)returnFilter);
                }
                if (this._directoryUpdate.checkHasFilter()) {
                    this._directoryUpdate.filter(returnFilter);
                }
                this._tempWlInteger.value(this._tempUpdateMsg.streamId());
                ret = this.callbackUser("WlDirectoryHandler.readRefreshMsgAsUpdate", (Msg)this._tempUpdateMsg, this._directoryUpdate, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
                if (ret < 0) {
                    for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                        this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                    }
                    this._directoryRefreshPool.add(newDirectoryRefresh);
                    break;
                }
                for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                    this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                }
                this._directoryRefreshPool.add(newDirectoryRefresh);
            }
        }
        return ret;
    }

    int readStatusMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        ret = this._directoryStatus.decode(dIter, msg);
        wlStream.responseReceived();
        if (((StatusMsg)msg).checkClearCache()) {
            this._serviceCache.clearCache(false);
            if (this._directoryStatus.state().streamState() == 1) {
                this._watchlist.directoryHandler().deleteAllServices(false);
            }
        }
        if (this._directoryStatus.checkHasState()) {
            this._directoryStatus.state().copy(wlStream.state());
        }
        return ret;
    }

    int readUpdateMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        this._directoryUpdate.clear();
        this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        ret = this._directoryUpdate.decode(dIter, msg);
        if (ret == 0) {
            List<Service> serviceList = this._directoryUpdate.serviceList();
            if (serviceList != null && (ret = this._serviceCache.processServiceList(serviceList, msg, errorInfo)) < 0) {
                return ret;
            }
        } else {
            return ret;
        }
        for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            if (wlRequest.state() != WlRequest.State.PENDING_REFRESH && wlRequest.state() != WlRequest.State.OPEN) continue;
            this._directoryUpdateCopy.clear();
            this.fillDirectoryUpdateFromRequestMsg(this._directoryUpdateCopy, wlRequest);
            this.fillDirectoryUpdateServiceListFromUpdateMsgServices(this._directoryUpdateCopy, this._directoryUpdate.serviceList());
            if (this._directoryUpdateCopy.serviceList().size() > 0) {
                int returnFilter = this.getResultingFilter(this._directoryUpdateCopy.filter(), this._directoryUpdate.filter());
                this._directoryUpdateCopy.filter(returnFilter);
                this._tempUpdateMsg.clear();
                this._watchlist.convertRDMToCodecMsg(this._directoryUpdateCopy, (Msg)this._tempUpdateMsg);
                this._tempWlInteger.value(this._tempUpdateMsg.streamId());
                ret = this.callbackUser("WlDirectoryHandler.readUpdateMsg", (Msg)this._tempUpdateMsg, this._directoryUpdateCopy, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
                if (ret < 0) {
                    for (int j = 0; j < this._directoryUpdateCopy.serviceList().size(); ++j) {
                        this._servicePool.add(this._directoryUpdateCopy.serviceList().get(j));
                    }
                    return ret;
                }
            }
            for (int j = 0; j < this._directoryUpdateCopy.serviceList().size(); ++j) {
                this._servicePool.add(this._directoryUpdateCopy.serviceList().get(j));
            }
        }
        return ret;
    }

    int readGenericMsg(WlStream wlStream, DecodeIterator dIter, Msg msg, ReactorErrorInfo errorInfo) {
        int ret = 0;
        for (int i = 0; i < wlStream.userRequestList().size(); ++i) {
            WlRequest wlRequest = wlStream.userRequestList().get(i);
            if (wlRequest.state() != WlRequest.State.PENDING_REFRESH && wlRequest.state() != WlRequest.State.PENDING_COMPLETE_REFRESH && wlRequest.state() != WlRequest.State.OPEN) continue;
            msg.streamId(wlRequest.requestMsg().streamId());
            ret = this._watchlist.reactor().sendAndHandleDefaultMsgCallback("WLDirectoryHandler.readGenericMsg", this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
            if (ret < 0) break;
        }
        return ret;
    }

    int dispatch(ReactorErrorInfo errorInfo) {
        int ret = 0;
        if (this._stream != null && this._hasPendingRequest) {
            this._hasPendingRequest = false;
            this._tempMsg.clear();
            this._watchlist.convertRDMToCodecMsg(this._directoryRequest, this._tempMsg);
            ret = this._stream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo);
            if (ret != 0) {
                return ret;
            }
        }
        if (!this._serviceCache._serviceList.isEmpty()) {
            DirectoryRefresh newDirectoryRefresh = null;
            for (int i = 0; i < this._stream.userRequestList().size(); ++i) {
                WlRequest wlRequest = this._stream.userRequestList().get(i);
                if (wlRequest.state() == WlRequest.State.PENDING_REFRESH) {
                    int j;
                    wlRequest.state(WlRequest.State.OPEN);
                    newDirectoryRefresh = !this._directoryRefreshPool.isEmpty() ? this._directoryRefreshPool.poll() : (DirectoryRefresh)DirectoryMsgFactory.createMsg();
                    newDirectoryRefresh.clear();
                    this.fillDirectoryRefreshFromRequestMsg(newDirectoryRefresh, wlRequest.requestMsg());
                    this.fillDirectoryRefreshServiceListFromCache(newDirectoryRefresh, wlRequest.streamInfo()._serviceName);
                    this._tempRefreshMsg.clear();
                    this._watchlist.convertRDMToCodecMsg(newDirectoryRefresh, (Msg)this._tempRefreshMsg);
                    int returnFilter = this.getResultingFilter(wlRequest.requestMsg().msgKey().filter(), newDirectoryRefresh.filter());
                    if (this._tempRefreshMsg.checkHasMsgKey()) {
                        this._tempRefreshMsg.msgKey().filter((long)returnFilter);
                    }
                    newDirectoryRefresh.filter(returnFilter);
                    this._tempWlInteger.value(this._tempRefreshMsg.streamId());
                    ret = this.callbackUser("WlDirectoryHandler.dispatch", (Msg)this._tempRefreshMsg, newDirectoryRefresh, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), errorInfo);
                    if (ret < 0) {
                        for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                            this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                        }
                        this._directoryRefreshPool.add(newDirectoryRefresh);
                        return ret;
                    }
                    for (j = 0; j < newDirectoryRefresh.serviceList().size(); ++j) {
                        this._servicePool.add(newDirectoryRefresh.serviceList().get(j));
                    }
                    this._directoryRefreshPool.add(newDirectoryRefresh);
                }
                this._requestDispatchFlag = false;
            }
        }
        return 0;
    }

    int loginStreamOpen(ReactorErrorInfo errorInfo) {
        this._stream.handler(this);
        this._stream.watchlist(this._watchlist);
        this._stream.domainType(4);
        this._stream.tableKey(ReactorFactory.createWlInteger());
        this._directoryRequest.streamId(this._directoryStreamId);
        this._stream.tableKey().value(this._directoryRequest.streamId());
        this._watchlist.streamIdtoWlStreamTable().put(this._stream.tableKey(), this._stream);
        if (this._watchlist.role()._directoryRequest != null && !this._roleDirectoryRequestAdded) {
            WlInteger wlInteger = ReactorFactory.createWlInteger();
            wlInteger.value(this._watchlist.role().rdmDirectoryRequest().streamId());
            if (!this._watchlist.streamIdtoWlRequestTable().containsKey(wlInteger)) {
                WlRequest wlRequest = ReactorFactory.createWlRequest();
                this._tempMsg.clear();
                this._watchlist.convertRDMToCodecMsg(this._watchlist.role().rdmDirectoryRequest(), this._tempMsg);
                wlRequest.requestMsg().clear();
                this._tempMsg.copy((Msg)wlRequest.requestMsg(), 4095);
                wlRequest.handler(this);
                wlRequest.tableKey(wlInteger);
                this._watchlist.streamIdtoWlRequestTable().put(wlInteger, wlRequest);
                wlRequest.state(WlRequest.State.PENDING_REFRESH);
                this._stream.userRequestList().add(wlRequest);
                wlRequest.stream(this._stream);
                this._roleDirectoryRequestAdded = true;
            } else {
                wlInteger.returnToPool();
            }
        }
        if (this._stream.state().streamState() != 1 && this._stream.state().streamState() != 4 && !this._stream.requestPending()) {
            this._tempMsg.clear();
            this._watchlist.convertRDMToCodecMsg(this._directoryRequest, this._tempMsg);
            int ret = this._stream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo);
            if (ret < 0) {
                return ret;
            }
        }
        return 0;
    }

    int loginStreamClosed() {
        int ret = 0;
        if (this._stream.state().streamState() == 1) {
            if (this._watchlist.loginHandler().wlStream().state().streamState() == 3 || this._watchlist.reactorChannel().enableSessionManagement()) {
                this._stream.state().clear();
                this._stream.state().streamState(3);
                this._stream.state().dataState(2);
                this._serviceCache.clearCache(false);
            } else if (this._watchlist.loginHandler().wlStream().state().streamState() == 4) {
                this._serviceCache.clearCache(false);
                this.closeDirectoryStream();
            }
        }
        return ret;
    }

    void channelUp(ReactorErrorInfo errorInfo) {
    }

    void deleteAllServices(boolean isChannelDown) {
        if (this._stream != null) {
            this.deleteAllServices(this._stream, isChannelDown, this._errorInfo);
        }
    }

    int fanoutStatus() {
        int ret = 0;
        if (this._stream.state().streamState() != 4) {
            this._statusMsg.state().streamState(1);
            this._statusMsg.state().dataState(2);
            this._directoryStatus.state().streamState(1);
            this._directoryStatus.state().dataState(2);
        } else {
            this._statusMsg.state().streamState(4);
            this._statusMsg.state().dataState(2);
            this._directoryStatus.state().streamState(4);
            this._directoryStatus.state().dataState(2);
        }
        for (int i = 0; i < this._stream.userRequestList().size(); ++i) {
            WlRequest wlRequest = this._stream.userRequestList().get(i);
            if (wlRequest.state() != WlRequest.State.PENDING_REFRESH && wlRequest.state() != WlRequest.State.OPEN) continue;
            this._statusMsg.streamId(wlRequest.requestMsg().streamId());
            this._directoryStatus.streamId(wlRequest.requestMsg().streamId());
            this._statusMsg.applyHasMsgKey();
            this._statusMsg.msgKey().filter(wlRequest.requestMsg().msgKey().filter());
            this._directoryStatus.applyHasFilter();
            this._directoryStatus.filter(wlRequest.requestMsg().msgKey().filter());
            this._tempWlInteger.value(this._statusMsg.streamId());
            ret = this.callbackUser("WlDirectoryHandler.fanoutStatus", (Msg)this._statusMsg, this._directoryStatus, this._watchlist.streamIdtoWlRequestTable().get(this._tempWlInteger), this._errorInfo);
            if (ret < 0) break;
        }
        return ret;
    }

    @Override
    public int callbackUser(String location, Msg msg, MsgBase rdmMsg, WlRequest wlRequest, ReactorErrorInfo errorInfo) {
        int ret = 0;
        ret = this._watchlist.reactor().sendAndHandleDirectoryMsgCallback(location, this._watchlist.reactorChannel(), null, msg, (DirectoryMsg)rdmMsg, wlRequest, errorInfo);
        if (ret == -2) {
            ret = this._watchlist.reactor().sendAndHandleDefaultMsgCallback(location, this._watchlist.reactorChannel(), null, msg, wlRequest, errorInfo);
        }
        return ret;
    }

    @Override
    public void addPendingRequest(WlStream wlStream) {
        this._hasPendingRequest = true;
    }

    LinkedList<WlService> serviceList() {
        return this._serviceCache._serviceList;
    }

    @Override
    public int requestTimeout(WlStream wlStream, ReactorErrorInfo errorInfo) {
        this.fanoutStatus();
        this._tempMsg.clear();
        this._watchlist.convertRDMToCodecMsg(this._directoryRequest, this._tempMsg);
        return this._stream.sendMsgOutOfLoop(this._tempMsg, this._submitOptions, errorInfo);
    }

    int serviceId(String serviceName) {
        return this._serviceCache.serviceId(serviceName);
    }

    String serviceName(int serviceId) {
        return this._serviceCache.serviceName(serviceId);
    }

    WlService service(String serviceName) {
        return this._serviceCache.service(serviceName);
    }

    WlService service(int serviceId) {
        return this._serviceCache.service(serviceId);
    }

    void clear() {
        this._stream.clear();
        this._directoryRefresh.clear();
        this._directoryRefresh.rdmMsgType(DirectoryMsgType.REFRESH);
        this._directoryStatus.clear();
        this._directoryStatus.rdmMsgType(DirectoryMsgType.STATUS);
        this._directoryStatus.applyHasState();
        this._directoryStatus.state().code(0);
        this._directoryStatus.state().text(this._tempBuffer);
        this._directoryUpdate.clear();
        this._directoryUpdate.rdmMsgType(DirectoryMsgType.UPDATE);
        this._directoryUpdateCopy = (DirectoryUpdate)DirectoryMsgFactory.createMsg();
        this._directoryUpdateCopy.rdmMsgType(DirectoryMsgType.UPDATE);
        this._submitOptions.clear();
        this._tempMsg.clear();
        this._statusMsg.clear();
        this._statusMsg.msgClass(3);
        this._statusMsg.domainType(4);
        this._statusMsg.applyHasState();
        this._statusMsg.state().code(0);
        this._statusMsg.state().text(this._tempBuffer);
        this._tempBuffer.clear();
        this._tempBuffer.data("");
        this._tempMsg.clear();
        this._errorInfo.clear();
        this._serviceCache.clear();
        this._tempRefreshMsg.clear();
        this._directoryRefreshPool.clear();
        this._tempDirectoryStatus.clear();
        this._tempUpdateMsg.clear();
        this._requestDispatchFlag = false;
        this._receivedRefresh = false;
        this._roleDirectoryRequestAdded = false;
        this._hasPendingRequest = false;
    }

    private void closeDirectoryStream() {
        this._stream.state().clear();
        this._stream.state().streamState(4);
        this._stream.state().dataState(2);
        this._watchlist.streamIdtoWlStreamTable().remove(this._stream.tableKey());
        this._stream.tableKey().returnToPool();
        this._stream.tableKey(null);
    }
}

